/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils;

import cn.hutool.core.date.format.FastDateFormat;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.AesUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.qiHu.QiHuRequest;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class JdazGatewayUtil {
    private static final Logger log = LoggerFactory.getLogger(JdazGatewayUtil.class);
    @Value(value="${jdazGateWay.secretKey}")
    private String secretKey;
    @Value(value="${jdazGateWay.appKey}")
    private String appKey;
    @Autowired
    AesUtils aesUtils;

    public String getGateWayContent(String content, String serviceName) {
        try {
            content = this.aesUtils.encrypt(content, this.secretKey);
        }
        catch (Exception e) {
            log.error("\u7f51\u5173AES\u52a0\u5bc6\u5931\u8d25,{}", (Throwable)e);
            return null;
        }
        log.warn("AES\u52a0\u5bc6\u540e\u6570\u636e\u4e3a\uff1a{}", (Object)content);
        QiHuRequest qiHuRequest = QiHuRequest.builder().data(content).appKey(this.appKey).serviceName(serviceName).timestamp(JdazGatewayUtil.getTimestamp()).build();
        log.warn("\u7b7e\u540d\u52a0\u5bc6\u503c\u4e3a\uff1a{}", (Object)(qiHuRequest.toString() + this.secretKey));
        String sign = SecureUtil.md5((String)(qiHuRequest.toString() + this.secretKey)).toUpperCase();
        qiHuRequest.setSign(sign);
        log.warn("MD5\u52a0\u5bc6\u540e\u7b7e\u660esign\u4e3a\uff1a{}", (Object)sign);
        return JSON.toJSONString((Object)qiHuRequest);
    }

    public static String getTimestamp() {
        FastDateFormat fdf2 = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");
        Date current = new Date();
        return fdf2.format(current);
    }
}

