/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.BaseCodeConvertUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.ChargeInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.ClaimOpenBillRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.CollectInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.CollectguideInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.CompensateInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.DflossPersBillInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.LossDelayInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.LossHealthInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.PayPersonInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RegistDamageInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyListQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyListServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelConfigsMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelUserMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class RegistDataCompletion {
    private static final Logger log = LoggerFactory.getLogger(RegistDataCompletion.class);
    @Autowired
    private ApisChannelCodeMapper apisChannelCodeMapper;
    @Autowired
    private ApisBusiChannelOrderMapper apisBusiChannelOrderMapper;
    @Autowired
    private ApisChannelUserMapper apisChannelUserMapper;
    @Autowired
    private ApisChannelConfigsMapper apisChannelConfigsMapper;
    @Value(value="${policyListAddress}")
    private String policyListAddress;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    private static String CHANNEL_CODE = "all";
    @Autowired
    private ApisBusinessService apisBusinessService;
    @Autowired
    private BaseCodeConvertUtils baseCodeConvertUtils;
    private static String ENDCASE_PLAN_CODE = "endcase_plan_code";
    private static String REGIST = "regist";
    private static String COMPENSATE = "compensate";
    private static String ENDCASE = "endcase";
    private static final Pattern EN_PATTERN = Pattern.compile("[a-zA-z]");

    public void checkRequestHeadBody(StanderRequest request) throws ApisBusinessException {
        this.judgeNotNull((Object)request, "\u8bf7\u6c42\u62a5\u6587 " + ErrorCode.NOT_NULL.getMessage());
        this.judgeNotNull((Object)request.getClaimOpenBillServiceRequest(), "claimOpenBillServiceRequest " + ErrorCode.NOT_NULL.getMessage());
        this.judgeNotNull((Object)request.getClaimOpenBillServiceRequest().getBody(), "\u8bf7\u6c42\u5934[head] " + ErrorCode.NOT_NULL.getMessage());
        this.judgeNotNull((Object)request.getClaimOpenBillServiceRequest().getHead(), "\u8bf7\u6c42\u4f53[body] " + ErrorCode.NOT_NULL.getMessage());
    }

    public void dataCompletionClaimOpenBillRequestDTO(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        TimeInterval timerAll = DateUtil.timer();
        ClaimOpenBillRequestDTO openBillRequestDTO = request.getClaimOpenBillServiceRequest().getBody();
        this.checkData(openBillRequestDTO);
        log.warn("\u5f00\u6848\uff0c\u6570\u636e\u524d\u7f6e\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.commonCompletion(request);
        log.warn("\u5f00\u6848\uff0c\u516c\u5171\u8865\u5168\u6570\u636e\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        PolicyListQueryResponse policyListQueryResponse = this.policyListQueryResponse(request, openBillRequestDTO);
        log.warn("\u5f00\u6848\uff0c\u67e5\u8be2\u4fdd\u5355\u5217\u8868\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.standardCompletion(openBillRequestDTO, policyListQueryResponse);
        log.warn("\u5f00\u6848\uff0c\u6807\u51c6\u6570\u636e\u8865\u5168\u4e0e\u8f6c\u6362\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.xcCompletion(request, policyListQueryResponse);
        log.warn("\u5f00\u6848\uff0c\u643a\u7a0b\u6570\u636e\u8865\u5168\u4e0e\u8f6c\u6362\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.accountAuthCheck(request, policyListQueryResponse);
        log.warn("\u5f00\u6848\uff0c\u8d26\u53f7\u6743\u9650\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.commonAfterCompletion(request, policyListQueryResponse);
        log.warn("\u5f00\u6848\uff0c\u516c\u5171\u540e\u7f6e\u6570\u636e\u8865\u5168\u4e0e\u8f6c\u6362\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        log.warn("\u5f00\u6848\uff0c\u8865\u5168\u4e0e\u8f6c\u6362\u603b\u8017\u65f6\uff0c\u7528\u65f6 :{}", (Object)timerAll.intervalRestart());
    }

    private PolicyListQueryResponse policyListQueryResponse(StanderRequest request, ClaimOpenBillRequestDTO openBillRequestDTO) throws ApisBusinessException {
        PolicyListQueryResponse policyListQueryResponse = null;
        policyListQueryResponse = this.getPolicyList(request);
        if (ObjectUtil.isEmpty((Object)policyListQueryResponse) || "0007".equals(policyListQueryResponse.getResponseHead().getAppCode())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NO_INSURER.getCode()).message(ErrorCode.NO_INSURER.getMessage()).build();
        }
        if ("xml".equals(openBillRequestDTO.getType()) && ObjectUtil.isNotEmpty((Object)policyListQueryResponse.getResponseBody()) && policyListQueryResponse.getResponseBody().getPolicyList().size() > 0 && !((PolicyListDTO)policyListQueryResponse.getResponseBody().getPolicyList().get(0)).getAgentCode().equals(openBillRequestDTO.getRegist().getRegistInfo().getReportChannel())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_MATCH_AGENCYCODE.getCode()).message(ErrorCode.NOT_MATCH_AGENCYCODE.getMessage()).build();
        }
        return policyListQueryResponse;
    }

    private void commonAfterCompletion(StanderRequest request, PolicyListQueryResponse policyListQueryResponse) throws ApisDataCompletionException {
        ClaimOpenBillRequestDTO openBillRequestDTO = request.getClaimOpenBillServiceRequest().getBody();
        if ("05_10".indexOf(openBillRequestDTO.getReportType()) != -1 && "07".equals(openBillRequestDTO.getDamageResult())) {
            ArrayList<String> kindList = new ArrayList<String>();
            for (PolicyListDTO policyListDTO : policyListQueryResponse.getResponseBody().getPolicyList()) {
                for (Object itemMainDTO : policyListDTO.getCoverage().getItemList()) {
                    for (ItemKindDTO itemKindDTO : itemMainDTO.getItemKind()) {
                        kindList.add(itemKindDTO.getKindCode());
                    }
                }
            }
            if ("07".equals(openBillRequestDTO.getDamageResult())) {
                List damageTypeList = this.apisChannelCodeMapper.getValueByDamageResultList("kind_damageType", kindList);
                if (ObjectUtil.isEmpty((Object)damageTypeList) || damageTypeList.size() == 0) {
                    throw ApisDataCompletionException.builder().errorCode(ErrorCode.KIND_FAIL.getCode()).message(ErrorCode.KIND_FAIL.getMessage()).build();
                }
                boolean isDamageReasonTypeInKindList = false;
                if (StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageReasonType())) {
                    Object itemMainDTO;
                    String damageReasonType = openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageReasonType();
                    itemMainDTO = damageTypeList.iterator();
                    block3: while (itemMainDTO.hasNext()) {
                        String str = (String)itemMainDTO.next();
                        if (null == str) continue;
                        String[] ss = str.split("\u3001");
                        for (String s : ss) {
                            if (!s.equals(damageReasonType)) continue;
                            isDamageReasonTypeInKindList = true;
                            continue block3;
                        }
                    }
                }
                if (isDamageReasonTypeInKindList) {
                    log.warn("\u51fa\u9669\u539f\u56e0\u5206\u7c7b\u5217\u8868\uff1a{}\uff0c\u51fa\u9669\u539f\u56e0\u5206\u7c7b\uff1a{}", (Object)damageTypeList, (Object)openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageReasonType());
                } else if (damageTypeList.contains("1") || damageTypeList.contains("2\u30011")) {
                    log.warn("\u5c06\u51fa\u9669\u539f\u56e0\u5206\u7c7bdamageReasonType\u7531 {} \u8bbe\u7f6e\u4e3a {}", (Object)openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageReasonType(), (Object)"1");
                    openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageReasonType("1");
                } else if (damageTypeList.contains("2")) {
                    log.warn("\u5c06\u51fa\u9669\u539f\u56e0\u5206\u7c7bdamageReasonType\u7531 {} \u8bbe\u7f6e\u4e3a {}", (Object)openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageReasonType(), (Object)"2");
                    openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageReasonType("2");
                } else {
                    throw ApisDataCompletionException.builder().errorCode(ErrorCode.KIND_LACK.getCode()).message(ErrorCode.KIND_LACK.getMessage()).build();
                }
            }
        }
        this.supplementLossOutReason(openBillRequestDTO);
        if ("1".equals(openBillRequestDTO.getRegist().getRegistDamageInfo().getNationFlag())) {
            if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getProvinceCode()) && StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getProvinceName())) {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setProvinceCode("999999");
                openBillRequestDTO.getRegist().getRegistDamageInfo().setProvinceName("\u5168\u56fd");
            } else if (StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getProvinceCode()) && StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getProvinceName())) {
                String provinceovinceName = this.apisChannelCodeMapper.getValueDesc(null, "province", openBillRequestDTO.getRegist().getRegistDamageInfo().getProvinceCode());
                openBillRequestDTO.getRegist().getRegistDamageInfo().setProvinceName(StringUtils.isNotBlank((CharSequence)provinceovinceName) ? provinceovinceName : "\u5168\u56fd");
            } else if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getProvinceCode()) && StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getProvinceName())) {
                String provinceCode = this.apisChannelCodeMapper.getValueByValueDescDim("province", openBillRequestDTO.getRegist().getRegistDamageInfo().getProvinceName() + "%");
                openBillRequestDTO.getRegist().getRegistDamageInfo().setProvinceCode(StringUtils.isNotBlank((CharSequence)provinceCode) ? provinceCode : "999");
            }
            if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCityName()) && StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCityCode())) {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setCityCode("999");
                openBillRequestDTO.getRegist().getRegistDamageInfo().setCityName("\u4e2d\u56fd");
            } else if (StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCityCode()) && StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCityName())) {
                String cityName = this.apisChannelCodeMapper.getValueDesc(null, "city", openBillRequestDTO.getRegist().getRegistDamageInfo().getCityCode());
                openBillRequestDTO.getRegist().getRegistDamageInfo().setCityName(StringUtils.isNotBlank((CharSequence)cityName) ? cityName : "\u4e2d\u56fd");
            } else if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCityCode()) && StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCityName())) {
                String cityCode = this.apisChannelCodeMapper.getValueByValueDescDim("city", openBillRequestDTO.getRegist().getRegistDamageInfo().getCityName() + "%");
                openBillRequestDTO.getRegist().getRegistDamageInfo().setCityCode(StringUtils.isNotBlank((CharSequence)cityCode) ? cityCode : "999");
            }
            if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCountyCode()) && StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCountyName())) {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setCountyCode("999");
                openBillRequestDTO.getRegist().getRegistDamageInfo().setCountyName("\u4e2d\u56fd");
            } else if (StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCountyCode()) && StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCountyName())) {
                String countyName = this.apisChannelCodeMapper.getValueDesc(null, "county", openBillRequestDTO.getRegist().getRegistDamageInfo().getCountyCode());
                openBillRequestDTO.getRegist().getRegistDamageInfo().setCountyName(StringUtils.isNotBlank((CharSequence)countyName) ? countyName : "\u4e2d\u56fd");
            } else if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCountyCode()) && StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCountyName())) {
                String countyCode = this.apisChannelCodeMapper.getValueByValueDescDim("county", openBillRequestDTO.getRegist().getRegistDamageInfo().getCountyName() + "%");
                openBillRequestDTO.getRegist().getRegistDamageInfo().setCountyCode(StringUtils.isNotBlank((CharSequence)countyCode) ? countyCode : "999");
            }
        }
        Boolean isCommerialInsure = false;
        if (policyListQueryResponse.getResponseBody().getPolicyList().size() > 0) {
            for (PolicyListDTO policyListDTO : policyListQueryResponse.getResponseBody().getPolicyList()) {
                if (!"07_09".contains(policyListDTO.getClassCode())) {
                    isCommerialInsure = true;
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getIdentifyType()) || StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getIdentifyNo())) {
                    for (InsuredDTO insuredDTO : policyListDTO.getInsuredList()) {
                        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getIdentifyNo())) {
                            if ("xcxml".equals(openBillRequestDTO.getType()) && openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getDamagePersonName().indexOf(insuredDTO.getInsuredName()) >= 0) {
                                openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setIdentifyNo(insuredDTO.getIdentifyNumber());
                                openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setIdentifyType(insuredDTO.getIdentifyType());
                                openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setDamagePersonName(insuredDTO.getInsuredName());
                                openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setDamagePersonAge(insuredDTO.getAge());
                                continue;
                            }
                            if (insuredDTO.getInsuredName().indexOf(openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getDamagePersonName()) < 0) continue;
                            openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setIdentifyNo(insuredDTO.getIdentifyNumber());
                            openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setIdentifyType(insuredDTO.getIdentifyType());
                            openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setDamagePersonName(insuredDTO.getInsuredName());
                            openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setDamagePersonAge(insuredDTO.getAge());
                            continue;
                        }
                        if (!openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getIdentifyNo().equals(insuredDTO.getIdentifyNumber())) continue;
                        openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setIdentifyType(insuredDTO.getIdentifyType());
                        openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setDamagePersonName(insuredDTO.getInsuredName());
                        openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setDamagePersonAge(insuredDTO.getAge());
                    }
                }
                if (!StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getIdentifyType())) continue;
                throw ApisDataCompletionException.builder().errorCode(ErrorCode.NO_INSURER.getCode()).message(ErrorCode.NO_INSURER.getMessage()).build();
            }
        }
        if (!"regist".equals(openBillRequestDTO.getStep())) {
            List compensateInfoDTOS = openBillRequestDTO.getCompensateInfoList();
            if (ObjectUtil.isNotEmpty((Object)compensateInfoDTOS)) {
                for (CompensateInfoDTO compensateInfoDTO : compensateInfoDTOS) {
                    List payPersonInfoDTOS;
                    List lossHealthInfoDTOS;
                    if (StringUtils.isBlank((CharSequence)compensateInfoDTO.getCaseType())) {
                        compensateInfoDTO.setCaseType("0");
                    }
                    if (StringUtils.isBlank((CharSequence)compensateInfoDTO.getCompensateType())) {
                        compensateInfoDTO.setCompensateType("1");
                    }
                    if (ObjectUtil.isEmpty((Object)compensateInfoDTO.getSumRealPay())) {
                        compensateInfoDTO.setSumRealPay(openBillRequestDTO.getRegist().getRegistDamageInfo().getReportedLoss());
                    }
                    List<LossDelayInfoDTO> lossDelayInfoDTOS = null;
                    LossDelayInfoDTO lossDelayInfoDTO = null;
                    if (ObjectUtil.isNotEmpty((Object)compensateInfoDTO.getLossDelayInfo()) && compensateInfoDTO.getLossDelayInfo().size() > 0) {
                        lossDelayInfoDTOS = compensateInfoDTO.getLossDelayInfo();
                        lossDelayInfoDTO = (LossDelayInfoDTO)lossDelayInfoDTOS.get(0);
                    } else {
                        lossDelayInfoDTOS = new ArrayList();
                        lossDelayInfoDTO = new LossDelayInfoDTO();
                        lossDelayInfoDTOS.add(lossDelayInfoDTO);
                    }
                    if (StringUtils.isBlank((CharSequence)lossDelayInfoDTO.getLossFeeType())) {
                        lossDelayInfoDTO.setLossFeeType(openBillRequestDTO.getDamageResult());
                    }
                    if (ObjectUtil.isNotEmpty((Object)lossDelayInfoDTO.getActualArrivalTime()) && ObjectUtil.isNotEmpty((Object)lossDelayInfoDTO.getPlanArrivalTime())) {
                        if (lossDelayInfoDTO.getActualArrivalTime().before(lossDelayInfoDTO.getPlanArrivalTime())) {
                            throw ApisDataCompletionException.builder().errorCode(ErrorCode.DATEFORMAT.getCode()).message(ErrorCode.DATEFORMAT.getMessage()).build();
                        }
                        long arrTime = lossDelayInfoDTO.getActualArrivalTime().getTime() - lossDelayInfoDTO.getPlanArrivalTime().getTime();
                        int hours = (int)arrTime / 3600000;
                        lossDelayInfoDTO.setSumDelayHours(Integer.valueOf(hours));
                    }
                    if (ObjectUtil.isNotEmpty((Object)(lossHealthInfoDTOS = compensateInfoDTO.getLossHealthInfo()))) {
                        for (LossHealthInfoDTO lossHealthInfoDTO : lossHealthInfoDTOS) {
                            if (!"07".equals(lossDelayInfoDTO.getLossFeeType())) continue;
                            if (null == lossHealthInfoDTO.getPayRate()) {
                                lossHealthInfoDTO.setPayRate(BigDecimal.valueOf(100L));
                            }
                            if (null == lossHealthInfoDTO.getInHospitalDays()) {
                                lossHealthInfoDTO.setInHospitalDays(Integer.valueOf(1));
                            }
                            if (null == lossHealthInfoDTO.getDeductDays()) {
                                lossHealthInfoDTO.setDeductDays(Integer.valueOf(0));
                            }
                            if ("05_10".indexOf(openBillRequestDTO.getReportType()) == -1) continue;
                            if (!"RMB".equals(((DflossPersBillInfoDTO)openBillRequestDTO.getDflossPersBillInfo().get(0)).getCurrency())) {
                                BigDecimal exchangeMoney = lossHealthInfoDTO.getSumLossFee().multiply(openBillRequestDTO.getRegist().getRegistDamageInfo().getExchRateL());
                                if (ObjectUtil.isEmpty((Object)lossHealthInfoDTO.getSumCalcPay())) {
                                    lossHealthInfoDTO.setSumCalcPay(exchangeMoney);
                                }
                                if (ObjectUtil.isEmpty((Object)lossHealthInfoDTO.getSumRealPay())) {
                                    lossHealthInfoDTO.setSumRealPay(exchangeMoney);
                                }
                                if (ObjectUtil.isNotEmpty((Object)openBillRequestDTO.getDflossPersBillInfo())) {
                                    lossHealthInfoDTO.setCurrencyL("RMB");
                                }
                                if (ObjectUtil.isNotEmpty((Object)openBillRequestDTO.getDflossPersBillInfo())) {
                                    lossHealthInfoDTO.setCurrencyP("RMB");
                                }
                                if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getRegist().getRegistDamageInfo().getCurrency()) && ObjectUtil.isNotEmpty((Object)openBillRequestDTO.getDflossPersBillInfo())) {
                                    log.warn("\u8bbe\u7f6eRegistDamageInfo.Currency\u4e3a{}", (Object)((DflossPersBillInfoDTO)openBillRequestDTO.getDflossPersBillInfo().get(0)).getCurrency());
                                    openBillRequestDTO.getRegist().getRegistDamageInfo().setCurrency(((DflossPersBillInfoDTO)openBillRequestDTO.getDflossPersBillInfo().get(0)).getCurrency());
                                }
                                compensateInfoDTO.setSumRealPay(exchangeMoney);
                                lossHealthInfoDTO.setSumLossFee(exchangeMoney);
                            } else {
                                if (ObjectUtil.isEmpty((Object)lossHealthInfoDTO.getSumCalcPay())) {
                                    lossHealthInfoDTO.setSumCalcPay(lossHealthInfoDTO.getSumLossFee());
                                }
                                if (ObjectUtil.isEmpty((Object)lossHealthInfoDTO.getSumRealPay())) {
                                    lossHealthInfoDTO.setSumRealPay(lossHealthInfoDTO.getSumLossFee());
                                }
                                if (ObjectUtil.isNotEmpty((Object)openBillRequestDTO.getDflossPersBillInfo())) {
                                    lossHealthInfoDTO.setCurrencyL(((DflossPersBillInfoDTO)openBillRequestDTO.getDflossPersBillInfo().get(0)).getCurrency());
                                }
                                if (ObjectUtil.isNotEmpty((Object)openBillRequestDTO.getDflossPersBillInfo())) {
                                    lossHealthInfoDTO.setCurrencyP(((DflossPersBillInfoDTO)openBillRequestDTO.getDflossPersBillInfo().get(0)).getCurrency());
                                }
                                if (ObjectUtil.isNotEmpty((Object)openBillRequestDTO.getDflossPersBillInfo())) {
                                    openBillRequestDTO.getRegist().getRegistDamageInfo().setCurrency(((DflossPersBillInfoDTO)openBillRequestDTO.getDflossPersBillInfo().get(0)).getCurrency());
                                }
                                if (ObjectUtil.isEmpty((Object)compensateInfoDTO.getSumRealPay())) {
                                    compensateInfoDTO.setSumRealPay(lossHealthInfoDTO.getSumLossFee());
                                }
                            }
                            if (!ENDCASE.equals(openBillRequestDTO.getStep()) || BigDecimal.ZERO.compareTo(lossHealthInfoDTO.getSumRealPay()) != 0) continue;
                            openBillRequestDTO.setZeroClaimFlag("1");
                            openBillRequestDTO.setZeroReasonCode("2");
                        }
                    }
                    if (ObjectUtil.isNotEmpty((Object)(payPersonInfoDTOS = compensateInfoDTO.getPayPersonInfo()))) {
                        for (PayPersonInfoDTO payPersonInfoDTO : payPersonInfoDTOS) {
                            if ("05_10".indexOf(openBillRequestDTO.getReportType()) != -1) {
                                if (StringUtils.isBlank((CharSequence)payPersonInfoDTO.getPayNowFlag())) {
                                    payPersonInfoDTO.setPayNowFlag("2");
                                }
                                if (StringUtils.isBlank((CharSequence)payPersonInfoDTO.getPayObjectKind())) {
                                    if (!payPersonInfoDTO.getPayeeName().equals(openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getDamagePersonName())) {
                                        payPersonInfoDTO.setPayObjectKind("05");
                                    } else {
                                        payPersonInfoDTO.setPayObjectKind("01");
                                    }
                                }
                                if (StringUtils.isBlank((CharSequence)payPersonInfoDTO.getPayObjectType())) {
                                    payPersonInfoDTO.setPayObjectType("1");
                                }
                                if (StringUtils.isBlank((CharSequence)payPersonInfoDTO.getPayment())) {
                                    payPersonInfoDTO.setPayment("02");
                                }
                                if (StringUtils.isBlank((CharSequence)payPersonInfoDTO.getPayeeMobile())) {
                                    payPersonInfoDTO.setPayeeMobile(openBillRequestDTO.getRegist().getRegistInfo().getReportorPhone());
                                }
                                if (!payPersonInfoDTO.getPayeeName().equals(openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getDamagePersonName())) {
                                    payPersonInfoDTO.setOtherCause("23");
                                }
                                if (ENDCASE.equals(openBillRequestDTO.getStep()) && ObjectUtil.isEmpty((Object)payPersonInfoDTO.getPayeeFee())) {
                                    payPersonInfoDTO.setPayeeFee(compensateInfoDTO.getSumRealPay());
                                }
                            }
                            if (!openBillRequestDTO.getStep().equals(COMPENSATE) || !"xml".equals(openBillRequestDTO.getType())) continue;
                            if (StringUtils.isBlank((CharSequence)payPersonInfoDTO.getPayObjectKind())) {
                                Integer insureAge = openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getDamagePersonAge();
                                if (payPersonInfoDTO.getPayeeName().equals(openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getDamagePersonName())) {
                                    payPersonInfoDTO.setPayObjectKind("01");
                                } else if (ObjectUtil.isNotEmpty((Object)insureAge) && insureAge < 18) {
                                    payPersonInfoDTO.setPayObjectKind("05");
                                    payPersonInfoDTO.setOtherCause("23");
                                } else {
                                    payPersonInfoDTO.setPayObjectKind("99");
                                    payPersonInfoDTO.setOtherCause("99");
                                }
                            }
                            if (!StringUtils.isBlank((CharSequence)payPersonInfoDTO.getPayObjectType())) continue;
                            payPersonInfoDTO.setPayObjectType("1");
                        }
                    }
                    if (openBillRequestDTO.getStep().equals(ENDCASE) && "xml".equals(openBillRequestDTO.getType())) {
                        PayPersonInfoDTO payPersonInfoDTO = new PayPersonInfoDTO();
                        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
                        apisChannelConfigs.setDeleted(Integer.valueOf(0));
                        apisChannelConfigs.setUserCode(request.getClaimOpenBillServiceRequest().getHead().getUser());
                        apisChannelConfigs.setConfigCode(ENDCASE_PLAN_CODE);
                        apisChannelConfigs.setValueType(openBillRequestDTO.getDamageResult());
                        QueryWrapper queryWrapper = new QueryWrapper((Object)apisChannelConfigs);
                        apisChannelConfigs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
                        String[] arr = apisChannelConfigs.getRemark().split(",");
                        payPersonInfoDTO.setCertifyType(arr[0]);
                        payPersonInfoDTO.setCertifyNo(arr[1]);
                        payPersonInfoDTO.setAccountNo(arr[2]);
                        payPersonInfoDTO.setPayeeName(arr[3]);
                        payPersonInfoDTO.setBankName(arr[4]);
                        payPersonInfoDTO.setBankCode(arr[5]);
                        payPersonInfoDTO.setPayeeMobile(arr[6]);
                        payPersonInfoDTO.setBankOutlets(arr[7]);
                        payPersonInfoDTO.setPayNowFlag("0");
                        payPersonInfoDTO.setPayObjectKind("99");
                        if (!payPersonInfoDTO.getPayeeName().equals(openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getDamagePersonName())) {
                            payPersonInfoDTO.setOtherCause("13");
                        }
                        payPersonInfoDTO.setPayObjectType("2");
                        payPersonInfoDTO.setPayment("02");
                        payPersonInfoDTO.setPayeeFee(compensateInfoDTO.getSumRealPay());
                        payPersonInfoDTOS.add(payPersonInfoDTO);
                        if (BigDecimal.ZERO.compareTo(openBillRequestDTO.getRegist().getRegistDamageInfo().getReportedLoss()) == 0) {
                            openBillRequestDTO.setZeroClaimFlag("1");
                            openBillRequestDTO.setZeroReasonCode("2");
                            ((LossDelayInfoDTO)lossDelayInfoDTOS.get(0)).setSumRealPay(openBillRequestDTO.getRegist().getRegistDamageInfo().getReportedLoss());
                        }
                    }
                    if (openBillRequestDTO.getStep().equals(ENDCASE)) {
                        CollectInfoDTO collectInfoDTO = new CollectInfoDTO();
                        if (ObjectUtil.isNotEmpty((Object)openBillRequestDTO.getCollectInfo())) {
                            collectInfoDTO = openBillRequestDTO.getCollectInfo();
                        }
                        DateTime date = new DateTime();
                        collectInfoDTO.setClaimApplyTime((Date)date);
                        collectInfoDTO.setNotifyTime((Date)date);
                        collectInfoDTO.setSource("1");
                        collectInfoDTO.setStatus("4");
                        ArrayList<CollectguideInfoDTO> collectguideInfoDTOS = new ArrayList<CollectguideInfoDTO>();
                        CollectguideInfoDTO collectguideInfoDTO = new CollectguideInfoDTO();
                        collectguideInfoDTO.setDocCode("99930");
                        collectguideInfoDTO.setEndDate((Date)date);
                        collectguideInfoDTOS.add(collectguideInfoDTO);
                        collectInfoDTO.setCollectguideInfo(collectguideInfoDTOS);
                        openBillRequestDTO.setCollectInfo(collectInfoDTO);
                    }
                    compensateInfoDTO.setLossDelayInfo(lossDelayInfoDTOS);
                    compensateInfoDTO.setLossHealthInfo(lossHealthInfoDTOS);
                    compensateInfoDTO.setPayPersonInfo(payPersonInfoDTOS);
                    ArrayList<ChargeInfoDTO> chargeInfoDTOList = compensateInfoDTO.getChargeInfo();
                    if (ObjectUtil.isEmpty((Object)chargeInfoDTOList)) {
                        chargeInfoDTOList = new ArrayList<ChargeInfoDTO>();
                    }
                    ChargeInfoDTO chargeInfoDTO = new ChargeInfoDTO();
                    if (chargeInfoDTOList.size() > 0) {
                        chargeInfoDTO = (ChargeInfoDTO)chargeInfoDTOList.get(0);
                    }
                    chargeInfoDTO.setRiskCode(((PolicyListDTO)policyListQueryResponse.getResponseBody().getPolicyList().get(0)).getRiskCode());
                    if (chargeInfoDTOList.size() > 0) {
                        chargeInfoDTOList.set(0, chargeInfoDTO);
                    } else {
                        chargeInfoDTOList.add(chargeInfoDTO);
                    }
                    compensateInfoDTO.setChargeInfo(chargeInfoDTOList);
                }
            }
        } else {
            if (ObjectUtil.isNotEmpty((Object)openBillRequestDTO.getDflossPersBillInfo()) && "05_10".indexOf(openBillRequestDTO.getReportType()) != -1 && "07".equals(openBillRequestDTO.getDamageResult())) {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setCurrency(((DflossPersBillInfoDTO)openBillRequestDTO.getDflossPersBillInfo().get(0)).getCurrency());
            }
            ArrayList<PayPersonInfoDTO> payPersonInfoDTOS = new ArrayList<PayPersonInfoDTO>();
            if (ObjectUtil.isNotEmpty((Object)openBillRequestDTO.getCompensateInfoList())) {
                for (CompensateInfoDTO compensateInfoDTO : openBillRequestDTO.getCompensateInfoList()) {
                    if (!ObjectUtil.isNotEmpty((Object)compensateInfoDTO.getPayPersonInfo())) continue;
                    for (PayPersonInfoDTO payPersonInfoDTO : compensateInfoDTO.getPayPersonInfo()) {
                        if (ObjectUtil.isNotEmpty((Object)payPersonInfoDTO.getBankCode()) && ObjectUtil.isEmpty((Object)payPersonInfoDTO.getBankName())) {
                            payPersonInfoDTO.setBankName(this.apisChannelCodeMapper.getValueDesc(null, "PRPDBANK", payPersonInfoDTO.getBankCode()));
                        }
                        if (!StringUtils.isNotBlank((CharSequence)payPersonInfoDTO.getBankCode()) || !StringUtils.isNotBlank((CharSequence)payPersonInfoDTO.getBankName()) || !StringUtils.isNotBlank((CharSequence)payPersonInfoDTO.getAccountNo()) || !StringUtils.isNotBlank((CharSequence)payPersonInfoDTO.getPayeeName())) continue;
                        String jsonString = JSON.toJSONString((Object)payPersonInfoDTO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
                        PayPersonInfoDTO params = (PayPersonInfoDTO)JSONObject.parseObject((String)jsonString, PayPersonInfoDTO.class);
                        payPersonInfoDTOS.add(params);
                    }
                }
            }
            if (payPersonInfoDTOS.size() > 0) {
                openBillRequestDTO.setPayPersonInfoList(payPersonInfoDTOS);
                for (PayPersonInfoDTO personInfoDTO : openBillRequestDTO.getPayPersonInfoList()) {
                    if ("05_10".indexOf(openBillRequestDTO.getReportType()) != -1) {
                        if (!personInfoDTO.getPayeeName().equals(openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getDamagePersonName())) {
                            personInfoDTO.setPayObjectKind("05");
                        } else {
                            personInfoDTO.setPayObjectKind("01");
                        }
                    } else {
                        personInfoDTO.setPayObjectKind("01");
                    }
                    personInfoDTO.setPayObjectType("1");
                }
            }
        }
        if (openBillRequestDTO.getStep().equals(REGIST)) {
            openBillRequestDTO.setStatus("2");
        }
        if (isCommerialInsure.booleanValue()) {
            openBillRequestDTO.getRegist().setRegistDamagePersonInfo(null);
        }
    }

    private void supplementLossOutReason(ClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
        if ("2".equals(openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageReasonType()) && StringUtils.isEmpty((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getLossOutReasonCode())) {
            String lossOutReasonCode = this.apisChannelCodeMapper.getCoreValue(null, "outReason", openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageCode());
            if (StringUtils.isEmpty((CharSequence)lossOutReasonCode)) {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setLossOutReasonCode("X58-X59");
            } else {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setLossOutReasonCode(lossOutReasonCode);
            }
        }
    }

    private void supplementCollectInfo(ClaimOpenBillRequestDTO openBillRequestDTO) {
        if ("xml".equals(openBillRequestDTO.getType()) && ENDCASE.equals(openBillRequestDTO.getStep())) {
            CollectInfoDTO collectInfoDTO = new CollectInfoDTO();
            Date reportTime = openBillRequestDTO.getRegist().getRegistInfo().getReportTime();
            collectInfoDTO.setClaimApplyTime(ObjectUtil.isNotEmpty((Object)reportTime) ? reportTime : new Date());
            collectInfoDTO.setNotifyTime(ObjectUtil.isNotEmpty((Object)reportTime) ? reportTime : new Date());
            collectInfoDTO.setEndTime(ObjectUtil.isNotEmpty((Object)reportTime) ? reportTime : new Date());
            collectInfoDTO.setSource("1");
            collectInfoDTO.setStatus("4");
            ArrayList<CollectguideInfoDTO> collectguideInfoDTOList = new ArrayList<CollectguideInfoDTO>();
            CollectguideInfoDTO collectguideInfoDTO = new CollectguideInfoDTO();
            collectguideInfoDTO.setDocCode("5");
            collectguideInfoDTO.setDocName("\u8eab\u4efd\u8bc1");
            collectguideInfoDTO.setEndDate(ObjectUtil.isNotEmpty((Object)reportTime) ? reportTime : new Date());
            collectguideInfoDTOList.add(collectguideInfoDTO);
            collectInfoDTO.setCollectguideInfo(collectguideInfoDTOList);
            openBillRequestDTO.setCollectInfo(collectInfoDTO);
        }
    }

    private void xcCompletion(StanderRequest request, PolicyListQueryResponse policyListQueryResponse) throws ApisDataCompletionException {
        ClaimOpenBillRequestDTO openBillRequestDTO = request.getClaimOpenBillServiceRequest().getBody();
        TimeInterval timer = DateUtil.timer();
        if ("xcxml".equals(openBillRequestDTO.getType())) {
            if (StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getDamageResult())) {
                String newResult = this.getNewResult(openBillRequestDTO.getDamageResult());
                openBillRequestDTO.setDamageResult(newResult);
                openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageResult(newResult);
            }
            log.warn("\u5f00\u6848\uff0c\u7406\u8d54\u539f\u56e0code\u8f6c\u6362\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            List<String> damageCodeList = Arrays.asList(openBillRequestDTO.getDamageResult().split(","));
            if (damageCodeList.contains("07")) {
                ArrayList<String> kindList = new ArrayList<String>();
                for (PolicyListDTO policyListDTO : policyListQueryResponse.getResponseBody().getPolicyList()) {
                    for (ItemMainDTO itemMainDTO : policyListDTO.getCoverage().getItemList()) {
                        for (ItemKindDTO itemKindDTO : itemMainDTO.getItemKind()) {
                            kindList.add(itemKindDTO.getKindCode());
                        }
                    }
                }
                List damageTypeList = this.apisChannelCodeMapper.getValueByDamageResultList("kind_damageType", kindList);
                if (ObjectUtil.isEmpty((Object)damageTypeList) || damageTypeList.size() == 0) {
                    throw ApisDataCompletionException.builder().errorCode(ErrorCode.KIND_FAIL.getCode()).message(ErrorCode.KIND_FAIL.getMessage()).build();
                }
                if (damageTypeList.contains("1") || damageTypeList.contains("2\u30011")) {
                    openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageReasonType("1");
                    openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageCode("9999");
                } else if (damageTypeList.contains("2")) {
                    openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageReasonType("2");
                    openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageCode("9999");
                } else {
                    throw ApisDataCompletionException.builder().errorCode(ErrorCode.KIND_LACK.getCode()).message(ErrorCode.KIND_LACK.getMessage()).build();
                }
                openBillRequestDTO.getRegist().getRegistDamageInfo().setHospitalCode("9999999");
                openBillRequestDTO.getRegist().getRegistDamageInfo().setHospitalName("\u5176\u4ed6\u533b\u9662");
            } else {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageReasonType("9");
                openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageCode("999");
            }
            log.warn("\u5f00\u6848\uff0c\u51fa\u9669\u539f\u56e0\u8bbe\u7f6e\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        }
    }

    private void standardCompletion(ClaimOpenBillRequestDTO openBillRequestDTO, PolicyListQueryResponse policyListQueryResponse) throws ApisDataCompletionException {
        if ("xml".equals(openBillRequestDTO.getType())) {
            String identifyType;
            RegistDamageInfoDTO registDamageInfo = openBillRequestDTO.getRegist().getRegistDamageInfo();
            if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistInfo().getReportorPhone())) {
                openBillRequestDTO.getRegist().getRegistInfo().setReportorPhone(openBillRequestDTO.getRegist().getRegistInfo().getLinkerPhone());
            }
            if (StringUtils.isNotBlank((CharSequence)(identifyType = openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getIdentifyType()))) {
                if (StringUtils.isNotBlank((CharSequence)(identifyType = this.apisChannelCodeMapper.getCoreValueValid(null, "IdentifyType", identifyType)))) {
                    openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setIdentifyType(identifyType);
                } else {
                    throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_IN.getCode()).message("\u8bc1\u4ef6\u7c7b\u578b" + ErrorCode.NOT_IN.getMessage()).build();
                }
            }
            if ("07".equals(openBillRequestDTO.getDamageResult()) && StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageReasonType()) || "3".equals(openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageReasonType())) {
                ArrayList<String> kindList = new ArrayList<String>();
                for (PolicyListDTO policyListDTO : policyListQueryResponse.getResponseBody().getPolicyList()) {
                    for (ItemMainDTO itemMainDTO : policyListDTO.getCoverage().getItemList()) {
                        for (ItemKindDTO itemKindDTO : itemMainDTO.getItemKind()) {
                            kindList.add(itemKindDTO.getKindCode());
                        }
                    }
                }
                if ("07".equals(openBillRequestDTO.getDamageResult())) {
                    if (ObjectUtil.isEmpty(kindList) || kindList.size() == 0) {
                        throw ApisDataCompletionException.builder().errorCode(ErrorCode.KINDLIST_ERR0R.getCode()).message(ErrorCode.KINDLIST_ERR0R.getMessage()).build();
                    }
                    List damageTypeList = this.apisChannelCodeMapper.getValueByDamageResultList("kind_damageType", kindList);
                    if (ObjectUtil.isEmpty((Object)damageTypeList) || damageTypeList.size() == 0) {
                        throw ApisDataCompletionException.builder().errorCode(ErrorCode.KIND_FAIL.getCode()).message(ErrorCode.KIND_FAIL.getMessage()).build();
                    }
                    if (damageTypeList.contains("1") || damageTypeList.contains("2\u30011")) {
                        openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageReasonType("1");
                    } else if (damageTypeList.contains("2")) {
                        openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageReasonType("2");
                    } else {
                        throw ApisDataCompletionException.builder().errorCode(ErrorCode.KIND_LACK.getCode()).message(ErrorCode.KIND_LACK.getMessage()).build();
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)registDamageInfo.getCountryCode()) && "0".equals(registDamageInfo.getNationFlag())) {
                String country = this.apisChannelCodeMapper.getValueDesc(null, "PRPDCOUNTRY", registDamageInfo.getCountryCode());
                registDamageInfo.setCountry(country);
                registDamageInfo.setCountryCode(this.apisChannelCodeMapper.getCoreValue(null, "PRPDCOUNTRY", registDamageInfo.getCountryCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)registDamageInfo.getProvinceCode()) && "1".equals(registDamageInfo.getNationFlag())) {
                String provinceName = this.apisChannelCodeMapper.getValueDesc(null, "province", registDamageInfo.getProvinceCode());
                registDamageInfo.setProvinceName(StringUtils.isNotBlank((CharSequence)provinceName) ? provinceName : "\u5168\u56fd");
                String provinceCode = this.baseCodeConvertUtils.convertLocationCode("province", registDamageInfo.getProvinceCode(), null, null);
                registDamageInfo.setProvinceCode(StringUtils.isNotBlank((CharSequence)provinceCode) ? provinceCode : "999999");
            }
            if (StringUtils.isNotBlank((CharSequence)registDamageInfo.getCityCode()) && "1".equals(registDamageInfo.getNationFlag()) && StringUtils.isNotBlank((CharSequence)registDamageInfo.getProvinceCode())) {
                String cityName = this.apisChannelCodeMapper.getValueDescByProvinceCode("city", registDamageInfo.getCityCode(), registDamageInfo.getProvinceCode().substring(0, 2));
                registDamageInfo.setCityName(StringUtils.isNotBlank((CharSequence)cityName) ? cityName : "\u4e2d\u56fd");
                String cityCode = this.baseCodeConvertUtils.convertLocationCode("city", registDamageInfo.getProvinceCode(), registDamageInfo.getCityCode(), null);
                registDamageInfo.setCityCode(StringUtils.isNotBlank((CharSequence)cityCode) ? cityCode : "999999");
            }
            registDamageInfo.setCountyCode("999999");
            registDamageInfo.setCountyName("\u4e2d\u56fd");
            if (StringUtils.isNotBlank((CharSequence)registDamageInfo.getDamageCode())) {
                String corePreSelect = this.getCorePreSelect(registDamageInfo.getDamageCode());
                registDamageInfo.setDamageCode(corePreSelect);
            }
            if (StringUtils.isBlank((CharSequence)registDamageInfo.getDamageCode())) {
                if ("9".equals(openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageReasonType())) {
                    registDamageInfo.setDamageCode("999");
                } else {
                    registDamageInfo.setDamageCode("9999");
                }
            }
            if (openBillRequestDTO.getCompensateInfoList() != null) {
                for (CompensateInfoDTO compensateInfo : openBillRequestDTO.getCompensateInfoList()) {
                    List payPersonInfoList;
                    if (compensateInfo.getPayPersonInfo() != null && (payPersonInfoList = compensateInfo.getPayPersonInfo()) != null) {
                        for (PayPersonInfoDTO payPersonInfo : payPersonInfoList) {
                            if (payPersonInfo.getBankCode() == null) continue;
                            payPersonInfo.setBankCode(this.apisChannelCodeMapper.getCoreValue(null, "PRPDBANK", payPersonInfo.getBankCode()));
                        }
                    }
                    if (compensateInfo.getLossDelayInfo() == null || compensateInfo.getLossDelayInfo().size() <= 0) continue;
                    for (LossDelayInfoDTO lossDelayInfoDTO : compensateInfo.getLossDelayInfo()) {
                        lossDelayInfoDTO.setLossFeeType(openBillRequestDTO.getDamageResult());
                    }
                }
            }
        }
    }

    private void accountAuthCheck(StanderRequest request, PolicyListQueryResponse policyListQueryResponse) throws ApisBusinessException {
        ClaimOpenBillRequestDTO openBillRequestDTO = request.getClaimOpenBillServiceRequest().getBody();
        if ("xml".equals(openBillRequestDTO.getType())) {
            List openStep = this.apisChannelConfigsMapper.getValueByUserAndCodeList(request.getClaimOpenBillServiceRequest().getHead().getUser(), "open_step");
            if (openStep == null || openStep.size() == 0) {
                throw ApisDataCompletionException.builder().errorCode(ErrorCode.INTERFACE_ERROR.getCode()).message(ErrorCode.INTERFACE_ERROR.getMessage()).build();
            }
            this.checkEndCasePlan(request, openStep, policyListQueryResponse);
        }
        if ("xml".equals(openBillRequestDTO.getType())) {
            this.maxAmountCheck(request);
        }
    }

    private void commonCompletion(StanderRequest request) throws ApisDataCompletionException {
        String damageResult;
        String newReportWay;
        ClaimOpenBillRequestDTO openBillRequestDTO = request.getClaimOpenBillServiceRequest().getBody();
        if ("xml".equals(openBillRequestDTO.getType()) && StringUtils.isNotBlank((CharSequence)(newReportWay = this.apisChannelCodeMapper.getCoreValue(null, "reportWay", openBillRequestDTO.getReportType())))) {
            openBillRequestDTO.setReportType(newReportWay);
            openBillRequestDTO.getRegist().getRegistInfo().setReportType(newReportWay);
        }
        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getNationFlag())) {
            openBillRequestDTO.getRegist().getRegistDamageInfo().setNationFlag("1");
        }
        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getAccidentAddress())) {
            openBillRequestDTO.getRegist().getRegistDamageInfo().setAccidentAddress("\u4e2d\u56fd");
        }
        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistInfo().getReportorRelation())) {
            openBillRequestDTO.getRegist().getRegistInfo().setReportorRelation("99");
        }
        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getReportorRelation())) {
            openBillRequestDTO.getRegist().getRegistDamagePersonInfo().setReportorRelation("99");
        }
        if (null == openBillRequestDTO.getRegist().getRegistDamageInfo().getReportedLoss()) {
            openBillRequestDTO.getRegist().getRegistDamageInfo().setReportedLoss(BigDecimal.valueOf(0L));
        }
        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageReasonType()) && !"07".equals(damageResult = this.checkDamageResult(openBillRequestDTO))) {
            openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageReasonType("9");
        }
        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageCode())) {
            damageResult = this.checkDamageResult(openBillRequestDTO);
            if (!"07".equals(damageResult)) {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageCode("999");
            } else {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setDamageCode("9999");
            }
        }
        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getCurrency())) {
            openBillRequestDTO.getRegist().getRegistDamageInfo().setCurrency("RMB");
        }
        if ("07".equals(openBillRequestDTO.getDamageResult())) {
            String hospitalCode;
            String hospitalName;
            if (StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getHospitalCode()) && StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getHospitalName()) && StringUtils.isNotBlank((CharSequence)(hospitalName = this.apisChannelCodeMapper.getCoreValue(null, "hospital", openBillRequestDTO.getRegist().getRegistDamageInfo().getHospitalCode())))) {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setHospitalName(hospitalName);
            }
            if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getHospitalCode()) && StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getHospitalName()) && StringUtils.isNotBlank((CharSequence)(hospitalCode = this.apisChannelCodeMapper.getChannelValue(null, "hospital", openBillRequestDTO.getRegist().getRegistDamageInfo().getHospitalName())))) {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setHospitalCode(hospitalCode);
            }
            if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getHospitalCode()) && StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getHospitalName())) {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setHospitalCode("9999999");
                openBillRequestDTO.getRegist().getRegistDamageInfo().setHospitalName("\u5176\u4ed6\u533b\u9662");
            }
            if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamageInfo().getDiagnosis())) {
                openBillRequestDTO.getRegist().getRegistDamageInfo().setDiagnosis("\u5176\u4ed6");
            }
        }
    }

    private String checkDamageResult(ClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
        String damageResult = openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageResult();
        if (StringUtils.isBlank((CharSequence)damageResult)) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u7406\u8d54\u7c7b\u578b" + ErrorCode.NOT_NULL.getMessage()).build();
        }
        return damageResult;
    }

    private void checkEndCasePlan(StanderRequest request, List<String> openStep, PolicyListQueryResponse policyListQueryResponse) throws ApisBusinessException {
        ClaimOpenBillRequestDTO openBillRequestDTO = request.getClaimOpenBillServiceRequest().getBody();
        if (!openStep.contains(REGIST)) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.INTERFACE_ERROR.getCode()).message(ErrorCode.INTERFACE_ERROR.getMessage()).build();
        }
        boolean endCasePlan = false;
        if ("22".equals(openBillRequestDTO.getDamageResult()) && StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getSpOperator())) {
            List policyList;
            List endcasePlanCode = this.apisChannelConfigsMapper.getValueByCodeAndName(ENDCASE_PLAN_CODE, openBillRequestDTO.getDamageResult());
            String goodsCode = "";
            if (ObjectUtil.isNotEmpty((Object)endcasePlanCode) && endcasePlanCode.size() > 0 && ObjectUtil.isNotEmpty((Object)policyListQueryResponse.getResponseBody()) && ObjectUtil.isNotEmpty((Object)(policyList = policyListQueryResponse.getResponseBody().getPolicyList())) && policyList.size() > 0) {
                block0: for (PolicyListDTO policyListDTO : policyList) {
                    if (!ObjectUtil.isNotEmpty((Object)policyListDTO.getInsuredList()) || policyListDTO.getInsuredList().size() <= 0) continue;
                    for (InsuredDTO insuredDTO : policyListDTO.getInsuredList()) {
                        if (StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getIdentifyNo())) {
                            if (!openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getIdentifyNo().equals(insuredDTO.getIdentifyNumber())) continue;
                            goodsCode = insuredDTO.getGoodsCode();
                            continue block0;
                        }
                        if (!openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getDamagePersonName().equals(insuredDTO.getInsuredName())) continue;
                        goodsCode = insuredDTO.getGoodsCode();
                        continue block0;
                    }
                }
            }
            if (endcasePlanCode.contains(goodsCode)) {
                endCasePlan = true;
            }
        }
        if (endCasePlan) {
            if (!openStep.contains(ENDCASE)) {
                throw ApisDataCompletionException.builder().errorCode(ErrorCode.INTERFACE_ERROR.getCode()).message(ErrorCode.INTERFACE_ERROR.getMessage()).build();
            }
        } else {
            if (openStep.contains(COMPENSATE)) {
                openBillRequestDTO.setStep(COMPENSATE);
                return;
            }
            openBillRequestDTO.setStep(REGIST);
            return;
        }
        openBillRequestDTO.setStep(ENDCASE);
        openBillRequestDTO.setStatus("1");
    }

    private PolicyListQueryResponse getPolicyList(StanderRequest standerRequest) throws ApisBusinessException {
        ClaimOpenBillRequestDTO openBillRequestDTO = standerRequest.getClaimOpenBillServiceRequest().getBody();
        PolicyListServiceRequest policyListServiceRequest = PolicyListServiceRequest.builder().build();
        policyListServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        String userCode = standerRequest.getHeader().getUserCode();
        PolicyListQueryRequestDTO policyListQueryRequestDTO = PolicyListQueryRequestDTO.builder().build();
        policyListQueryRequestDTO.setPolicyNo(openBillRequestDTO.getPolicyNo());
        policyListQueryRequestDTO.setBusinessNature2(CHANNEL_CODE);
        policyListQueryRequestDTO.setOperateCode(CHANNEL_CODE);
        String damageName = openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getDamagePersonName();
        if ("xcxml".equals(openBillRequestDTO.getType()) && StringUtils.isNotEmpty((CharSequence)damageName) && this.isEnchar(damageName)) {
            damageName = null;
        }
        policyListQueryRequestDTO.setInsuredName(StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getIdentifyNo()) ? damageName : null);
        policyListQueryRequestDTO.setIdentifyNumber(openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getIdentifyNo());
        policyListQueryRequestDTO.setClaimType("all");
        policyListServiceRequest.setRequestBody(policyListQueryRequestDTO);
        StanderRequest request = new StanderRequest();
        request.setHeader(new StanderHeader("policyList", "JME_USER", "JME_USER", UUID.fastUUID().toString().replaceAll("-", ""), null, null));
        request.setPolicyListServiceRequest(policyListServiceRequest);
        RegistDataCompletion.restTemplateInstance((RestTemplate)this.restTemplate);
        log.warn("\u8c03\u7528\u4fdd\u5355\u8be6\u60c5\u63a5\u53e3\uff0c\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)request));
        log.warn("\u8c03\u7528\u4fdd\u5355\u8be6\u60c5\u63a5\u53e3\uff0c\u8bf7\u6c42url\uff1a{}", (Object)this.policyListAddress);
        String json = (String)this.restTemplate.postForObject(this.policyListAddress, (Object)request, String.class, new Object[0]);
        WebResponse webResponse = (WebResponse)JSON.parseObject((String)json, WebResponse.class);
        if (ObjectUtil.isNotEmpty((Object)webResponse) && ObjectUtil.isNotEmpty((Object)webResponse.getResult())) {
            StanderResponse standerResponse = (StanderResponse)JSON.parseObject((String)webResponse.getResult().toString(), StanderResponse.class);
            log.warn("\u8c03\u7528\u4fdd\u5355\u8be6\u60c5\u63a5\u53e3\uff0c\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)standerResponse));
            if (ObjectUtil.isNotEmpty((Object)standerResponse)) {
                return standerResponse.getPolicyListQueryResponse();
            }
        }
        return null;
    }

    private void maxAmountCheck(StanderRequest request) throws ApisDataCompletionException {
        ClaimOpenBillRequestDTO openBillRequestDTO = request.getClaimOpenBillServiceRequest().getBody();
        if ("compensate".equals(openBillRequestDTO.getStep()) || "endcase".equals(openBillRequestDTO.getStep())) {
            String allMaxAmount = this.apisChannelConfigsMapper.getValueByUserCodeAndName(request.getClaimOpenBillServiceRequest().getHead().getUser(), "max_amount", "all");
            List<String> damageResults = Arrays.asList(openBillRequestDTO.getDamageResult().split(","));
            ArrayList<String> maxAmounts = new ArrayList<String>();
            for (String damageResult : damageResults) {
                String oneMaxAmount = this.apisChannelConfigsMapper.getValueByUserCodeAndName(request.getClaimOpenBillServiceRequest().getHead().getUser(), "max_amount", damageResult);
                if (!StringUtils.isNotBlank((CharSequence)oneMaxAmount)) continue;
                maxAmounts.add(oneMaxAmount);
            }
            if (StringUtils.isBlank((CharSequence)allMaxAmount) && maxAmounts.size() == 0) {
                throw ApisDataCompletionException.builder().errorCode(ErrorCode.NO_AMOUNT.getCode()).message(ErrorCode.NO_AMOUNT.getMessage()).build();
            }
            BigDecimal reportedLoss = openBillRequestDTO.getRegist().getRegistDamageInfo().getReportedLoss();
            if (null != reportedLoss) {
                for (String maxAmount : maxAmounts) {
                    if (reportedLoss.compareTo(new BigDecimal(maxAmount)) <= 0) continue;
                    throw ApisDataCompletionException.builder().errorCode(ErrorCode.NO_LOSSTYPEAMOUNT.getCode()).message(ErrorCode.NO_LOSSTYPEAMOUNT.getMessage()).build();
                }
                if (StringUtils.isNotBlank((CharSequence)allMaxAmount) && reportedLoss.compareTo(new BigDecimal(allMaxAmount)) > 0) {
                    throw ApisDataCompletionException.builder().errorCode(ErrorCode.NO_LOSSAMOUNT.getCode()).message(ErrorCode.NO_LOSSAMOUNT.getMessage()).build();
                }
            }
        }
    }

    private String getCorePreSelect(String damageCode) {
        String damage = "";
        damage = damageCode.matches("[\u4e00-\u9fa5]") ? this.apisChannelCodeMapper.getValueByChannelValueDesc("damage", damageCode) : this.apisChannelCodeMapper.getValue("damage", damageCode);
        return damage;
    }

    private void checkData(ClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
        this.notNullCheck(openBillRequestDTO);
        this.notEqualsCheck(openBillRequestDTO);
        this.policyCheck(openBillRequestDTO);
        this.timeCheck(openBillRequestDTO);
        this.formatCheck(openBillRequestDTO);
        this.amountCheck(openBillRequestDTO);
        this.notInCheck(openBillRequestDTO);
    }

    private void formatCheck(ClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
        if (StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getRegist().getRegistInfo().getLinkerEmail()) && !openBillRequestDTO.getRegist().getRegistInfo().getLinkerEmail().matches("^([a-z0-9A-Z]+[-|_|\\.&]?)+@([a-z0-9A-Z]+(-[a-z0-9A-Z]+){0,}\\.)+[a-zA-Z]{2,}$")) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.EMAIL_ERROR.getCode()).message("\u8054\u7cfb\u4eba\u90ae\u7bb1\uff1a" + ErrorCode.EMAIL_ERROR.getMessage()).build();
        }
        if (StringUtils.isNotBlank((CharSequence)openBillRequestDTO.getRegist().getRegistInfo().getReportorEmail()) && !openBillRequestDTO.getRegist().getRegistInfo().getReportorEmail().matches("^([a-z0-9A-Z]+[-|_|\\.&]?)+@([a-z0-9A-Z]+(-[a-z0-9A-Z]+){0,}\\.)+[a-zA-Z]{2,}$")) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.EMAIL_ERROR.getCode()).message("\u62a5\u6848\u4eba\u90ae\u7bb1\uff1a" + ErrorCode.EMAIL_ERROR.getMessage()).build();
        }
    }

    private void notInCheck(ClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
        List reportWays;
        if ("99".equals(openBillRequestDTO.getDamageResult()) && "xml".equals(openBillRequestDTO.getType())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.DAMAGERESULT_NOT_99.getCode()).message(ErrorCode.DAMAGERESULT_NOT_99.getMessage()).build();
        }
        if ("xml".equals(openBillRequestDTO.getType()) && !(reportWays = this.apisChannelCodeMapper.getChannelValueValid("reportWay")).contains(openBillRequestDTO.getReportType())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_IN.getCode()).message("\u62a5\u6848\u9014\u5f84\uff1a" + openBillRequestDTO.getReportType() + ErrorCode.NOT_IN.getMessage()).build();
        }
    }

    private void amountCheck(ClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
    }

    private void policyCheck(ClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
    }

    private void timeCheck(ClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
    }

    private void notNullCheck(ClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
        this.judgeNotNull((Object)openBillRequestDTO.getRegist(), "\u62a5\u6848\u4fe1\u606f " + ErrorCode.NOT_NULL.getMessage());
        this.judgeNotNull((Object)openBillRequestDTO.getRegist().getRegistInfo(), "\u62a5\u6848\u57fa\u672c\u4fe1\u606f " + ErrorCode.NOT_NULL.getMessage());
        this.judgeNotNull((Object)openBillRequestDTO.getRegist().getRegistDamageInfo(), "\u51fa\u9669\u57fa\u672c\u4fe1\u606f " + ErrorCode.NOT_NULL.getMessage());
        this.judgeNotNull((Object)openBillRequestDTO.getRegist().getRegistDamagePersonInfo(), "\u51fa\u9669\u4eba\u57fa\u672c\u4fe1\u606f " + ErrorCode.NOT_NULL.getMessage());
        this.judgeNotNull((Object)openBillRequestDTO.getStatus(), "\u72b6\u6001 " + ErrorCode.NOT_NULL.getMessage());
        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getType())) {
            this.judgeNotNull((Object)openBillRequestDTO.getStep(), "\u6b65\u5e8f " + ErrorCode.NOT_NULL.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getPolicyNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u4fdd\u5355\u53f7 " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getReportType())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u6848\u9014\u5f84 " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistInfo().getReportorName())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u6848\u4eba\u59d3\u540d " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getDamagePersonName())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u51fa\u9669\u4eba\u59d3\u540d " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (("08".equals(openBillRequestDTO.getReportType()) || "AG".equals(openBillRequestDTO.getReportType())) && StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistInfo().getReportChannel())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u6848\u6e20\u9053 " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if ("02".equals(openBillRequestDTO.getReportType()) || "EL".equals(openBillRequestDTO.getReportType()) && StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistInfo().getReportorPhone())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u6848\u4eba\u90ae\u7bb1 " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (!"xcxml".equals(openBillRequestDTO.getType()) && StringUtils.isBlank((CharSequence)openBillRequestDTO.getRegist().getRegistDamagePersonInfo().getIdentifyNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u51fa\u9669\u4eba\u8bc1\u4ef6\u53f7\u7801 " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (("23".equals(openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageResult()) || "KOL176".equals(openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageResult())) && !"xcxml".equals(openBillRequestDTO.getType()) && openBillRequestDTO.getRegist().getRegistDamageBagDelayInfo() == null) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u884c\u674e\u5ef6\u8bef\u4fe1\u606f " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (("22".equals(openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageResult()) || "KOL170".equals(openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageResult())) && "xml".equals(openBillRequestDTO.getType())) {
            List registDamageTravelDelayInfo = openBillRequestDTO.getRegist().getRegistDamageTravelDelayInfo();
            this.judgeNotNull((Object)registDamageTravelDelayInfo, "\u65c5\u884c/\u822a\u73ed\u5ef6\u8bef\u4fe1\u606f " + ErrorCode.NOT_NULL.getMessage());
        }
        if ("25".equals(openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageResult()) && !"xcxml".equals(openBillRequestDTO.getType())) {
            this.judgeNotNull((Object)openBillRequestDTO.getRegist().getRegistDamageInfo().getVisaApplyDate(), "\u9012\u7b7e\u65e5\u671f " + ErrorCode.NOT_NULL.getMessage());
        }
    }

    private void notEqualsCheck(ClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
        if (!openBillRequestDTO.getReportType().equals(openBillRequestDTO.getRegist().getRegistInfo().getReportType())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.CHANNEL_CODE_NOT_EQUALS.getCode()).message(ErrorCode.CHANNEL_CODE_NOT_EQUALS.getMessage()).build();
        }
        if (!openBillRequestDTO.getDamageResult().equals(openBillRequestDTO.getRegist().getRegistDamageInfo().getDamageResult())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.DAMAGE_RESULT_NOT_EQUALS.getCode()).message(ErrorCode.DAMAGE_RESULT_NOT_EQUALS.getMessage()).build();
        }
    }

    public void judgeNotNull(Object target, String message) throws ApisDataCompletionException {
        if (ObjectUtils.isEmpty((Object)target)) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message(message).build();
        }
    }

    private String getNewResult(String oldDamageResult) throws ApisDataCompletionException {
        String[] damageResults;
        List validResults = this.apisChannelCodeMapper.getChannelValueValid("claimType");
        for (String damageResult : damageResults = oldDamageResult.split(",")) {
            if (validResults.contains(damageResult)) continue;
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_IN.getCode()).message("\u7406\u8d54\u7c7b\u578b\uff1a\u3010" + damageResult + "\u3011" + ErrorCode.NOT_IN.getMessage()).build();
        }
        HashSet<String> resultSet = new HashSet<String>();
        String newDamageResults = "";
        for (int i = 0; i < damageResults.length; ++i) {
            String newDamageResult = this.apisChannelCodeMapper.getCoreValue(null, "claimType", damageResults[i]);
            resultSet.add(newDamageResult);
        }
        for (String one : resultSet) {
            newDamageResults = newDamageResults + one + ",";
        }
        if (newDamageResults.length() > 0 && ",".equals(newDamageResults.substring(newDamageResults.length() - 1))) {
            newDamageResults = newDamageResults.substring(0, newDamageResults.length() - 1);
        }
        return newDamageResults;
    }

    public static void restTemplateInstance(RestTemplate restTemplate) {
        List list = restTemplate.getMessageConverters();
        for (HttpMessageConverter httpMessageConverter : list) {
            if (!(httpMessageConverter instanceof StringHttpMessageConverter)) continue;
            ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(Charset.forName("utf-8"));
            break;
        }
    }

    public boolean isEnchar(String string) {
        boolean enflag = false;
        if (EN_PATTERN.matcher(string).find()) {
            enflag = true;
        }
        boolean chineseFlag = false;
        try {
            int len = string.length();
            for (int i = 0; i < len; ++i) {
                String[] codes;
                String temp = URLEncoder.encode(string.charAt(i) + "", "utf-8");
                if (temp.equals(string.charAt(i) + "")) continue;
                for (String code : codes = temp.split("%")) {
                    if (code.compareTo("40") <= 0) continue;
                    chineseFlag = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return chineseFlag && enflag;
    }
}

