/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.SDAesUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.SDStandard;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.response.SDResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SDClaimInfoNotifyUtil {
    private static final Logger log = LoggerFactory.getLogger(SDClaimInfoNotifyUtil.class);
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisChannelUserService apisChannelUserService;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    public static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    static OkHttpClient client = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();

    @Async(value="scheduleTaskNotifyExecutor")
    public void asyncNotice(ApisBusiTaskLog busiTaskLog) {
        this.pushContentToUrl(busiTaskLog);
    }

    @Async(value="scheduleTaskNotifyExecutor")
    public void asyncNoticeComment(ApisBusiTaskLog busiTaskLog) {
        this.pushContentToUrlComment(busiTaskLog);
    }

    public void pushContentToUrlComment(ApisBusiTaskLog busiTaskLog) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushTargetUrl())) {
            log.warn("\u4efb\u52a1businessKey={},\u6ca1\u6709\u914d\u7f6e\u63a8\u9001\u7684URL", (Object)busiTaskLog.getBusinessKey());
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            if (isUpdSuccess) {
                Response resp = (Response)this.convertAndSendForCallback(busiTaskLog.getPushTargetUrl(), (Object)busiTaskLog.getPushContent(), Response.class);
                log.warn("\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\uff1a{}", (Object)resp);
                if (null != resp && resp.isSuccessful()) {
                    busiTaskLog.setPushStatus("1");
                } else {
                    busiTaskLog.setPushStatus("4");
                }
                if (null != resp) {
                    busiTaskLog.setErrMsg(resp.toString());
                }
            }
        }
        catch (Exception e) {
            busiTaskLog.setPushStatus("4");
            busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            log.error("\u5f02\u6b65\u56de\u8c03\u901a\u77e5 error:", (Throwable)e);
        }
        if (isUpdSuccess) {
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    @Async(value="scheduleTaskNotifyExecutor")
    public void asyncNotice(String businessKey, String pushType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_key", (Object)businessKey);
        queryWrapper.eq((Object)"push_type", (Object)pushType);
        queryWrapper.eq((Object)"push_status", (Object)"0");
        ApisBusiTaskLog apisBusiTaskLog = (ApisBusiTaskLog)this.apisBusiTaskLogService.getOne((Wrapper)queryWrapper);
        this.pushContentToUrl(apisBusiTaskLog);
    }

    public void pushContentToUrl(ApisBusiTaskLog busiTaskLog) {
        boolean isUpdSuccess;
        block10: {
            if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
                return;
            }
            if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushTargetUrl())) {
                log.warn("\u4efb\u52a1businessKey={},\u6ca1\u6709\u914d\u7f6e\u63a8\u9001\u7684URL", (Object)busiTaskLog.getBusinessKey());
                busiTaskLog.setPushStatus("5");
                busiTaskLog.setRemark("\u672a\u914d\u7f6e\u4fe1\u606f\u63a8\u9001URL");
                this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
                return;
            }
            isUpdSuccess = false;
            try {
                busiTaskLog.setPushStatus("2");
                busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
                busiTaskLog.setLastPushTime(LocalDateTime.now());
                isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
                if (!isUpdSuccess) break block10;
                ApisChannelUser apisChannelUser = new ApisChannelUser();
                apisChannelUser.setUserCode(busiTaskLog.getCreator());
                apisChannelUser.setDeleted(Integer.valueOf(0));
                apisChannelUser = (ApisChannelUser)this.apisChannelUserService.getOne((Wrapper)new QueryWrapper((Object)apisChannelUser));
                SDStandard sdStandard = null;
                if (1 == busiTaskLog.getPushStep()) {
                    String pushContentAes = SDAesUtils.encryptBase64((String)apisChannelUser.getDecrypKey(), (String)busiTaskLog.getPushContent());
                    sdStandard = SDStandard.builder().inscompanyId("ALCX20210205").content(pushContentAes).build();
                    busiTaskLog.setPushContent(JSON.toJSONString((Object)sdStandard));
                }
                String resp = (String)this.convertAndSendForCallback(busiTaskLog.getPushTargetUrl(), (Object)busiTaskLog.getPushContent(), String.class);
                log.warn("\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\uff1a{}", (Object)resp);
                if (!ObjectUtil.isNotEmpty((Object)resp)) break block10;
                busiTaskLog.setErrMsg(resp);
                SDResponse sdResponseContent = null;
                try {
                    sdStandard = (SDStandard)JSON.parseObject((String)resp, SDStandard.class);
                    String responseContent = SDAesUtils.decryptBase64((String)apisChannelUser.getDecrypKey(), (String)sdStandard.getContent());
                    sdResponseContent = (SDResponse)JSON.parseObject((String)responseContent, SDResponse.class);
                }
                catch (Exception e) {
                    log.error("\u6c34\u6ef4\u7406\u8d54\u8fd4\u56de\u62a5\u6587\u89e3\u5bc6\u5931\u8d25\uff1a", (Throwable)e);
                }
                if (ObjectUtil.isNotEmpty(sdResponseContent) && "1".equals(sdResponseContent.getErrorCode())) {
                    busiTaskLog.setPushStatus("1");
                } else {
                    busiTaskLog.setPushStatus("4");
                }
            }
            catch (Exception e) {
                busiTaskLog.setPushStatus("4");
                busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > 1300 ? e.getMessage().substring(0, 1300) : e.getMessage());
                log.error("\u5f02\u6b65\u56de\u8c03\u901a\u77e5 error:", (Throwable)e);
            }
        }
        if (isUpdSuccess) {
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public <T> T convertAndSendForCallback(String url, Object body, Class<T> respType) {
        Date startDate = new Date();
        try {
            Object resp;
            String requestBodyStr = body instanceof String ? (String)body : JSON.toJSONString((Object)body);
            RequestBody requestBody = RequestBody.create((MediaType)JSON_TYPE, (String)requestBodyStr);
            Request request = new Request.Builder().url(url).post(requestBody).build();
            log.warn("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)requestBodyStr);
            Call call = client.newCall(request);
            Response response = call.execute();
            if (respType == Response.class) {
                resp = response;
            } else if (respType == String.class) {
                resp = response.body().string();
            } else {
                String responseBodyStr = response.body().string();
                log.warn("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseBodyStr);
                resp = JSON.parseObject((String)responseBodyStr, respType);
            }
            Response response2 = resp;
            return (T)response2;
        }
        catch (Exception e) {
            log.error("=============call api error :{}", (Object)url);
            throw new RuntimeException(e);
        }
        finally {
            log.warn("\u63a8\u9001\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
        }
    }

    private void saveTaskInfo(String pushType, String businessKey, Integer pushStep, String errMsg, String pushStatus) {
        ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
        apisBusiTaskLog.setPushType(pushType);
        apisBusiTaskLog.setBusinessKey(businessKey);
        apisBusiTaskLog.setPushStep(pushStep);
        apisBusiTaskLog.setErrMsg(errMsg);
        apisBusiTaskLog.setPushStatus(pushStatus);
        apisBusiTaskLog.setLastPushTime(LocalDateTime.now());
        this.apisBusiTaskLogService.saveTaskInfo(apisBusiTaskLog);
    }

    public Boolean isShuiDiCase(ApisBusiRequestRegist apisBusiRequestRegist) {
        if ("14".equals(apisBusiRequestRegist.getChannelType())) {
            return true;
        }
        ApisChannelConfigs channelConfig = new ApisChannelConfigs();
        channelConfig.setConfigCode("ShuiDiAgencyCode");
        channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
        if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue()) && ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist.getChannelCode()) && channelConfig.getConfigValue().contains(apisBusiRequestRegist.getChannelCode())) {
            return true;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_no", (Object)apisBusiRequestRegist.getPolicyNo());
        queryWrapper.eq((Object)"deleted", (Object)0);
        queryWrapper.eq((Object)"status", (Object)"04");
        ApisBusiChannelOrder apisBusiChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue()) && ObjectUtil.isNotEmpty((Object)apisBusiChannelOrder) && ObjectUtil.isNotEmpty((Object)apisBusiChannelOrder.getChannelCode()) && channelConfig.getConfigValue().contains(apisBusiChannelOrder.getChannelCode())) {
            return true;
        }
        return false;
    }
}

