/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimOpenBillRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimPolicyItemRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyListQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyListServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ImgBatchUploadServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiReqmsgLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiReqmsgLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelUserMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiProperties;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiServProperties;
import com.jdaz.sinosoftgz.coreapi.common.factory.CoreDtoConverterFactory;
import com.jdaz.sinosoftgz.coreapi.common.handler.CoreDtoConverter;
import com.jdaz.sinosoftgz.coreapi.h5img.MediaUploadApi;
import com.sinosoft.image.client.dto.ImgBatchUploadMetaDTO;
import com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO;
import com.sinosoft.image.client.dto.ImgBusiDTO;
import com.sinosoft.image.client.dto.RequestHeadDTO;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class SDRegistDataCompletion {
    private static final Logger log = LoggerFactory.getLogger(SDRegistDataCompletion.class);
    @Autowired
    private ApisChannelCodeMapper apisChannelCodeMapper;
    @Autowired
    private ApisChannelUserMapper apisChannelUserMapper;
    @Value(value="${policyListAddress}")
    private String policyListAddress;
    @Value(value="${policyDetailAddress}")
    private String policyDetailAddress;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    MediaUploadApi mediaUploadApi;
    @Autowired
    CoreDtoConverterFactory coreDtoConverterFactory;
    @Autowired
    ApisBusiReqmsgLogService apisBusiReqmsgLogService;
    @Autowired
    CoreApiProperties coreApiProperties;
    TimeInterval timer = DateUtil.timer();
    private static String ALL = "all";
    private static final List<String> AH_DAMAGE_TYPE = Arrays.asList("07", "01", "03", "04", "08", "21");
    private static final String COMMA = ",";

    public void checkRequestHeadBody(StanderRequest request) throws ApisBusinessException {
        this.judgeNotNull((Object)request, "\u8bf7\u6c42\u62a5\u6587 " + ErrorCode.NOT_NULL.getMessage());
        this.judgeNotNull((Object)request.getSdClaimOpenBillServiceRequest(), "sdClaimOpenBillServiceRequest " + ErrorCode.NOT_NULL.getMessage());
        this.judgeNotNull((Object)request.getSdClaimOpenBillServiceRequest().getHead(), "\u8bf7\u6c42\u5934[head] " + ErrorCode.NOT_NULL.getMessage());
        this.judgeNotNull((Object)request.getSdClaimOpenBillServiceRequest().getBody(), "\u8bf7\u6c42\u4f53[body] " + ErrorCode.NOT_NULL.getMessage());
    }

    public void dataCompletionClaimOpenBillRequestDTO(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        TimeInterval timerAll = DateUtil.timer();
        SDClaimOpenBillRequestDTO openBillRequestDTO = request.getSdClaimOpenBillServiceRequest().getBody();
        this.checkData(openBillRequestDTO);
        log.warn("\u5f00\u6848\uff0c\u6570\u636e\u524d\u7f6e\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.commonCompletion(request);
        log.warn("\u5f00\u6848\uff0c\u516c\u5171\u8865\u5168\u6570\u636e\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        PolicyListQueryResponse policyListQueryResponse = this.checkPolicy(request, openBillRequestDTO);
        log.warn("\u5f00\u6848\uff0c\u67e5\u8be2\u4fdd\u5355\u5217\u8868\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.standardCompletion(openBillRequestDTO, policyListQueryResponse);
        log.warn("\u5f00\u6848\uff0c\u6807\u51c6\u6570\u636e\u8865\u5168\u4e0e\u8f6c\u6362\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        log.warn("\u5f00\u6848\uff0c\u8865\u5168\u4e0e\u8f6c\u6362\u603b\u8017\u65f6\uff0c\u7528\u65f6 :{}", (Object)timerAll.intervalRestart());
    }

    private PolicyListQueryResponse checkPolicy(StanderRequest request, SDClaimOpenBillRequestDTO openBillRequestDTO) throws ApisBusinessException {
        PolicyListQueryResponse policyListQueryResponse = this.getPolicyList(request);
        if (ObjectUtil.isEmpty((Object)policyListQueryResponse) || "0007".equals(policyListQueryResponse.getResponseHead().getAppCode())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NO_INSURER.getCode()).message(ErrorCode.NO_INSURER.getMessage()).build();
        }
        if (ObjectUtil.isNotEmpty((Object)policyListQueryResponse.getResponseBody()) && policyListQueryResponse.getResponseBody().getPolicyList().size() > 0) {
            ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
            apisChannelConfigs.setConfigCode("ShuiDiAgencyCode");
            apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs) && !apisChannelConfigs.getConfigValue().contains(((PolicyListDTO)policyListQueryResponse.getResponseBody().getPolicyList().get(0)).getAgentCode())) {
                throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_MATCH_AGENCYCODE.getCode()).message(ErrorCode.NOT_MATCH_AGENCYCODE.getMessage()).build();
            }
        }
        return policyListQueryResponse;
    }

    private void standardCompletion(SDClaimOpenBillRequestDTO openBillRequestDTO, PolicyListQueryResponse policyListQueryResponse) throws ApisDataCompletionException {
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getIdentifyType())) {
            openBillRequestDTO.setIdentifyType(((InsuredDTO)((PolicyListDTO)policyListQueryResponse.getResponseBody().getPolicyList().get(0)).getInsuredList().stream().filter(t -> t.getIdentifyNumber().equals(openBillRequestDTO.getIdentifyNo()) && t.getInsuredName().equals(openBillRequestDTO.getDamagePersonName())).collect(Collectors.toList()).get(0)).getIdentifyType());
        }
        ArrayList kindList = new ArrayList();
        if (AH_DAMAGE_TYPE.containsAll(Arrays.asList(openBillRequestDTO.getDamageResult().split(COMMA))) && ObjectUtil.isEmpty((Object)openBillRequestDTO.getDamageReasonType())) {
            this.findKindList(policyListQueryResponse, kindList);
            if (ObjectUtil.isEmpty(kindList)) {
                throw ApisDataCompletionException.builder().errorCode(ErrorCode.KINDLIST_ERR0R.getCode()).message(ErrorCode.KINDLIST_ERR0R.getMessage()).build();
            }
            List damageTypeList = this.apisChannelCodeMapper.getValueByDamageResultList("kind_damageType", kindList);
            if (ObjectUtil.isEmpty((Object)damageTypeList)) {
                throw ApisDataCompletionException.builder().errorCode(ErrorCode.KIND_FAIL.getCode()).message(ErrorCode.KIND_FAIL.getMessage()).build();
            }
            if (damageTypeList.contains("1") || damageTypeList.contains("2\u30011")) {
                openBillRequestDTO.setDamageReasonType("1");
            } else if (damageTypeList.contains("2")) {
                openBillRequestDTO.setDamageReasonType("2");
            } else {
                throw ApisDataCompletionException.builder().errorCode(ErrorCode.KIND_LACK.getCode()).message(ErrorCode.KIND_LACK.getMessage()).build();
            }
        }
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getDamageCode())) {
            openBillRequestDTO.setDamageCode("9999");
        }
        if ("08".equals(openBillRequestDTO.getReportType()) && ObjectUtil.isEmpty((Object)openBillRequestDTO.getReportChannel())) {
            openBillRequestDTO.setReportChannel(((PolicyListDTO)policyListQueryResponse.getResponseBody().getPolicyList().get(0)).getAgentCode());
        }
    }

    private void findKindList(PolicyListQueryResponse policyListQueryResponse, List<String> kindList) {
        if (ObjectUtil.isNotEmpty(kindList)) {
            return;
        }
        for (PolicyListDTO policyListDTO : policyListQueryResponse.getResponseBody().getPolicyList()) {
            for (ItemMainDTO itemMainDTO : policyListDTO.getCoverage().getItemList()) {
                for (ItemKindDTO itemKindDTO : itemMainDTO.getItemKind()) {
                    if (kindList.contains(itemKindDTO.getKindCode())) continue;
                    kindList.add(itemKindDTO.getKindCode());
                }
            }
        }
    }

    private void commonCompletion(StanderRequest request) throws ApisDataCompletionException {
        SDClaimOpenBillRequestDTO openBillRequestDTO = request.getSdClaimOpenBillServiceRequest().getBody();
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getNationFlag())) {
            openBillRequestDTO.setNationFlag("1");
        }
        if ("08".equals(openBillRequestDTO.getReportType())) {
            String channel = this.apisChannelUserMapper.getChannelCodeByUserCode(request.getHeader().getUserCode());
            openBillRequestDTO.setReportChannel(channel);
        }
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getDamageAddress())) {
            openBillRequestDTO.setDamageAddress("\u4e2d\u56fd");
        }
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getReportorRelation())) {
            openBillRequestDTO.setReportorRelation("99");
        }
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getReportedLoss())) {
            openBillRequestDTO.setReportedLoss(BigDecimal.ZERO);
        }
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getCurrency())) {
            openBillRequestDTO.setCurrency("RMB");
        }
        if ("14".equals(openBillRequestDTO.getReportType())) {
            openBillRequestDTO.setReportedLoss(openBillRequestDTO.getReportedLoss().divide(new BigDecimal("100"), 2, 4));
            if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getHospitalName())) {
                throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u533b\u9662\u4fe1\u606f" + ErrorCode.NOT_NULL.getMessage()).build();
            }
            ApisChannelCode hospital = this.apisChannelCodeMapper.getByCodeAndChannelValueDesc("SD_HOSP_MAP", openBillRequestDTO.getHospitalName());
            if (ObjectUtil.isNotEmpty((Object)hospital)) {
                openBillRequestDTO.setHospitalCode(hospital.getValue());
                openBillRequestDTO.setHospitalName(hospital.getValueDesc());
            } else {
                openBillRequestDTO.setHospitalCode("9999999");
            }
        } else {
            if (ObjectUtil.isNotEmpty((Object)openBillRequestDTO.getHospitalCode()) && ObjectUtil.isEmpty((Object)openBillRequestDTO.getHospitalName())) {
                openBillRequestDTO.setHospitalName(this.apisChannelCodeMapper.getCoreValue(null, "hospital", openBillRequestDTO.getHospitalCode()));
            }
            if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getHospitalCode()) && ObjectUtil.isNotEmpty((Object)openBillRequestDTO.getHospitalName())) {
                openBillRequestDTO.setHospitalCode(this.apisChannelCodeMapper.getChannelValue(null, "hospital", openBillRequestDTO.getHospitalName()));
            }
        }
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getHospitalCode()) && ObjectUtil.isEmpty((Object)openBillRequestDTO.getHospitalName())) {
            openBillRequestDTO.setHospitalCode("9999999");
            openBillRequestDTO.setHospitalName("\u5176\u4ed6\u533b\u9662");
        }
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getDiagnosis())) {
            openBillRequestDTO.setDiagnosis("\u5176\u4ed6");
        }
    }

    private PolicyListQueryResponse getPolicyList(StanderRequest standerRequest) throws ApisBusinessException {
        StanderResponse standerResponse;
        SDClaimOpenBillRequestDTO openBillRequestDTO = standerRequest.getSdClaimOpenBillServiceRequest().getBody();
        PolicyListServiceRequest policyListServiceRequest = PolicyListServiceRequest.builder().build();
        policyListServiceRequest.setRequestHead(com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO.initRequestHead());
        String userCode = standerRequest.getHeader().getUserCode();
        PolicyListQueryRequestDTO policyListQueryRequestDTO = PolicyListQueryRequestDTO.builder().build();
        policyListQueryRequestDTO.setPolicyNo(openBillRequestDTO.getPolicyNo());
        policyListQueryRequestDTO.setBusinessNature2(ALL);
        policyListQueryRequestDTO.setOperateCode(ALL);
        policyListQueryRequestDTO.setInsuredName(openBillRequestDTO.getDamagePersonName());
        policyListQueryRequestDTO.setIdentifyNumber(openBillRequestDTO.getIdentifyNo());
        policyListQueryRequestDTO.setClaimType(ALL);
        policyListServiceRequest.setRequestBody(policyListQueryRequestDTO);
        StanderRequest request = new StanderRequest();
        request.setHeader(new StanderHeader("policyList", "JME_USER", "JME_USER", UUID.fastUUID().toString().replaceAll("-", ""), null, null));
        request.setPolicyListServiceRequest(policyListServiceRequest);
        this.restTemplateInstance(this.restTemplate);
        log.warn("\u67e5\u8be2insure\u670d\u52a1\u4fdd\u5355\u5217\u8868\uff0c\u8bf7\u6c42\u62a5\u6587 {}", (Object)JSON.toJSONString((Object)request));
        String json = (String)this.restTemplate.postForObject(this.policyListAddress, (Object)request, String.class, new Object[0]);
        log.warn("\u67e5\u8be2insure\u670d\u52a1\u4fdd\u5355\u5217\u8868\uff0c\u8fd4\u56de\u62a5\u6587 {}", (Object)json);
        WebResponse webResponse = (WebResponse)JSON.parseObject((String)json, WebResponse.class);
        if (ObjectUtil.isNotEmpty((Object)webResponse) && ObjectUtil.isNotEmpty((Object)webResponse.getResult()) && ObjectUtil.isNotEmpty((Object)(standerResponse = (StanderResponse)JSON.parseObject((String)webResponse.getResult().toString(), StanderResponse.class)))) {
            return standerResponse.getPolicyListQueryResponse();
        }
        return null;
    }

    private String getCorePreSelect(String damageCode) {
        String damage = "";
        damage = damageCode.matches("[\u4e00-\u9fa5]") ? this.apisChannelCodeMapper.getValueByChannelValueDesc("damage", damageCode) : this.apisChannelCodeMapper.getValue("damage", damageCode);
        return damage;
    }

    private void checkData(SDClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
        this.notNullCheck(openBillRequestDTO);
        this.formatCheck(openBillRequestDTO);
    }

    private void formatCheck(SDClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
        if (ObjectUtil.isNotEmpty((Object)openBillRequestDTO.getReportorEmail()) && !openBillRequestDTO.getReportorEmail().matches("^([a-z0-9A-Z]+[-|_|\\.&]?)+@([a-z0-9A-Z]+(-[a-z0-9A-Z]+){0,}\\.)+[a-zA-Z]{2,}$")) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.EMAIL_ERROR.getCode()).message("\u62a5\u6848\u4eba\u90ae\u7bb1\uff1a" + ErrorCode.EMAIL_ERROR.getMessage()).build();
        }
    }

    private void notNullCheck(SDClaimOpenBillRequestDTO openBillRequestDTO) throws ApisDataCompletionException {
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getDamageResult())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u7406\u8d54\u7c7b\u578b" + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getPolicyNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u4fdd\u5355\u53f7 " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getDamageTime())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u51fa\u9669\u65f6\u95f4 " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getReportorName())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u6848\u4eba\u59d3\u540d " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getDamageArea())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u51fa\u9669\u533a\u57df " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (ObjectUtil.isEmpty((Object)openBillRequestDTO.getReportedLoss())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u635f\u91d1\u989d " + ErrorCode.NOT_NULL.getMessage()).build();
        }
    }

    public void judgeNotNull(Object target, String message) throws ApisDataCompletionException {
        if (ObjectUtils.isEmpty((Object)target)) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message(message).build();
        }
    }

    public void validSdPolicyItemInfoRequestNotNull(SDClaimPolicyItemRequestDTO policyItemRequestDTO) throws ApisDataCompletionException {
        if (StrUtil.isBlank((CharSequence)policyItemRequestDTO.getRegistNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u6848\u53f7 " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (StrUtil.isBlank((CharSequence)policyItemRequestDTO.getInsuredName()) && StrUtil.isBlank((CharSequence)policyItemRequestDTO.getInsuredCertifyNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u88ab\u4fdd\u9669\u4eba\u59d3\u540d/\u8bc1\u4ef6\u53f7 " + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (StrUtil.isBlank((CharSequence)policyItemRequestDTO.getPolicyNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u4fdd\u5355\u53f7 " + ErrorCode.NOT_NULL.getMessage()).build();
        }
    }

    public void restTemplateInstance(RestTemplate restTemplate) {
        List list = restTemplate.getMessageConverters();
        for (HttpMessageConverter httpMessageConverter : list) {
            if (!(httpMessageConverter instanceof StringHttpMessageConverter)) continue;
            ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(Charset.forName("utf-8"));
            break;
        }
    }

    public void lock(String userCode, String key) throws ApisBusinessException {
        if (!this.redisTemplate.opsForValue().setIfAbsent((Object)(userCode + key), (Object)(userCode + key), 3L, TimeUnit.MINUTES).booleanValue()) {
            throw new ApisBusinessException("\u8ba2\u5355\u53f7\u3010" + key + "\u3011\u8bf7\u6c42\u6b63\u5728\u5904\u7406,\u8bf7\u7a0d\u540e\u518d\u8bd5", ChannelErrorCodeEnum.ERR_C10007.getKey());
        }
    }

    public void unLock(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public PolicyDTO getPolicyDetailByInsureds(StanderRequest request, String policyNo, String insuredName, String identifyNumber, String planCode) throws ApisBusinessException {
        String userCode = request.getHeader().getUserCode();
        PolicyDetailRequestDTO policyDetailRequestDTO = PolicyDetailRequestDTO.builder().policyNo(policyNo).businessNature2("all").plancode(planCode).insuredName(insuredName).identifyNumber(identifyNumber).operateCode(userCode).isStatusQueryFlag("N").build();
        PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().requestHead(com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO.initRequestHead()).requestBody(policyDetailRequestDTO).build();
        request.setPolicyDetailServiceRequest(policyDetailServiceRequest);
        log.warn("\u4fdd\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)policyDetailServiceRequest));
        WebResponse webResponse = (WebResponse)this.restTemplate.postForObject(this.policyDetailAddress, (Object)request, WebResponse.class, new Object[0]);
        String resStr = null;
        if (null != webResponse) {
            resStr = JSON.toJSONString((Object)webResponse);
        }
        log.warn("\u4fdd\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)resStr);
        if (ObjectUtil.isEmpty((Object)webResponse) || ObjectUtil.isEmpty((Object)webResponse.getResult())) {
            throw new ApisBusinessException(ErrorCode.POLICY_DETAIL_FAIL.getMessage(), ErrorCode.POLICY_DETAIL_FAIL.getCode());
        }
        if (webResponse.getSuccess().booleanValue()) {
            StanderResponse standerResponse = (StanderResponse)JSON.parseObject((String)JSON.toJSONString((Object)webResponse.getResult()), StanderResponse.class);
            PolicyDetailResponse policyDetailResponse = standerResponse.getPolicyDetailResponse();
            if (ObjectUtil.isEmpty((Object)policyDetailResponse) || ObjectUtil.isEmpty((Object)policyDetailResponse.getResponseHead()) || ObjectUtil.isEmpty((Object)policyDetailResponse.getResponseBody())) {
                throw new ApisBusinessException(ErrorCode.POLICY_DETAIL_FAIL.getMessage(), ErrorCode.POLICY_DETAIL_FAIL.getCode());
            }
            if (1 != policyDetailResponse.getResponseHead().getStatus() || ObjectUtil.isEmpty((Object)policyDetailResponse.getResponseBody().getPolicy())) {
                String appCode = policyDetailResponse.getResponseHead().getAppCode();
                String appMessage = policyDetailResponse.getResponseHead().getAppMessage();
                log.error("\u83b7\u53d6\u4fdd\u5355\u8be6\u60c5\u63a5\u53e3\u5931\u8d25\uff1a" + appMessage + ",\u9519\u8bef\u4ee3\u7801\uff1a" + appCode);
                throw new ApisBusinessException(appMessage, appCode);
            }
            return policyDetailResponse.getResponseBody().getPolicy();
        }
        throw new ApisBusinessException(webResponse.getMessage(), webResponse.getCode());
    }

    @Async(value="imgBatchUploadExecutor")
    public void uploadImage(List<String> imageUrlList, String registNo, String userCode, String orderNo, String defaultFileNameSuffix) {
        long startDateTimestamp = System.currentTimeMillis();
        try {
            Optional properties = this.coreApiProperties.getServProperties("batchUploadFile");
            if (!properties.isPresent()) {
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B80001.getValue(), ErrorBisCodeEnum.ERR_B80001.getKey());
            }
            ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = new ImgBatchUploadRequestDTO();
            RequestHeadDTO requestHeadDTO = new RequestHeadDTO();
            requestHeadDTO.setSeqNo(UUID.randomUUID().toString().replace("-", ""));
            requestHeadDTO.setRequestTime(new Date());
            requestHeadDTO.setOptComCode("apis");
            requestHeadDTO.setOptUserCode("apis");
            requestHeadDTO.setOptUserName("apis");
            requestHeadDTO.setConsumerID(((CoreApiServProperties)properties.get()).getUser());
            requestHeadDTO.setConsumerPWD(((CoreApiServProperties)properties.get()).getUserPwd());
            imgBatchUploadRequestDTO.setHeadDto(requestHeadDTO);
            ImgBusiDTO imgBusiDTO = new ImgBusiDTO();
            imgBusiDTO.setAppCode("CL");
            imgBusiDTO.setClassCode("CLA");
            imgBusiDTO.setBusinessNo(registNo);
            imgBusiDTO.setBusiComCode("apis");
            imgBatchUploadRequestDTO.setBusiDto(imgBusiDTO);
            ArrayList<ImgBatchUploadMetaDTO> uploadMetaDTOList = new ArrayList<ImgBatchUploadMetaDTO>();
            String fileName = "";
            for (String imageUrl : imageUrlList) {
                uploadMetaDTOList.clear();
                ImgBatchUploadMetaDTO imgBatchUploadMetaDTO = new ImgBatchUploadMetaDTO();
                imgBatchUploadMetaDTO.setFileURL(imageUrl);
                try {
                    fileName = FilenameUtils.getName((String)new URL(imageUrl).getPath());
                }
                catch (Exception e) {
                    fileName = UUID.randomUUID().toString().replace("-", "") + "." + defaultFileNameSuffix;
                    log.error("FilenameUtils.getName error: ", (Throwable)e);
                }
                imgBatchUploadMetaDTO.setFileOrgName(fileName);
                imgBatchUploadMetaDTO.setImgType("|999|");
                imgBatchUploadMetaDTO.setImgTypeName("|\u5176\u4ed6|");
                uploadMetaDTOList.add(imgBatchUploadMetaDTO);
                imgBatchUploadRequestDTO.setUploadMetas(uploadMetaDTOList);
                ClaimMediaCommitResult responseDTO = this.mediaUploadApi.batchUpload(((CoreApiServProperties)properties.get()).getUrl(), imgBatchUploadRequestDTO, null);
                if (ObjectUtil.isEmpty((Object)responseDTO) || ObjectUtil.isEmpty((Object)responseDTO.getHeadDto())) {
                    throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B80002.getValue(), ErrorBisCodeEnum.ERR_B80002.getKey());
                }
                if (responseDTO.getHeadDto().getStatus() < 0) {
                    throw new ApisBusinessException("\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u5931\u8d25\uff1a" + responseDTO.getHeadDto().getErrorMessage(), responseDTO.getHeadDto().getErrorCode());
                }
                ImgBatchUploadServiceResponse imgBatchUploadResponse = ImgBatchUploadServiceResponse.builder().build();
                imgBatchUploadResponse.setImgNodes(responseDTO.getImgNodes());
                log.warn("\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u54cd\u5e94\u62a5\u6587\u6210\u529f\u6570:{}", (Object)responseDTO.getSize());
                log.warn("\u4e0a\u4f20\u5f71\u50cf\u8d44\u6599\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDateTimestamp));
                this.insertImgBatchUploadLog(userCode, orderNo, responseDTO);
            }
        }
        catch (Exception e) {
            log.error("uploadImage error: ", (Throwable)e);
        }
    }

    public void insertImgBatchUploadLog(String userCode, String orderNo, ClaimMediaCommitResult responseDTO) throws ApisBusinessException {
        try {
            CoreDtoConverter converter = this.coreDtoConverterFactory.get("JSON");
            String api = "imgBatchUpload";
            String bodyStr = converter.toPacketStr((Object)responseDTO);
            ApisBusiReqmsgLog apisBusiReqmsgLog = new ApisBusiReqmsgLog();
            apisBusiReqmsgLog.setApiCode(api);
            apisBusiReqmsgLog.setLogContent(bodyStr);
            apisBusiReqmsgLog.setLogType("2");
            apisBusiReqmsgLog.setOrderNo(orderNo);
            apisBusiReqmsgLog.setCreator(userCode);
            this.apisBusiReqmsgLogService.save((Object)apisBusiReqmsgLog);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u5f71\u50cf\u4e0a\u4f20\u62a5\u6587\u65f6\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)orderNo, (Object)e);
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
    }
}

