/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.SecureUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimCaseStatus.ClaimCaseStatusRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.yaoPinBao.ClaimInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.yaoPinBao.ClaimStatusSynRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.yaoPinBao.GeneralInfo;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class YaoPinBaoUtil {
    private static final Logger log = LoggerFactory.getLogger(YaoPinBaoUtil.class);
    @Value(value="${yaopinbao.secretKey}")
    private String secretKey;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;

    public String dealMessage(ApisBusiRequestRegist apisBusiRequestRegist, ClaimCaseStatusRequestDTO mqBody, String businessType) {
        if (!this.isYaoPinBaoCase(apisBusiRequestRegist.getChannelCode())) {
            return null;
        }
        String status = this.getStatus(mqBody.getCaseStatus(), businessType);
        if (ObjectUtil.isEmpty((Object)status)) {
            return null;
        }
        ClaimStatusSynRequest requestInfo = ClaimStatusSynRequest.builder().claimInfo(this.getClaimInfo(mqBody, status)).generalInfo(GeneralInfo.builder().uuid(UUID.fastUUID().toString().replaceAll("-", "")).build()).build();
        String md5Content = ObjectUtil.isEmpty((Object)requestInfo.getClaimInfo().getSumLoss()) ? null : requestInfo.getClaimInfo().getSumLoss().setScale(2, 5).toPlainString();
        requestInfo.getGeneralInfo().setMd5Value(this.getMdValue(requestInfo.getGeneralInfo().getUuid(), md5Content));
        return YaoPinBaoUtil.objectToXml((Object)requestInfo, ClaimStatusSynRequest.class);
    }

    private String getStatus(String value, String businessType) {
        String result = null;
        if ("2".equals(businessType)) {
            result = (String)BusinessConstants.CLAIM_CASE_STATUS_MQ.YI_YAO_BAO_PAYSTATUS_MAP.get(value);
        }
        if ("0".equals(businessType)) {
            result = (String)BusinessConstants.CLAIM_CASE_STATUS_MQ.YI_YAO_BAO_CASESTATUS_MAP.get(value);
        }
        return result;
    }

    public String getMdValue(String uuid, String content) {
        content = ObjectUtil.isEmpty((Object)content) ? "" : content;
        return SecureUtil.md5((String)(uuid + content + this.secretKey));
    }

    private ClaimInfo getClaimInfo(ClaimCaseStatusRequestDTO mqBody, String status) {
        ClaimInfo claimInfo = ClaimInfo.builder().claimStatus(status).failReason(mqBody.getCancelReason()).registNo(mqBody.getRegistNo()).certiNo(mqBody.getCompensateNo()).acctName(mqBody.getPayeeName()).acctNo(mqBody.getAccountNo()).sumPaid(mqBody.getSumRealPay()).sumLoss(mqBody.getEndCaseAmount()).sumRealPay(mqBody.getEndCaseAmount()).refNo(UUID.fastUUID().toString().replaceAll("-", "")).build();
        return claimInfo;
    }

    public static <T> String objectToXml(Object o, Class<T> cl) {
        try {
            StringWriter writer = new StringWriter();
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{cl});
            Marshaller ms = jc.createMarshaller();
            ms.marshal(o, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (JAXBException e) {
            log.error("\u836f\u54c1\u5b9d\u8f6c\u6362XML\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a{}", (Throwable)e);
            return null;
        }
    }

    public boolean isYaoPinBaoPush(String businessType, String channelCode) {
        if (!this.isYaoPinBaoCase(channelCode)) {
            return false;
        }
        return BusinessConstants.CLAIM_CASE_STATUS_MQ.YI_YAO_BAO_SET.contains(businessType);
    }

    public boolean isYaoPinBaoCase(String channelCode) {
        if (ObjectUtil.isEmpty((Object)channelCode)) {
            return false;
        }
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("ECO-DEFAULT_CHANNEL");
        channelConfigsCondition.setChannelCode(channelCode);
        ApisChannelConfigs accs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        return ObjectUtil.isNotEmpty((Object)accs);
    }
}

