/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.web;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.CommonResponseHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimRegistResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimRegistResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ClaimApiController {
    private static final Logger logger = LoggerFactory.getLogger(ClaimApiController.class);
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;

    @RequestMapping(value={"/claim/claimRegist"})
    public WebResponse claimRegist(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRequestId(request.getClaimRegistRequest().getHead().getTransID());
            if (ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist)) {
                CommonResponseHead head = CommonResponseHead.builder().build();
                BeanUtil.copyProperties((Object)request.getClaimRegistRequest().getHead(), (Object)head, (String[])new String[0]);
                head.setResponseCode("1");
                head.setErrorCode(ChannelErrorCodeEnum.ERR_C10002.getKey());
                head.setErrorMessage(ChannelErrorCodeEnum.ERR_C10002.getValue());
                ClaimRegistResponseDTO claimRegistResponseDTO = ClaimRegistResponseDTO.builder().registNo(apisBusiRequestRegist.getRegistNo()).build();
                resp = StanderResponse.builder().claimRegistResponse(ClaimRegistResponse.builder().head(head).body(claimRegistResponseDTO).build()).build();
            } else {
                resp = this.apisBusinessService.execute("claimRegist", request);
            }
            this.redisTemplate.delete((Object)(request.getClaimRegistRequest().getHead().getUser() + request.getClaimRegistRequest().getHead().getTransID()));
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).businessKey(request.getHeader().getBusinessKey()).bussinessType(request.getHeader().getBussinessType()).build();
        }
        catch (ApisBusinessException e) {
            this.redisTemplate.delete((Object)(request.getClaimRegistRequest().getHead().getUser() + request.getClaimRegistRequest().getHead().getTransID()));
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage()).code(e.getErrorCode()).businessKey(request.getHeader().getBusinessKey()).bussinessType(request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u62a5\u6848\u63a5\u53e3\u7cfb\u7edf\u5f02\u5e38\uff1a{}", (Throwable)e);
            this.redisTemplate.delete((Object)(request.getClaimRegistRequest().getHead().getUser() + request.getClaimRegistRequest().getHead().getTransID()));
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/claim/payeeInfoReceive"})
    public WebResponse payeeInfoReceive(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("payeeInfoReceive", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).businessKey(request.getHeader().getBusinessKey()).bussinessType(request.getHeader().getBussinessType()).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage()).code(e.getErrorCode()).businessKey(request.getHeader().getBusinessKey()).bussinessType(request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u9886\u6b3e\u4eba\u4fe1\u606f\u63a5\u6536\u5f02\u5e38\uff1a{}", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/claim/informationComplement"})
    public WebResponse claimInformationComplement(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("informationComplement", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage()).code(e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/claim/adjustingSyn"})
    public WebResponse adjustingSyn(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("adjustingSyn", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage()).code(e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/claim/caseBarCode"})
    public WebResponse caseBarCode(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("caseBarCode", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage()).code(e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/claim/ylFpDiscernDataFeedBack"})
    public WebResponse ylFpDiscernDataFeedBack(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("ylFpDiscernDataFeedBack", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).businessKey(request.getHeader().getBusinessKey()).bussinessType(request.getHeader().getBussinessType()).build();
        }
        catch (ApisBusinessException e) {
            logger.error("\u533b\u7597\u53d1\u7968\u8bc6\u522b\u6570\u636e\u53cd\u9988\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage()).code(e.getErrorCode()).businessKey(request.getHeader().getBusinessKey()).bussinessType(request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u533b\u7597\u53d1\u7968\u8bc6\u522b\u6570\u636e\u53cd\u9988\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/claim/jdhQuestionnaire"})
    public WebResponse jdhQuestionnaire(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("jdhQuestionnaire", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            String uid = UUID.randomUUID().toString().replaceAll("-", "");
            logger.warn("\u4eac\u4e1c\u5065\u5eb7UUID\u4e3a\u5f02\u5e38:{}", (Object)uid);
            resp = StanderResponse.builder().header(StanderHeader.builder().businessKey(uid).build()).build();
            return WebResponse.builder().success(Boolean.valueOf(false)).result((Serializable)resp).message(e.getMessage()).code(e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            String uid = UUID.randomUUID().toString().replaceAll("-", "");
            logger.warn("\u4eac\u4e1c\u5065\u5eb7UUID\u4e3a\u5f02\u5e38:{}", (Object)uid);
            resp = StanderResponse.builder().header(StanderHeader.builder().businessKey(uid).build()).build();
            logger.error("\u4eac\u4e1c\u5065\u5eb7\u540c\u6b65\u95ee\u8bca\u5355\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }
}

