/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.web;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.EcoErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.service.ClaimOpenBillService;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.EcoRegistDataCompletion;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimOpenBillEcoResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimOpenBillServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.EcoGeneralInfoReturn;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ClaimOpenBillController {
    private Logger log = LoggerFactory.getLogger(ClaimOpenBillController.class);
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    ClaimOpenBillService claimOpenBillService;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    EcoRegistDataCompletion ecoRegistDataCompletion;

    @RequestMapping(value={"/claim/openbill"}, method={RequestMethod.POST})
    public WebResponse claimOpenBill(@RequestBody StanderRequest request, HttpServletRequest httpServletRequest) {
        StanderResponse resp;
        String code = "0";
        String message = "\u5931\u8d25";
        boolean success = false;
        Date date = new Date();
        try {
            TimeInterval timer = DateUtil.timer();
            resp = this.claimOpenBillService.checkRequestId(request);
            this.log.warn("\u5f00\u6848\uff0c\u68c0\u67e5\u8bf7\u6c42\u6d41\u6c34\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            if (resp == null) {
                resp = this.apisBusinessService.execute("claimsOpenBill", request);
                this.log.warn("\u5f00\u6848\uff0c\u6267\u884c\u6d41\u7a0b\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
                ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getApisBusiRequestRegist(request, resp);
                if (StringUtils.isNotBlank((CharSequence)apisBusiRequestRegist.getRequestId()) && StringUtils.isNotBlank((CharSequence)apisBusiRequestRegist.getRegistNo())) {
                    this.apisBusiRequestRegistService.addRequestRegistNo(apisBusiRequestRegist);
                }
                this.log.warn("\u5f00\u6848\uff0c\u4fdd\u5b58\u6d41\u6c34\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            }
            if (StringUtils.isBlank((CharSequence)resp.getClaimOpenBillServiceResponse().getHead().getErrorCode())) {
                code = "1";
                message = "\u6210\u529f";
                success = true;
            }
        }
        catch (ApisBusinessException e) {
            this.log.error(e.getMessage());
            success = false;
            resp = new StanderResponse();
            RequestHeadDTO requestHead = request.getClaimOpenBillServiceRequest().getHead();
            ResponseHeadDTO head = new ResponseHeadDTO(requestHead.getTransID(), requestHead.getTransType(), "0", e.getErrorCode(), e.getMessage(), new Date(), null, null);
            ClaimOpenBillServiceResponse response = new ClaimOpenBillServiceResponse(head, null);
            resp.setHeader(request.getHeader());
            resp.setClaimOpenBillServiceResponse(response);
        }
        catch (Exception e) {
            this.log.error("\u5f00\u6848\u5f02\u5e38\u6d41\u6c34\u53f7\uff1a{}", (Object)request.getClaimOpenBillServiceRequest().getHead().getTransID());
            this.log.error("\u7406\u8d54\u5f00\u6848\u7cfb\u7edf\u5f02\u5e38\uff1a{}", (Throwable)e);
            resp = new StanderResponse();
            success = false;
            RequestHeadDTO requestHead = request.getClaimOpenBillServiceRequest().getHead();
            ResponseHeadDTO head = new ResponseHeadDTO(requestHead.getTransID(), requestHead.getTransType(), "0", "500", "\u7cfb\u7edf\u5f02\u5e38", new Date(), null, null);
            ClaimOpenBillServiceResponse response = new ClaimOpenBillServiceResponse(head, null);
            resp.setHeader(request.getHeader());
            resp.setClaimOpenBillServiceResponse(response);
        }
        this.log.warn("\u5f00\u6848\u603b\u8017\u65f6\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - date.getTime()));
        return WebResponse.builder().success(Boolean.valueOf(success)).result((Serializable)resp).message(message).code(code).build();
    }

    private Map<String, String> getHeadKeyAndValue(HttpServletRequest httpRequest) {
        HashMap<String, String> header = new HashMap<String, String>();
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String nextElement = (String)headerNames.nextElement();
            header.put(nextElement, httpRequest.getHeader(nextElement));
        }
        return header;
    }

    @RequestMapping(value={"/claim/openbillEco"}, method={RequestMethod.POST})
    public WebResponse claimOpenBillEco(@RequestBody StanderRequest request) {
        StanderResponse resp;
        this.log.warn("\u836f\u8054\u7406\u8d54\u5f00\u6848\u8bf7\u6c42: {}", (Object)request.toString());
        String code = "0";
        String message = "\u5931\u8d25";
        boolean success = false;
        Date date = new Date();
        try {
            TimeInterval timer = DateUtil.timer();
            this.ecoRegistDataCompletion.checkSign(request.getClaimOpenBillEcoRequest());
            resp = this.claimOpenBillService.checkUuid(request);
            if (resp == null) {
                resp = this.apisBusinessService.execute("ecoClaimsOpenBill", request);
                this.log.warn("\u836f\u8054-\u5f00\u6848\uff0c\u6267\u884c\u6d41\u7a0b\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
                ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getApisBusiRequestRegist(request, resp);
                if (StringUtils.isNotBlank((CharSequence)apisBusiRequestRegist.getRequestId()) && StringUtils.isNotBlank((CharSequence)apisBusiRequestRegist.getRegistNo())) {
                    this.apisBusiRequestRegistService.addRequestRegistNo(apisBusiRequestRegist);
                    this.log.warn("\u836f\u8054-\u5f00\u6848\uff0c\u4fdd\u5b58\u6d41\u6c34\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
                }
                if (StringUtils.isBlank((CharSequence)resp.getClaimOpenBillServiceResponse().getHead().getErrorCode())) {
                    code = "1";
                    message = "\u6210\u529f";
                    success = true;
                }
            } else {
                code = "1";
                message = "\u6210\u529f";
                success = true;
            }
        }
        catch (ApisBusinessException e) {
            this.log.error("\u836f\u8054-\u7406\u8d54\u5f00\u6848\u7cfb\u7edf\u5f02\u5e38:", (Throwable)e);
            success = false;
            resp = new StanderResponse();
            EcoGeneralInfoReturn response = EcoGeneralInfoReturn.builder().uuid(request.getClaimOpenBillEcoRequest().getGeneralInfo().getUuid()).errorCode(e.getErrorCode()).errorMessage(e.getMessage()).build();
            resp.setHeader(request.getHeader());
            resp.setClaimOpenBillEcoResponse(ClaimOpenBillEcoResponse.builder().generalInfoReturn(response).build());
        }
        catch (Exception e) {
            this.log.error("\u836f\u8054-\u7406\u8d54\u5f00\u6848\u7cfb\u7edf\u5f02\u5e38:", (Throwable)e);
            resp = new StanderResponse();
            success = false;
            EcoGeneralInfoReturn response = EcoGeneralInfoReturn.builder().uuid(request.getClaimOpenBillEcoRequest().getGeneralInfo().getUuid()).errorCode(EcoErrorCodeEnum.ERROR_C01.getKey()).errorMessage(EcoErrorCodeEnum.ERROR_C01.getValue()).build();
            resp.setHeader(request.getHeader());
            resp.setClaimOpenBillEcoResponse(ClaimOpenBillEcoResponse.builder().generalInfoReturn(response).build());
        }
        this.log.warn("\u836f\u8054-\u5f00\u6848\u603b\u8017\u65f6\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - date.getTime()));
        return WebResponse.builder().success(Boolean.valueOf(success)).result((Serializable)resp).message(message).code(code).build();
    }
}

