/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.web;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDRegistDataCompletion;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimOpenBillServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.SDInforSupplementServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimCaseCancelServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimOpenBillRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.response.SDClaimOpenBillServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SDClaimController {
    private Logger log = LoggerFactory.getLogger(SDClaimController.class);
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    SDRegistDataCompletion sdRegistDataCompletion;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;

    @RequestMapping(value={"/claim/sdRegist"})
    public WebResponse claimOpenBill(@RequestBody StanderRequest request, HttpServletRequest httpServletRequest) {
        StanderResponse resp;
        String code = "0";
        String message = "\u5931\u8d25";
        boolean success = false;
        Date date = new Date();
        SDRequestHeadDTO requestHead = request.getSdClaimOpenBillServiceRequest().getHead();
        SDClaimOpenBillRequestDTO requestBody = request.getSdClaimOpenBillServiceRequest().getBody();
        try {
            TimeInterval timer = DateUtil.timer();
            ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRequestId(requestHead.getReqPartyBizNo());
            if (ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist) && ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist.getRegistNo())) {
                StanderResponse resp2 = StanderResponse.builder().header(request.getHeader()).sdClaimOpenBillServiceResponse(SDClaimOpenBillServiceResponse.builder().head(ResponseHeadDTO.builder().responseCode("1").transTime(new Date()).transType(requestHead.getTransType()).transID(requestHead.getTransID()).build()).body(ClaimOpenBillServiceResponseDTO.builder().registNo(apisBusiRequestRegist.getRegistNo()).insCompanyId("ALCX20210205").policyNo(apisBusiRequestRegist.getPolicyNo()).insuredCardNo(requestBody.getIdentifyNo()).insuredName(requestBody.getDamagePersonName()).build()).build()).build();
                code = "1";
                message = "\u6210\u529f";
                success = true;
                return WebResponse.builder().success(Boolean.valueOf(success)).result((Serializable)resp2).message(message).code(code).build();
            }
            this.log.warn("\u5f00\u6848\uff0c\u68c0\u67e5\u8bf7\u6c42\u6d41\u6c34\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            resp = this.apisBusinessService.execute("sdClaimOpenBill", request);
            this.log.warn("\u5f00\u6848\uff0c\u6267\u884c\u6d41\u7a0b\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            ResponseHeadDTO responseHead = resp.getSdClaimOpenBillServiceResponse().getHead();
            if (ObjectUtil.isNotEmpty((Object)responseHead) && ObjectUtil.isEmpty((Object)responseHead.getErrorCode()) && "1".equals(responseHead.getResponseCode())) {
                code = "1";
                message = "\u6210\u529f";
                success = true;
                apisBusiRequestRegist = new ApisBusiRequestRegist();
                apisBusiRequestRegist.setRequestId(requestHead.getReqPartyBizNo());
                apisBusiRequestRegist.setPolicyNo(requestBody.getPolicyNo());
                apisBusiRequestRegist.setChannelType(requestBody.getReportType());
                apisBusiRequestRegist.setDamageResult(requestBody.getDamageResult());
                apisBusiRequestRegist.setCurrency(requestBody.getCurrency());
                apisBusiRequestRegist.setUserCode(request.getHeader().getUserCode());
                apisBusiRequestRegist.setChannelCode(requestBody.getReportChannel());
                apisBusiRequestRegist.setDamageTime(requestBody.getDamageTime());
                if (ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist.getRequestId()) && ObjectUtil.isNotEmpty((Object)resp.getSdClaimOpenBillServiceResponse()) && ObjectUtil.isNotEmpty((Object)resp.getSdClaimOpenBillServiceResponse().getBody())) {
                    apisBusiRequestRegist.setRegistNo(resp.getSdClaimOpenBillServiceResponse().getBody().getRegistNo());
                    this.apisBusiRequestRegistService.addRequestRegistNo(apisBusiRequestRegist);
                }
                this.log.warn("\u5f00\u6848\uff0c\u4fdd\u5b58\u6d41\u6c34\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            }
            this.sdRegistDataCompletion.unLock(request.getHeader().getUserCode() + requestHead.getReqPartyBizNo());
            this.sdRegistDataCompletion.unLock(request.getSdClaimOpenBillServiceRequest().getBody().getPolicyNo() + request.getSdClaimOpenBillServiceRequest().getBody().getIdentifyNo() + request.getSdClaimOpenBillServiceRequest().getBody().getDamageTime().getTime() + request.getSdClaimOpenBillServiceRequest().getBody().getDamageResult());
        }
        catch (ApisBusinessException e) {
            this.sdRegistDataCompletion.unLock(request.getHeader().getUserCode() + requestHead.getReqPartyBizNo());
            this.sdRegistDataCompletion.unLock(request.getSdClaimOpenBillServiceRequest().getBody().getPolicyNo() + request.getSdClaimOpenBillServiceRequest().getBody().getIdentifyNo() + request.getSdClaimOpenBillServiceRequest().getBody().getDamageTime().getTime() + request.getSdClaimOpenBillServiceRequest().getBody().getDamageResult());
            this.log.error("\u6c34\u6ef4\u7406\u8d54\u5f00\u6848\u5f02\u5e38\uff1a{}", (Throwable)e);
            success = false;
            resp = new StanderResponse();
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode(e.getErrorCode()).errorMessage(e.getMessage()).build();
            resp.setHeader(request.getHeader());
            resp.setSdClaimOpenBillServiceResponse(SDClaimOpenBillServiceResponse.builder().head(head).build());
        }
        catch (Exception e) {
            this.sdRegistDataCompletion.unLock(request.getHeader().getUserCode() + requestHead.getReqPartyBizNo());
            this.sdRegistDataCompletion.unLock(request.getSdClaimOpenBillServiceRequest().getBody().getPolicyNo() + request.getSdClaimOpenBillServiceRequest().getBody().getIdentifyNo() + request.getSdClaimOpenBillServiceRequest().getBody().getDamageTime().getTime() + request.getSdClaimOpenBillServiceRequest().getBody().getDamageResult());
            this.log.error("\u6c34\u6ef4\u5f00\u6848\u5f02\u5e38\u6d41\u6c34\u53f7\uff1a{}", (Object)request.getSdClaimOpenBillServiceRequest().getHead().getTransID());
            this.log.error("\u6c34\u6ef4\u7406\u8d54\u5f00\u6848\u7cfb\u7edf\u5f02\u5e38\uff1a{}", (Throwable)e);
            resp = new StanderResponse();
            success = false;
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode(ChannelErrorCodeEnum.ERR_C10006.getKey()).errorMessage(ChannelErrorCodeEnum.ERR_C10006.getValue()).build();
            resp.setHeader(request.getHeader());
            resp.setSdClaimOpenBillServiceResponse(SDClaimOpenBillServiceResponse.builder().head(head).build());
        }
        this.log.warn("\u6c34\u6ef4\u7406\u8d54\u5f00\u6848\u603b\u8017\u65f6\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - date.getTime()));
        return WebResponse.builder().success(Boolean.valueOf(success)).result((Serializable)resp).message(message).code(code).build();
    }

    @RequestMapping(value={"/claim/sdCaseCancel"})
    public WebResponse caseCancel(@RequestBody StanderRequest request, HttpServletRequest httpServletRequest) {
        StanderResponse resp;
        String code = "0";
        String message = "\u5931\u8d25";
        boolean success = false;
        Date date = new Date();
        SDRequestHeadDTO requestHead = request.getSdClaimCaseCancelServiceRequest().getHead();
        try {
            TimeInterval timer = DateUtil.timer();
            resp = this.apisBusinessService.execute("sdClaimCaseCancel", request);
            this.log.warn("\u6848\u4ef6\u6ce8\u9500\uff0c\u6267\u884c\u6d41\u7a0b\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            ResponseHeadDTO responseHead = resp.getSdClaimOpenBillServiceResponse().getHead();
            if (ObjectUtil.isNotEmpty((Object)responseHead) && ObjectUtil.isEmpty((Object)responseHead.getErrorCode()) && "1".equals(responseHead.getResponseCode())) {
                code = "1";
                message = "\u6210\u529f";
                success = true;
            }
            this.sdRegistDataCompletion.unLock(request.getHeader().getUserCode() + requestHead.getTransType() + requestHead.getTransID());
        }
        catch (ApisBusinessException e) {
            this.sdRegistDataCompletion.unLock(request.getHeader().getUserCode() + requestHead.getTransType() + requestHead.getTransID());
            this.log.error("\u6c34\u6ef4\u7406\u8d54\u6848\u4ef6\u6ce8\u9500\u5f02\u5e38\uff1a{}", (Throwable)e);
            success = false;
            resp = new StanderResponse();
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode(e.getErrorCode()).errorMessage(e.getMessage()).build();
            resp.setHeader(request.getHeader());
            resp.setSdClaimOpenBillServiceResponse(SDClaimOpenBillServiceResponse.builder().head(head).build());
        }
        catch (Exception e) {
            this.sdRegistDataCompletion.unLock(request.getHeader().getUserCode() + requestHead.getTransType() + requestHead.getTransID());
            this.log.error("\u6c34\u6ef4\u6848\u4ef6\u6ce8\u9500\u5f02\u5e38\u6d41\u6c34\u53f7\uff1a{}", (Object)request.getSdClaimCaseCancelServiceRequest().getHead().getTransID());
            this.log.error("\u6c34\u6ef4\u7406\u8d54\u6848\u4ef6\u6ce8\u9500\u7cfb\u7edf\u5f02\u5e38\uff1a{}", (Throwable)e);
            resp = new StanderResponse();
            success = false;
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode(ChannelErrorCodeEnum.ERR_C10006.getKey()).errorMessage(ChannelErrorCodeEnum.ERR_C10006.getValue()).build();
            resp.setHeader(request.getHeader());
            resp.setSdClaimOpenBillServiceResponse(SDClaimOpenBillServiceResponse.builder().head(head).build());
        }
        this.log.warn("\u6c34\u6ef4\u7406\u8d54\u6848\u4ef6\u6ce8\u9500\u603b\u8017\u65f6\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - date.getTime()));
        return WebResponse.builder().success(Boolean.valueOf(success)).result((Serializable)resp).message(message).code(code).build();
    }

    @RequestMapping(value={"/claim/sdCaseSupply"})
    public WebResponse caseSupply(@RequestBody StanderRequest request, HttpServletRequest httpServletRequest) {
        StanderResponse resp;
        if (ObjectUtil.isNotEmpty((Object)request.getSdClaimCaseSupplyServiceRequest().getBody().getCancelCode())) {
            SDClaimCaseCancelServiceRequest sdClaimCaseCancelServiceRequest = new SDClaimCaseCancelServiceRequest();
            SDRequestHeadDTO sdRequestHeadDTO = new SDRequestHeadDTO();
            BeanUtils.copyProperties((Object)request.getSdClaimCaseSupplyServiceRequest().getHead(), (Object)sdRequestHeadDTO);
            sdRequestHeadDTO.setTransType("AC006");
            sdClaimCaseCancelServiceRequest.setHead(sdRequestHeadDTO);
            sdClaimCaseCancelServiceRequest.setBody(request.getSdClaimCaseSupplyServiceRequest().getBody());
            request.setSdClaimCaseCancelServiceRequest(sdClaimCaseCancelServiceRequest);
            return this.caseCancel(request, httpServletRequest);
        }
        String code = "0";
        String message = "\u5931\u8d25";
        boolean success = false;
        Date date = new Date();
        SDRequestHeadDTO requestHead = request.getSdClaimCaseSupplyServiceRequest().getHead();
        try {
            TimeInterval timer = DateUtil.timer();
            resp = this.apisBusinessService.execute("sdClaimCaseSupply", request);
            this.log.warn("\u6848\u4ef6\u4fe1\u606f\u8865\u5145\uff0c\u6267\u884c\u6d41\u7a0b\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            ResponseHeadDTO responseHead = resp.getSdClaimOpenBillServiceResponse().getHead();
            if (ObjectUtil.isNotEmpty((Object)responseHead) && ObjectUtil.isEmpty((Object)responseHead.getErrorCode()) && "1".equals(responseHead.getResponseCode())) {
                code = "1";
                message = "\u6210\u529f";
                success = true;
            }
            this.sdRegistDataCompletion.unLock(request.getHeader().getUserCode() + requestHead.getTransType() + requestHead.getTransID());
        }
        catch (ApisBusinessException e) {
            this.sdRegistDataCompletion.unLock(request.getHeader().getUserCode() + requestHead.getTransType() + requestHead.getTransID());
            this.log.error("\u6c34\u6ef4\u7406\u8d54\u6848\u4ef6\u4fe1\u606f\u8865\u5145\u5f02\u5e38\uff1a{}", (Throwable)e);
            success = false;
            resp = new StanderResponse();
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode(e.getErrorCode()).errorMessage(e.getMessage()).build();
            resp.setHeader(request.getHeader());
            resp.setSdClaimOpenBillServiceResponse(SDClaimOpenBillServiceResponse.builder().head(head).build());
        }
        catch (Exception e) {
            this.sdRegistDataCompletion.unLock(request.getHeader().getUserCode() + requestHead.getTransType() + requestHead.getTransID());
            this.log.error("\u6c34\u6ef4\u6848\u4ef6\u4fe1\u606f\u8865\u5145\u5f02\u5e38\u6d41\u6c34\u53f7\uff1a{}", (Object)request.getSdClaimCaseSupplyServiceRequest().getHead().getTransID());
            this.log.error("\u6c34\u6ef4\u7406\u8d54\u6848\u4ef6\u4fe1\u606f\u8865\u5145\u7cfb\u7edf\u5f02\u5e38\uff1a{}", (Throwable)e);
            resp = new StanderResponse();
            success = false;
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode(ChannelErrorCodeEnum.ERR_C10006.getKey()).errorMessage(ChannelErrorCodeEnum.ERR_C10006.getValue()).build();
            resp.setHeader(request.getHeader());
            resp.setSdClaimOpenBillServiceResponse(SDClaimOpenBillServiceResponse.builder().head(head).build());
        }
        this.log.warn("\u6c34\u6ef4\u7406\u8d54\u6848\u4ef6\u4fe1\u606f\u8865\u5145\u603b\u8017\u65f6\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - date.getTime()));
        return WebResponse.builder().success(Boolean.valueOf(success)).result((Serializable)resp).message(message).code(code).build();
    }

    @RequestMapping(value={"/claim/sdAdjustingSyn"})
    public WebResponse adjustingSyn(@RequestBody StanderRequest request, HttpServletRequest httpServletRequest) {
        StanderResponse resp = null;
        String code = "0";
        String message = "\u5931\u8d25";
        boolean success = false;
        this.log.warn("\u6c34\u6ef4\uff0c\u7406\u7b97\u4fe1\u606f\u540c\u6b65\u8f6c\u6362\u540e\u62a5\u6587\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)request));
        Date date = new Date();
        try {
            TimeInterval timer = DateUtil.timer();
            try {
                if (request.getSdClaimCaseCancelServiceRequest().getBody().getTextType().equals("5")) {
                    request.getSdClaimCaseCancelServiceRequest().getBody().setTextType("1");
                    request.getSdClaimCaseCancelServiceRequest().getBody().setCancelSubject("\u5173\u4e8e\u533b\u7597\u7d22\u8d54\u4e8b\u5b9c");
                    this.log.warn("\u62d2\u8d54\u8d70\u6848\u4ef6\u6ce8\u9500\u63a5\u53e3,\u6848\u53f7\u4e3a\uff1a{}", (Object)request.getSdClaimCaseCancelServiceRequest().getBody().getRegistNo());
                    return this.caseCancel(request, httpServletRequest);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.warn("\u7406\u8d54\u4fe1\u606f\u540c\u6b65\u8bf7\u6c42\u6d41\u6c34\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            if (resp == null) {
                resp = this.apisBusinessService.execute("sdAdjustingSyn", request);
                this.log.warn("\u7406\u8d54\u4fe1\u606f\u540c\u6b65\uff0c\u6267\u884c\u6d41\u7a0b\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            }
            if (StringUtils.isBlank((CharSequence)resp.getSdAdjustingSynServiceResponse().getHead().getErrorCode())) {
                code = "1";
                message = "\u6210\u529f";
                success = true;
            }
        }
        catch (ApisBusinessException e) {
            this.log.error("\u6c34\u6ef4\u7406\u7b97\u4fe1\u606f\u540c\u6b65\u51fa\u9519: ", (Throwable)e);
            success = false;
            resp = new StanderResponse();
            SDRequestHeadDTO requestHead = request.getSdAdjustingSynServiceRequest().getHead();
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode(e.getErrorCode()).errorMessage(e.getMessage()).build();
            SDClaimOpenBillServiceResponse response = new SDClaimOpenBillServiceResponse(head, null);
            resp.setHeader(request.getHeader());
            resp.setSdClaimOpenBillServiceResponse(response);
        }
        catch (Exception e) {
            this.log.error("\u7406\u7b97\u4fe1\u606f\u540c\u6b65\u5f02\u5e38\u6d41\u6c34\u53f7\uff1a{}", (Object)request.getSdAdjustingSynServiceRequest().getHead().getTransID());
            this.log.error("\u7406\u7b97\u4fe1\u606f\u540c\u6b65\u7cfb\u7edf\u5f02\u5e38\uff1a{}", (Throwable)e);
            resp = new StanderResponse();
            success = false;
            SDRequestHeadDTO requestHead = request.getSdAdjustingSynServiceRequest().getHead();
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode("500").errorMessage("\u7cfb\u7edf\u5f02\u5e38").build();
            SDClaimOpenBillServiceResponse response = new SDClaimOpenBillServiceResponse(head, null);
            resp.setHeader(request.getHeader());
            resp.setSdClaimOpenBillServiceResponse(response);
        }
        this.log.warn("\u7406\u7b97\u4fe1\u606f\u540c\u6b65\u603b\u8017\u65f6\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - date.getTime()));
        return WebResponse.builder().success(Boolean.valueOf(success)).result((Serializable)resp).message(message).code(code).build();
    }

    @RequestMapping(value={"/claim/sdInformationComplement"})
    public WebResponse informationComplement(@RequestBody StanderRequest request, HttpServletRequest httpServletRequest) {
        StanderResponse resp = null;
        String code = "0";
        String message = "\u5931\u8d25";
        boolean success = false;
        Date date = new Date();
        try {
            TimeInterval timer = DateUtil.timer();
            this.log.warn("\u8d44\u6599\u4fe1\u606f\u8865\u5145\u8bf7\u6c42\u6d41\u6c34\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            if (resp == null) {
                resp = this.apisBusinessService.execute("sdInformationComplement", request);
                this.log.warn("\u8d44\u6599\u4fe1\u606f\u8865\u5145\uff0c\u6267\u884c\u6d41\u7a0b\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
                this.log.warn("\u8d44\u6599\u4fe1\u606f\u8865\u5145\uff0c\u4fdd\u5b58\u6d41\u6c34\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            }
            if (StringUtils.isBlank((CharSequence)resp.getSdInforSupplementServiceResponse().getHead().getErrorCode())) {
                code = "1";
                message = "\u6210\u529f";
                success = true;
            }
        }
        catch (ApisBusinessException e) {
            this.log.error("\u6c34\u6ef4\u8d44\u6599\u4fe1\u606f\u8865\u5145\u51fa\u9519: ", (Throwable)e);
            success = false;
            resp = new StanderResponse();
            SDRequestHeadDTO requestHead = request.getSdInforSupplementServiceRequest().getHead();
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode(e.getErrorCode()).errorMessage(e.getMessage()).build();
            SDInforSupplementServiceResponse response = new SDInforSupplementServiceResponse(head, null);
            resp.setHeader(request.getHeader());
            resp.setSdInforSupplementServiceResponse(response);
        }
        catch (Exception e) {
            this.log.error("\u8d44\u6599\u4fe1\u606f\u8865\u5145\u5f02\u5e38\u6d41\u6c34\u53f7\uff1a{}", (Object)request.getSdInforSupplementServiceRequest().getHead().getTransID());
            this.log.error("\u8d44\u6599\u4fe1\u606f\u8865\u5145\u7cfb\u7edf\u5f02\u5e38\uff1a{}", (Throwable)e);
            resp = new StanderResponse();
            success = false;
            SDRequestHeadDTO requestHead = request.getSdInforSupplementServiceRequest().getHead();
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode("500").errorMessage("\u7cfb\u7edf\u5f02\u5e38").build();
            SDInforSupplementServiceResponse response = new SDInforSupplementServiceResponse(head, null);
            resp.setHeader(request.getHeader());
            resp.setSdInforSupplementServiceResponse(response);
        }
        this.log.warn("\u8d44\u6599\u4fe1\u606f\u8865\u5145\u603b\u8017\u65f6\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - date.getTime()));
        return WebResponse.builder().success(Boolean.valueOf(success)).result((Serializable)resp).message(message).code(code).build();
    }

    @RequestMapping(value={"/claim/sdClaimSurvey"})
    public WebResponse sdClaimSurvey(@RequestBody StanderRequest request) {
        StanderResponse resp;
        String code = "0";
        String message = "\u5931\u8d25";
        boolean success = false;
        Date date = new Date();
        SDRequestHeadDTO requestHead = request.getSdClaimSurveyServiceRequest().getHead();
        try {
            TimeInterval timer = DateUtil.timer();
            resp = this.apisBusinessService.execute("sdClaimSurvey", request);
            this.log.warn("\u7406\u8d54\u8c03\u67e5\u53d1\u8d77\uff0c\u6267\u884c\u6d41\u7a0b\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            ResponseHeadDTO responseHead = resp.getSdClaimOpenBillServiceResponse().getHead();
            if (ObjectUtil.isNotEmpty((Object)responseHead) && ObjectUtil.isEmpty((Object)responseHead.getErrorCode()) && "1".equals(responseHead.getResponseCode())) {
                code = "1";
                message = "\u6210\u529f";
                success = true;
            }
        }
        catch (ApisBusinessException e) {
            this.log.error("\u7406\u8d54\u8c03\u67e5\u53d1\u8d77\u63a5\u53e3\u5f02\u5e38\u3002", (Throwable)e);
            success = false;
            resp = new StanderResponse();
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode(e.getErrorCode()).errorMessage(e.getMessage()).build();
            resp.setHeader(request.getHeader());
            resp.setSdClaimOpenBillServiceResponse(SDClaimOpenBillServiceResponse.builder().head(head).build());
        }
        catch (Exception e) {
            this.log.error("\u7406\u8d54\u8c03\u67e5\u53d1\u8d77\u63a5\u53e3\u6d41\u6c34\u53f7\uff1a{}", (Object)request.getSdClaimSurveyServiceRequest().getHead().getTransID());
            this.log.error("\u7406\u8d54\u8c03\u67e5\u53d1\u8d77\u7cfb\u7edf\u5f02\u5e38\u3002", (Throwable)e);
            resp = new StanderResponse();
            success = false;
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode(ChannelErrorCodeEnum.ERR_C10006.getKey()).errorMessage(ChannelErrorCodeEnum.ERR_C10006.getValue()).build();
            resp.setHeader(request.getHeader());
            resp.setSdClaimOpenBillServiceResponse(SDClaimOpenBillServiceResponse.builder().head(head).build());
        }
        this.log.warn("\u7406\u8d54\u8c03\u67e5\u53d1\u8d77\u603b\u8017\u65f6\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - date.getTime()));
        return WebResponse.builder().success(Boolean.valueOf(success)).result((Serializable)resp).message(message).code(code).build();
    }

    @RequestMapping(value={"/claim/sdPolicyItemInfo"})
    public WebResponse sdPolicyItemInfo(@RequestBody StanderRequest request) {
        StanderResponse resp;
        String code = "0";
        String message = "\u5931\u8d25";
        boolean success = false;
        Date date = new Date();
        SDRequestHeadDTO requestHead = request.getSdClaimPolicyItemServiceRequest().getHead();
        try {
            TimeInterval timer = DateUtil.timer();
            resp = this.apisBusinessService.execute("sdPolicyItemInfo", request);
            this.log.warn("\u7406\u8d54\u4fdd\u5168\u4fe1\u606f\u67e5\u8be2\uff0c\u6267\u884c\u6d41\u7a0b\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            ResponseHeadDTO responseHead = resp.getSdClaimOpenBillServiceResponse().getHead();
            if (ObjectUtil.isNotEmpty((Object)responseHead) && ObjectUtil.isEmpty((Object)responseHead.getErrorCode()) && "1".equals(responseHead.getResponseCode())) {
                code = "1";
                message = "\u6210\u529f";
                success = true;
            }
        }
        catch (ApisBusinessException e) {
            this.log.error("\u7406\u8d54\u4fdd\u5168\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\u3002", (Throwable)e);
            success = false;
            resp = new StanderResponse();
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode(e.getErrorCode()).errorMessage(e.getMessage()).build();
            resp.setHeader(request.getHeader());
            resp.setSdClaimOpenBillServiceResponse(SDClaimOpenBillServiceResponse.builder().head(head).build());
        }
        catch (Exception e) {
            this.log.error("\u7406\u8d54\u4fdd\u5168\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u6d41\u6c34\u53f7\uff1a{}", (Object)requestHead.getTransID());
            this.log.error("\u7406\u8d54\u4fdd\u5168\u4fe1\u606f\u67e5\u8be2\u7cfb\u7edf\u5f02\u5e38\u3002", (Throwable)e);
            resp = new StanderResponse();
            success = false;
            ResponseHeadDTO head = ResponseHeadDTO.builder().transID(requestHead.getTransID()).transTime(new Date()).errorCode(ChannelErrorCodeEnum.ERR_C10006.getKey()).errorMessage(ChannelErrorCodeEnum.ERR_C10006.getValue()).build();
            resp.setHeader(request.getHeader());
            resp.setSdClaimOpenBillServiceResponse(SDClaimOpenBillServiceResponse.builder().head(head).build());
        }
        this.log.warn("\u7406\u8d54\u4fdd\u5168\u4fe1\u606f\u67e5\u8be2\u603b\u8017\u65f6\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - date.getTime()));
        return WebResponse.builder().success(Boolean.valueOf(success)).result((Serializable)resp).message(message).code(code).build();
    }
}

