/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.analysis.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiAnalysisTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.mapper.ApisBusiAnalysisTaskLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import java.util.Calendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApisBusiAnalysisTaskLogServiceImpl
extends ServiceImpl<ApisBusiAnalysisTaskLogMapper, ApisBusiAnalysisTaskLog>
implements ApisBusiAnalysisTaskLogService {
    @Autowired
    private ApisBusiAnalysisTaskLogMapper apisBusiAnalysisTaskLogMapper;

    @Override
    public void saveTaskInfo(ApisBusiAnalysisTaskLog taskLog) {
        if (ObjectUtil.isEmpty((Object)taskLog.getPushStep())) {
            taskLog.setPushStep(0);
        }
        if (ObjectUtil.isEmpty((Object)taskLog.getPushStatus())) {
            taskLog.setPushStatus("0");
        }
        this.save(taskLog);
    }

    @Override
    public List<ApisBusiAnalysisTaskLog> getNeedPushTaskRecord(String pushType, Integer maxPushTimes) {
        QueryWrapper pushLogQueryWrapper = new QueryWrapper();
        pushLogQueryWrapper.in((Object)"push_type", new Object[]{pushType});
        Calendar cal = Calendar.getInstance();
        cal.add(5, -15);
        pushLogQueryWrapper.and(wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)wrapper.eq((Object)"push_status", (Object)"3")).or(qw -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)qw.in((Object)"push_status", (Object[])new String[]{"0", "4"})).lt((Object)"push_step", (Object)maxPushTimes)).gt((Object)"create_time", (Object)cal.getTime());
            });
        });
        pushLogQueryWrapper.last("limit 50");
        pushLogQueryWrapper.orderByDesc((Object)"id");
        return this.apisBusiAnalysisTaskLogMapper.selectList((Wrapper)pushLogQueryWrapper);
    }

    @Override
    public List<ApisBusiTaskLog> getNeedSendFailEmail() {
        return this.apisBusiAnalysisTaskLogMapper.getNeedSendFailEmail();
    }
}

