/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.analysis.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxAddInsuredVoucher;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxAddSuminsuredOrder;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxNewOrderVoucher;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.mapper.ApisBusiMxAddInsuredVoucherMapper;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddInsuredOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddInsuredVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddSuminsuredOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxNewOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxNewOrderVoucherService;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApisBusiMxAddInsuredVoucherServiceImpl
extends ServiceImpl<ApisBusiMxAddInsuredVoucherMapper, ApisBusiMxAddInsuredVoucher>
implements ApisBusiMxAddInsuredVoucherService {
    @Autowired
    ApisBusiMxNewOrderService apisBusiMxNewOrderService;
    @Autowired
    ApisBusiMxAddSuminsuredOrderService apisBusiMxAddSuminsuredOrderService;
    @Autowired
    ApisBusiMxNewOrderVoucherService apisBusiMxNewOrderVoucherService;
    @Autowired
    ApisBusiMxAddInsuredOrderService apisBusiMxAddInsuredOrderService;

    @Override
    public ApisBusiMxAddInsuredVoucher getToCheckClaimRegist(String contractNo, String mxPolicyNo, String orderNo) {
        if (StringUtils.isBlank((CharSequence)contractNo) || StringUtils.isBlank((CharSequence)mxPolicyNo)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        queryWrapper.eq((Object)"mx_policy_no", (Object)mxPolicyNo);
        queryWrapper.eq((Object)"deleted", (Object)0);
        List vouchers = this.list((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)vouchers)) {
            return null;
        }
        return vouchers.stream().findFirst().orElse(null);
    }

    @Override
    public ApisBusiMxAddInsuredVoucher getToCheckClaimRegistYq(String contractNo, String policyNo, String mxPolicyNo) {
        if (StringUtils.isBlank((CharSequence)policyNo) || StringUtils.isBlank((CharSequence)mxPolicyNo)) {
            return null;
        }
        String mxContractNo = this.apisBusiMxAddInsuredOrderService.getMxContractNo(contractNo);
        if (StringUtils.isBlank((CharSequence)mxContractNo)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mx_contract_no", (Object)mxContractNo);
        queryWrapper.eq((Object)"policy_no", (Object)policyNo);
        queryWrapper.eq((Object)"mx_policy_no", (Object)mxPolicyNo);
        queryWrapper.eq((Object)"project_code", (Object)"YQ");
        return (ApisBusiMxAddInsuredVoucher)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public String getPk(String contractNo, String mxPolicyNo, String orderNo) {
        if (StringUtils.isBlank((CharSequence)contractNo) || StringUtils.isBlank((CharSequence)mxPolicyNo)) {
            return null;
        }
        ApisBusiMxAddInsuredVoucher voucher = this.getToCheckClaimRegist(contractNo, mxPolicyNo, orderNo);
        if (ObjectUtils.isNotEmpty((Object)voucher) && StringUtils.isNotBlank((CharSequence)voucher.getPk())) {
            return voucher.getPk();
        }
        List<ApisBusiMxAddSuminsuredOrder> suminsuredOrders = this.apisBusiMxAddSuminsuredOrderService.getAddSumInsuredInfoByOrderNoAndMxPolicyNo(orderNo, mxPolicyNo);
        if (ObjectUtils.isNotEmpty(suminsuredOrders) && StringUtils.isNotBlank((CharSequence)suminsuredOrders.get(0).getPk())) {
            return suminsuredOrders.get(0).getPk();
        }
        return null;
    }

    @Override
    public String getPkToYq(String contractNo, String policyNo, String mxPolicyNo) {
        if (StringUtils.isBlank((CharSequence)policyNo) || StringUtils.isBlank((CharSequence)mxPolicyNo)) {
            return null;
        }
        ApisBusiMxAddInsuredVoucher voucher = this.getToCheckClaimRegistYq(contractNo, policyNo, mxPolicyNo);
        if (ObjectUtils.isNotEmpty((Object)voucher) && StringUtils.isNotBlank((CharSequence)voucher.getPk())) {
            return voucher.getPk();
        }
        return null;
    }

    @Override
    public LocalDateTime getPolicyEffectiveTime(String contractNo, String mxPolicyNo, String orderNo) {
        if (StringUtils.isBlank((CharSequence)contractNo) || StringUtils.isBlank((CharSequence)mxPolicyNo)) {
            return null;
        }
        ApisBusiMxAddInsuredVoucher voucher = this.getToCheckClaimRegist(contractNo, mxPolicyNo, orderNo);
        if (ObjectUtils.isNotEmpty((Object)voucher) && ObjectUtils.isNotEmpty((Object)voucher.getEndorseEffectiveTime())) {
            return voucher.getEndorseEffectiveTime();
        }
        List<ApisBusiMxAddSuminsuredOrder> suminsuredOrders = this.apisBusiMxAddSuminsuredOrderService.getAddSumInsuredInfoByOrderNoAndMxPolicyNo(orderNo, mxPolicyNo);
        if (ObjectUtils.isNotEmpty(suminsuredOrders) && ObjectUtils.isNotEmpty((Object)suminsuredOrders.get(0).getEndorseEffectiveTime())) {
            return suminsuredOrders.get(0).getEndorseEffectiveTime();
        }
        return null;
    }

    @Override
    public LocalDateTime getPolicyEffectiveTimeToYq(String contractNo, String policyNo, String mxPolicyNo) {
        if (StringUtils.isBlank((CharSequence)policyNo) || StringUtils.isBlank((CharSequence)mxPolicyNo)) {
            return null;
        }
        ApisBusiMxAddInsuredVoucher voucher = this.getToCheckClaimRegistYq(contractNo, policyNo, mxPolicyNo);
        if (ObjectUtils.isNotEmpty((Object)voucher) && ObjectUtils.isNotEmpty((Object)voucher.getEndorseEffectiveTime())) {
            return voucher.getEndorseEffectiveTime();
        }
        return null;
    }

    @Override
    public Map<String, String> getInsuredInfo(String contractNo, String mxPolicyNo, String orderNo) {
        if (StringUtils.isBlank((CharSequence)contractNo) || StringUtils.isBlank((CharSequence)mxPolicyNo)) {
            return null;
        }
        String mxContractNo = this.apisBusiMxNewOrderService.getMxContractNo(contractNo);
        ApisBusiMxAddInsuredVoucher voucher = this.getExistAddInsure(mxContractNo, mxPolicyNo, "YKF");
        HashMap<String, String> result = new HashMap<String, String>();
        if (ObjectUtils.isNotEmpty((Object)voucher) && ObjectUtils.isNotEmpty((Object)voucher.getInsuredName())) {
            result.put("insured_name", voucher.getInsuredName());
            result.put("gender", voucher.getGender());
            result.put("credential_type", voucher.getCredentialType());
            result.put("credential_no", voucher.getCredentialNo());
            return result;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mx_contract_no", (Object)mxContractNo);
        queryWrapper.eq((Object)"mx_policy_no", (Object)mxPolicyNo);
        ApisBusiMxNewOrderVoucher newOrderVoucher = (ApisBusiMxNewOrderVoucher)this.apisBusiMxNewOrderVoucherService.getOne((Wrapper)queryWrapper);
        if (ObjectUtils.isNotEmpty((Object)newOrderVoucher) && ObjectUtils.isNotEmpty((Object)newOrderVoucher.getInsuredName())) {
            result.put("insured_name", newOrderVoucher.getInsuredName());
            result.put("gender", newOrderVoucher.getGender());
            result.put("credential_type", newOrderVoucher.getCredentialType());
            result.put("credential_no", newOrderVoucher.getCredentialNo());
            return result;
        }
        return null;
    }

    @Override
    public Map<String, String> getInsuredInfoToYq(String contractNo, String policyNo, String mxPolicyNo) {
        if (StringUtils.isBlank((CharSequence)policyNo) || StringUtils.isBlank((CharSequence)mxPolicyNo)) {
            return null;
        }
        ApisBusiMxAddInsuredVoucher voucher = this.getToCheckClaimRegistYq(contractNo, policyNo, mxPolicyNo);
        HashMap<String, String> result = new HashMap<String, String>();
        if (ObjectUtils.isNotEmpty((Object)voucher) && ObjectUtils.isNotEmpty((Object)voucher.getInsuredName())) {
            result.put("insured_name", voucher.getInsuredName());
            result.put("gender", voucher.getGender());
            result.put("credential_type", voucher.getCredentialType());
            result.put("credential_no", voucher.getCredentialNo());
            return result;
        }
        return null;
    }

    @Override
    public List<ApisBusiMxAddInsuredVoucher> queryListByNos(String mxContractNo, String policyNo, String mxPolicyNo, String projectCode) {
        QueryWrapper addInsuredVoucherQueryWrapper = new QueryWrapper();
        addInsuredVoucherQueryWrapper.eq((Object)"mx_contract_no", (Object)mxContractNo);
        if (ObjectUtils.isNotEmpty((Object)policyNo)) {
            addInsuredVoucherQueryWrapper.eq((Object)"policy_no", (Object)policyNo);
        }
        if (StrUtil.isNotBlank((CharSequence)projectCode)) {
            addInsuredVoucherQueryWrapper.eq((Object)"project_code", (Object)projectCode);
        }
        if (StrUtil.isNotBlank((CharSequence)mxPolicyNo)) {
            addInsuredVoucherQueryWrapper.eq((Object)"mx_policy_no", (Object)mxPolicyNo);
        }
        addInsuredVoucherQueryWrapper.eq((Object)"deleted", (Object)0);
        List addInsuredVoucherList = this.list((Wrapper)addInsuredVoucherQueryWrapper);
        return addInsuredVoucherList;
    }

    @Override
    public List<ApisBusiMxAddInsuredVoucher> queryListByMxPolicyNoOrOrderNo(String mxContractNo, String mxPolicyNo, String orderNo, String projectCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_code", (Object)projectCode);
        queryWrapper.eq((Object)"deleted", (Object)0);
        if (StrUtil.isNotBlank((CharSequence)orderNo)) {
            queryWrapper.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"mx_policy_no", (Object)mxPolicyNo)).eq((Object)"mx_contract_no", (Object)mxContractNo)).or(qw -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)qw.eq((Object)"order_no", (Object)orderNo);
                });
            });
        } else {
            queryWrapper.eq((Object)"mx_contract_no", (Object)mxContractNo);
            queryWrapper.eq((Object)"mx_policy_no", (Object)mxPolicyNo);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ApisBusiMxAddInsuredVoucher> listAddInsuredVoucherByPolicyNoList(List<ApisBusiMxAddInsuredVoucher> voucherList, String projectCode) {
        if (ObjectUtil.isEmpty(voucherList)) {
            return null;
        }
        return ((ApisBusiMxAddInsuredVoucherMapper)this.baseMapper).listAddInsuredVoucherByPolicyNoList(voucherList, projectCode);
    }

    @Override
    public List<ApisBusiMxAddInsuredVoucher> queryListByMxPolicyNo(String mxContractNo, String mxPolicyNo, String policyNo, String projectCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mx_contract_no", (Object)mxContractNo);
        queryWrapper.eq((Object)"mx_policy_no", (Object)mxPolicyNo);
        queryWrapper.eq((Object)"policy_no", (Object)policyNo);
        queryWrapper.eq((Object)"project_code", (Object)projectCode);
        queryWrapper.eq((Object)"deleted", (Object)0);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ApisBusiMxAddInsuredVoucher> queryAddInsuredListByMxPolicyNo(String mxContractNo, String mxPolicyNo, String policyNo, String orderNo, String projectCode, String productCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mx_contract_no", (Object)mxContractNo);
        queryWrapper.eq((Object)"mx_policy_no", (Object)mxPolicyNo);
        queryWrapper.eq((Object)"policy_no", (Object)policyNo);
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        queryWrapper.eq((Object)"project_code", (Object)projectCode);
        queryWrapper.eq((Object)"deleted", (Object)0);
        queryWrapper.eq((Object)"product_code", (Object)productCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ApisBusiMxAddInsuredVoucher> getExistAddInsuredByOrderNoAndMxPolicyNo(String orderNo, String mxPolicyNo) {
        return ((ApisBusiMxAddInsuredVoucherMapper)this.baseMapper).getExistAddInsuredByOrderNoAndMxPolicyNo(orderNo, mxPolicyNo, null, null, null);
    }

    @Override
    public List<ApisBusiMxAddInsuredVoucher> getExistAddInsuredByOrderNoAndMxPolicyNo(String mxContractNo, String mxPolicyNo, String policyNo, String projectCode) {
        return ((ApisBusiMxAddInsuredVoucherMapper)this.baseMapper).getExistAddInsuredByOrderNoAndMxPolicyNo(null, mxPolicyNo, mxContractNo, policyNo, projectCode);
    }

    @Override
    public ApisBusiMxAddInsuredVoucher getExistAddInsure(String mxContractNo, String mxPolicyNo, String projectCode) {
        if (StringUtils.isBlank((CharSequence)mxContractNo) || StringUtils.isBlank((CharSequence)mxPolicyNo)) {
            return null;
        }
        List<ApisBusiMxAddInsuredVoucher> vouchers = this.queryListByNos(mxContractNo, null, mxPolicyNo, projectCode);
        if (ObjectUtils.isEmpty(vouchers)) {
            return null;
        }
        return vouchers.stream().findFirst().orElse(null);
    }

    @Override
    public String getMxProductCodeByOrderNo(String orderNo, String projectCode) {
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            return null;
        }
        return ((ApisBusiMxAddInsuredVoucherMapper)this.baseMapper).getMxProductCodeByOrderNo(orderNo, projectCode);
    }
}

