/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.analysis.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiAnalysisTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMaterial;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMedia;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimRegist;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.mapper.ApisBusiMxClaimMaterialMapper;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimMaterialService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimMediaService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimRegistService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApisBusiMxClaimMaterialServiceImpl
extends ServiceImpl<ApisBusiMxClaimMaterialMapper, ApisBusiMxClaimMaterial>
implements ApisBusiMxClaimMaterialService {
    @Autowired
    ApisBusiMxClaimMediaService apisBusiMxClaimMediaService;
    @Autowired
    ApisBusiMxClaimRegistService apisBusiMxClaimRegistService;
    @Autowired
    ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    private static final String MX_CLAIM_SUPPLEMENT = "mxClaimSupplement";

    @Override
    public boolean saveClaimSupplement(ApisBusiMxClaimMaterial apisBusiMxClaimMaterial, List<ApisBusiMxClaimMedia> mediaList) {
        boolean flag;
        ApisBusiMxClaimRegist apisBusiMxClaimRegist = this.apisBusiMxClaimRegistService.getByMxReportNo(apisBusiMxClaimMaterial.getMxReportNo());
        if (ObjectUtil.isNotEmpty((Object)apisBusiMxClaimRegist.getProjectCode())) {
            apisBusiMxClaimMaterial.setProjectCode(apisBusiMxClaimRegist.getProjectCode());
        }
        if (flag = this.save(apisBusiMxClaimMaterial)) {
            for (ApisBusiMxClaimMedia mxClaimMedia : mediaList) {
                mxClaimMedia.setRequestId(apisBusiMxClaimMaterial.getRequestId());
                mxClaimMedia.setMxReportNo(apisBusiMxClaimMaterial.getMxReportNo());
                mxClaimMedia.setProjectCode(apisBusiMxClaimMaterial.getProjectCode());
            }
        }
        ApisBusiAnalysisTaskLog taskLog = new ApisBusiAnalysisTaskLog();
        taskLog.setPushType(MX_CLAIM_SUPPLEMENT);
        taskLog.setBusinessKey(apisBusiMxClaimMaterial.getRequestId());
        taskLog.setPushStatus("0");
        taskLog.setPushStep(0);
        return this.apisBusiMxClaimMediaService.saveBatch(mediaList) && this.apisBusiAnalysisTaskLogService.save(taskLog);
    }

    @Override
    public ApisBusiMxClaimMaterial getMxClaimMaterial(String requestId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"request_id", (Object)requestId);
        return (ApisBusiMxClaimMaterial)this.getOne((Wrapper)wrapper);
    }

    @Override
    public void updateResult(ApisBusiMxClaimMaterial busiMxClaimMaterial) {
        ApisBusiMxClaimMaterial mxClaimMaterial = this.getMxClaimMaterial(busiMxClaimMaterial.getRequestId());
        mxClaimMaterial.setResultMsg(busiMxClaimMaterial.getResultMsg());
        mxClaimMaterial.setResultCode(busiMxClaimMaterial.getResultCode());
        this.saveOrUpdate(mxClaimMaterial);
    }
}

