/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.analysis.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMedia;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.mapper.ApisBusiMxClaimMediaMapper;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimMediaService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimMediaTempService;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApisBusiMxClaimMediaServiceImpl
extends ServiceImpl<ApisBusiMxClaimMediaMapper, ApisBusiMxClaimMedia>
implements ApisBusiMxClaimMediaService {
    @Resource
    ApisBusiMxClaimMediaTempService apisBusiMxClaimMediaTempService;
    @Resource
    ApisBusiMxClaimMediaMapper apisBusiMxClaimMediaMapper;

    @Override
    public List<ApisBusiMxClaimMedia> getByMxReportNo(String mxReportNo) {
        if (StringUtils.isBlank((CharSequence)mxReportNo)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mx_report_no", (Object)mxReportNo);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ApisBusiMxClaimMedia> getByRequestId(String requestId) {
        if (StringUtils.isBlank((CharSequence)requestId)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"request_id", (Object)requestId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ApisBusiMxClaimMedia> listNeedUpload() {
        String dateStr = "2021-05-13 13:00:00";
        DateTime endDate = DateUtil.parse((CharSequence)dateStr, (String)"yyyy-MM-dd HH:mm:ss");
        DateTime startDate = DateUtil.offsetDay((Date)endDate, (int)-4);
        List<ApisBusiMxClaimMedia> mediaList = this.apisBusiMxClaimMediaMapper.listNeedUpload((Date)startDate, (Date)endDate);
        List mediaTemps = this.apisBusiMxClaimMediaTempService.list();
        List fullMediaNames = mediaTemps.stream().map(temp -> temp.getClaimApplyId() + "-" + temp.getMediaName()).collect(Collectors.toList());
        List<ApisBusiMxClaimMedia> needUploadList = mediaList.stream().filter(m -> {
            String fullMediaName = m.getClaimApplyId() + "-" + m.getMediaNo() + "." + m.getFileSuffix();
            return !fullMediaNames.contains(fullMediaName);
        }).limit(50L).collect(Collectors.toList());
        return needUploadList;
    }

    @Override
    public List<ApisBusiMxClaimMedia> listRepeatNameMedias(Date endDate) {
        return this.apisBusiMxClaimMediaMapper.listRepeatName(endDate);
    }
}

