/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.analysis.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiAnalysisTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMedia;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimRegist;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.mapper.ApisBusiMxClaimRegistMapper;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimMediaService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimRegistService;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApisBusiMxClaimRegistServiceImpl
extends ServiceImpl<ApisBusiMxClaimRegistMapper, ApisBusiMxClaimRegist>
implements ApisBusiMxClaimRegistService {
    @Autowired
    ApisBusiMxClaimRegistMapper apisBusiMxClaimRegistMapper;
    @Autowired
    ApisBusiMxClaimMediaService apisBusiMxClaimMediaService;
    @Autowired
    ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    private static final String SUCCESS_CODE = "000000";

    @Override
    public Boolean saveRegistAndMedia(ApisBusiMxClaimRegist regist, List<ApisBusiMxClaimMedia> mediaList) {
        if (ObjectUtils.isEmpty((Object)regist) || ObjectUtils.isEmpty(mediaList)) {
            return false;
        }
        return this.save(regist) && this.apisBusiMxClaimMediaService.saveBatch(mediaList);
    }

    @Override
    public void updateResult(ApisBusiMxClaimRegist regist) {
        if (ObjectUtils.isEmpty((Object)regist) || ObjectUtils.isEmpty((Object)regist.getRequestId())) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"request_id", (Object)regist.getRequestId());
        ApisBusiMxClaimRegist updateRegist = ApisBusiMxClaimRegist.builder().responseTime(LocalDateTime.now()).resultCode(regist.getResultCode()).resultMsg(regist.getResultMsg()).build();
        this.update(updateRegist, (Wrapper)updateWrapper);
    }

    @Override
    public ApisBusiMxClaimRegist getByRequestId(String requestId, String orderNo) {
        List list;
        if (StringUtils.isBlank((CharSequence)requestId)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"request_id", (Object)requestId);
        if (StringUtils.isNotBlank((CharSequence)orderNo)) {
            ((QueryWrapper)queryWrapper.or()).eq((Object)"order_no", (Object)orderNo);
        }
        if (ObjectUtils.isEmpty((Object)(list = this.list((Wrapper)queryWrapper)))) {
            return null;
        }
        return list.stream().findFirst().orElse(null);
    }

    @Override
    public ApisBusiMxClaimRegist getByClaimApplyId(String claimApplyId) {
        if (StringUtils.isBlank((CharSequence)claimApplyId)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"claim_apply_id", (Object)claimApplyId);
        return (ApisBusiMxClaimRegist)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public ApisBusiMxClaimRegist getByMxReportNo(String mxReportNo) {
        if (StringUtils.isBlank((CharSequence)mxReportNo)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mx_report_no", (Object)mxReportNo);
        return (ApisBusiMxClaimRegist)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public ApisBusiMxClaimRegist getCheckIdempotent(ApisBusiMxClaimRegist regist) {
        if (StringUtils.isBlank((CharSequence)regist.getContractNo()) || StringUtils.isBlank((CharSequence)regist.getMxPolicyNo()) || ObjectUtils.isEmpty((Object)regist.getDamageTime())) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(StringUtils.isNotBlank((CharSequence)regist.getContractNo()), ApisBusiMxClaimRegist::getContractNo, (Object)regist.getContractNo());
        wrapper.eq(StringUtils.isNotBlank((CharSequence)regist.getMxPolicyNo()), ApisBusiMxClaimRegist::getMxPolicyNo, (Object)regist.getMxPolicyNo());
        wrapper.eq(StringUtils.isNotBlank((CharSequence)regist.getOrderNo()), ApisBusiMxClaimRegist::getOrderNo, (Object)regist.getOrderNo());
        wrapper.eq(ObjectUtils.isNotEmpty((Object)regist.getDamageTime()), ApisBusiMxClaimRegist::getDamageTime, (Object)regist.getDamageTime());
        wrapper.eq(ApisBusiMxClaimRegist::getResultCode, (Object)SUCCESS_CODE);
        return (ApisBusiMxClaimRegist)this.getOne((Wrapper)wrapper);
    }

    @Override
    public boolean saveAndLog(String pushType, ApisBusiMxClaimRegist regist) {
        ApisBusiAnalysisTaskLog taskLog = new ApisBusiAnalysisTaskLog();
        taskLog.setPushType(pushType);
        taskLog.setBusinessKey(regist.getClaimApplyId());
        taskLog.setPushStatus("0");
        taskLog.setPushStep(0);
        return this.save(regist) && this.apisBusiAnalysisTaskLogService.save(taskLog);
    }

    @Override
    public boolean saveWithMediaAndLog(String pushType, ApisBusiMxClaimRegist regist, List<ApisBusiMxClaimMedia> mediaList) {
        if (ObjectUtils.isEmpty((Object)regist) || ObjectUtils.isEmpty(mediaList)) {
            return false;
        }
        ApisBusiAnalysisTaskLog taskLog = new ApisBusiAnalysisTaskLog();
        taskLog.setPushType(pushType);
        taskLog.setBusinessKey(regist.getClaimApplyId());
        taskLog.setPushStatus("0");
        taskLog.setPushStep(0);
        return this.save(regist) && this.apisBusiMxClaimMediaService.saveBatch(mediaList) && this.apisBusiAnalysisTaskLogService.save(taskLog);
    }

    @Override
    public List<ApisBusiMxClaimRegist> listDiffNotPushTrirdp() {
        DateTime endDate = DateUtil.offsetMinute((Date)new Date(), (int)-5);
        DateTime startDate = DateUtil.offsetHour((Date)endDate, (int)-48);
        return this.apisBusiMxClaimRegistMapper.listDiffNotPushTrirdp((Date)startDate, (Date)endDate);
    }

    @Override
    public List<ApisBusiMxClaimRegist> getClaimRegistListByOrderNo(List<String> orderNoList, String projectCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"order_no", orderNoList);
        queryWrapper.eq((Object)"project_code", (Object)projectCode);
        queryWrapper.eq((Object)"deleted", (Object)0);
        return this.list((Wrapper)queryWrapper);
    }
}

