/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.analysis.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxNewOrder;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxTransferNotice;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxTransferNoticeOrder;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.mapper.ApisBusiMxTransferNoticeMapper;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddInsuredVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddSuminsuredOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxNewOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxTransferNoticeOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxTransferNoticeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApisBusiMxTransferNoticeServiceImpl
extends ServiceImpl<ApisBusiMxTransferNoticeMapper, ApisBusiMxTransferNotice>
implements ApisBusiMxTransferNoticeService {
    @Autowired
    ApisBusiMxTransferNoticeOrderService apisBusiMxTransferNoticeOrderService;
    @Autowired
    ApisBusiMxNewOrderService apisBusiMxNewOrderService;
    @Autowired
    ApisBusiMxAddInsuredVoucherService apisBusiMxAddInsuredVoucherService;
    @Autowired
    ApisBusiMxAddSuminsuredOrderService apisBusiMxAddSuminsuredOrderService;
    @Autowired
    ApisBusiMxTransferNoticeService apisBusiMxTransferNoticeService;

    @Override
    public boolean saveTransferNotice(ApisBusiMxTransferNotice apisBusiMxTransferNotice, List<ApisBusiMxTransferNoticeOrder> orderList) {
        for (ApisBusiMxTransferNoticeOrder order : orderList) {
            order.setRequestId(apisBusiMxTransferNotice.getRequestId());
            order.setTransactionNo(apisBusiMxTransferNotice.getTransactionNo());
            ApisBusiMxNewOrder apisBusiMxNewOrder = this.getApisBusiMxNewOrder(order.getContractNo());
            if (!ObjectUtil.isNotEmpty((Object)apisBusiMxNewOrder)) continue;
            order.setProjectCode(apisBusiMxNewOrder.getProjectCode());
        }
        boolean flag = this.apisBusiMxTransferNoticeOrderService.saveBatch(orderList);
        if (flag) {
            apisBusiMxTransferNotice.setProjectCode(orderList.get(0).getProjectCode());
            this.save(apisBusiMxTransferNotice);
        } else {
            flag = false;
        }
        return flag;
    }

    @Override
    public ApisBusiMxTransferNotice getMxTransferNotice(ApisBusiMxTransferNotice apisBusiMxTransferNotice) {
        QueryWrapper wrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)apisBusiMxTransferNotice.getRequestId())) {
            wrapper.eq((Object)"request_id", (Object)apisBusiMxTransferNotice.getRequestId());
        }
        if (StrUtil.isNotEmpty((CharSequence)apisBusiMxTransferNotice.getResultCode())) {
            wrapper.eq((Object)"result_code", (Object)apisBusiMxTransferNotice.getResultCode());
        }
        if (StrUtil.isNotEmpty((CharSequence)apisBusiMxTransferNotice.getTransactionNo())) {
            wrapper.eq((Object)"transaction_no", (Object)apisBusiMxTransferNotice.getTransactionNo());
        }
        return (ApisBusiMxTransferNotice)this.getOne((Wrapper)wrapper);
    }

    @Override
    public void updateResult(ApisBusiMxTransferNotice apisBusiMxTransferNotice) {
        ApisBusiMxTransferNotice transferNotice = this.getMxTransferNotice(apisBusiMxTransferNotice);
        if (ObjectUtil.isEmpty((Object)transferNotice)) {
            this.saveOrUpdate(apisBusiMxTransferNotice);
        } else {
            transferNotice.setResultMsg(apisBusiMxTransferNotice.getResultMsg());
            transferNotice.setResultCode(apisBusiMxTransferNotice.getResultCode());
            this.updateById(transferNotice);
        }
    }

    @Override
    public String[] judgeIsHasInsured(List<ApisBusiMxTransferNoticeOrder> orderList) {
        String[] result = new String[2];
        result[0] = "1";
        for (ApisBusiMxTransferNoticeOrder order : orderList) {
            ApisBusiMxNewOrder apisBusiMxNewOrder = this.getApisBusiMxNewOrder(order.getContractNo());
            if (ObjectUtil.isNotEmpty((Object)apisBusiMxNewOrder)) {
                QueryWrapper insuredVoucherWrapper = new QueryWrapper();
                insuredVoucherWrapper.eq((Object)"mx_contract_no", (Object)apisBusiMxNewOrder.getMxContractNo());
                insuredVoucherWrapper.eq((Object)"mx_policy_no", (Object)order.getMxPolicyNo());
                insuredVoucherWrapper.eq((Object)"order_no", (Object)order.getOrderNo());
                int insuredVoucherList = this.apisBusiMxAddInsuredVoucherService.count((Wrapper)insuredVoucherWrapper);
                QueryWrapper suminsuredOrderWrapper = new QueryWrapper();
                suminsuredOrderWrapper.eq((Object)"mx_contract_no", (Object)apisBusiMxNewOrder.getMxContractNo());
                suminsuredOrderWrapper.eq((Object)"mx_policy_no", (Object)order.getMxPolicyNo());
                suminsuredOrderWrapper.eq((Object)"order_no", (Object)order.getOrderNo());
                int sumInsuredOrderList = this.apisBusiMxAddSuminsuredOrderService.count((Wrapper)suminsuredOrderWrapper);
                if (insuredVoucherList != 0 || sumInsuredOrderList != 0) continue;
                result[0] = "0";
                result[1] = order.getOrderNo();
                break;
            }
            result[0] = "0";
            result[1] = order.getOrderNo();
            break;
        }
        return result;
    }

    @Override
    public int checkIdempotent(String transactionNo, String requestId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"transaction_no", (Object)transactionNo);
        if (this.apisBusiMxTransferNoticeService.count((Wrapper)wrapper) > 0) {
            return this.apisBusiMxTransferNoticeService.count((Wrapper)wrapper);
        }
        wrapper = new QueryWrapper();
        wrapper.eq((Object)"request_id", (Object)requestId);
        if (this.apisBusiMxTransferNoticeService.count((Wrapper)wrapper) > 0) {
            return this.apisBusiMxTransferNoticeService.count((Wrapper)wrapper);
        }
        return 0;
    }

    private ApisBusiMxNewOrder getApisBusiMxNewOrder(String contractNo) {
        QueryWrapper mxOrderWrapper = new QueryWrapper();
        mxOrderWrapper.eq((Object)"contract_no", (Object)contractNo);
        return (ApisBusiMxNewOrder)this.apisBusiMxNewOrderService.getOne((Wrapper)mxOrderWrapper);
    }
}

