/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.oldCoreSystem.Q005;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.oldCoreSystem.Q005.InsuredQ005Vo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.oldCoreSystem.Q005.PlanListQ005Vo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.oldCoreSystem.Q005.PlanQ005Vo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.MainEndorResponseDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyQ005Vo
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PolicyQ005Vo.class);
    String policyRef;
    String endorsementPolicyRef;
    String issueDate;
    String effectiveDate;
    String expireDate;
    String policyStatus;
    String totalPremium;
    String adjustmentPremium;
    String holderName;
    String holderIdNumber;
    String agencyPolicyRef;
    String changeDescription;
    String cancelEffectiveDate;
    PlanListQ005Vo planList;
    String refundPremium;
    String installmentFlag;
    String refundMoneyType;
    String needRefund;
    public static Map<String, String> productCodeMap = new HashMap<String, String>();

    public static MainEndorResponseDTO convertNewPolicy(PolicyQ005Vo policyQ005Vo) {
        MainEndorResponseDTO element = MainEndorResponseDTO.builder().build();
        ArrayList<PlanDTO> planList = new ArrayList<PlanDTO>();
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getPolicyRef())) {
            element.setPolicyNo(policyQ005Vo.getPolicyRef());
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getEndorsementPolicyRef())) {
            element.setEndorseNo(policyQ005Vo.getEndorsementPolicyRef());
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getIssueDate())) {
            element.setIssueDate(PolicyQ005Vo.getDate(policyQ005Vo.getIssueDate()));
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getEffectiveDate())) {
            element.setStartDateStr(policyQ005Vo.getEffectiveDate());
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getExpireDate())) {
            element.setEndDateStr(policyQ005Vo.getExpireDate());
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getPolicyStatus())) {
            element.setPolicyStatus(policyQ005Vo.getPolicyStatus());
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getTotalPremium())) {
            element.setRespondPrice(PolicyQ005Vo.getPrice(policyQ005Vo.getTotalPremium()));
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getAdjustmentPremium())) {
            element.setChgSumPremium(PolicyQ005Vo.getPrice(policyQ005Vo.getAdjustmentPremium()));
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getHolderName())) {
            element.setAppliName(policyQ005Vo.getHolderName());
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getHolderIdNumber())) {
            element.setApplyNo(policyQ005Vo.getHolderIdNumber());
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getAgencyPolicyRef())) {
            element.setOrderId(policyQ005Vo.getAgencyPolicyRef());
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getChangeDescription())) {
            // empty if block
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getCancelEffectiveDate())) {
            element.setValidDateStr(policyQ005Vo.getCancelEffectiveDate());
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getRefundPremium())) {
            element.setActualRefPremium(PolicyQ005Vo.getPrice(policyQ005Vo.getRefundPremium()));
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getInstallmentFlag())) {
            element.setInstallmentFlag(policyQ005Vo.getInstallmentFlag());
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getRefundMoneyType())) {
            element.setSubEndorType(PolicyQ005Vo.getNewRefundMoneyType(policyQ005Vo.getRefundMoneyType()));
        }
        if (StrUtil.isNotEmpty((CharSequence)policyQ005Vo.getNeedRefund())) {
            element.setNeedRefund(policyQ005Vo.getNeedRefund());
        }
        if (policyQ005Vo.getPlanList() != null && policyQ005Vo.getPlanList().getPlan().size() > 0) {
            List<PlanQ005Vo> list = policyQ005Vo.getPlanList().getPlan();
            for (PlanQ005Vo pqv : list) {
                PlanDTO planDTO = PlanDTO.builder().build();
                if (StrUtil.isNotEmpty((CharSequence)pqv.getPlanCode())) {
                    planDTO.setPlanCode(pqv.getPlanCode());
                }
                if (StrUtil.isNotEmpty((CharSequence)pqv.getPlanNameZhs())) {
                    planDTO.setPlanNameZhs(pqv.getPlanNameZhs());
                }
                if (BeanUtil.isNotEmpty((Object)pqv.getInsuredList(), (String[])new String[0]) && pqv.getInsuredList().getInsured().size() > 0) {
                    ArrayList<InsuredDTO> insuredDTOList = new ArrayList<InsuredDTO>();
                    for (InsuredQ005Vo iqv : pqv.getInsuredList().getInsured()) {
                        InsuredDTO insuredDTO = InsuredDTO.builder().build();
                        if (StrUtil.isNotEmpty((CharSequence)iqv.getInsuredName())) {
                            insuredDTO.setInsuredName(iqv.getInsuredName());
                        }
                        if (StrUtil.isNotEmpty((CharSequence)iqv.getIdNumber())) {
                            insuredDTO.setIdNumber(iqv.getIdNumber());
                        }
                        if (StrUtil.isNotEmpty((CharSequence)iqv.getIdType())) {
                            insuredDTO.setIdType(PolicyQ005Vo.getNewIdType(iqv.getIdType()));
                        }
                        if (StrUtil.isNotEmpty((CharSequence)iqv.getBirthDate())) {
                            insuredDTO.setBirthDate(PolicyQ005Vo.getDate(iqv.getBirthDate()));
                        }
                        if (StrUtil.isNotEmpty((CharSequence)iqv.getPremium())) {
                            insuredDTO.setPremium(PolicyQ005Vo.getPrice(iqv.getPremium()));
                        }
                        if (StrUtil.isNotEmpty((CharSequence)iqv.getMobile())) {
                            insuredDTO.setMobile(iqv.getMobile());
                        }
                        if (StrUtil.isNotEmpty((CharSequence)iqv.getEmail())) {
                            insuredDTO.setEmail(iqv.getEmail());
                        }
                        if (StrUtil.isNotEmpty((CharSequence)iqv.getGender())) {
                            insuredDTO.setGender(iqv.getGender());
                        }
                        insuredDTOList.add(insuredDTO);
                    }
                    planDTO.setInsuredList(insuredDTOList);
                }
                planList.add(planDTO);
            }
            element.setPlanList(planList);
        }
        return element;
    }

    public static String getNewIdType(String idType) {
        String type = "";
        if (StrUtil.isNotEmpty((CharSequence)idType)) {
            switch (idType) {
                case "1": {
                    type = "01";
                    break;
                }
                case "2": {
                    type = "07";
                    break;
                }
                default: {
                    type = "99";
                }
            }
        }
        return type;
    }

    public static String getNewProductCode(String productCode) {
        String riskCode = productCodeMap.get(productCode);
        return riskCode;
    }

    public static Double getPrice(String priceStr) {
        Double p = 0.0;
        try {
            p = Double.parseDouble(priceStr);
        }
        catch (NumberFormatException e) {
            log.error("error: ", (Throwable)e);
        }
        return p;
    }

    public static Date getDate(String dateStr) {
        try {
            return DateUtil.parse((CharSequence)dateStr, (String)"yyyyMMddHHmmss");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getNewRefundMoneyType(String refundMoneyType) {
        String type = "";
        if (StrUtil.isNotEmpty((CharSequence)refundMoneyType)) {
            switch (refundMoneyType) {
                case "0": {
                    type = "00";
                    break;
                }
                case "1": {
                    type = "01";
                    break;
                }
                case "2": {
                    type = "02";
                    break;
                }
                default: {
                    type = "";
                }
            }
        }
        return type;
    }

    public static PolicyQ005VoBuilder builder() {
        return new PolicyQ005VoBuilder();
    }

    public String getPolicyRef() {
        return this.policyRef;
    }

    public String getEndorsementPolicyRef() {
        return this.endorsementPolicyRef;
    }

    public String getIssueDate() {
        return this.issueDate;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public String getExpireDate() {
        return this.expireDate;
    }

    public String getPolicyStatus() {
        return this.policyStatus;
    }

    public String getTotalPremium() {
        return this.totalPremium;
    }

    public String getAdjustmentPremium() {
        return this.adjustmentPremium;
    }

    public String getHolderName() {
        return this.holderName;
    }

    public String getHolderIdNumber() {
        return this.holderIdNumber;
    }

    public String getAgencyPolicyRef() {
        return this.agencyPolicyRef;
    }

    public String getChangeDescription() {
        return this.changeDescription;
    }

    public String getCancelEffectiveDate() {
        return this.cancelEffectiveDate;
    }

    public PlanListQ005Vo getPlanList() {
        return this.planList;
    }

    public String getRefundPremium() {
        return this.refundPremium;
    }

    public String getInstallmentFlag() {
        return this.installmentFlag;
    }

    public String getRefundMoneyType() {
        return this.refundMoneyType;
    }

    public String getNeedRefund() {
        return this.needRefund;
    }

    public void setPolicyRef(String policyRef) {
        this.policyRef = policyRef;
    }

    public void setEndorsementPolicyRef(String endorsementPolicyRef) {
        this.endorsementPolicyRef = endorsementPolicyRef;
    }

    public void setIssueDate(String issueDate) {
        this.issueDate = issueDate;
    }

    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public void setExpireDate(String expireDate) {
        this.expireDate = expireDate;
    }

    public void setPolicyStatus(String policyStatus) {
        this.policyStatus = policyStatus;
    }

    public void setTotalPremium(String totalPremium) {
        this.totalPremium = totalPremium;
    }

    public void setAdjustmentPremium(String adjustmentPremium) {
        this.adjustmentPremium = adjustmentPremium;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public void setHolderIdNumber(String holderIdNumber) {
        this.holderIdNumber = holderIdNumber;
    }

    public void setAgencyPolicyRef(String agencyPolicyRef) {
        this.agencyPolicyRef = agencyPolicyRef;
    }

    public void setChangeDescription(String changeDescription) {
        this.changeDescription = changeDescription;
    }

    public void setCancelEffectiveDate(String cancelEffectiveDate) {
        this.cancelEffectiveDate = cancelEffectiveDate;
    }

    public void setPlanList(PlanListQ005Vo planList) {
        this.planList = planList;
    }

    public void setRefundPremium(String refundPremium) {
        this.refundPremium = refundPremium;
    }

    public void setInstallmentFlag(String installmentFlag) {
        this.installmentFlag = installmentFlag;
    }

    public void setRefundMoneyType(String refundMoneyType) {
        this.refundMoneyType = refundMoneyType;
    }

    public void setNeedRefund(String needRefund) {
        this.needRefund = needRefund;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PolicyQ005Vo)) {
            return false;
        }
        PolicyQ005Vo other = (PolicyQ005Vo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$policyRef = this.getPolicyRef();
        String other$policyRef = other.getPolicyRef();
        if (this$policyRef == null ? other$policyRef != null : !this$policyRef.equals(other$policyRef)) {
            return false;
        }
        String this$endorsementPolicyRef = this.getEndorsementPolicyRef();
        String other$endorsementPolicyRef = other.getEndorsementPolicyRef();
        if (this$endorsementPolicyRef == null ? other$endorsementPolicyRef != null : !this$endorsementPolicyRef.equals(other$endorsementPolicyRef)) {
            return false;
        }
        String this$issueDate = this.getIssueDate();
        String other$issueDate = other.getIssueDate();
        if (this$issueDate == null ? other$issueDate != null : !this$issueDate.equals(other$issueDate)) {
            return false;
        }
        String this$effectiveDate = this.getEffectiveDate();
        String other$effectiveDate = other.getEffectiveDate();
        if (this$effectiveDate == null ? other$effectiveDate != null : !this$effectiveDate.equals(other$effectiveDate)) {
            return false;
        }
        String this$expireDate = this.getExpireDate();
        String other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !this$expireDate.equals(other$expireDate)) {
            return false;
        }
        String this$policyStatus = this.getPolicyStatus();
        String other$policyStatus = other.getPolicyStatus();
        if (this$policyStatus == null ? other$policyStatus != null : !this$policyStatus.equals(other$policyStatus)) {
            return false;
        }
        String this$totalPremium = this.getTotalPremium();
        String other$totalPremium = other.getTotalPremium();
        if (this$totalPremium == null ? other$totalPremium != null : !this$totalPremium.equals(other$totalPremium)) {
            return false;
        }
        String this$adjustmentPremium = this.getAdjustmentPremium();
        String other$adjustmentPremium = other.getAdjustmentPremium();
        if (this$adjustmentPremium == null ? other$adjustmentPremium != null : !this$adjustmentPremium.equals(other$adjustmentPremium)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        if (this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName)) {
            return false;
        }
        String this$holderIdNumber = this.getHolderIdNumber();
        String other$holderIdNumber = other.getHolderIdNumber();
        if (this$holderIdNumber == null ? other$holderIdNumber != null : !this$holderIdNumber.equals(other$holderIdNumber)) {
            return false;
        }
        String this$agencyPolicyRef = this.getAgencyPolicyRef();
        String other$agencyPolicyRef = other.getAgencyPolicyRef();
        if (this$agencyPolicyRef == null ? other$agencyPolicyRef != null : !this$agencyPolicyRef.equals(other$agencyPolicyRef)) {
            return false;
        }
        String this$changeDescription = this.getChangeDescription();
        String other$changeDescription = other.getChangeDescription();
        if (this$changeDescription == null ? other$changeDescription != null : !this$changeDescription.equals(other$changeDescription)) {
            return false;
        }
        String this$cancelEffectiveDate = this.getCancelEffectiveDate();
        String other$cancelEffectiveDate = other.getCancelEffectiveDate();
        if (this$cancelEffectiveDate == null ? other$cancelEffectiveDate != null : !this$cancelEffectiveDate.equals(other$cancelEffectiveDate)) {
            return false;
        }
        PlanListQ005Vo this$planList = this.getPlanList();
        PlanListQ005Vo other$planList = other.getPlanList();
        if (this$planList == null ? other$planList != null : !((Object)this$planList).equals(other$planList)) {
            return false;
        }
        String this$refundPremium = this.getRefundPremium();
        String other$refundPremium = other.getRefundPremium();
        if (this$refundPremium == null ? other$refundPremium != null : !this$refundPremium.equals(other$refundPremium)) {
            return false;
        }
        String this$installmentFlag = this.getInstallmentFlag();
        String other$installmentFlag = other.getInstallmentFlag();
        if (this$installmentFlag == null ? other$installmentFlag != null : !this$installmentFlag.equals(other$installmentFlag)) {
            return false;
        }
        String this$refundMoneyType = this.getRefundMoneyType();
        String other$refundMoneyType = other.getRefundMoneyType();
        if (this$refundMoneyType == null ? other$refundMoneyType != null : !this$refundMoneyType.equals(other$refundMoneyType)) {
            return false;
        }
        String this$needRefund = this.getNeedRefund();
        String other$needRefund = other.getNeedRefund();
        return !(this$needRefund == null ? other$needRefund != null : !this$needRefund.equals(other$needRefund));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PolicyQ005Vo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $policyRef = this.getPolicyRef();
        result = result * 59 + ($policyRef == null ? 43 : $policyRef.hashCode());
        String $endorsementPolicyRef = this.getEndorsementPolicyRef();
        result = result * 59 + ($endorsementPolicyRef == null ? 43 : $endorsementPolicyRef.hashCode());
        String $issueDate = this.getIssueDate();
        result = result * 59 + ($issueDate == null ? 43 : $issueDate.hashCode());
        String $effectiveDate = this.getEffectiveDate();
        result = result * 59 + ($effectiveDate == null ? 43 : $effectiveDate.hashCode());
        String $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : $expireDate.hashCode());
        String $policyStatus = this.getPolicyStatus();
        result = result * 59 + ($policyStatus == null ? 43 : $policyStatus.hashCode());
        String $totalPremium = this.getTotalPremium();
        result = result * 59 + ($totalPremium == null ? 43 : $totalPremium.hashCode());
        String $adjustmentPremium = this.getAdjustmentPremium();
        result = result * 59 + ($adjustmentPremium == null ? 43 : $adjustmentPremium.hashCode());
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        String $holderIdNumber = this.getHolderIdNumber();
        result = result * 59 + ($holderIdNumber == null ? 43 : $holderIdNumber.hashCode());
        String $agencyPolicyRef = this.getAgencyPolicyRef();
        result = result * 59 + ($agencyPolicyRef == null ? 43 : $agencyPolicyRef.hashCode());
        String $changeDescription = this.getChangeDescription();
        result = result * 59 + ($changeDescription == null ? 43 : $changeDescription.hashCode());
        String $cancelEffectiveDate = this.getCancelEffectiveDate();
        result = result * 59 + ($cancelEffectiveDate == null ? 43 : $cancelEffectiveDate.hashCode());
        PlanListQ005Vo $planList = this.getPlanList();
        result = result * 59 + ($planList == null ? 43 : ((Object)$planList).hashCode());
        String $refundPremium = this.getRefundPremium();
        result = result * 59 + ($refundPremium == null ? 43 : $refundPremium.hashCode());
        String $installmentFlag = this.getInstallmentFlag();
        result = result * 59 + ($installmentFlag == null ? 43 : $installmentFlag.hashCode());
        String $refundMoneyType = this.getRefundMoneyType();
        result = result * 59 + ($refundMoneyType == null ? 43 : $refundMoneyType.hashCode());
        String $needRefund = this.getNeedRefund();
        result = result * 59 + ($needRefund == null ? 43 : $needRefund.hashCode());
        return result;
    }

    public String toString() {
        return "PolicyQ005Vo(policyRef=" + this.getPolicyRef() + ", endorsementPolicyRef=" + this.getEndorsementPolicyRef() + ", issueDate=" + this.getIssueDate() + ", effectiveDate=" + this.getEffectiveDate() + ", expireDate=" + this.getExpireDate() + ", policyStatus=" + this.getPolicyStatus() + ", totalPremium=" + this.getTotalPremium() + ", adjustmentPremium=" + this.getAdjustmentPremium() + ", holderName=" + this.getHolderName() + ", holderIdNumber=" + this.getHolderIdNumber() + ", agencyPolicyRef=" + this.getAgencyPolicyRef() + ", changeDescription=" + this.getChangeDescription() + ", cancelEffectiveDate=" + this.getCancelEffectiveDate() + ", planList=" + this.getPlanList() + ", refundPremium=" + this.getRefundPremium() + ", installmentFlag=" + this.getInstallmentFlag() + ", refundMoneyType=" + this.getRefundMoneyType() + ", needRefund=" + this.getNeedRefund() + ")";
    }

    public PolicyQ005Vo() {
    }

    public PolicyQ005Vo(String policyRef, String endorsementPolicyRef, String issueDate, String effectiveDate, String expireDate, String policyStatus, String totalPremium, String adjustmentPremium, String holderName, String holderIdNumber, String agencyPolicyRef, String changeDescription, String cancelEffectiveDate, PlanListQ005Vo planList, String refundPremium, String installmentFlag, String refundMoneyType, String needRefund) {
        this.policyRef = policyRef;
        this.endorsementPolicyRef = endorsementPolicyRef;
        this.issueDate = issueDate;
        this.effectiveDate = effectiveDate;
        this.expireDate = expireDate;
        this.policyStatus = policyStatus;
        this.totalPremium = totalPremium;
        this.adjustmentPremium = adjustmentPremium;
        this.holderName = holderName;
        this.holderIdNumber = holderIdNumber;
        this.agencyPolicyRef = agencyPolicyRef;
        this.changeDescription = changeDescription;
        this.cancelEffectiveDate = cancelEffectiveDate;
        this.planList = planList;
        this.refundPremium = refundPremium;
        this.installmentFlag = installmentFlag;
        this.refundMoneyType = refundMoneyType;
        this.needRefund = needRefund;
    }

    static {
        productCodeMap.put("614", "P010998");
        productCodeMap.put("613", "P010090");
        productCodeMap.put("431", "P060018");
        productCodeMap.put("615", "P010093");
        productCodeMap.put("328", "P080016");
        productCodeMap.put("504", "P070005");
        productCodeMap.put("520", "P090001");
        productCodeMap.put("593", "P070002");
        productCodeMap.put("594", "P070006");
        productCodeMap.put("595", "P070004");
        productCodeMap.put("545", "P070003");
        productCodeMap.put("544", "P070007");
        productCodeMap.put("530", "P070001");
        productCodeMap.put("543", "P090002");
    }

    public static class PolicyQ005VoBuilder {
        private String policyRef;
        private String endorsementPolicyRef;
        private String issueDate;
        private String effectiveDate;
        private String expireDate;
        private String policyStatus;
        private String totalPremium;
        private String adjustmentPremium;
        private String holderName;
        private String holderIdNumber;
        private String agencyPolicyRef;
        private String changeDescription;
        private String cancelEffectiveDate;
        private PlanListQ005Vo planList;
        private String refundPremium;
        private String installmentFlag;
        private String refundMoneyType;
        private String needRefund;

        PolicyQ005VoBuilder() {
        }

        public PolicyQ005VoBuilder policyRef(String policyRef) {
            this.policyRef = policyRef;
            return this;
        }

        public PolicyQ005VoBuilder endorsementPolicyRef(String endorsementPolicyRef) {
            this.endorsementPolicyRef = endorsementPolicyRef;
            return this;
        }

        public PolicyQ005VoBuilder issueDate(String issueDate) {
            this.issueDate = issueDate;
            return this;
        }

        public PolicyQ005VoBuilder effectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public PolicyQ005VoBuilder expireDate(String expireDate) {
            this.expireDate = expireDate;
            return this;
        }

        public PolicyQ005VoBuilder policyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
            return this;
        }

        public PolicyQ005VoBuilder totalPremium(String totalPremium) {
            this.totalPremium = totalPremium;
            return this;
        }

        public PolicyQ005VoBuilder adjustmentPremium(String adjustmentPremium) {
            this.adjustmentPremium = adjustmentPremium;
            return this;
        }

        public PolicyQ005VoBuilder holderName(String holderName) {
            this.holderName = holderName;
            return this;
        }

        public PolicyQ005VoBuilder holderIdNumber(String holderIdNumber) {
            this.holderIdNumber = holderIdNumber;
            return this;
        }

        public PolicyQ005VoBuilder agencyPolicyRef(String agencyPolicyRef) {
            this.agencyPolicyRef = agencyPolicyRef;
            return this;
        }

        public PolicyQ005VoBuilder changeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
            return this;
        }

        public PolicyQ005VoBuilder cancelEffectiveDate(String cancelEffectiveDate) {
            this.cancelEffectiveDate = cancelEffectiveDate;
            return this;
        }

        public PolicyQ005VoBuilder planList(PlanListQ005Vo planList) {
            this.planList = planList;
            return this;
        }

        public PolicyQ005VoBuilder refundPremium(String refundPremium) {
            this.refundPremium = refundPremium;
            return this;
        }

        public PolicyQ005VoBuilder installmentFlag(String installmentFlag) {
            this.installmentFlag = installmentFlag;
            return this;
        }

        public PolicyQ005VoBuilder refundMoneyType(String refundMoneyType) {
            this.refundMoneyType = refundMoneyType;
            return this;
        }

        public PolicyQ005VoBuilder needRefund(String needRefund) {
            this.needRefund = needRefund;
            return this;
        }

        public PolicyQ005Vo build() {
            return new PolicyQ005Vo(this.policyRef, this.endorsementPolicyRef, this.issueDate, this.effectiveDate, this.expireDate, this.policyStatus, this.totalPremium, this.adjustmentPremium, this.holderName, this.holderIdNumber, this.agencyPolicyRef, this.changeDescription, this.cancelEffectiveDate, this.planList, this.refundPremium, this.installmentFlag, this.refundMoneyType, this.needRefund);
        }

        public String toString() {
            return "PolicyQ005Vo.PolicyQ005VoBuilder(policyRef=" + this.policyRef + ", endorsementPolicyRef=" + this.endorsementPolicyRef + ", issueDate=" + this.issueDate + ", effectiveDate=" + this.effectiveDate + ", expireDate=" + this.expireDate + ", policyStatus=" + this.policyStatus + ", totalPremium=" + this.totalPremium + ", adjustmentPremium=" + this.adjustmentPremium + ", holderName=" + this.holderName + ", holderIdNumber=" + this.holderIdNumber + ", agencyPolicyRef=" + this.agencyPolicyRef + ", changeDescription=" + this.changeDescription + ", cancelEffectiveDate=" + this.cancelEffectiveDate + ", planList=" + this.planList + ", refundPremium=" + this.refundPremium + ", installmentFlag=" + this.installmentFlag + ", refundMoneyType=" + this.refundMoneyType + ", needRefund=" + this.needRefund + ")";
        }
    }
}

