/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelInstallmentOrder;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class InstallmentQueryListDTO {
    private Integer payTimes;
    private BigDecimal planFee;
    @JsonFormat(pattern="yyyyMMddHHmmss", timezone="GMT+8")
    private Date planStartDate;
    @JsonFormat(pattern="yyyyMMddHHmmss", timezone="GMT+8")
    private Date planDate;
    private String payComplete;
    private BigDecimal actuallyPaid;
    @JsonFormat(pattern="yyyyMMddHHmmss", timezone="GMT+8")
    private LocalDateTime payTime;

    public InstallmentQueryListDTO() {
    }

    public InstallmentQueryListDTO(ApisBusiChannelInstallmentOrder order) {
        this.payTimes = order.getCurrentPayNo();
        this.planFee = order.getCurrentPremium();
        this.planStartDate = this.asDate(order.getDueDate());
        this.planDate = this.asDate(order.getOriginDueDate());
        if (order.getPayTime() == null) {
            this.payComplete = "N";
        } else {
            this.payComplete = "Y";
            this.payTime = order.getPayTime();
            this.actuallyPaid = order.getCurrentPremium();
        }
    }

    public Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public Integer getPayTimes() {
        return this.payTimes;
    }

    public BigDecimal getPlanFee() {
        return this.planFee;
    }

    public Date getPlanStartDate() {
        return this.planStartDate;
    }

    public Date getPlanDate() {
        return this.planDate;
    }

    public String getPayComplete() {
        return this.payComplete;
    }

    public BigDecimal getActuallyPaid() {
        return this.actuallyPaid;
    }

    public LocalDateTime getPayTime() {
        return this.payTime;
    }

    public void setPayTimes(Integer payTimes) {
        this.payTimes = payTimes;
    }

    public void setPlanFee(BigDecimal planFee) {
        this.planFee = planFee;
    }

    public void setPlanStartDate(Date planStartDate) {
        this.planStartDate = planStartDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public void setPayComplete(String payComplete) {
        this.payComplete = payComplete;
    }

    public void setActuallyPaid(BigDecimal actuallyPaid) {
        this.actuallyPaid = actuallyPaid;
    }

    public void setPayTime(LocalDateTime payTime) {
        this.payTime = payTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstallmentQueryListDTO)) {
            return false;
        }
        InstallmentQueryListDTO other = (InstallmentQueryListDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$payTimes = this.getPayTimes();
        Integer other$payTimes = other.getPayTimes();
        if (this$payTimes == null ? other$payTimes != null : !((Object)this$payTimes).equals(other$payTimes)) {
            return false;
        }
        BigDecimal this$planFee = this.getPlanFee();
        BigDecimal other$planFee = other.getPlanFee();
        if (this$planFee == null ? other$planFee != null : !((Object)this$planFee).equals(other$planFee)) {
            return false;
        }
        Date this$planStartDate = this.getPlanStartDate();
        Date other$planStartDate = other.getPlanStartDate();
        if (this$planStartDate == null ? other$planStartDate != null : !((Object)this$planStartDate).equals(other$planStartDate)) {
            return false;
        }
        Date this$planDate = this.getPlanDate();
        Date other$planDate = other.getPlanDate();
        if (this$planDate == null ? other$planDate != null : !((Object)this$planDate).equals(other$planDate)) {
            return false;
        }
        String this$payComplete = this.getPayComplete();
        String other$payComplete = other.getPayComplete();
        if (this$payComplete == null ? other$payComplete != null : !this$payComplete.equals(other$payComplete)) {
            return false;
        }
        BigDecimal this$actuallyPaid = this.getActuallyPaid();
        BigDecimal other$actuallyPaid = other.getActuallyPaid();
        if (this$actuallyPaid == null ? other$actuallyPaid != null : !((Object)this$actuallyPaid).equals(other$actuallyPaid)) {
            return false;
        }
        LocalDateTime this$payTime = this.getPayTime();
        LocalDateTime other$payTime = other.getPayTime();
        return !(this$payTime == null ? other$payTime != null : !((Object)this$payTime).equals(other$payTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstallmentQueryListDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $payTimes = this.getPayTimes();
        result = result * 59 + ($payTimes == null ? 43 : ((Object)$payTimes).hashCode());
        BigDecimal $planFee = this.getPlanFee();
        result = result * 59 + ($planFee == null ? 43 : ((Object)$planFee).hashCode());
        Date $planStartDate = this.getPlanStartDate();
        result = result * 59 + ($planStartDate == null ? 43 : ((Object)$planStartDate).hashCode());
        Date $planDate = this.getPlanDate();
        result = result * 59 + ($planDate == null ? 43 : ((Object)$planDate).hashCode());
        String $payComplete = this.getPayComplete();
        result = result * 59 + ($payComplete == null ? 43 : $payComplete.hashCode());
        BigDecimal $actuallyPaid = this.getActuallyPaid();
        result = result * 59 + ($actuallyPaid == null ? 43 : ((Object)$actuallyPaid).hashCode());
        LocalDateTime $payTime = this.getPayTime();
        result = result * 59 + ($payTime == null ? 43 : ((Object)$payTime).hashCode());
        return result;
    }

    public String toString() {
        return "InstallmentQueryListDTO(payTimes=" + this.getPayTimes() + ", planFee=" + this.getPlanFee() + ", planStartDate=" + this.getPlanStartDate() + ", planDate=" + this.getPlanDate() + ", payComplete=" + this.getPayComplete() + ", actuallyPaid=" + this.getActuallyPaid() + ", payTime=" + this.getPayTime() + ")";
    }
}

