/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.busi.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiTaskLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import java.util.Calendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ApisBusiTaskLogServiceImpl
extends ServiceImpl<ApisBusiTaskLogMapper, ApisBusiTaskLog>
implements ApisBusiTaskLogService {
    @Autowired
    ApisBusiTaskLogMapper apisBusiTaskLogMapper;

    @Override
    public List<ApisBusiTaskLog> getNeedPushData(String pushType) {
        return this.apisBusiTaskLogMapper.getNeedPushTasks(pushType);
    }

    @Override
    public void insertTaskInfo(String pushType, String businessKey) {
        ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
        apisBusiTaskLog.setBusinessKey(businessKey);
        apisBusiTaskLog.setPushType(pushType);
        apisBusiTaskLog.setPushStep(0);
        apisBusiTaskLog.setPushStatus("0");
        this.save(apisBusiTaskLog);
    }

    @Override
    public List<ApisBusiTaskLog> getNeedSendFailEmail() {
        return this.apisBusiTaskLogMapper.getNeedSendFailEmail();
    }

    @Override
    public List<ApisBusiTaskLog> getNeedPushInstallmentPayRecord(String pushType, Integer maxPushTimes) {
        QueryWrapper pushLogQueryWrapper = new QueryWrapper();
        pushLogQueryWrapper.in((Object)"push_type", new Object[]{pushType});
        Calendar cal = Calendar.getInstance();
        cal.add(5, -15);
        pushLogQueryWrapper.and(wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)wrapper.eq((Object)"push_status", (Object)"3")).or(qw -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)qw.in((Object)"push_status", (Object[])new String[]{"0", "4"})).lt((Object)"push_step", (Object)maxPushTimes)).gt((Object)"create_time", (Object)cal.getTime());
            });
        });
        pushLogQueryWrapper.last("limit 50");
        return this.apisBusiTaskLogMapper.selectList((Wrapper)pushLogQueryWrapper);
    }

    @Override
    public List<ApisBusiTaskLog> getNeedPushInstallmentPayRecordTasks(Integer maxPushTimes) {
        return this.apisBusiTaskLogMapper.getNeedPushInstallmentPayRecordTasks(maxPushTimes);
    }

    @Override
    public void insertTaskInfo(String pushType, String businessKey, String pushUrl, String pushContent) {
        ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
        apisBusiTaskLog.setBusinessKey(businessKey);
        apisBusiTaskLog.setPushType(pushType);
        apisBusiTaskLog.setPushTargetUrl(pushUrl);
        apisBusiTaskLog.setPushContent(pushContent);
        apisBusiTaskLog.setPushStep(0);
        apisBusiTaskLog.setPushStatus("0");
        this.save(apisBusiTaskLog);
    }

    @Override
    public void saveTaskInfo(ApisBusiTaskLog apisBusiTaskLog) {
        if (ObjectUtil.isEmpty((Object)apisBusiTaskLog.getPushStep())) {
            apisBusiTaskLog.setPushStep(0);
        }
        if (ObjectUtil.isEmpty((Object)apisBusiTaskLog.getPushStatus())) {
            apisBusiTaskLog.setPushStatus("0");
        }
        this.save(apisBusiTaskLog);
    }

    @Override
    public List<ApisBusiTaskLog> getTaskInfo(String pushType, String businessKey) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"push_type", (Object)pushType);
        queryWrapper.eq((Object)"business_key", (Object)businessKey);
        return this.list((Wrapper)queryWrapper);
    }
}

