/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.busi.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiUwOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwOrderService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApisBusiUwOrderServiceImpl
extends ServiceImpl<ApisBusiUwOrderMapper, ApisBusiUwOrder>
implements ApisBusiUwOrderService {
    @Resource
    ApisBusiUwOrderMapper apisBusiUwOrderMapper;

    @Override
    public int countByAgent(String agencyPolicyRef, String channelCode, String agentCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"agency_order_no", (Object)agencyPolicyRef);
        queryWrapper.eq((Object)"order_no", (Object)(agentCode + agencyPolicyRef));
        queryWrapper.eq((Object)"channel_code", (Object)channelCode);
        queryWrapper.eq((Object)"agent_code", (Object)agentCode);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public ApisBusiUwOrder getByAgent(String agencyPolicyRef, String channelCode, String agentCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"agency_order_no", (Object)agencyPolicyRef);
        queryWrapper.eq((Object)"order_no", (Object)(agentCode + agencyPolicyRef));
        if (StringUtils.isNotBlank((CharSequence)channelCode)) {
            queryWrapper.eq((Object)"channel_code", (Object)channelCode);
        }
        queryWrapper.eq((Object)"agent_code", (Object)agentCode);
        List list = this.list((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)list)) {
            return null;
        }
        return list.stream().findFirst().orElse(null);
    }

    @Override
    public void updateStatus(String orderNo, String status) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"order_no", (Object)orderNo);
        ApisBusiUwOrder order = new ApisBusiUwOrder();
        order.setStatus(status);
        this.update(order, (Wrapper)updateWrapper);
    }

    @Override
    public String getStatusByOrderNo(String orderNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        ApisBusiUwOrder order = (ApisBusiUwOrder)this.getOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)order)) {
            return null;
        }
        return order.getStatus();
    }

    @Override
    public ApisBusiUwOrder getByOrderNo(String orderNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        return (ApisBusiUwOrder)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public ApisBusiUwOrder getByUwId(String uwId) {
        return this.apisBusiUwOrderMapper.getByUwId(uwId);
    }
}

