/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.busi.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwSupport;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiUwSupportMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwSupportService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApisBusiUwSupportServiceImpl
extends ServiceImpl<ApisBusiUwSupportMapper, ApisBusiUwSupport>
implements ApisBusiUwSupportService {
    @Autowired
    ApisBusiUwOrderService apisBusiUwOrderService;

    @Override
    public boolean supportIsEnable(String supportCode) {
        ApisBusiUwSupport support = this.getEnableSupport(supportCode);
        return ObjectUtils.isNotEmpty((Object)support);
    }

    @Override
    public ApisBusiUwSupport getEnableSupport(String supportCode) {
        if (StringUtils.isBlank((CharSequence)supportCode)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"support_code", (Object)supportCode);
        List supports = this.list((Wrapper)queryWrapper);
        List enableList = supports.stream().filter(support -> {
            if (ObjectUtils.isEmpty((Object)support.getEndTime())) {
                return true;
            }
            if (ObjectUtils.isEmpty((Object)support.getStartTime())) {
                return support.getEndTime().isAfter(LocalDateTime.now());
            }
            return support.getStartTime().isBefore(LocalDateTime.now()) && support.getEndTime().isAfter(LocalDateTime.now());
        }).collect(Collectors.toList());
        return enableList.stream().findFirst().orElse(null);
    }

    @Override
    public ApisBusiUwSupport getSupportByOrderNo(String orderNo) {
        ApisBusiUwOrder order = this.apisBusiUwOrderService.getByOrderNo(orderNo);
        if (ObjectUtils.isEmpty((Object)order)) {
            return null;
        }
        return this.getEnableSupport(order.getSupportCode());
    }
}

