/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.cache;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jdaz.sinosoftgz.apis.commons.model.cache.SpringUtil;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.RedisTemplate;

public class MyBatisRedisCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(MyBatisRedisCache.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private RedisTemplate<String, Object> redisTemplate;
    private String id;

    public MyBatisRedisCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object key, Object value) {
        if (this.redisTemplate == null) {
            this.redisTemplate = (RedisTemplate)SpringUtil.getBean("redisTemplate");
        }
        if (value != null) {
            this.redisTemplate.opsForValue().set((Object)key.toString(), value);
        }
    }

    public Object getObject(Object key) {
        if (this.redisTemplate == null) {
            this.redisTemplate = (RedisTemplate)SpringUtil.getBean("redisTemplate");
        }
        try {
            if (key != null) {
                return this.redisTemplate.opsForValue().get((Object)key.toString());
            }
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u51fa\u9519 ", (Throwable)e);
        }
        return null;
    }

    public Object removeObject(Object key) {
        if (this.redisTemplate == null) {
            this.redisTemplate = (RedisTemplate)SpringUtil.getBean("redisTemplate");
        }
        if (key != null) {
            this.redisTemplate.delete((Object)key.toString());
        }
        return null;
    }

    public void clear() {
        Set keys;
        log.debug("\u6e05\u7a7a\u7f13\u5b58");
        if (this.redisTemplate == null) {
            this.redisTemplate = (RedisTemplate)SpringUtil.getBean("redisTemplate");
        }
        if (!CollectionUtils.isEmpty((Collection)(keys = this.redisTemplate.keys((Object)("*:" + this.id + "*"))))) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public int getSize() {
        if (this.redisTemplate == null) {
            this.redisTemplate = (RedisTemplate)SpringUtil.getBean("redisTemplate");
        }
        Long size = (Long)this.redisTemplate.execute(RedisServerCommands::dbSize);
        return size.intValue();
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}

