/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.model.channel.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelConfigsMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApisChannelConfigsServiceImpl
extends ServiceImpl<ApisChannelConfigsMapper, ApisChannelConfigs>
implements ApisChannelConfigsService {
    private static final Logger log = LoggerFactory.getLogger(ApisChannelConfigsServiceImpl.class);
    @Autowired
    ApisChannelConfigsMapper apisChannelConfigsMapper;

    @Override
    public ApisChannelConfigs getChannelConfig(ApisChannelConfigs apisChannelConfigs) {
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            if (StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getUserCode())) {
                queryWrapper.eq((Object)"user_code", (Object)apisChannelConfigs.getUserCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getChannelCode())) {
                queryWrapper.eq((Object)"channel_code", (Object)apisChannelConfigs.getChannelCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getProductCode())) {
                queryWrapper.like((Object)"product_code", (Object)apisChannelConfigs.getProductCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getConfigCode())) {
                queryWrapper.eq((Object)"config_code", (Object)apisChannelConfigs.getConfigCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getRationCode())) {
                queryWrapper.eq((Object)"ration_code", (Object)apisChannelConfigs.getRationCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getComCode())) {
                queryWrapper.eq((Object)"com_code", (Object)apisChannelConfigs.getComCode());
            }
            queryWrapper.eq((Object)"deleted", (Object)"0");
            List apisChannelConfigsList = this.apisChannelConfigsMapper.selectList((Wrapper)queryWrapper);
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfigsList) && apisChannelConfigsList.size() > 0) {
                return (ApisChannelConfigs)apisChannelConfigsList.get(0);
            }
        }
        return null;
    }

    @Override
    public List<ApisChannelConfigs> getChannelConfigList(ApisChannelConfigs apisChannelConfigs) {
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            if (StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getUserCode())) {
                queryWrapper.eq((Object)"user_code", (Object)apisChannelConfigs.getUserCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getChannelCode())) {
                queryWrapper.eq((Object)"channel_code", (Object)apisChannelConfigs.getChannelCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getProductCode())) {
                queryWrapper.like((Object)"product_code", (Object)apisChannelConfigs.getProductCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getConfigCode())) {
                queryWrapper.eq((Object)"config_code", (Object)apisChannelConfigs.getConfigCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getRationCode())) {
                queryWrapper.eq((Object)"ration_code", (Object)apisChannelConfigs.getRationCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getComCode())) {
                queryWrapper.eq((Object)"com_code", (Object)apisChannelConfigs.getComCode());
            }
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs.getEffectiveDate())) {
                queryWrapper.le((Object)"effective_date", (Object)apisChannelConfigs.getEffectiveDate());
                queryWrapper.ge((Object)"expire_date", (Object)apisChannelConfigs.getEffectiveDate());
            }
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs.getConfigValue())) {
                queryWrapper.eq((Object)"config_value", (Object)apisChannelConfigs.getConfigValue());
            }
            queryWrapper.eq((Object)"deleted", (Object)"0");
            return this.apisChannelConfigsMapper.selectList((Wrapper)queryWrapper);
        }
        return null;
    }

    @Override
    public String getConfigValue(String configCode) {
        if (StringUtils.isBlank((CharSequence)configCode)) {
            return null;
        }
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode(configCode);
        ApisChannelConfigs channelConfig = this.getChannelConfig(apisChannelConfigs);
        if (ObjectUtil.isEmpty((Object)channelConfig) || StringUtils.isBlank((CharSequence)channelConfig.getConfigValue())) {
            log.error("Config \u8868\u6ca1\u6709configCode: {}\u5bf9\u5e94\u7684\u503c,", (Object)configCode);
            return null;
        }
        return channelConfig.getConfigValue();
    }
}

