/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.util.image;

import com.jdaz.sinosoftgz.apis.commons.util.image.Base64EncryptUtil;
import com.jdaz.sinosoftgz.apis.commons.util.image.ImgErrorCode;
import com.jdaz.sinosoftgz.apis.commons.util.image.ImgServiceException;
import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImgEncryptUtil {
    private static final Logger log = LoggerFactory.getLogger(ImgEncryptUtil.class);
    private static String jdkvs = System.getProperty("java.vm.vendor");

    public static void main(String[] args) {
        String password = "admin123";
        String encPwd = ImgEncryptUtil.getEncPwd(password);
        String passwd = ImgEncryptUtil.MD5(password);
    }

    public static String getEncPwd(String consumerPwd) {
        String md5ConsumerPwd = ImgEncryptUtil.MD5(consumerPwd);
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        String res = dateFormat.format(date) + "#" + md5ConsumerPwd;
        return ImgEncryptUtil.getEncString(res, ImgEncryptUtil.initKey(md5ConsumerPwd));
    }

    private static Key initKey(String edsKey) {
        SecretKey key = null;
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("DES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(edsKey.getBytes());
            keyGenerator.init(secureRandom);
            key = keyGenerator.generateKey();
            keyGenerator = null;
        }
        catch (Exception e) {
            log.error("error: ", (Throwable)e);
        }
        return key;
    }

    public static String encodeStr(String strMing, Key key) {
        String miStr = null;
        miStr = null != jdkvs && jdkvs.startsWith("IBM") ? Base64EncryptUtil.encoder(strMing) : ImgEncryptUtil.getEncString(strMing, key);
        return miStr;
    }

    public static String getDecPwd(String strMi, String edsKey) {
        String minStr = null;
        minStr = strMi != null ? ImgEncryptUtil.getDesString(strMi, ImgEncryptUtil.initKey(edsKey)) : strMi;
        return minStr;
    }

    private static String getEncString(String strMing, Key key) {
        String strMi = "";
        if (strMing == null) {
            return strMi;
        }
        try {
            return ImgEncryptUtil.byte2hex(ImgEncryptUtil.getEncCode(strMing.getBytes(), key));
        }
        catch (Exception e) {
            throw new IllegalStateException("\u6570\u636e\u52a0\u5bc6\u9519\u8bef" + e.getMessage(), e);
        }
    }

    private static String getDesString(String strMi, Key key) {
        String strMing = "";
        try {
            strMing = new String(ImgEncryptUtil.getDesCode(ImgEncryptUtil.hex2byte(strMi.getBytes()), key));
        }
        catch (Exception e) {
            throw new ImgServiceException("\u6d88\u8d39\u65b9\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5consumerPWD\u53c2\u6570\uff01", ImgErrorCode.MissingArgument);
        }
        return strMing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getEncCode(byte[] byteS, Key key) {
        byte[] byteFina = null;
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, key);
            byteFina = cipher.doFinal(byteS);
        }
        catch (Exception e) {
            log.error("error: ", (Throwable)e);
        }
        finally {
            Object cipher = null;
        }
        return byteFina;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getDesCode(byte[] byteD, Key key) {
        byte[] byteFina = null;
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, key);
            byteFina = cipher.doFinal(byteD);
        }
        catch (Exception e) {
            log.error("error: ", (Throwable)e);
        }
        finally {
            Object cipher = null;
        }
        return byteFina;
    }

    private static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs.toUpperCase();
    }

    private static byte[] hex2byte(byte[] b) {
        if (b.length % 2 != 0) {
            throw new IllegalArgumentException("\u957f\u5ea6\u4e0d\u662f\u5076\u6570");
        }
        byte[] b2 = new byte[b.length / 2];
        for (int n = 0; n < b.length; n += 2) {
            String item = new String(b, n, 2);
            b2[n / 2] = (byte)Integer.parseInt(item, 16);
        }
        return b2;
    }

    private static String MD5(String res) {
        return ImgEncryptUtil.messageDigest(res);
    }

    private static String messageDigest(String res) {
        try {
            byte[] secretBytes = null;
            try {
                secretBytes = MessageDigest.getInstance("md5").digest(res.getBytes());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("\u6ca1\u6709\u8fd9\u4e2amd5\u7b97\u6cd5\uff01");
            }
            String md5code = new BigInteger(1, secretBytes).toString(16);
            for (int i = 0; i < 32 - md5code.length(); ++i) {
                md5code = "0" + md5code;
            }
            return md5code.toUpperCase();
        }
        catch (Exception e) {
            log.error("error: ", (Throwable)e);
            return null;
        }
    }
}

