/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.service.configs;

import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationClause;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationClauseKindFactory;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationEngage;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationHealth;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationKind;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationKindPayment;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationKindPaymentDetail;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationLimit;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationLimitDetail;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationPfchealth;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationServices;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationServicesDetail;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.dto.message.PfpRationMsgClause;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.dto.message.PfpRationMsgEngage;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.dto.message.PfpRationMsgHealth;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.dto.message.PfpRationMsgKind;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.dto.message.PfpRationMsgKindFactor;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.dto.message.PfpRationMsgLimit;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.dto.message.PfpRationMsgPayment;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.dto.message.PfpRationMsgPaymentDetail;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.dto.message.PfpRationMsgRation;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.dto.message.PfpRationMsgServices;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.converter.BidirectionalConverter;
import ma.glasnost.orika.converter.ConverterFactory;
import ma.glasnost.orika.impl.DefaultMapperFactory;
import ma.glasnost.orika.metadata.Type;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CommonOrikaAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(CommonOrikaAutoConfig.class);

    @Bean
    public MapperFacade rationOrikaMapperFacade() {
        DefaultMapperFactory factory = new DefaultMapperFactory.Builder().build();
        ConverterFactory converterFactory = factory.getConverterFactory();
        converterFactory.registerConverter((Converter)new LocalDateTimeLongConverter());
        converterFactory.registerConverter((Converter)new LocalDateTimeConverter());
        converterFactory.registerConverter((Converter)new LocalDateConverter());
        converterFactory.registerConverter((Converter)new LocalTimeConverter());
        converterFactory.registerConverter((Converter)new NullSafeBigDecimalStringConverter());
        converterFactory.registerConverter((Converter)new NullSafeShortStringConverter());
        converterFactory.registerConverter((Converter)new NullSafeIntegerStringConverter());
        converterFactory.registerConverter((Converter)new NullSafeLongStringConverter());
        converterFactory.registerConverter((Converter)new NullSafeDoubleStringConverter());
        converterFactory.registerConverter((Converter)new NullSafeFloatStringConverter());
        converterFactory.registerConverter("stringIntegerLogicConverter", (Converter)new StringIntegerLogicConverter());
        factory.getConverterFactory().registerConverter((Converter)new BidirectionalConverter<Integer, String>(){

            public String convertTo(Integer integer, Type<String> type, MappingContext mappingContext) {
                return integer.toString();
            }

            public Integer convertFrom(String s, Type<Integer> type, MappingContext mappingContext) {
                Integer val = null;
                if ("Y".equalsIgnoreCase(s)) {
                    val = ModelConstants.INT_VALUE_YES;
                } else if ("N".equalsIgnoreCase(s)) {
                    val = ModelConstants.INT_VALUE_NO;
                } else {
                    try {
                        val = Integer.parseInt(s);
                    }
                    catch (Exception e) {
                        log.error("error: ", (Throwable)e);
                        val = null;
                    }
                }
                return val;
            }
        });
        factory.classMap(ApisPfpRationMain.class, PfpRationMsgRation.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationClause.class, PfpRationMsgClause.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationClause.class, PfpRationMsgClause.PfpRationMsgPfcClause.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationClauseKindFactory.class, PfpRationMsgKindFactor.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationEngage.class, PfpRationMsgEngage.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationHealth.class, PfpRationMsgHealth.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationKind.class, PfpRationMsgKind.class).fieldMap("isOptional", "isOptional").converter("stringIntegerLogicConverter").add().exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationKindPayment.class, PfpRationMsgPayment.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationKindPaymentDetail.class, PfpRationMsgPaymentDetail.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationLimit.class, PfpRationMsgLimit.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationLimitDetail.class, PfpRationMsgLimit.PfpRationMsgPfcLimit.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationPfchealth.class, PfpRationMsgHealth.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationServices.class, PfpRationMsgServices.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        factory.classMap(ApisPfpRationServicesDetail.class, PfpRationMsgServices.PfpRationMsgPfcService.class).exclude("id").byDefault(new DefaultFieldMapper[0]).register();
        return factory.getMapperFacade();
    }

    private class StringIntegerLogicConverter
    extends BidirectionalConverter<String, Integer> {
        private StringIntegerLogicConverter() {
        }

        public Integer convertTo(String s, Type<Integer> type, MappingContext mappingContext) {
            return "Y".equalsIgnoreCase(s) ? ModelConstants.INT_VALUE_YES : ModelConstants.INT_VALUE_NO;
        }

        public String convertFrom(Integer integer, Type<String> type, MappingContext mappingContext) {
            return integer > 0 ? "Y" : "N";
        }
    }

    private class LocalTimeConverter
    extends BidirectionalConverter<LocalTime, LocalTime> {
        private LocalTimeConverter() {
        }

        public LocalTime convertTo(LocalTime localTime, Type<LocalTime> type, MappingContext mappingContext) {
            return LocalTime.from(localTime);
        }

        public LocalTime convertFrom(LocalTime localTime, Type<LocalTime> type, MappingContext mappingContext) {
            return LocalTime.from(localTime);
        }
    }

    private class LocalDateConverter
    extends BidirectionalConverter<LocalDate, LocalDate> {
        private LocalDateConverter() {
        }

        public LocalDate convertTo(LocalDate localDate, Type<LocalDate> type, MappingContext mappingContext) {
            return LocalDate.from(localDate);
        }

        public LocalDate convertFrom(LocalDate localDate, Type<LocalDate> type, MappingContext mappingContext) {
            return LocalDate.from(localDate);
        }
    }

    private class LocalDateTimeConverter
    extends BidirectionalConverter<LocalDateTime, LocalDateTime> {
        private LocalDateTimeConverter() {
        }

        public LocalDateTime convertTo(LocalDateTime localDateTime, Type<LocalDateTime> type, MappingContext mappingContext) {
            return LocalDateTime.from(localDateTime);
        }

        public LocalDateTime convertFrom(LocalDateTime localDateTime, Type<LocalDateTime> type, MappingContext mappingContext) {
            return LocalDateTime.from(localDateTime);
        }
    }

    private class LocalDateTimeLongConverter
    extends BidirectionalConverter<LocalDateTime, Long> {
        private LocalDateTimeLongConverter() {
        }

        public Long convertTo(LocalDateTime localDateTime, Type<Long> type, MappingContext mappingContext) {
            return localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        }

        public LocalDateTime convertFrom(Long aLong, Type<LocalDateTime> type, MappingContext mappingContext) {
            return LocalDateTime.ofEpochSecond(aLong / 1000L, 0, ZoneOffset.ofHours(8));
        }
    }

    private class NullSafeBigDecimalStringConverter
    extends BidirectionalConverter<String, BigDecimal> {
        private NullSafeBigDecimalStringConverter() {
        }

        public BigDecimal convertTo(String s, Type<BigDecimal> type, MappingContext mappingContext) {
            if (StringUtils.isEmpty((CharSequence)s)) {
                return null;
            }
            return new BigDecimal(s);
        }

        public String convertFrom(BigDecimal bigDecimal, Type<String> type, MappingContext mappingContext) {
            return bigDecimal == null ? null : bigDecimal.toString();
        }
    }

    private class NullSafeFloatStringConverter
    extends BidirectionalConverter<String, Float> {
        private NullSafeFloatStringConverter() {
        }

        public Float convertTo(String s, Type<Float> type, MappingContext mappingContext) {
            if (StringUtils.isEmpty((CharSequence)s)) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(s));
        }

        public String convertFrom(Float number, Type<String> type, MappingContext mappingContext) {
            return number == null ? "" : number.toString();
        }
    }

    private class NullSafeDoubleStringConverter
    extends BidirectionalConverter<String, Double> {
        private NullSafeDoubleStringConverter() {
        }

        public Double convertTo(String s, Type<Double> type, MappingContext mappingContext) {
            if (StringUtils.isEmpty((CharSequence)s)) {
                return null;
            }
            return Double.parseDouble(s);
        }

        public String convertFrom(Double number, Type<String> type, MappingContext mappingContext) {
            return number == null ? "" : number.toString();
        }
    }

    private class NullSafeLongStringConverter
    extends BidirectionalConverter<String, Long> {
        private NullSafeLongStringConverter() {
        }

        public Long convertTo(String s, Type<Long> type, MappingContext mappingContext) {
            if (StringUtils.isEmpty((CharSequence)s)) {
                return null;
            }
            return Long.parseLong(s);
        }

        public String convertFrom(Long number, Type<String> type, MappingContext mappingContext) {
            return number == null ? "" : number.toString();
        }
    }

    private class NullSafeIntegerStringConverter
    extends BidirectionalConverter<String, Integer> {
        private NullSafeIntegerStringConverter() {
        }

        public Integer convertTo(String s, Type<Integer> type, MappingContext mappingContext) {
            if (StringUtils.isEmpty((CharSequence)s)) {
                return null;
            }
            return Integer.parseInt(s);
        }

        public String convertFrom(Integer number, Type<String> type, MappingContext mappingContext) {
            return number == null ? "" : number.toString();
        }
    }

    private class NullSafeShortStringConverter
    extends BidirectionalConverter<String, Short> {
        private NullSafeShortStringConverter() {
        }

        public Short convertTo(String s, Type<Short> type, MappingContext mappingContext) {
            if (StringUtils.isEmpty((CharSequence)s)) {
                return null;
            }
            return Short.parseShort(s);
        }

        public String convertFrom(Short number, Type<String> type, MappingContext mappingContext) {
            return number == null ? "" : number.toString();
        }
    }
}

