/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.utils;

import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AesUtils {
    private static final Logger log = LoggerFactory.getLogger(AesUtils.class);

    public static String encrypt(String data, String key) throws Exception {
        return AesUtils.doAES(data, key, 1, 1);
    }

    public static String decrypt(String data, String key) throws Exception {
        return AesUtils.doAES(data, key, 2, 1);
    }

    private static String doAES(String data, String key, int mode, int codeType) throws Exception {
        try {
            if (!data.isEmpty() && !key.isEmpty()) {
                byte[] content = null;
                boolean encrypt = mode == 1;
                KeyGenerator kgen = KeyGenerator.getInstance("AES");
                SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                secureRandom.setSeed(key.getBytes());
                kgen.init(128, secureRandom);
                SecretKey secretKey = kgen.generateKey();
                byte[] enCodeFormat = secretKey.getEncoded();
                SecretKeySpec keySpec = new SecretKeySpec(enCodeFormat, "AES");
                Cipher cipher = Cipher.getInstance("AES");
                if (encrypt) {
                    content = data.getBytes("UTF-8");
                    cipher.init(1, keySpec);
                } else {
                    switch (codeType) {
                        case 1: {
                            content = Base64.decodeBase64((String)data);
                            break;
                        }
                        case 2: {
                            content = AesUtils.hex2byte(data);
                            break;
                        }
                    }
                    cipher.init(2, keySpec);
                }
                byte[] result = cipher.doFinal(content);
                if (encrypt) {
                    String resultCode = null;
                    switch (codeType) {
                        case 1: {
                            resultCode = Base64.encodeBase64String((byte[])result);
                            break;
                        }
                        case 2: {
                            resultCode = AesUtils.byte2hex(result);
                            break;
                        }
                    }
                    return resultCode;
                }
                return new String(result, "UTF-8");
            }
            return null;
        }
        catch (Exception var14) {
            throw new Exception("AES\u5bc6\u6587\u5904\u7406\u5f02\u5e38");
        }
    }

    private static String byte2hex(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] hex2byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        int splitNum = 2;
        for (int i = 0; i < hexStr.length() / splitNum; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

