/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.commons.utils;

import cn.hutool.core.util.ObjectUtil;
import java.io.File;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtils {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtils.class);
    private static final int READ_TIMEOUT = 100;
    private static final int CONNECT_TIMEOUT = 60;
    private static final int WRITE_TIMEOUT = 60;
    private static volatile OkHttpClient okHttpClient;

    private OkHttpUtils() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        clientBuilder.readTimeout(100L, TimeUnit.SECONDS);
        clientBuilder.connectTimeout(60L, TimeUnit.SECONDS);
        clientBuilder.writeTimeout(60L, TimeUnit.SECONDS);
        clientBuilder.connectionPool(new ConnectionPool(32, 5L, TimeUnit.MINUTES));
        okHttpClient = clientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getInstance() {
        if (null != okHttpClient) return okHttpClient;
        Class<OkHttpUtils> clazz = OkHttpUtils.class;
        synchronized (OkHttpUtils.class) {
            if (okHttpClient != null) return okHttpClient;
            new OkHttpUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return okHttpClient;
        }
    }

    public static String getBase64EncodeByUrl(String fileUrl) {
        try {
            OkHttpClient okHttpClient = OkHttpUtils.getInstance();
            Request request = new Request.Builder().url(fileUrl).get().build();
            Response okResponse = okHttpClient.newCall(request).execute();
            byte[] bytes = okResponse.body().bytes();
            if (ObjectUtil.isNotEmpty((Object)bytes)) {
                return Base64.encodeBase64String((byte[])bytes);
            }
        }
        catch (Exception e) {
            log.error("error:", (Throwable)e);
        }
        return null;
    }

    public static String postXml(String url, String xmlStr) {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml"), (String)xmlStr);
        Request requestOk = new Request.Builder().url(url).post(body).build();
        try {
            Response response = OkHttpUtils.getInstance().newCall(requestOk).execute();
            String jsonString = response.body().string();
            if (response.isSuccessful()) {
                return jsonString;
            }
        }
        catch (Exception e) {
            log.error("error:", (Throwable)e);
            return e.getMessage();
        }
        return "";
    }

    public static String getJson(String url) {
        Request requestOk = new Request.Builder().url(url).get().build();
        try {
            Response response = OkHttpUtils.getInstance().newCall(requestOk).execute();
            String jsonString = response.body().string();
            if (response.isSuccessful()) {
                return jsonString;
            }
        }
        catch (Exception e) {
            log.error("error:", (Throwable)e);
            return e.getMessage();
        }
        return "";
    }

    public String uploadFilePost(String url, String uploadDir, String baseFileUrl, String relativeUrl) {
        File temporaryFile = new File(baseFileUrl + relativeUrl);
        if (!temporaryFile.exists()) {
            return "";
        }
        MultipartBody requestBody = new MultipartBody.Builder().addFormDataPart("uploadDir", uploadDir).addFormDataPart("fileUrl", relativeUrl).addFormDataPart("file", temporaryFile.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)temporaryFile)).build();
        Request requestOk = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        try {
            Response response = OkHttpUtils.getInstance().newCall(requestOk).execute();
            String jsonString = response.body().string();
            if (response.isSuccessful()) {
                return jsonString;
            }
        }
        catch (Exception e) {
            log.error("error:", (Throwable)e);
        }
        return "";
    }

    public static OkHttpClient getSslHttpsClient() {
        OkHttpClient.Builder okhttpClient = new OkHttpClient().newBuilder();
        okhttpClient.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            okhttpClient.sslSocketFactory(sslContext.getSocketFactory());
        }
        catch (Exception e) {
            log.error("error:", (Throwable)e);
        }
        return okhttpClient.build();
    }
}

