/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.ecifapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.ecifapp.consts.EcifEorrorCode;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.EcifHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.request.core.QueryClaimDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.resp.Claim;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.resp.EcifClaimSearchResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.resp.core.EcifResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.resp.core.InsurePerInfo;
import com.jdaz.sinosoftgz.coreapi.ecif.CoreEcifClaimListApi;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ClaimListHandler
implements EcifHandler {
    @Value(value="${system.source}")
    private String systemSource;
    @Autowired
    private CoreEcifClaimListApi coreEcifClaimListApi;
    private static Logger log = LoggerFactory.getLogger(ClaimListHandler.class);

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        if (this.checkRequest(request)) {
            throw ApisDataCompletionException.builder().errorCode(EcifEorrorCode.NOT_NULL.getCode()).message(EcifEorrorCode.NOT_NULL.getMessage()).build();
        }
        return request;
    }

    public EcifResponse execute(StanderRequest request) throws ApisBusinessException {
        QueryClaimDTO queryClaimDTO = QueryClaimDTO.builder().systemSource(this.systemSource).custNo(request.getEcifClaimServiceRequest().getCustomerId()).policyNo(request.getEcifClaimServiceRequest().getPolicyNo()).registrationNo(request.getEcifClaimServiceRequest().getRegistrationNo()).build();
        EcifResponse ecifResponse = this.coreEcifClaimListApi.queryClaimList(queryClaimDTO);
        return ecifResponse;
    }

    public WebResponse beforeReturn(StanderRequest request, EcifResponse response) {
        List claimList = (List)response.getData();
        List<Object> claims = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)claimList) && claimList.size() > 0) {
            claims = claimList.stream().map(claimInfoVo -> Claim.builder().policyNo(claimInfoVo.getPolicyNo()).reportNo(claimInfoVo.getReportNo()).registrationNo(claimInfoVo.getRegistrationNo()).reportPhone(claimInfoVo.getReportPhone()).reportPerson(claimInfoVo.getReportPerson()).lossOccurDate(claimInfoVo.getLossOccurDate()).damageCode(null).riskAddress(claimInfoVo.getRiskAddress()).riskReason(claimInfoVo.getRiskReason()).reportDate(claimInfoVo.getReportDate()).reportChannel(claimInfoVo.getReportChannel()).linkerName(claimInfoVo.getLinkerName()).linkerPhone(claimInfoVo.getLinkerPhone()).reportLinkPerson(null).claimSts(claimInfoVo.getClaimSts()).claimAmt(claimInfoVo.getClaimAmt()).paySts(claimInfoVo.getPaySts()).claimsFinTime(claimInfoVo.getClaimsFinTime()).custSource(claimInfoVo.getCustSource()).insuredName(claimInfoVo.getInsurePerInfoList().size() == 0 ? null : ((InsurePerInfo)claimInfoVo.getInsurePerInfoList().get(0)).getInsureName()).mobileNo1(claimInfoVo.getInsurePerInfoList().size() == 0 ? null : ((InsurePerInfo)claimInfoVo.getInsurePerInfoList().get(0)).getMobile1()).mobileNo2(claimInfoVo.getInsurePerInfoList().size() == 0 ? null : ((InsurePerInfo)claimInfoVo.getInsurePerInfoList().get(0)).getMobile2()).build()).collect(Collectors.toList());
        }
        return WebResponse.builder().success(Boolean.valueOf(true)).code(response.getCode()).message(response.getMessage()).result((Serializable)EcifClaimSearchResponse.builder().claimList(claims).build()).businessKey(request.getHeader().getBusinessKey()).bussinessType(request.getHeader().getBussinessType()).build();
    }

    private boolean checkRequest(StanderRequest request) {
        return ObjectUtil.isEmpty((Object)request) || ObjectUtil.isEmpty((Object)request.getHeader()) || ObjectUtil.isEmpty((Object)request.getEcifClaimServiceRequest());
    }
}

