/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.ecifapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.ecifapp.consts.EcifEorrorCode;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.EcifHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.request.core.QueryCustomerDetailDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.resp.core.ClientDetailInfoVo;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.resp.core.EcifResponse;
import com.jdaz.sinosoftgz.coreapi.ecif.CoreEcifCustomerDetailApi;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomerDetailHandler
implements EcifHandler {
    @Value(value="${system.source}")
    private String systemSource;
    @Autowired
    private CoreEcifCustomerDetailApi coreEcifCustomerDetailApi;
    private static Logger log = LoggerFactory.getLogger(CustomerDetailHandler.class);

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        if (this.checkRequest(request)) {
            throw ApisDataCompletionException.builder().errorCode(EcifEorrorCode.NOT_NULL.getCode()).message(EcifEorrorCode.NOT_NULL.getMessage()).build();
        }
        return request;
    }

    public EcifResponse execute(StanderRequest request) throws ApisBusinessException {
        QueryCustomerDetailDTO queryCustomerDetailDTO = QueryCustomerDetailDTO.builder().systemSource(this.systemSource).custNo(request.getEcifCustomerDetailServiceRequest().getCustomerId()).insuredName(request.getEcifCustomerDetailServiceRequest().getInsuredName()).identifyNumber(request.getEcifCustomerDetailServiceRequest().getIdentifyNumber()).identifyType(request.getEcifCustomerDetailServiceRequest().getIdentifyType()).licensePlate(request.getEcifCustomerDetailServiceRequest().getLicensePlate()).vinNo(request.getEcifCustomerDetailServiceRequest().getVinNo()).engineNo(request.getEcifCustomerDetailServiceRequest().getEngineNo()).build();
        EcifResponse ecifResponse = this.coreEcifCustomerDetailApi.queryCustomerDetail(queryCustomerDetailDTO);
        return ecifResponse;
    }

    public WebResponse beforeReturn(StanderRequest request, EcifResponse response) {
        List clientDetailInfoVoList = (List)response.getData();
        ClientDetailInfoVo clientDetailInfoVo = null;
        if (ObjectUtil.isNotEmpty((Object)clientDetailInfoVoList) && clientDetailInfoVoList.size() > 0) {
            clientDetailInfoVo = (ClientDetailInfoVo)clientDetailInfoVoList.get(0);
        }
        return WebResponse.builder().success(Boolean.valueOf(true)).code(response.getCode()).message(response.getMessage()).result((Serializable)clientDetailInfoVo).businessKey(request.getHeader().getBusinessKey()).bussinessType(request.getHeader().getBussinessType()).build();
    }

    private boolean checkRequest(StanderRequest request) {
        return ObjectUtil.isEmpty((Object)request) || ObjectUtil.isEmpty((Object)request.getHeader()) || ObjectUtil.isEmpty((Object)request.getEcifCustomerDetailServiceRequest());
    }
}

