/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.ecifapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.ecifapp.consts.EcifEorrorCode;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.EcifHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.request.EcifCustomerListServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.request.core.QueryCustomerListDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.resp.Customer;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.resp.EcifCustomerSearchListResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.resp.core.EcifResponse;
import com.jdaz.sinosoftgz.coreapi.ecif.CoreEcifCustomerListApi;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomerListHandler
implements EcifHandler {
    @Value(value="${system.source}")
    private String systemSource;
    @Autowired
    private CoreEcifCustomerListApi coreEcifCustomerListApi;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        if (this.checkRequest(request)) {
            throw ApisDataCompletionException.builder().errorCode(EcifEorrorCode.NOT_NULL.getCode()).message(EcifEorrorCode.NOT_NULL.getMessage()).build();
        }
        return request;
    }

    public EcifResponse execute(StanderRequest request) throws ApisBusinessException {
        QueryCustomerListDTO queryCustomerListDTO = new QueryCustomerListDTO();
        EcifCustomerListServiceRequest ecifCustomerListServiceRequest = request.getEcifCustomerListServiceRequest();
        queryCustomerListDTO.setSystemSource(this.systemSource);
        queryCustomerListDTO.setInsuredName(ecifCustomerListServiceRequest.getNameZhs());
        queryCustomerListDTO.setSex(ecifCustomerListServiceRequest.getGender());
        queryCustomerListDTO.setPhone1(ecifCustomerListServiceRequest.getMobileNo());
        queryCustomerListDTO.setPhone2(ecifCustomerListServiceRequest.getPhoneNumber());
        queryCustomerListDTO.setPolicyNo(ecifCustomerListServiceRequest.getPolicyRef());
        queryCustomerListDTO.setCardtNo(ecifCustomerListServiceRequest.getCardNo());
        queryCustomerListDTO.setPassPortNo(ecifCustomerListServiceRequest.getPassport());
        queryCustomerListDTO.setOtherNo(ecifCustomerListServiceRequest.getOtherCardNo());
        queryCustomerListDTO.setLicensePlate(ecifCustomerListServiceRequest.getLicenseNo());
        queryCustomerListDTO.setPageNum(0);
        queryCustomerListDTO.setPageSize(10);
        EcifResponse ecifResponse = this.coreEcifCustomerListApi.queryCustomerList(queryCustomerListDTO);
        return ecifResponse;
    }

    public WebResponse beforeReturn(StanderRequest request, EcifResponse response) {
        List clientInfoVoList = (List)response.getData();
        List<Object> customerList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)clientInfoVoList) && clientInfoVoList.size() > 0) {
            customerList = clientInfoVoList.stream().map(clientInfoVo -> new Customer(clientInfoVo.getCustNo(), clientInfoVo.getInsuredName(), clientInfoVo.getCustomerId(), clientInfoVo.getSex(), clientInfoVo.getCardtNo(), clientInfoVo.getOtherNo(), clientInfoVo.getMobile(), clientInfoVo.getLinkerPhone(), clientInfoVo.getWechatNo(), clientInfoVo.getPassPortNo(), clientInfoVo.getLinkerAddress(), null, clientInfoVo.getLinkerName(), clientInfoVo.getCountry(), clientInfoVo.getNation(), clientInfoVo.getBirthday())).collect(Collectors.toList());
        }
        EcifCustomerSearchListResponse ecifCustomerSearchListResponse = EcifCustomerSearchListResponse.builder().customerList(customerList).build();
        return WebResponse.builder().success(Boolean.valueOf(true)).code(response.getCode()).message(response.getMessage()).result((Serializable)ecifCustomerSearchListResponse).businessKey(request.getHeader().getBusinessKey()).bussinessType(request.getHeader().getBussinessType()).build();
    }

    private boolean checkRequest(StanderRequest request) {
        return ObjectUtil.isEmpty((Object)request) || ObjectUtil.isEmpty((Object)request.getHeader()) || ObjectUtil.isEmpty((Object)request.getEcifCustomerListServiceRequest());
    }
}

