/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.ecifapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.ecifapp.consts.EcifEorrorCode;
import com.jdaz.sinosoftgz.apis.business.app.ecifapp.service.QueryCifService;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.EcifHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.request.core.QueryPolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.resp.EcifPolicySearchResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.resp.core.EcifResponse;
import com.jdaz.sinosoftgz.coreapi.ecif.CoreEcifPolicyListApi;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PolicyListHandler
implements EcifHandler {
    @Value(value="${system.source}")
    private String systemSource;
    @Autowired
    private CoreEcifPolicyListApi coreEcifPolicyListApi;
    @Autowired
    private QueryCifService queryCifService;
    private static Logger log = LoggerFactory.getLogger(PolicyListHandler.class);
    public static Map<String, String> polciyStatusMap = new /* Unavailable Anonymous Inner Class!! */;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        if (this.checkRequest(request)) {
            throw ApisDataCompletionException.builder().errorCode(EcifEorrorCode.NOT_NULL.getCode()).message(EcifEorrorCode.NOT_NULL.getMessage()).build();
        }
        return request;
    }

    public EcifResponse execute(StanderRequest request) throws ApisBusinessException {
        QueryPolicyDTO queryPolicyDTO = QueryPolicyDTO.builder().systemSource(this.systemSource).policyNo(request.getEcifCustomerPolicyServiceRequest().getPolicyRef()).custTpy(request.getEcifCustomerPolicyServiceRequest().getCustomerType()).insuredName(request.getEcifCustomerPolicyServiceRequest().getInsuredName()).custNo(request.getEcifCustomerPolicyServiceRequest().getCustomerId()).build();
        EcifResponse ecifResponse = this.coreEcifPolicyListApi.queryPolicyList(queryPolicyDTO);
        return ecifResponse;
    }

    public WebResponse beforeReturn(StanderRequest request, EcifResponse response) {
        List cifQuery = new ArrayList();
        try {
            if (StringUtils.isNotEmpty((CharSequence)request.getEcifCustomerPolicyServiceRequest().getCustomerId()) && request.getEcifCustomerPolicyServiceRequest().getCustomerId().matches("[0-9]+")) {
                log.warn("\u5ba2\u6237id\u4e3a\u6570\u5b57\u7c7b\u578b\uff1a{},\u67e5\u8be2cif\u8f66\u9669\u6570\u636e", (Object)request.getEcifCustomerPolicyServiceRequest().getCustomerId());
                cifQuery = this.queryCifService.getCif(request.getEcifCustomerPolicyServiceRequest().getCustomerId());
                if (ObjectUtil.isNotEmpty(cifQuery) && cifQuery.size() > 0) {
                    for (EcifPolicySearchResponse ecifPolicySearchResponse : cifQuery) {
                        ecifPolicySearchResponse.setCustSource("3");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("ecif\u67e5\u8be2\u65e7\u5ba2\u6237\u53f7\u5931\u8d25", (Throwable)e);
        }
        List<Object> ecifPolicySearchResponses = new ArrayList();
        List policyInfoVoList = (List)response.getData();
        if (ObjectUtil.isNotEmpty((Object)policyInfoVoList)) {
            ecifPolicySearchResponses = policyInfoVoList.stream().map(policyInfoVo -> {
                String policyStatus = policyInfoVo.getPolicySts();
                if (StringUtils.isNotEmpty((CharSequence)policyStatus)) {
                    Date nowDate = new Date();
                    if (null != policyInfoVo.getPolicyStartDate()) {
                        if (policyInfoVo.getPolicyStartDate().after(nowDate)) {
                            policyStatus = (String)polciyStatusMap.get("01");
                        } else if (policyInfoVo.getPolicyEndDate().before(nowDate)) {
                            policyStatus = (String)polciyStatusMap.get("4");
                        } else if (policyInfoVo.getPolicyStartDate().before(nowDate) && policyInfoVo.getPolicyEndDate().after(nowDate)) {
                            policyStatus = (String)polciyStatusMap.get("1");
                        }
                    }
                } else {
                    policyStatus = (String)polciyStatusMap.get("02");
                }
                return EcifPolicySearchResponse.builder().policyNo(policyInfoVo.getPolicyNo()).policySts(policyStatus).policyStartDate(policyInfoVo.getPolicyStartDate()).policyEndDate(policyInfoVo.getPolicyEndDate()).insuredName(policyInfoVo.getInsuredName()).productLine(policyInfoVo.getRiskCode()).productName(policyInfoVo.getRiskName()).appName(policyInfoVo.getAppName()).sumPremiums(policyInfoVo.getSumPremiums()).policyGenerationDate(policyInfoVo.getPolicyGenerationDate()).contractId(policyInfoVo.getContractId()).identifyNumber(policyInfoVo.getIdentifyNumber()).identifyType(policyInfoVo.getIdentifyType()).blnChn(policyInfoVo.getBlnChn()).custSource(policyInfoVo.getCustSource()).build();
            }).collect(Collectors.toList());
        }
        ecifPolicySearchResponses.addAll(cifQuery);
        return WebResponse.builder().success(Boolean.valueOf(true)).code(response.getCode()).message(response.getMessage()).result(ecifPolicySearchResponses instanceof Serializable ? (Serializable)((Object)ecifPolicySearchResponses) : null).businessKey(request.getHeader().getBusinessKey()).bussinessType(request.getHeader().getBussinessType()).build();
    }

    private boolean checkRequest(StanderRequest request) {
        return ObjectUtil.isEmpty((Object)request) || ObjectUtil.isEmpty((Object)request.getHeader()) || ObjectUtil.isEmpty((Object)request.getEcifCustomerPolicyServiceRequest());
    }
}

