/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.coreapi.insure.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CalculateObjectDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ClaimStatusDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ClaimStatusResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CompanyInfoAuditRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.JdUserVerify.JdUserVerifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.JdUserVerify.JdUserVerifyResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PayPlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PayerInfoChangeFccbRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ReceiveNoticeRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RenewalShortLikeServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.UnderWriteQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.UnderwritingQuestion;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.UwInfoQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.BaseResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PaymentAccountQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PolicyRefundConfirmQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PolicyRefundQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PremiumPayStatusQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.policyActivate.PaymentInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.policyActivate.PolicyActivateRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.policyActivate.PolicyActivateServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.policyActivate.PolicyPaymentNotifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.policyActivate.PolicyPaymentNotifyResultRequestParams;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.AssembleCalculateObjectDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.BasicsPolicyModifyResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.BasicsPolicyQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CalculateResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CalculateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.DeclarationVoucherResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvListQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredPremiumDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PayerInfoChangeResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyNoGetResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicySubmitResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PrintQueryImgURLResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QueryVoucherServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.RechargePoaResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.RechargePoaVoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.RenewalShortLikeResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponsePP;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResultDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.UnderWriteQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.UwData;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.UwInfoQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.UwQuestionDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.UwResultFinalDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.payment.PaymentAccountQueryResponseVo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.payment.RefundConfirmQueryResponseVo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.payment.RefundQueryResponseVo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.payment.ResponseVo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.policyActivate.ConfirmFeeResponseDto;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.policyActivate.PolicyActivateResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.policyActivate.PolicyActivateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.policyActivate.PolicyConfirmResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.policyActivate.PolicyConfirmResultBodyDto;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.policyActivate.PolicyPaymentNotifyResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.CommissionQueryDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.PayNotifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.resp.AgentQueryResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.resp.PayNotifyResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.DockRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.response.ChannelDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelInstallmentOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiReqmsgLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelInstallmentOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiReqmsgLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationClauseKindFactory;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationPaymentPlan;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationClauseKindFactoryMapper;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationMainMapper;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationPaymentPlanMapper;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfsEpolicyFactorRateMapper;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoreInsureApiImpl
implements CoreInsureApi {
    private static Logger log = LoggerFactory.getLogger(CoreInsureApiImpl.class);
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    ApisPfpRationMainMapper apisPfpRationMainMapper;
    @Autowired
    ApisPfpRationClauseKindFactoryMapper apisPfpRationClauseKindFactoryMapper;
    @Autowired
    ApisBusiChannelOrderMapper apisBusiChannelOrderMapper;
    @Autowired
    ApisPfsEpolicyFactorRateMapper apisPfsEpolicyFactorRateMapper;
    @Autowired
    ApisBusiReqmsgLogMapper apisBusiReqmsgLogMapper;
    @Autowired
    private ApisBusiChannelInstallmentOrderMapper apisBusiChannelInstallmentOrderMapper;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    private ApisPfpRationPaymentPlanMapper apisPfpRationPaymentPlanMapper;
    public static final String[] NOT_SUM_ASSURED_RANGE = new String[]{"ZR-SSBQ-TJFY-XY-2C"};

    @Override
    public StanderResponse quotePrice(StanderRequest request) {
        PolicyListQueryResponse policyListQueryResponse = (PolicyListQueryResponse)this.httpRequestService.convertAndSend("quotePrice", "quotePrice", (Object)request.getQuotePriceServiceRequest(), PolicyListQueryResponse.class);
        return StanderResponse.builder().header(request.getHeader()).policyListQueryResponse(policyListQueryResponse).build();
    }

    @Override
    public StanderResponse quotePriceForGroup(StanderRequest request) {
        PolicyListQueryResponse policyListQueryResponse = (PolicyListQueryResponse)this.httpRequestService.convertAndSend("quotePriceForGroup", "quotePriceForGroup", (Object)request.getQuotePriceServiceRequest(), PolicyListQueryResponse.class);
        return StanderResponse.builder().header(request.getHeader()).policyListQueryResponse(policyListQueryResponse).build();
    }

    @Override
    public StanderResponse policyList(StanderRequest request) {
        PolicyListQueryResponse policyListQueryResponse = (PolicyListQueryResponse)this.httpRequestService.convertAndSend("policyList", "PolicyListQueryService", (Object)request.getPolicyListServiceRequest(), PolicyListQueryResponse.class);
        return StanderResponse.builder().header(request.getHeader()).policyListQueryResponse(policyListQueryResponse).build();
    }

    @Override
    public StanderResponse policyDetail(StanderRequest request) {
        PolicyDetailResponse policyDetailResponse = (PolicyDetailResponse)this.httpRequestService.convertAndSend("policyDetail", "PolicyInquiryService", (Object)request.getPolicyDetailServiceRequest(), PolicyDetailResponse.class);
        return StanderResponse.builder().header(request.getHeader()).policyDetailResponse(policyDetailResponse).build();
    }

    @Override
    public StanderResponse policyNoGet(StanderRequest request) {
        PolicyNoGetResponse policyNoGetResponse = (PolicyNoGetResponse)this.httpRequestService.convertAndSend("policyNoGet", "policyNoGet", (Object)request.getPolicyNoGetRequest(), PolicyNoGetResponse.class);
        return StanderResponse.builder().header(request.getHeader()).policyNoGetResponse(policyNoGetResponse).build();
    }

    @Override
    public StanderResponse policySubmit(StanderRequest request) {
        PolicySubmitResponse policySubmitResponse = (PolicySubmitResponse)this.httpRequestService.convertAndSend("policyConfirm", "policyConfirm", (Object)request.getPolicySubmitRequest(), PolicySubmitResponse.class);
        return StanderResponse.builder().header(request.getHeader()).policySubmitResponse(policySubmitResponse).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StanderResponse policyCalculate(List<CalculateObjectDTO> list) {
        TimeInterval timer = DateUtil.timer();
        Date startDate = new Date();
        HashMap<String, Object> premiumMap = new HashMap<String, Object>();
        HashMap<String, Object> rateMap = new HashMap<String, Object>();
        ArrayList<InsuredPremiumDTO> insuredList = new ArrayList<InsuredPremiumDTO>();
        CalculateObjectDTO calculateObjectDTO = null;
        boolean premiumFlag = true;
        boolean rateFlag = true;
        boolean errorFlag = true;
        String methodType = "";
        BigDecimal premium = null;
        BigDecimal rate = null;
        BigDecimal totalPremium = new BigDecimal("0");
        for (int i = 0; i < list.size(); ++i) {
            calculateObjectDTO = list.get(i);
            methodType = calculateObjectDTO.getCalMethod();
            try {
                premiumMap.put("ration_code", calculateObjectDTO.getPlanCode());
                premiumMap.put("gd_insured_type", calculateObjectDTO.getInsuredType());
                premiumMap.put("gd_day", calculateObjectDTO.getDay());
                premiumMap.put("gd_tran_soprt_type", calculateObjectDTO.getGdTranSoprtType());
                premiumMap.put("gd_is_xiz", calculateObjectDTO.getIsXiz());
                premiumMap.put("gd_single_limit", calculateObjectDTO.getGdSingleLimit());
                premiumMap.put("gd_lj_limit", calculateObjectDTO.getGdLjLimit());
                premiumMap.put("gd_item_type", calculateObjectDTO.getGdItemType());
                premiumMap.put("gd_sex", calculateObjectDTO.getSex());
                if (StringUtils.isNotEmpty((CharSequence)calculateObjectDTO.getGdIsInsuranceFlag())) {
                    if ("1".equals(calculateObjectDTO.getGdIsInsuranceFlag())) {
                        calculateObjectDTO.setGdIsInsuranceFlag("Y");
                    } else {
                        calculateObjectDTO.setGdIsInsuranceFlag("N");
                    }
                }
                premiumMap.put("gd_is_insurance_flag", calculateObjectDTO.getGdIsInsuranceFlag());
                premiumMap.put("gd_Population", calculateObjectDTO.getPhdTotal());
                premium = this.apisPfpRationClauseKindFactoryMapper.queryPremium(premiumMap);
                premiumFlag = ObjectUtil.isNotNull((Object)premium);
            }
            catch (Exception e) {
                premium = null;
                log.error("\n\u4fdd\u8d39\u8ba1\u7b97\uff1a\u83b7\u53d6\u57fa\u7840\u4fdd\u8d39\u62a5\u5f02\u5e38 apis_pfp_ration_clause_kind_factory\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)((Object)premiumMap).toString(), (Object)e);
            }
            finally {
                premiumFlag = ObjectUtil.isNotNull(premium);
            }
            log.warn("\u4fdd\u8d39\u8ba1\u7b97-\u57fa\u7840\u4fdd\u8d39\u83b7\u53d6\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
            if (methodType.equals("6") || methodType.equals("7")) {
                rateMap.put("ration_code", calculateObjectDTO.getPlanCode());
                rateMap.put("number", calculateObjectDTO.getNumber());
                try {
                    rate = this.apisPfsEpolicyFactorRateMapper.queryRate(rateMap);
                }
                catch (Exception e) {
                    try {
                        rate = null;
                        log.error("\n\u4fdd\u8d39\u8ba1\u7b97\uff1a\u83b7\u53d6\u77ed\u671f\u8d39\u7387\u62a5\u5f02\u5e38 \u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)((Object)premiumMap).toString(), (Object)e);
                    }
                    catch (Throwable throwable) {
                        rateFlag = ObjectUtil.isNotNull(rate);
                        throw throwable;
                    }
                    rateFlag = ObjectUtil.isNotNull((Object)rate);
                }
                rateFlag = ObjectUtil.isNotNull((Object)rate);
            }
            log.warn("\u4fdd\u8d39\u8ba1\u7b97-\u8d39\u7387\u914d\u7f6e\u83b7\u53d6\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
            BigDecimal singlePremium = new BigDecimal("0");
            if (premiumFlag && rateFlag) {
                BigDecimal basePrem;
                if (methodType.equals("2")) {
                    basePrem = new BigDecimal(premium.toString());
                    BigDecimal day = new BigDecimal(calculateObjectDTO.getUwDays() != null ? calculateObjectDTO.getUwDays().toString() : "0");
                    singlePremium = basePrem.multiply(day).setScale(2, 4);
                } else if (methodType.equals("3")) {
                    basePrem = new BigDecimal(premium.toString());
                    BigDecimal month = new BigDecimal(calculateObjectDTO.getMonth() != null ? calculateObjectDTO.getMonth().toString() : "0");
                    singlePremium = basePrem.multiply(month).setScale(2, 4);
                } else if (methodType.equals("5")) {
                    basePrem = new BigDecimal(premium.toString());
                    BigDecimal yearDays = new BigDecimal(calculateObjectDTO.getYearDays());
                    BigDecimal day = new BigDecimal(calculateObjectDTO.getUwDays() != null ? calculateObjectDTO.getUwDays().toString() : "0");
                    BigDecimal proportion = day.divide(yearDays, 10, 4);
                    singlePremium = basePrem.multiply(proportion).setScale(2, 4);
                } else if (methodType.equals("6") || methodType.equals("7")) {
                    basePrem = new BigDecimal(premium.toString());
                    BigDecimal factorRate = new BigDecimal(rate.toString());
                    BigDecimal compare = new BigDecimal("0.01");
                    singlePremium = basePrem.multiply(factorRate);
                    singlePremium = singlePremium.compareTo(compare) == -1 ? compare : singlePremium.setScale(2, 4);
                } else if (methodType.equals("11") || methodType.equals("12")) {
                    basePrem = new BigDecimal(premium.toString());
                    BigDecimal phdTotal = new BigDecimal(calculateObjectDTO.getPhdTotal() != null ? calculateObjectDTO.getPhdTotal().toString() : "0");
                    BigDecimal[] singlePremiumArray = basePrem.divideAndRemainder(phdTotal);
                    singlePremium = i == list.size() - 1 && null != singlePremiumArray && singlePremiumArray.length == 2 ? singlePremiumArray[0].add(singlePremiumArray[1]) : basePrem.divideAndRemainder(phdTotal)[0];
                } else {
                    singlePremium = new BigDecimal(premium.toString()).setScale(2, 4);
                }
            } else {
                errorFlag = false;
                log.error("\n\u4fdd\u8d39\u8ba1\u7b97\uff1a\u83b7\u53d6\u57fa\u7840\u4fdd\u8d39\u62a5\u5f02\u5e38 \u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)((Object)premiumMap).toString());
            }
            totalPremium = totalPremium.add(singlePremium);
            if (methodType.equals("8") || methodType.equals("96")) continue;
            InsuredPremiumDTO insuredPremium = InsuredPremiumDTO.builder().build();
            insuredPremium.setSerialNo(calculateObjectDTO.getInsuredIDCache());
            insuredPremium.setPremium(Double.valueOf(singlePremium.doubleValue()));
            insuredPremium.setInsuredType(calculateObjectDTO.getInsuredType());
            insuredPremium.setInsuredName(calculateObjectDTO.getInsuredName());
            insuredPremium.setGoodCode(calculateObjectDTO.getPlanCode());
            insuredList.add(insuredPremium);
        }
        AssembleCalculateObjectDTO assembleCalculate = AssembleCalculateObjectDTO.builder().build();
        assembleCalculate.setAgencyPolicyRef(calculateObjectDTO.getAgencyPolicyRef());
        assembleCalculate.setConsumerSeqNo(calculateObjectDTO.getConsumerSeqNo());
        assembleCalculate.setStatus(Boolean.valueOf(errorFlag));
        assembleCalculate.setCompanyInfo(calculateObjectDTO.getCompanyInfo());
        assembleCalculate.setInsuredPremiumList(insuredList);
        assembleCalculate.setTotalPremium(Double.valueOf(totalPremium.setScale(2, 4).doubleValue()));
        log.warn("\u4fdd\u8d39\u8ba1\u7b97-\u8ba1\u7b97\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
        return this.installCalculateObj(assembleCalculate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StanderResponse policyCalculateByLawsuit(StanderRequest request, List<CalculateObjectDTO> list) {
        HashMap<String, Object> premiumMap = new HashMap<String, Object>();
        String errorCode = "";
        String errorMessage = "";
        Boolean rateFlag = true;
        BigDecimal totalPremium = new BigDecimal("0");
        ApisPfpRationClauseKindFactory apisPfpRationClauseKindFactory = null;
        for (int i = 0; i < list.size(); ++i) {
            CalculateObjectDTO calculateObjectDTO = list.get(i);
            if (null != calculateObjectDTO.getAnnualPremium() && null != calculateObjectDTO.getAmount() && calculateObjectDTO.getAmount().compareTo(BigDecimal.ZERO) == 1) {
                if (!calculateObjectDTO.isLawsuitPremiumConfigFlag()) {
                    calculateObjectDTO.setGdAmountRate(calculateObjectDTO.getAnnualPremium().divide(calculateObjectDTO.getAmount(), 10, 4));
                }
            } else {
                rateFlag = false;
                log.error("\n\u8bc9\u8bbc\u9669\u4fdd\u8d39\u6216\u4fdd\u989d\u6709\u8bef\uff1a{}", (Object)calculateObjectDTO.toString());
                break;
            }
            ApisPfpRationMain apisPfpRationMain = this.apisPfpRationMainMapper.getApisPfpRationMainByPlanCode(calculateObjectDTO.getPlanCode());
            if ("06".equals(apisPfpRationMain.getClassCode())) {
                totalPremium = totalPremium.add(calculateObjectDTO.getAnnualPremium());
                continue;
            }
            try {
                if (Arrays.asList(NOT_SUM_ASSURED_RANGE).contains(calculateObjectDTO.getPlanCode())) {
                    premiumMap.put("ration_code", calculateObjectDTO.getPlanCode());
                    premiumMap.put("ration_id", ObjectUtil.isNotEmpty((Object)apisPfpRationMain) ? apisPfpRationMain.getId() : "");
                    premiumMap.put("ration_version", ObjectUtil.isNotEmpty((Object)apisPfpRationMain) ? apisPfpRationMain.getRationVersion() : "");
                    premiumMap.put("gd_premium_config", calculateObjectDTO.getCalMethod());
                    apisPfpRationClauseKindFactory = this.apisPfpRationClauseKindFactoryMapper.queryRateRangeByLawsuit(premiumMap);
                    if (ObjectUtil.isEmpty((Object)apisPfpRationClauseKindFactory) || ObjectUtil.isNotEmpty((Object)apisPfpRationClauseKindFactory.getGdMinAmountRate()) || ObjectUtil.isNotEmpty((Object)apisPfpRationClauseKindFactory.getGdMaxAmountRate())) {
                        errorCode = ChannelErrorCodeEnum.ERR_C10667.getKey();
                        errorMessage = ChannelErrorCodeEnum.ERR_C10667.getValue();
                    }
                    BigDecimal baseRate = this.getDisCount(apisPfpRationClauseKindFactory.getGdMinAmountRate(), apisPfpRationClauseKindFactory.getGdMaxAmountRate(), calculateObjectDTO.getGdAmountRate());
                    for (ItemKindDTO itk : ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getItemKind()) {
                        itk.setDisCount(Double.valueOf(calculateObjectDTO.getGdAmountRate().divide(baseRate, 2, 4).doubleValue()));
                    }
                    calculateObjectDTO.setGdAmountRate(baseRate);
                } else {
                    premiumMap.put("ration_code", calculateObjectDTO.getPlanCode());
                    premiumMap.put("ration_id", ObjectUtil.isNotEmpty((Object)apisPfpRationMain) ? apisPfpRationMain.getId() : "");
                    premiumMap.put("ration_version", ObjectUtil.isNotEmpty((Object)apisPfpRationMain) ? apisPfpRationMain.getRationVersion() : "");
                    premiumMap.put("gd_premium_config", calculateObjectDTO.getCalMethod());
                    premiumMap.put("gd_amount_rate", calculateObjectDTO.getGdAmountRate());
                    apisPfpRationClauseKindFactory = this.apisPfpRationClauseKindFactoryMapper.queryAountByLawsuit(premiumMap);
                    if (ObjectUtil.isEmpty((Object)apisPfpRationClauseKindFactory)) {
                        errorCode = ChannelErrorCodeEnum.ERR_C10475.getKey();
                        errorMessage = ChannelErrorCodeEnum.ERR_C10475.getValue().replaceFirst("##", calculateObjectDTO.getGdAmountRate().toString()).replaceFirst("##", calculateObjectDTO.getPlanCode());
                    }
                }
                rateFlag = ObjectUtil.isNotNull((Object)apisPfpRationClauseKindFactory);
                if (!rateFlag.booleanValue()) continue;
                totalPremium = totalPremium.add(calculateObjectDTO.getAnnualPremium());
                continue;
            }
            catch (Exception e) {
                apisPfpRationClauseKindFactory = null;
                log.error("\n\u4fdd\u8d39\u8ba1\u7b97\uff1a\u83b7\u53d6\u57fa\u7840\u4fdd\u8d39\u62a5\u5f02\u5e38 apis_pfp_ration_clause_kind_factory\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)((Object)premiumMap).toString(), (Object)e);
                continue;
            }
            finally {
                rateFlag = ObjectUtil.isNotNull(apisPfpRationClauseKindFactory);
                if (rateFlag.booleanValue()) {
                    totalPremium = totalPremium.add(calculateObjectDTO.getAnnualPremium());
                }
            }
        }
        AssembleCalculateObjectDTO assembleCalculate = AssembleCalculateObjectDTO.builder().build();
        assembleCalculate.setStatus(rateFlag);
        assembleCalculate.setTotalPremium(Double.valueOf(totalPremium.setScale(2, 4).doubleValue()));
        assembleCalculate.setErrorCode(errorCode);
        assembleCalculate.setErrorMessage(errorMessage);
        return this.installCalculateObj(assembleCalculate);
    }

    @Override
    public StanderResponse policyCalculateByHy(StanderRequest request, List<CalculateObjectDTO> list) {
        String errorCode = "";
        String errorMessage = "";
        Boolean rateFlag = true;
        BigDecimal totalPremium = new BigDecimal("0");
        for (int i = 0; i < list.size(); ++i) {
            CalculateObjectDTO calculateObjectDTO = list.get(i);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"code", (Object)"FIXED_PREMIUM");
            queryWrapper.eq((Object)"channel_value", (Object)calculateObjectDTO.getPlanCode());
            ApisChannelCode apisChannelCode = (ApisChannelCode)this.apisChannelCodeService.getOne((Wrapper)queryWrapper);
            BigDecimal rate = BigDecimal.valueOf(Double.valueOf(apisChannelCode.getValue()));
            totalPremium = totalPremium.add(calculateObjectDTO.getAmount().multiply(rate).divide(new BigDecimal(100)));
        }
        AssembleCalculateObjectDTO assembleCalculate = AssembleCalculateObjectDTO.builder().build();
        assembleCalculate.setStatus(rateFlag);
        assembleCalculate.setTotalPremium(Double.valueOf(totalPremium.setScale(2, 4).doubleValue()));
        assembleCalculate.setErrorCode(errorCode);
        assembleCalculate.setErrorMessage(errorMessage);
        return this.installCalculateObj(assembleCalculate);
    }

    private BigDecimal getDisCount(BigDecimal min, BigDecimal max, BigDecimal value) {
        if (value.compareTo(max) == 1) {
            return max;
        }
        if (value.compareTo(min) == -1) {
            return min;
        }
        return value;
    }

    private StanderResponse installCalculateObj(AssembleCalculateObjectDTO assembleCalculate) {
        long start = System.currentTimeMillis();
        StanderResponse standerResponse = StanderResponse.builder().build();
        StanderHeader standerHeader = StanderHeader.builder().build();
        CalculateResponse calculateResponse = CalculateResponse.builder().build();
        ResponseHeadDTO responseHead = ResponseHeadDTO.builder().build();
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        responseHead.setProviderSeqNo(uuid);
        responseHead.setConsumerSeqNo(assembleCalculate.getConsumerSeqNo());
        responseHead.setStatus(assembleCalculate.getStatus() != false ? 1 : 0);
        if (!assembleCalculate.getStatus().booleanValue()) {
            responseHead.setAppCode(ObjectUtil.isNotEmpty((Object)assembleCalculate.getErrorCode()) ? assembleCalculate.getErrorCode() : ChannelErrorCodeEnum.ERR_C10317.getKey());
            responseHead.setAppMessage(ObjectUtil.isNotEmpty((Object)assembleCalculate.getErrorMessage()) ? assembleCalculate.getErrorMessage() : ChannelErrorCodeEnum.ERR_C10317.getValue());
        }
        CalculateResponseDTO calculateResponseDTO = CalculateResponseDTO.builder().build();
        calculateResponseDTO.setAgencyPolicyRef(assembleCalculate.getAgencyPolicyRef());
        calculateResponseDTO.setInsuredPremiumList(assembleCalculate.getInsuredPremiumList());
        calculateResponseDTO.setTotalPremium(Double.valueOf(new BigDecimal(assembleCalculate.getTotalPremium()).setScale(2, 4).doubleValue()));
        calculateResponseDTO.setCompanyInfo(assembleCalculate.getCompanyInfo());
        calculateResponse.setResponseHead(responseHead);
        calculateResponse.setResponseBody(calculateResponseDTO);
        standerResponse.setHeader(standerHeader);
        standerResponse.setCalculateResponse(calculateResponse);
        log.warn("\u4fdd\u8d39\u8ba1\u7b97-\u8fd4\u56de\u4f53\u7ec4\u88c5\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return standerResponse;
    }

    @Override
    public StanderResponse policyActivate(StanderRequest request) {
        StanderResponse resp = null;
        String businessNo = request.getPolicyActivateServiceRequest().getRequestBody().getBusinessNo();
        log.warn("\u4fdd\u5355\u6fc0\u6d3b\uff0cbusinessNo:{}", (Object)businessNo);
        resp = this.policyConfirm(request);
        return resp;
    }

    public StanderResponse policyConfirm(StanderRequest request) {
        PolicyActivateResponse policyActivateResponse = PolicyActivateResponse.builder().build();
        PolicySubmitRequest policySubmitRequest = this.policyActivateRequestBeforeProcess(request);
        policySubmitRequest = this.compensatePolicyConfirmParams(policySubmitRequest);
        PolicyConfirmResult result = (PolicyConfirmResult)this.httpRequestService.convertAndSend("policyConfirm", "policyConfirmService", (Object)policySubmitRequest, PolicyConfirmResult.class);
        policyActivateResponse = this.resultProcessPolicyConfirm(policySubmitRequest, policyActivateResponse, result);
        if (ObjectUtil.isNotEmpty((Object)result) && 1 == result.getResponseHead().getStatus()) {
            policyActivateResponse.getResponseBody().setPolicyStatus("70");
        }
        return StanderResponse.builder().header(request.getHeader()).policyActivateResponse(policyActivateResponse).build();
    }

    private PolicySubmitRequest compensatePolicyConfirmParams(PolicySubmitRequest policySubmitRequest) {
        policySubmitRequest.getRequestBody().setBusinessType("P");
        return policySubmitRequest;
    }

    private PolicyActivateResponse resultProcessPolicyConfirm(PolicySubmitRequest policySubmitRequest, PolicyActivateResponse policyActivateResponse, PolicyConfirmResult result) {
        PolicySubmitRequestDTO policySubmitRequestDTO = policySubmitRequest.getRequestBody();
        policyActivateResponse.setResponseHead(result.getResponseHead());
        PolicyActivateResponseDTO responseBody = PolicyActivateResponseDTO.builder().build();
        if (!BeanUtil.isEmpty((Object)result.getResponseBody(), (String[])new String[0])) {
            PolicyConfirmResultBodyDto policyConfirmResultBodyDto = result.getResponseBody();
            responseBody.setBusinessNo(policySubmitRequestDTO.getPreBusinessNo());
            responseBody.setUnderwriteFlag(policyConfirmResultBodyDto.getUnderwriteFlag());
            responseBody.setPremium(policySubmitRequestDTO.getPaymentInfo().getPremium());
            String proposalNo = policySubmitRequestDTO.getBusinessNo();
            QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
            apisBusiChannelOrderQueryWrapper.eq((Object)"proposal_no", (Object)proposalNo);
            ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusiChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
            responseBody.setTotalPremium(order.getPremium());
        }
        policyActivateResponse.setResponseBody(responseBody);
        return policyActivateResponse;
    }

    public String policyPaymentNotify(String proposalNo) {
        PolicyPaymentNotifyRequest policyPaymentNotifyRequest = PolicyPaymentNotifyRequest.builder().build();
        policyPaymentNotifyRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        policyPaymentNotifyRequest.setRequestBody(PolicyPaymentNotifyResultRequestParams.builder().businessNo(proposalNo).businessType("1").build());
        PolicyPaymentNotifyResult result = (PolicyPaymentNotifyResult)this.httpRequestService.convertAndSend("policyPaymentNotify", "policyPaymentNotify", (Object)policyPaymentNotifyRequest, PolicyPaymentNotifyResult.class);
        if (ObjectUtil.isNotEmpty((Object)result) && 1 == result.getResponseHead().getStatus()) {
            return result.getResponseBody().getBizNo();
        }
        log.error("\u7f34\u8d39\u901a\u77e5\u5931\u8d25\uff0c{}", (Object)proposalNo);
        return null;
    }

    private PolicyPaymentNotifyRequest compensatePolicyPaymentNotifyParams(PolicySubmitRequest policySubmitRequest) {
        PolicyPaymentNotifyResultRequestParams params = PolicyPaymentNotifyResultRequestParams.builder().build();
        String businessNo = policySubmitRequest.getRequestBody().getBusinessNo();
        String businessType = "1";
        params.setBusinessNo(businessNo);
        params.setBusinessType(businessType);
        PolicyPaymentNotifyRequest requestParams = PolicyPaymentNotifyRequest.builder().requestHead(policySubmitRequest.getRequestHead()).requestBody(params).build();
        return requestParams;
    }

    public PolicySubmitRequest policyActivateRequestBeforeProcess(StanderRequest request) {
        List rationPaymentPlanList;
        PolicyActivateServiceRequest policyActivateServiceRequest = request.getPolicyActivateServiceRequest();
        PolicyActivateRequestDTO policyActivateRequestDTO = policyActivateServiceRequest.getRequestBody();
        String businessNo = policyActivateServiceRequest.getRequestBody().getBusinessNo();
        PolicySubmitRequest policySubmitRequest = PolicySubmitRequest.builder().build();
        RequestHeadDTO requestHeadDTO = RequestHeadDTO.initRequestHead();
        requestHeadDTO.setConsumerSeqNo(request.getHeader().getUserCode() + businessNo);
        policySubmitRequest.setRequestHead(requestHeadDTO);
        PolicySubmitRequestDTO requestBody = PolicySubmitRequestDTO.builder().build();
        QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
        apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)businessNo);
        ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusiChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
        PaymentInfoDTO paymentInfo = PaymentInfoDTO.builder().premium(policyActivateRequestDTO.getPremium()).paymentMethod(policyActivateRequestDTO.getPaymentMethod()).payTime(policyActivateRequestDTO.getPayTime()).platformSerialNumber(policyActivateRequestDTO.getPlatformSerialNumber()).build();
        requestBody.setJfeeFlag(order.getPayType());
        requestBody.setBusinessNo(order.getProposalNo());
        requestBody.setPreBusinessNo(businessNo);
        String paymentMethod = "";
        if ("1".equals(requestBody.getJfeeFlag())) {
            QueryWrapper queryWrapperCode = new QueryWrapper();
            queryWrapperCode.eq((Object)"code", (Object)"paymentMethod_1");
            queryWrapperCode.eq((Object)"channel_value", (Object)policyActivateRequestDTO.getPaymentMethod());
            ApisChannelCode apisChannelCode = (ApisChannelCode)this.apisChannelCodeService.getOne((Wrapper)queryWrapperCode);
            if (ObjectUtil.isNotEmpty((Object)apisChannelCode) && StringUtils.isNotEmpty((CharSequence)apisChannelCode.getValue())) {
                paymentMethod = apisChannelCode.getValue();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)paymentMethod) && paymentMethod.equals("JDPayTrade")) {
            requestBody.setPaymentFlag("8");
        } else if ("1".equals(order.getPayType())) {
            requestBody.setPaymentFlag("2");
        } else {
            requestBody.setPaymentFlag("1");
        }
        requestBody.setUnderWriteType("EX");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_no", (Object)policyActivateRequestDTO.getBusinessNo());
        queryWrapper.eq((Object)"log_type", (Object)"1");
        ApisBusiReqmsgLog apisBusiReqmsgLog = (ApisBusiReqmsgLog)this.apisBusiReqmsgLogMapper.selectOne((Wrapper)queryWrapper);
        QuotePriceServiceRequest quotePriceServiceRequest = (QuotePriceServiceRequest)JSON.parseObject((String)apisBusiReqmsgLog.getLogContent(), QuotePriceServiceRequest.class);
        requestBody.setUnderWriteCode(quotePriceServiceRequest.getRequestBody().getQuotePrice().getMain().getOperateCode());
        requestBody.setUnderWriteName(quotePriceServiceRequest.getRequestBody().getQuotePrice().getMain().getOperateName());
        requestBody.setPaymentInfo(paymentInfo);
        if (ObjectUtil.isNotEmpty((Object)order.getPlanCode()) && ObjectUtil.isNotEmpty((Object)quotePriceServiceRequest.getRequestBody().getQuotePrice().getPayPlanList()) && ObjectUtil.isNotEmpty((Object)(rationPaymentPlanList = this.apisPfpRationPaymentPlanMapper.getApisPfpRationPaymentPlanList(Arrays.asList(order.getPlanCode().split(",")))))) {
            requestBody.setPaymentMethod(((ApisPfpRationPaymentPlan)rationPaymentPlanList.get(0)).getPaymentMethod());
        }
        requestBody.setPayPlanList(this.packagePayPlanInfo(policyActivateRequestDTO, order.getPremium().doubleValue(), quotePriceServiceRequest, requestBody));
        policySubmitRequest.setRequestBody(requestBody);
        request.setPolicySubmitRequest(policySubmitRequest);
        return policySubmitRequest;
    }

    private List<PayPlanDTO> packagePayPlanInfo(PolicyActivateRequestDTO policyActivateRequestDTO, Double premium, QuotePriceServiceRequest quotePriceServiceRequest, PolicySubmitRequestDTO requestBody) {
        PayPlanDTO payPlanDTO;
        AppliClientDTO appliClientDTO = (AppliClientDTO)quotePriceServiceRequest.getRequestBody().getQuotePrice().getAppliClient().get(0);
        List<PayPlanDTO> payPlanDTOList = new ArrayList();
        String paymentMethod = "";
        if ("1".equals(requestBody.getJfeeFlag())) {
            QueryWrapper queryWrapperCode = new QueryWrapper();
            queryWrapperCode.eq((Object)"code", (Object)"paymentMethod_1");
            queryWrapperCode.eq((Object)"channel_value", (Object)policyActivateRequestDTO.getPaymentMethod());
            ApisChannelCode apisChannelCode = (ApisChannelCode)this.apisChannelCodeService.getOne((Wrapper)queryWrapperCode);
            if (ObjectUtil.isNotEmpty((Object)apisChannelCode) && StringUtils.isNotEmpty((CharSequence)apisChannelCode.getValue())) {
                paymentMethod = apisChannelCode.getValue();
            }
        }
        if (ObjectUtil.isNotEmpty((Object)quotePriceServiceRequest.getRequestBody().getQuotePrice().getPayPlanList()) && quotePriceServiceRequest.getRequestBody().getQuotePrice().getPayPlanList().size() > 1) {
            payPlanDTOList = quotePriceServiceRequest.getRequestBody().getQuotePrice().getPayPlanList();
            payPlanDTO = (PayPlanDTO)payPlanDTOList.get(0);
            payPlanDTO.setPaymentMethod(paymentMethod);
            payPlanDTO.setPayFee(Double.valueOf(policyActivateRequestDTO.getPremium().doubleValue()));
            if ("2".equals(requestBody.getPaymentFlag()) || "8".equals(requestBody.getPaymentFlag())) {
                payPlanDTO.setPlatformSerialNumber(policyActivateRequestDTO.getPlatformSerialNumber());
            }
            payPlanDTO.setPayDate(policyActivateRequestDTO.getPayTime());
            QueryWrapper queryWrapperIns = new QueryWrapper();
            queryWrapperIns.eq((Object)"policy_no", (Object)policyActivateRequestDTO.getBusinessNo());
            queryWrapperIns.eq((Object)"current_pay_no", (Object)1);
            ApisBusiChannelInstallmentOrder installmentOrder = (ApisBusiChannelInstallmentOrder)this.apisBusiChannelInstallmentOrderMapper.selectOne((Wrapper)queryWrapperIns);
            if (ObjectUtil.isNotEmpty((Object)installmentOrder)) {
                payPlanDTO.setPlanFee(Double.valueOf(installmentOrder.getCurrentPremium().doubleValue()));
            }
            payPlanDTO.setPayApplyNo(policyActivateRequestDTO.getPayApplyNo());
        } else {
            payPlanDTO = PayPlanDTO.builder().build();
            BeanUtils.copyProperties((Object)appliClientDTO, (Object)payPlanDTO);
            payPlanDTO.setInsuredSerialNo(appliClientDTO.getSerialNo());
            payPlanDTO.setInsuredType("1");
            payPlanDTO.setPaymentMethod(paymentMethod);
            if (StrUtil.isNotEmpty((CharSequence)policyActivateRequestDTO.getPlatformSerialNumber()) && ("2".equals(requestBody.getPaymentFlag()) || "8".equals(requestBody.getPaymentFlag()))) {
                payPlanDTO.setPlatformSerialNumber(policyActivateRequestDTO.getPlatformSerialNumber());
            }
            if (policyActivateRequestDTO.getPremium() != null) {
                payPlanDTO.setPayFee(Double.valueOf(policyActivateRequestDTO.getPremium().doubleValue()));
            }
            payPlanDTO.setPayDate(policyActivateRequestDTO.getPayTime() == null ? new Date() : policyActivateRequestDTO.getPayTime());
            payPlanDTO.setPlanStartDate(policyActivateRequestDTO.getPayTime() == null ? new Date() : policyActivateRequestDTO.getPayTime());
            payPlanDTO.setPlanDate(quotePriceServiceRequest.getRequestBody().getQuotePrice().getMain().getStartDate());
            payPlanDTO.setPlanFee(premium);
            payPlanDTO.setPayTimes(Integer.valueOf(1));
            payPlanDTO.setPayApplyNo(policyActivateRequestDTO.getPayApplyNo());
            payPlanDTOList.add(payPlanDTO);
        }
        return payPlanDTOList;
    }

    private PolicyActivateResponse resultProcessPolicyPaymentNotify(PolicySubmitRequest policySubmitRequest, PolicyActivateResponse policyActivateResponse, PolicyPaymentNotifyResult result) {
        policyActivateResponse.setResponseHead(result.getResponseHead());
        PolicyActivateResponseDTO responseBody = PolicyActivateResponseDTO.builder().build();
        PolicySubmitRequestDTO policySubmitRequestDTO = policySubmitRequest.getRequestBody();
        if (!BeanUtil.isEmpty((Object)result.getResponseBody(), (String[])new String[0])) {
            ConfirmFeeResponseDto confirmFeeResponseDto = result.getResponseBody();
            responseBody.setBusinessNo(confirmFeeResponseDto.getBizNo());
            String status = result.getResponseBody().getBizNo();
            status = StrUtil.isEmpty((CharSequence)status) ? "60" : "70";
            responseBody.setUnderwriteFlag(status);
            responseBody.setPremium(policySubmitRequestDTO.getPaymentInfo().getPremium());
            String businessNo = policySubmitRequestDTO.getBusinessNo();
            QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
            apisBusiChannelOrderQueryWrapper.eq((Object)"proposal_no", (Object)businessNo);
            ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusiChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
            responseBody.setTotalPremium(order.getPremium());
        }
        policyActivateResponse.setResponseBody(responseBody);
        return policyActivateResponse;
    }

    private void orderDataUpdateProcessPolicyNotify(PolicyPaymentNotifyResult result, StanderRequest request) {
        if (!(BeanUtil.isEmpty((Object)result, (String[])new String[0]) || BeanUtil.isEmpty((Object)result.getResponseHead(), (String[])new String[0]) || BeanUtil.isEmpty((Object)result.getResponseBody(), (String[])new String[0]))) {
            String policyNo = request.getPolicyActivateServiceRequest().getRequestBody().getBusinessNo();
            PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().requestHead(RequestHeadDTO.builder().consumerID("apis").transactionDate(new Date()).build()).requestBody(PolicyDetailRequestDTO.builder().policyNo(policyNo).build()).build();
            PolicyDetailResponse policyDetailResponse = null;
            policyDetailResponse = (PolicyDetailResponse)this.httpRequestService.convertAndSend("policyDetail", "policyDetail", (Object)policyDetailServiceRequest, PolicyDetailResponse.class);
            if (!BeanUtil.isEmpty((Object)policyDetailResponse, (String[])new String[0]) || policyDetailResponse.getResponseBody() != null || policyDetailResponse.getResponseBody().getPolicy() == null) {
                UpdateWrapper orderUpdateWrapper = new UpdateWrapper();
                orderUpdateWrapper.eq((Object)"policy_no", (Object)policyNo);
                ApisBusiChannelOrder updateEntity = new ApisBusiChannelOrder();
                updateEntity.setStatus("04");
                DateTime dateTime = DateUtil.date((Date)new Date());
                LocalDateTime localDateTime = dateTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                updateEntity.setPayTime(localDateTime);
                updateEntity.setPolicyTime(localDateTime);
                this.apisBusiChannelOrderMapper.update((Object)updateEntity, (Wrapper)orderUpdateWrapper);
            }
        }
    }

    @Override
    public AgentQueryResponseDTO commissionQuery(CommissionQueryDTO commissionQueryDTO) {
        AgentQueryResponseDTO agentQueryResponseDTO = (AgentQueryResponseDTO)this.httpRequestService.convertAndSendForSales("commissionQuery", (Object)commissionQueryDTO, AgentQueryResponseDTO.class);
        return agentQueryResponseDTO;
    }

    @Override
    public StanderResponse policyUnderWrite(StanderRequest request) {
        PolicyListQueryResponse policyListQueryResponse = (PolicyListQueryResponse)this.httpRequestService.convertAndSend("quotePrice", "quotePrice", (Object)request.getPolicyUnderwritRequest(), PolicyListQueryResponse.class);
        return StanderResponse.builder().header(request.getHeader()).policyListQueryResponse(policyListQueryResponse).build();
    }

    @Override
    public StanderResponse insuredIdvListQueryService(StanderRequest request) {
        InsuredIdvListQueryResponse insuredIdvListQueryResponse = (InsuredIdvListQueryResponse)this.httpRequestService.convertAndSend("insuredIdvListQuery", "insuredIdvListQuery", (Object)request.getInsuredIdvListQueryRequest(), InsuredIdvListQueryResponse.class);
        return StanderResponse.builder().header(request.getHeader()).insuredIdvListQueryResponse(insuredIdvListQueryResponse).build();
    }

    @Override
    public StanderResponse planQuotationQuery(StanderRequest request) {
        return null;
    }

    @Override
    public UwInfoQueryResponse uwInfoQuery(UwInfoQueryRequest uwInfoQueryRequest, String urlRoute) {
        UwInfoQueryResponse uwInfoQueryResponse = UwInfoQueryResponse.builder().build();
        if (urlRoute.equals("uwInfoQueryService")) {
            uwInfoQueryResponse = (UwInfoQueryResponse)this.httpRequestService.convertAndSend(urlRoute, urlRoute, (Object)uwInfoQueryRequest, UwInfoQueryResponse.class);
        } else {
            String xmlRequestStr = this.convertToUwInfoQueryRequest(uwInfoQueryRequest);
            String xmlResponseStr = this.httpRequestService.uwInfoQueryByQuestion(urlRoute, xmlRequestStr);
            uwInfoQueryResponse = this.convertToUwInfoQueryResponse(xmlResponseStr);
        }
        return uwInfoQueryResponse;
    }

    private String convertToUwInfoQueryRequest(UwInfoQueryRequest uwInfoQueryRequest) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Packet>";
        if (StringUtils.isNotEmpty((CharSequence)uwInfoQueryRequest.getRequestType())) {
            xml = xml + " <RequestType>" + uwInfoQueryRequest.getRequestType() + "</RequestType>";
        }
        if (StringUtils.isNotEmpty((CharSequence)uwInfoQueryRequest.getSerialNumber())) {
            xml = xml + " <SerialNumber>" + uwInfoQueryRequest.getSerialNumber() + "</SerialNumber>";
        }
        if (StringUtils.isNotEmpty((CharSequence)uwInfoQueryRequest.getInsuredName())) {
            xml = xml + " <InsuredName>" + uwInfoQueryRequest.getInsuredName() + "</InsuredName>";
        }
        if (StringUtils.isNotEmpty((CharSequence)uwInfoQueryRequest.getIdNumber())) {
            xml = xml + " <IdNumber>" + uwInfoQueryRequest.getIdNumber() + "</IdNumber>";
        }
        if (StringUtils.isNotEmpty((CharSequence)uwInfoQueryRequest.getCid())) {
            xml = xml + " <Cid>" + uwInfoQueryRequest.getCid() + "</Cid>";
        }
        if (ObjectUtil.isNotEmpty((Object)uwInfoQueryRequest.getUnderwritingQuestionList()) && uwInfoQueryRequest.getUnderwritingQuestionList().size() > 0) {
            xml = xml + "<UnderwritingQuestionList>";
            for (UnderwritingQuestion underwritingQuestion : uwInfoQueryRequest.getUnderwritingQuestionList()) {
                xml = xml + "<UnderwritingQuestion>";
                xml = xml + " <DiseaseCode>" + underwritingQuestion.getDiseaseCode() + "</DiseaseCode>";
                xml = xml + " <QuestionId>" + underwritingQuestion.getQuestionId() + "</QuestionId>";
                xml = xml + " <AnswerYN>" + underwritingQuestion.getAnswerYn() + "</AnswerYN>";
                xml = xml + "</UnderwritingQuestion>";
            }
            xml = xml + "</UnderwritingQuestionList>";
        }
        if (StringUtils.isNotEmpty((CharSequence)uwInfoQueryRequest.getAgencyCode())) {
            xml = xml + " <AgencyCode>" + uwInfoQueryRequest.getAgencyCode() + "</AgencyCode>";
        }
        if (StringUtils.isNotEmpty((CharSequence)uwInfoQueryRequest.getResideAddress())) {
            xml = xml + " <ResideAddress>" + uwInfoQueryRequest.getResideAddress() + "</ResideAddress>";
        }
        if (StringUtils.isNotEmpty((CharSequence)uwInfoQueryRequest.getResideAddressId())) {
            xml = xml + " <ResideAddressId>" + uwInfoQueryRequest.getResideAddressId() + "</ResideAddressId>";
        }
        if (StringUtils.isNotEmpty((CharSequence)uwInfoQueryRequest.getProductName())) {
            xml = xml + " <ProductName>" + uwInfoQueryRequest.getProductName() + "</ProductName>";
        }
        xml = xml + "</Packet>";
        return xml;
    }

    private UwInfoQueryResponse convertToUwInfoQueryResponse(String xmlResponseStr) {
        UwInfoQueryResponse uwInfoQueryResponse = UwInfoQueryResponse.builder().build();
        if (StringUtils.isNotEmpty((CharSequence)xmlResponseStr)) {
            try {
                Document doc = DocumentHelper.parseText((String)xmlResponseStr);
                Element rootElt = doc.getRootElement();
                ResultDTO resultDTO = ResultDTO.builder().build();
                String result = "Result";
                String resultCodeTxt = "ResultCode";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(result).element(resultCodeTxt))) {
                    resultDTO.setResultCode(rootElt.element("Result").element("ResultCode").getTextTrim());
                }
                String resultDescTxt = "ResultDesc";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(result).element(resultDescTxt))) {
                    resultDTO.setResultDesc(rootElt.element("Result").element("ResultDesc").getTextTrim());
                }
                String resideAddressIdTxt = "ResideAddressId";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(result).element(resideAddressIdTxt))) {
                    resultDTO.setResideAddressId(rootElt.element("Result").element("ResideAddressId").getTextTrim());
                }
                String resideFullAddressTxt = "ResideFullAddress";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(result).element(resideFullAddressTxt))) {
                    resultDTO.setResideFullAddress(rootElt.element("Result").element("ResideFullAddress").getTextTrim());
                }
                String isAddressRulePassTxt = "IsAddressRulePass";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(result).element(isAddressRulePassTxt))) {
                    resultDTO.setIsAddressRulePass(rootElt.element("Result").element("IsAddressRulePass").getTextTrim());
                }
                String resideAddressDescTxt = "ResideAddressDesc";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(result).element(resideAddressDescTxt))) {
                    resultDTO.setResideAddressDesc(rootElt.element("Result").element("ResideAddressDesc").getTextTrim());
                }
                uwInfoQueryResponse.setResult(resultDTO);
                UwInfoQueryRequest uwQueryParam = UwInfoQueryRequest.builder().build();
                String uwQueryParamTxt = "UwQueryParam";
                String cidTxt = "Cid";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwQueryParamTxt).element(cidTxt))) {
                    String cid = rootElt.element("UwQueryParam").element("Cid").getTextTrim();
                    uwQueryParam.setCid(cid);
                }
                String serialNumberTxt = "SerialNumber";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwQueryParamTxt).element(serialNumberTxt))) {
                    String serialNumber = rootElt.element("UwQueryParam").element("SerialNumber").getTextTrim();
                    uwQueryParam.setSerialNumber(serialNumber);
                }
                String requestTypeTxt = "RequestType";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwQueryParamTxt).element(requestTypeTxt))) {
                    String requestType = rootElt.element("UwQueryParam").element("RequestType").getTextTrim();
                    uwQueryParam.setRequestType(requestType);
                }
                String insuredNameTxt = "InsuredName";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwQueryParamTxt).element(insuredNameTxt))) {
                    String insuredName = rootElt.element("UwQueryParam").element("InsuredName").getTextTrim();
                    uwQueryParam.setInsuredName(insuredName);
                }
                String idNumberTxt = "IdNumber";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwQueryParamTxt).element(idNumberTxt))) {
                    String idNumber = rootElt.element("UwQueryParam").element("IdNumber").getTextTrim();
                    uwQueryParam.setIdNumber(idNumber);
                }
                String agencyCodeTxt = "AgencyCode";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwQueryParamTxt).element(agencyCodeTxt))) {
                    String agencyCode = rootElt.element("UwQueryParam").element("AgencyCode").getTextTrim();
                    uwQueryParam.setAgencyCode(agencyCode);
                }
                String resideAddressIdTxt2 = "ResideAddressId";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwQueryParamTxt).element(resideAddressIdTxt2))) {
                    String resideAddressId = rootElt.element("UwQueryParam").element("ResideAddressId").getTextTrim();
                    uwQueryParam.setResideAddressId(resideAddressId);
                }
                String productNameTxt = "ProductName";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwQueryParamTxt).element(productNameTxt))) {
                    String productName = rootElt.element("UwQueryParam").element("ProductName").getTextTrim();
                    uwQueryParam.setProductName(productName);
                }
                String resideAddressTxt = "ResideAddress";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwQueryParamTxt).element(resideAddressTxt))) {
                    String resideAddress = rootElt.element("UwQueryParam").element("ResideAddress").getTextTrim();
                    uwQueryParam.setResideAddress(resideAddress);
                }
                uwInfoQueryResponse.setUwQueryParam(uwQueryParam);
                String uwDataTxt = "UwData";
                if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwDataTxt))) {
                    Iterator questionIter = rootElt.element("UwData").element("QuestionList").elementIterator("Question");
                    ArrayList<UwQuestionDTO> uwQuestionDTOList = new ArrayList<UwQuestionDTO>();
                    while (questionIter.hasNext()) {
                        Element recordEle = (Element)questionIter.next();
                        UwQuestionDTO uwQuestionDTO = UwQuestionDTO.builder().build();
                        if (ObjectUtil.isNotEmpty((Object)recordEle.element("DiseaseCode"))) {
                            uwQuestionDTO.setDiseaseCode(recordEle.element("DiseaseCode").getTextTrim());
                        }
                        if (ObjectUtil.isNotEmpty((Object)recordEle.element("DiseaseDesc"))) {
                            uwQuestionDTO.setDiseaseDesc(recordEle.element("DiseaseDesc").getTextTrim());
                        }
                        if (ObjectUtil.isNotEmpty((Object)recordEle.element("QuestionOrder"))) {
                            uwQuestionDTO.setQuestionOrder(Integer.valueOf(Integer.parseInt(recordEle.element("QuestionOrder").getTextTrim())));
                        }
                        if (ObjectUtil.isNotEmpty((Object)recordEle.element("QuestionId"))) {
                            uwQuestionDTO.setQuestionId(recordEle.element("QuestionId").getTextTrim());
                        }
                        if (ObjectUtil.isNotEmpty((Object)recordEle.element("QuestionDesc"))) {
                            uwQuestionDTO.setQuestionDesc(recordEle.element("QuestionDesc").getTextTrim());
                        }
                        if (ObjectUtil.isNotEmpty((Object)recordEle.element("Answer"))) {
                            uwQuestionDTO.setAnswer(recordEle.element("Answer").getTextTrim());
                        }
                        uwQuestionDTOList.add(uwQuestionDTO);
                    }
                    Iterator uwResultFinalIter = rootElt.element("UwData").element("UwResultFinalList").elementIterator("UwResultFinal");
                    ArrayList<UwResultFinalDTO> uwResultFinalDTOList = new ArrayList<UwResultFinalDTO>();
                    while (uwResultFinalIter.hasNext()) {
                        Element recordEle = (Element)uwResultFinalIter.next();
                        UwResultFinalDTO uwResultFinalDTO = UwResultFinalDTO.builder().build();
                        if (ObjectUtil.isNotEmpty((Object)recordEle.element("DiseaseCode"))) {
                            uwResultFinalDTO.setDiseaseCode(recordEle.element("DiseaseCode").getTextTrim());
                        }
                        if (ObjectUtil.isNotEmpty((Object)recordEle.element("DiseaseDesc"))) {
                            uwResultFinalDTO.setDiseaseDesc(recordEle.element("DiseaseDesc").getTextTrim());
                        }
                        if (ObjectUtil.isNotEmpty((Object)recordEle.element("Decision"))) {
                            uwResultFinalDTO.setDecision(recordEle.element("Decision").getTextTrim());
                        }
                        uwResultFinalDTOList.add(uwResultFinalDTO);
                    }
                    UwData uwData = UwData.builder().build();
                    uwData.setQuestionList(uwQuestionDTOList);
                    uwData.setUwResultFinalList(uwResultFinalDTOList);
                    String insuredNameTxt2 = "InsuredName";
                    if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwDataTxt).element(insuredNameTxt2))) {
                        uwData.setInsuredName(rootElt.element("UwData").element("InsuredName").getTextTrim());
                    }
                    if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwDataTxt).element(idNumberTxt))) {
                        uwData.setIdNumber(rootElt.element("UwData").element("IdNumber").getTextTrim());
                    }
                    if (ObjectUtil.isNotEmpty((Object)rootElt.element(uwDataTxt).element(agencyCodeTxt))) {
                        uwData.setAgencyCode(rootElt.element("UwData").element("AgencyCode").getTextTrim());
                    }
                    uwInfoQueryResponse.setUwData(uwData);
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return uwInfoQueryResponse;
    }

    @Override
    public ResponseVo premiumPayStatusQuery(PremiumPayStatusQueryRequest premiumPayStatusQueryRequest) {
        ResponseVo responseVo = (ResponseVo)this.httpRequestService.convertAndSend("premiumPayStatusQueryService", "premiumPayStatusQueryService", (Object)premiumPayStatusQueryRequest, ResponseVo.class);
        return responseVo;
    }

    @Override
    public StanderResponse rechargePoaQuery(StanderRequest request) {
        RechargePoaVoDTO responseVo = (RechargePoaVoDTO)this.httpRequestService.convertAndSend("RechargePoaServer", "RechargePoaServer", (Object)request.getRechargePoaRequest(), RechargePoaVoDTO.class);
        RechargePoaResponse rechargePoaResponse = RechargePoaResponse.builder().responseVo(responseVo).build();
        return StanderResponse.builder().header(request.getHeader()).rechargePoaResponse(rechargePoaResponse).build();
    }

    @Override
    public JdUserVerifyResponse verifyJdUser(JdUserVerifyRequest request) {
        return (JdUserVerifyResponse)this.httpRequestService.convertAndSend("jdUserVerifyService", "jdUserVerifyService", (Object)request, JdUserVerifyResponse.class);
    }

    @Override
    public PayNotifyResponse payNotifyToSales(PayNotifyRequest payNotifyRequest) {
        return (PayNotifyResponse)this.httpRequestService.convertAndSendForSales("payNotifyToSales", (Object)payNotifyRequest, PayNotifyResponse.class);
    }

    @Override
    public StanderResponse printQueryVoucherImgUrl(StanderRequest request) {
        PrintQueryImgURLResponse printQueryVoucherImgUrl = (PrintQueryImgURLResponse)this.httpRequestService.convertAndSend("printQueryVoucherImgURL", "printQueryVoucherImgURL", (Object)request.getPrintQueryVoucherImgUrlRequest(), PrintQueryImgURLResponse.class);
        return StanderResponse.builder().header(request.getHeader()).printQueryImgUrlResponse(printQueryVoucherImgUrl).build();
    }

    @Override
    public QuotePriceServiceResponse companyInfoAudit(CompanyInfoAuditRequest request) {
        QuotePriceServiceResponse responseVo = (QuotePriceServiceResponse)this.httpRequestService.convertAndSend("companyInfoAudit", "companyInfoAudit", (Object)request, QuotePriceServiceResponse.class);
        return responseVo;
    }

    @Override
    public QuotePriceServiceResponse receiveNotice(ReceiveNoticeRequest receiveNoticeRequest) {
        QuotePriceServiceResponse responseVo = (QuotePriceServiceResponse)this.httpRequestService.convertAndSend("receiveNotice", "receiveNotice", (Object)receiveNoticeRequest, QuotePriceServiceResponse.class);
        return responseVo;
    }

    @Override
    public RefundQueryResponseVo policyRefundQuery(PolicyRefundQueryRequest policyRefundQueryRequest) {
        RefundQueryResponseVo responseVo = (RefundQueryResponseVo)this.httpRequestService.convertAndSend("refundInfoQueryService", "refundInfoQueryService", (Object)policyRefundQueryRequest, RefundQueryResponseVo.class);
        return responseVo;
    }

    @Override
    public ChannelDetailResponse channelDetailQuery(DockRequest dockRequest) {
        ChannelDetailResponse responseVo = (ChannelDetailResponse)this.httpRequestService.convertAndSendForSales("channelDetail", (Object)dockRequest, ChannelDetailResponse.class);
        return responseVo;
    }

    @Override
    public PayerInfoChangeResponse payerInfoChange(PayerInfoChangeFccbRequest request) {
        PayerInfoChangeResponse responseVo = (PayerInfoChangeResponse)this.httpRequestService.convertAndSend("payerInfoChange", "payerInfoChange", (Object)request, PayerInfoChangeResponse.class);
        return responseVo;
    }

    @Override
    public RefundConfirmQueryResponseVo refundQueryConfirm(PolicyRefundConfirmQueryRequest request) {
        RefundConfirmQueryResponseVo responseVo = (RefundConfirmQueryResponseVo)this.httpRequestService.convertAndSend("refundQueryConfirm", "refundQueryConfirm", (Object)request, RefundConfirmQueryResponseVo.class);
        return responseVo;
    }

    @Override
    public StanderResponse queryVoucherInformation(StanderRequest request) {
        QueryVoucherServiceResponse responseVo = (QueryVoucherServiceResponse)this.httpRequestService.convertAndSend("QueryVoucherService", "QueryVoucherService", (Object)request.getQueryVoucherServiceRequest(), QueryVoucherServiceResponse.class);
        return StanderResponse.builder().queryVoucherServiceResponse(responseVo).header(request.getHeader()).build();
    }

    @Override
    public StanderResponse declarationVoucher(StanderRequest request) {
        DeclarationVoucherResponse responseVo = (DeclarationVoucherResponse)this.httpRequestService.convertAndSend("DeclarationVoucherService", "DeclarationVoucherService", (Object)request.getDeclarationVoucherRequest(), DeclarationVoucherResponse.class);
        return StanderResponse.builder().header(request.getHeader()).declarationVoucherResponse(responseVo).build();
    }

    @Override
    public ResponsePP freightHyQuotePricePp(QuotePriceServiceRequest request) {
        ResponsePP responseVo = (ResponsePP)this.httpRequestService.convertAndSend("freightHYQuotePrice", "freightHYQuotePrice", (Object)request, ResponsePP.class);
        return responseVo;
    }

    @Override
    public ClaimStatusResponseDTO claimMoneyQuery(ClaimStatusDTO claimStatusDTO) {
        ClaimStatusResponseDTO responseDTO = (ClaimStatusResponseDTO)this.httpRequestService.convertAndSend("claimMoneyQuery", "claimMoneyQuery", (Object)claimStatusDTO, ClaimStatusResponseDTO.class);
        return responseDTO;
    }

    @Override
    public UnderWriteQueryResponse underWriteQuery(UnderWriteQueryRequest underWriteQueryRequest) {
        UnderWriteQueryResponse responseDTO = (UnderWriteQueryResponse)this.httpRequestService.convertAndSend("underWriteQuery", "underWriteQuery", (Object)underWriteQueryRequest, UnderWriteQueryResponse.class);
        return responseDTO;
    }

    @Override
    public PaymentAccountQueryResponseVo accountQuery(PaymentAccountQueryRequest paymentAccountQueryRequest) {
        PaymentAccountQueryResponseVo responseDTO = (PaymentAccountQueryResponseVo)this.httpRequestService.convertAndSend("paymentGateway", "paymentGateway", (Object)paymentAccountQueryRequest, PaymentAccountQueryResponseVo.class);
        return responseDTO;
    }

    @Override
    public BaseResponse rulingsUpdate(StanderRequest request) {
        BaseResponse response = (BaseResponse)this.httpRequestService.convertAndSend("rulingsUpdate", "rulingsUpdate", (Object)request.getRulingResultRequest(), BaseResponse.class);
        return response;
    }

    @Override
    public RenewalShortLikeResponse renewalShortLike(RenewalShortLikeServiceRequest request) {
        RenewalShortLikeResponse response = (RenewalShortLikeResponse)this.httpRequestService.convertAndSend("renewalShortLike", "renewalShortLike", (Object)request, RenewalShortLikeResponse.class);
        return response;
    }

    @Override
    public StanderResponse basicsPolicyModify(StanderRequest request) {
        BasicsPolicyModifyResponse response = (BasicsPolicyModifyResponse)this.httpRequestService.convertAndSend("basicsPolicyModify", "basicsPolicyModify", (Object)request.getBasicsPolicyModifyRequest(), BasicsPolicyModifyResponse.class);
        return StanderResponse.builder().header(request.getHeader()).basicsPolicyModifyResponse(response).build();
    }

    @Override
    public StanderResponse basicsPolicyQuery(StanderRequest request) {
        BasicsPolicyQueryResponse response = (BasicsPolicyQueryResponse)this.httpRequestService.convertAndSend("basicsPolicyQuery", "basicsPolicyQuery", (Object)request.getBasicsPolicyQueryRequest(), BasicsPolicyQueryResponse.class);
        return StanderResponse.builder().header(request.getHeader()).basicsPolicyQueryResponse(response).build();
    }
}

