/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.coreapi.payment.impl;

import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PayContractSendSmsResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PaymentContractResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PaymentGatewayResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.payment.RenewalContractResponse;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import com.jdaz.sinosoftgz.coreapi.payment.PaymentGatewayApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentGatewayApiImpl
implements PaymentGatewayApi {
    private static final String PAYMENT_GATEWAY_SERVER = "paymentGateway";
    private static final String PAYMENT_GATEWAY_METHOD = "/method";
    @Autowired
    HttpRequestService httpRequestService;

    @Override
    public PaymentGatewayResponse paymentNoApply(StanderRequest request) {
        PaymentGatewayResponse resp = (PaymentGatewayResponse)this.httpRequestService.convertAndSend(PAYMENT_GATEWAY_SERVER, PAYMENT_GATEWAY_METHOD, (Object)request.getPaymentGateWayServiceRequest(), PaymentGatewayResponse.class);
        return resp;
    }

    @Override
    public PaymentContractResponse paymentContract(StanderRequest request) {
        PaymentContractResponse resp = (PaymentContractResponse)this.httpRequestService.convertAndSend(PAYMENT_GATEWAY_SERVER, null, (Object)request.getPaymentContractServiceRequest(), PaymentContractResponse.class);
        return resp;
    }

    @Override
    public StanderResponse payContractSendMsg(StanderRequest request) {
        PayContractSendSmsResponse response = (PayContractSendSmsResponse)this.httpRequestService.convertAndSend(PAYMENT_GATEWAY_SERVER, null, (Object)request.getPayContractSendSmsRequest(), PayContractSendSmsResponse.class);
        return StanderResponse.builder().header(request.getHeader()).payContractSendSmsResponse(response).build();
    }

    @Override
    public StanderResponse renewalContract(StanderRequest request) {
        RenewalContractResponse response = (RenewalContractResponse)this.httpRequestService.convertAndSend(PAYMENT_GATEWAY_SERVER, null, (Object)request.getRenewalContractRequest(), RenewalContractResponse.class);
        return StanderResponse.builder().header(request.getHeader()).renewalContractResponse(response).build();
    }
}

