/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.executor;

import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.log.api.ApisLog;
import com.jdaz.sinosoftgz.coreapi.common.service.impl.HttpRequestServiceImpl;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CallApiService {
    public static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestServiceImpl.class);
    static OkHttpClient client = new OkHttpClient.Builder().connectTimeout(4L, TimeUnit.SECONDS).readTimeout(4L, TimeUnit.SECONDS).build();

    public <T> T callApi(String url, Object body, Class<T> respType) {
        block8: {
            Date startDate = new Date();
            byte[] requestBodyBytes = new byte[]{};
            byte[] responseBodyBytes = new byte[]{};
            Boolean errorFlag = false;
            String errorMessage = null;
            try {
                Object object;
                String bodyStr = JSON.toJSONString((Object)body);
                logger.warn("\u63a5\u53e3 {} \u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)url, (Object)bodyStr);
                RequestBody requestBody = RequestBody.create((MediaType)JSON_TYPE, (String)bodyStr);
                requestBodyBytes = bodyStr.getBytes();
                Request request = new Request.Builder().url(url).post(requestBody).addHeader("Connection", "close").build();
                Call call = client.newCall(request);
                try {
                    Object resp;
                    Response response = call.execute();
                    String responseBodyStr = response.body().string();
                    responseBodyBytes = responseBodyStr.getBytes();
                    logger.warn("\u63a5\u53e3:{} \u8c03\u7528\u54cd\u5e94\u62a5\u6587\uff1a", (Object)url, (Object)responseBodyStr);
                    object = resp = JSON.parseObject((String)responseBodyStr, respType);
                }
                catch (IOException e) {
                    try {
                        logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (Exception e2) {
                        logger.error("=============call api error :{}", (Object)url);
                        errorFlag = true;
                        errorMessage = e2.getMessage();
                        throw new RuntimeException(e2);
                    }
                    logger.warn("\u63a5\u53e3:{} \u8c03\u7528\u7528\u65f6:{}", (Object)url, (Object)(System.currentTimeMillis() - startDate.getTime()));
                    String[] api = url.split("/");
                    this.sendLog(startDate, requestBodyBytes, responseBodyBytes, errorFlag, errorMessage, api[api.length - 1]);
                    break block8;
                }
                return (T)object;
            }
            finally {
                logger.warn("\u63a5\u53e3:{} \u8c03\u7528\u7528\u65f6:{}", (Object)url, (Object)(System.currentTimeMillis() - startDate.getTime()));
                String[] api = url.split("/");
                this.sendLog(startDate, requestBodyBytes, responseBodyBytes, errorFlag, errorMessage, api[api.length - 1]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLog(Date startDate, byte[] requestBodyBytes, byte[] responseBodyBytes, Boolean errorFlag, String errorMessage, String api) {
        try {
            String uid = null;
            if (ApisLog.getRequest() != null) {
                uid = ApisLog.getRequest().toString();
            }
            if (uid == null) {
                uid = UUID.randomUUID().toString().replaceAll("-", "");
            }
            ApisLog.create((String)uid).setContent(new String(requestBodyBytes, "utf-8")).setBusinessNode("api:call:in:" + api).setStartTime(startDate).setLevel("info").sendAndEnd();
            ApisLog.create((String)uid).setContent(new String(responseBodyBytes, "utf-8")).setBusinessNode("api:call:out:" + api).setStartTime(new Date()).setLevel("info").sendAndEnd();
            if (errorFlag.booleanValue()) {
                ApisLog.create((String)uid).setContent(errorMessage).setBusinessNode("api:call:error:" + api).setStartTime(new Date()).setLevel("error").sendAndEnd();
            }
        }
        catch (Exception e) {
            logger.error("\u8bb0\u5f55\u65e5\u5fd7\u65f6\u51fa\u9519:" + e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

