/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.executor;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.ExecutorUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.FxqCustomerCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ZybxRiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.web.TestLocalhost;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CommonsExecutorRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CommonsExecutorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CommonsValidateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelConfigsMapper;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonsValidateUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonsValidateUtil.class);
    @Autowired
    private ExecutorUtil executorUtil;
    @Autowired
    private ZybxRiskManagementCheckUtil zybxRiskManagementCheckUtil;
    @Autowired
    private RiskManagementCheckUtil riskManagementCheckUtil;
    @Autowired
    private FxqCustomerCheckUtil fxqCustomerCheckUtil;
    @Autowired
    private ApisChannelConfigsMapper apisChannelConfigsMapper;
    private static final String PASS_CHECK_CHANNEL_CODE = "pass_check_channel_code";

    public void executorValidate(StanderRequest request, Boolean addZybx, Boolean addRiskManagement, Boolean addFxq) throws ApisBusinessException {
        long startTime = System.currentTimeMillis();
        if (this.passCheck(request)) {
            return;
        }
        ArrayList requestList = new ArrayList();
        if (addZybx.booleanValue()) {
            this.zybxRiskManagementCheckUtil.addZybxRiskManagementApi(request, requestList);
        }
        if (addRiskManagement.booleanValue()) {
            this.riskManagementCheckUtil.addRiskManagement(request, requestList);
        }
        if (addFxq.booleanValue()) {
            this.fxqCustomerCheckUtil.addFxqCheck(request, requestList);
        }
        this.executorCallApi(requestList);
        log.warn("\u5e76\u53d1\u6821\u9a8c\u603b\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
    }

    public void test() throws ApisBusinessException {
        ArrayList<CommonsExecutorRequestDTO> requestList = new ArrayList<CommonsExecutorRequestDTO>();
        int len = 10;
        for (int i = 0; i < len; ++i) {
            TestLocalhost request = new TestLocalhost();
            request.setName("testLocalhost_" + i);
            requestList.add(new CommonsExecutorRequestDTO("http://192.168.3.60:9003/testLocalhostPost", (Object)request, CommonsValidateResponseDTO.class));
        }
        this.executorCallApi(requestList);
    }

    public void executorCallApi(List<CommonsExecutorRequestDTO> requestList) throws ApisBusinessException {
        if (requestList.size() > 0) {
            Map result = this.executorUtil.callApi(requestList);
            log.warn("\u5e76\u53d1\u8c03\u7528\u7ed3\u679c\u96c6\uff1a{}", (Object)result);
            for (CommonsExecutorResponseDTO responseDTO : result.values()) {
                if (responseDTO.getCode() == 0) {
                    Object obj = responseDTO.getData();
                    CommonsValidateResponseDTO response = null;
                    if (obj instanceof CommonsValidateResponseDTO) {
                        response = (CommonsValidateResponseDTO)obj;
                    }
                    if (response == null || ChannelErrorCodeEnum.ERR_C10002.getKey().equals(response.getCode())) continue;
                    throw new ApisBusinessException(response.getMessage(), response.getCode());
                }
                log.error("\u5e76\u53d1\u8c03\u7528\u5f02\u5e38\uff1a{}", (Object)responseDTO.getMsg());
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B110002.getValue(), ErrorBisCodeEnum.ERR_B110002.getKey());
            }
        }
    }

    public boolean passCheck(StanderRequest request) {
        String channelCode = request.getHeader().getChannelCode();
        if (StringUtils.isBlank((CharSequence)channelCode)) {
            return false;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)PASS_CHECK_CHANNEL_CODE);
        ApisChannelConfigs configs = (ApisChannelConfigs)this.apisChannelConfigsMapper.selectOne((Wrapper)queryWrapper);
        if (configs == null) {
            return false;
        }
        return configs.getConfigValue().indexOf(channelCode) > -1;
    }
}

