/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.executor;

import com.alibaba.fastjson.JSON;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.MyTaskCallable;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CommonsExecutorRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CommonsExecutorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CommonsValidateResponseDTO;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

@Component
public class ExecutorUtil {
    private static final Logger log = LoggerFactory.getLogger(ExecutorUtil.class);
    private static final ExecutorService EXEC = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("insure-app-common-pool-%d").build());
    @Autowired
    private DataCompletionUtil dataCompletionUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Map<String, CommonsExecutorResponseDTO> callApi(List<CommonsExecutorRequestDTO> requestList) throws ApisBusinessException {
        if (requestList.size() == 0) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N15001.getValue(), ErrorNullValueCodeEnum.ERR_N15001.getKey());
        }
        for (CommonsExecutorRequestDTO request : requestList) {
            if (!StringUtils.isEmpty((Object)request.getUrl()) && request.getRequest() != null && request.getResponse() != null) continue;
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B110001.getValue(), ErrorBisCodeEnum.ERR_B110001.getKey());
        }
        HashMap future = new HashMap();
        HashMap<String, CommonsExecutorResponseDTO> result = new HashMap<String, CommonsExecutorResponseDTO>();
        for (CommonsExecutorRequestDTO request : requestList) {
            String key = this.getMD5Key(request.getUrl(), JSON.toJSONString((Object)request.getRequest()));
            future.put(key, EXEC.submit(new MyTaskCallable(request.getUrl(), request.getRequest(), request.getResponse())));
        }
        for (CommonsExecutorRequestDTO request : requestList) {
            CommonsExecutorResponseDTO response = new CommonsExecutorResponseDTO();
            String key = this.getMD5Key(request.getUrl(), JSON.toJSONString((Object)request.getRequest()));
            try {
                response.code(Integer.valueOf(0)).data(((Future)future.get(key)).get());
                if (!"riskManageCheck".equals(request.getOptType()) || !(request.getRequest() instanceof StanderRequest)) continue;
                StanderRequest req = (StanderRequest)request.getRequest();
                String riskCode = null;
                try {
                    riskCode = req.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getRiskCode();
                }
                catch (NullPointerException e) {
                    riskCode = null;
                }
                if (!"P070008".equals(riskCode) || !(response.getData() instanceof CommonsValidateResponseDTO)) continue;
                CommonsValidateResponseDTO responseDTO = (CommonsValidateResponseDTO)response.getData();
                if (!ChannelErrorCodeEnum.ERR_C10002.getKey().equals(responseDTO.getCode()) || "P".equals(responseDTO.getProcess())) continue;
                this.dataCompletionUtil.validTrafficItem(req);
            }
            catch (ApisBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("Future\u963b\u585e\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e);
                response.code(Integer.valueOf(-1)).msg(e.toString());
            }
            finally {
                result.put(key, response);
            }
        }
        return result;
    }

    public String getMD5Key(String url, String request) {
        return DigestUtils.md5DigestAsHex((byte[])(url + request).getBytes());
    }
}

