/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpProductMainService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationKindService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.impl.ApisPfpKindClaimExchangeServiceImpl;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsQueryApi;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClaimQueryHandler
implements BusinessHandler {
    @Autowired
    private CoreClaimsQueryApi coreClaimsQueryApi;
    @Autowired
    private ApisPfpProductMainService apisPfpProductMainService;
    @Autowired
    private ApisPfpRationKindService apisPfpRationKindService;
    @Autowired
    ApisPfpKindClaimExchangeServiceImpl apisPfpKindClaimExchangeServiceImpl;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (this.checkRequestHeadBodyIsNull(request)) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        String uuid = cn.hutool.core.lang.UUID.fastUUID().toString().replaceAll("-", "");
        String businessKey = request.getHeader().getBusinessKey();
        request.getHeader().setBusinessKey(ObjectUtil.isNotEmpty((Object)businessKey) ? businessKey : uuid);
        RequestHeadDTO requestHeadDTO = request.getClaimListQueryServiceRequest().getHead();
        requestHeadDTO.setTransDate(new Date());
        if (StringUtils.isBlank((CharSequence)requestHeadDTO.getTransID())) {
            requestHeadDTO.setTransID(UUID.randomUUID().toString().replace("-", ""));
        }
        request.getClaimListQueryServiceRequest().getBody().setUserCode(request.getHeader().getUserCode());
        return this.coreClaimsQueryApi.claimsQuery(request);
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        if (this.checkRequestHeadBodyIsNull(request) || this.checkResponseBodyIsNull(response) || !this.checkResponseHeadSuccess(response)) {
            return response;
        }
        if (!"Y".equalsIgnoreCase(request.getClaimListQueryServiceRequest().getBody().getNotQueryGoodInfoFlag())) {
            List claimList = response.getClaimListQueryResponse().getBody().getClaimInfoList();
            claimList.stream().map(claimListInfo -> {
                List rationMains;
                claimListInfo.setTrackingNumber(claimListInfo.getTrackingNumber() == null ? "" : claimListInfo.getTrackingNumber());
                if (StringUtils.isNotEmpty((CharSequence)claimListInfo.getRiskCode()) && ObjectUtil.isNotEmpty((Object)(rationMains = this.apisPfpProductMainService.getRationNamesByProductCode(claimListInfo.getRiskCode()))) && rationMains.size() > 0) {
                    claimListInfo.setGoodCode(rationMains.stream().map(ApisPfpRationMain::getRationCode).collect(Collectors.toList()));
                    claimListInfo.setGoodName(rationMains.stream().map(ApisPfpRationMain::getRationName).collect(Collectors.toList()));
                }
                return claimListInfo;
            }).collect(Collectors.toList());
        }
        return response;
    }

    private boolean checkRequestHeadBodyIsNull(StanderRequest request) {
        return ObjectUtil.isEmpty((Object)request) || ObjectUtil.isEmpty((Object)request.getClaimListQueryServiceRequest()) || ObjectUtil.isEmpty((Object)request.getClaimListQueryServiceRequest().getHead()) || ObjectUtil.isEmpty((Object)request.getClaimListQueryServiceRequest().getBody());
    }

    private boolean checkResponseBodyIsNull(StanderResponse standerResponse) {
        return standerResponse.getClaimListQueryResponse() == null || standerResponse.getClaimListQueryResponse().getBody() == null;
    }

    private boolean checkResponseHeadSuccess(StanderResponse standerResponse) {
        return standerResponse.getClaimListQueryResponse() != null && standerResponse.getClaimListQueryResponse().getHead() != null && String.valueOf(1).equals(standerResponse.getClaimListQueryResponse().getHead().getResponseCode());
    }

    public boolean hasIntersectionByHashMap(List<String> array1, List<String> array2) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String str : array2) {
            map.put(str, str);
        }
        for (String str : array1) {
            if (map.get(str) == null) continue;
            return true;
        }
        return false;
    }
}

