/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.EPolicyDownServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.DeclarationVoucherRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.DeclarationVoucherRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.GoodDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DeclarationVoucherHandler
implements BusinessHandler {
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    private ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    private EPolicyDownServiceImpl ePolicyDownService;
    private static final String DECLARATION_VOUCHER_REQUEST = "declarationVoucherRequest";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)DECLARATION_VOUCHER_REQUEST);
        if (ObjectUtil.isEmpty((Object)request.getHeader())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "header"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)request.getHeader().getChannelCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "channelCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)request.getHeader().getUserCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "userCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)request.getHeader().getBusinessKey())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "businessKey"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        DeclarationVoucherRequest dvRequest = request.getDeclarationVoucherRequest();
        DeclarationVoucherRequestDTO dvRequestBody = dvRequest.getRequestBody();
        if (ObjectUtil.isEmpty((Object)dvRequestBody.getPolicyNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "policyNo"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)dvRequestBody.getGoodsList())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "goodsList"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)dvRequestBody.getApplicantInformation())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "applicantInformation"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)dvRequestBody.getVoucherInformation())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "voucherInformation"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        for (String[] goodDTO : dvRequestBody.getGoodsList()) {
            if (!ObjectUtil.isEmpty((Object)goodDTO.getGoodsCode())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "goodsCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        String[] policyNos = dvRequestBody.getPolicyNo().split(",");
        if (ObjectUtil.isNotEmpty((Object)policyNos)) {
            for (String policyNo : policyNos) {
                this.dataCompletionUtil.getPolicyDetailWithoutInsureds(request, policyNo, false);
            }
        }
        request.getDeclarationVoucherRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        List rationCodes = dvRequestBody.getGoodsList().stream().map(GoodDTO::getGoodsCode).collect(Collectors.toList());
        List apisPfpRationMainList = this.apisPfpRationMainService.findRationInfoByRationCodes(rationCodes);
        if (ObjectUtil.isEmpty((Object)apisPfpRationMainList)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10656.getValue().replaceFirst("##", Arrays.toString(rationCodes.toArray())), ChannelErrorCodeEnum.ERR_C10656.getKey());
        }
        String errorPlanCodes = "";
        for (GoodDTO goodDTO : dvRequestBody.getGoodsList()) {
            List apisPfpRationMains = apisPfpRationMainList.stream().filter(rationMain -> goodDTO.getGoodsCode().equals(rationMain.getRationCode())).collect(Collectors.toList());
            if (ObjectUtil.isEmpty(apisPfpRationMains)) {
                errorPlanCodes = errorPlanCodes + goodDTO.getPlanCode() + ",";
                continue;
            }
            goodDTO.setPlanCode(((ApisPfpRationMain)apisPfpRationMains.get(0)).getProductCode());
            goodDTO.setPlanName(((ApisPfpRationMain)apisPfpRationMains.get(0)).getProductName());
            goodDTO.setPlanType(((ApisPfpRationMain)apisPfpRationMains.get(0)).getRationType());
            goodDTO.setGoodsCode(((ApisPfpRationMain)apisPfpRationMains.get(0)).getRationCode());
            goodDTO.setGoodsName(((ApisPfpRationMain)apisPfpRationMains.get(0)).getRationName());
        }
        if (ObjectUtil.isNotEmpty((Object)errorPlanCodes)) {
            errorPlanCodes = "[" + errorPlanCodes.substring(0, errorPlanCodes.length() - 1) + "]";
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10656.getValue().replaceFirst("##", errorPlanCodes), ChannelErrorCodeEnum.ERR_C10656.getKey());
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        return this.coreInsureApi.declarationVoucher(request);
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (response == null || response.getDeclarationVoucherResponse() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getKey(), ErrorNullValueCodeEnum.ERR_N00002.getValue());
        }
        if (ObjectUtil.isNotEmpty((Object)response.getDeclarationVoucherResponse().getResponseBody())) {
            response.getDeclarationVoucherResponse().getResponseBody().setVoucherUrl(this.ePolicyDownService.aesEncryptVoucherUrl(response.getDeclarationVoucherResponse().getResponseBody().getVoucherNo(), response.getDeclarationVoucherResponse().getResponseBody().getVoucherUrl()));
        }
        return response;
    }
}

