/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.payment.PaymentGatewayApi;
import com.sinosoft.epay.sdk.EpaySign;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PayContractSendSmsHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(PayContractSendSmsHandler.class);
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    private PaymentGatewayApi paymentGatewayApi;
    @Value(value="${paymentWithHold.privateKey}")
    private String privateKey;
    @Value(value="${paymentWithHold.publicKey}")
    private String publicKey;
    private static final String VERSION = "1.0";
    private static final String SYSTEM_CODE = "01";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.verifyNotNull(request);
        PolicyDTO policyDTO = this.dataCompletionUtil.getPolicyDetailWithoutInsureds(request, request.getPayContractSendSmsRequest().getBody().getPolicyNo(), false);
        this.validFormat(request, policyDTO);
        this.setPayContractSendSmsRequestHead(request);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse response = this.paymentGatewayApi.payContractSendMsg(request);
        return response;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (response.getPayContractSendSmsResponse() == null || response.getPayContractSendSmsResponse().getHead() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getKey(), ErrorNullValueCodeEnum.ERR_N00002.getValue());
        }
        if ((long)CommonConstant.FccbResponseCode.FAIL.intValue() != response.getPayContractSendSmsResponse().getHead().getCode()) {
            log.error("\u8c03\u7528\u901a\u77e5\u6536\u4ed8\u53d1\u8865\u7b7e\u7ea6\u77ed\u4fe1\u63a5\u53e3\u62a5\u9519\uff0c\u4e1a\u52a1\u53f7{},\u9519\u8bef\u4fe1\u606f:{}", (Object)request.getPayContractSendSmsRequest().getBody().getPolicyNo(), (Object)response.getPayContractSendSmsResponse().getHead().getMessage());
            String message = response.getPayContractSendSmsResponse().getHead().getMessage();
            if (StrUtil.isBlank((CharSequence)message)) {
                message = ErrorBisCodeEnum.ERR_B40007.getValue();
            }
            throw new ApisBusinessException(message, ErrorBisCodeEnum.ERR_B40007.getKey());
        }
        return response;
    }

    private void verifyNotNull(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getPayContractSendSmsRequest().getBody())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "body"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)request.getPayContractSendSmsRequest().getBody().getPolicyNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "policyNo"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)request.getPayContractSendSmsRequest().getBody().getAppliName())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "appliName"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)request.getPayContractSendSmsRequest().getBody().getAmount())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "amount"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    private void setPayContractSendSmsRequestHead(StanderRequest request) {
        PaymentGatewayRequestHeadDTO headDTO = PaymentGatewayRequestHeadDTO.builder().msgtype("payContractSendSms").version(VERSION).systemCode(SYSTEM_CODE).timestamp(String.valueOf(DateUtil.current())).sign("").build();
        JSONObject headMap = JSON.parseObject((String)JSON.toJSONString((Object)headDTO));
        JSONObject bodyMap = JSON.parseObject((String)JSON.toJSONString((Object)request.getPayContractSendSmsRequest().getBody()));
        EpaySign epaySignClient = EpaySign.newInstance((String)this.publicKey, (String)this.privateKey, (Boolean)false);
        log.warn("headMap:{}, bodyMap:{}", (Object)headMap, (Object)bodyMap);
        String sign = epaySignClient.requestSign((Map)headMap, (Map)bodyMap);
        log.warn("\u901a\u77e5\u6536\u4ed8\u53d1\u8865\u7b7e\u7ea6\u77ed\u4fe1\u63a5\u53e3,\u8bf7\u6c42\u53c2\u6570sign\uff1a{}", (Object)sign);
        headDTO.setSign(sign);
        request.getPayContractSendSmsRequest().setHead(headDTO);
    }

    private void validFormat(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        String appliName = null;
        if (ObjectUtil.isNotEmpty((Object)policyDTO.getAppliClient())) {
            appliName = ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getInsuredName();
        }
        if (!request.getPayContractSendSmsRequest().getBody().getAppliName().equals(appliName)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10672.getValue().replaceFirst("##", "\u6295\u4fdd\u4eba\u540d\u79f0"), ChannelErrorCodeEnum.ERR_C10672.getKey());
        }
    }
}

