/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.EPolicyDownServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QueryVoucherServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QueryVoucherServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.VoucherInformationDTO;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryVoucherInfomationHandler
implements BusinessHandler {
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    private EPolicyDownServiceImpl ePolicyDownService;
    private static final String QUERY_VOUCHER_SERVICE_REQUEST = "queryVoucherServiceRequest";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)QUERY_VOUCHER_SERVICE_REQUEST);
        QueryVoucherServiceRequest qvRequest = request.getQueryVoucherServiceRequest();
        QueryVoucherServiceRequestDTO qvRequestBody = qvRequest.getRequestBody();
        if (ObjectUtil.isEmpty((Object)qvRequestBody.getVoucherNo()) && ObjectUtil.isEmpty((Object)qvRequestBody.getApplicantInformation()) && (ObjectUtil.isEmpty((Object)qvRequestBody.getStartDate()) || ObjectUtil.isEmpty((Object)qvRequestBody.getEndDate()))) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10655.getValue(), ChannelErrorCodeEnum.ERR_C10655.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)qvRequestBody.getApplicantInformation())) {
            for (AppliClientDTO dto : qvRequestBody.getApplicantInformation()) {
                if (ObjectUtil.isEmpty((Object)dto.getInsuredName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "insuredName"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (ObjectUtil.isEmpty((Object)dto.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "identifyType"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (!ObjectUtil.isEmpty((Object)dto.getIdentifyNumber())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "identifyNumber"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        }
        request.getQueryVoucherServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        return this.coreInsureApi.queryVoucherInformation(request);
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        List voucherInformationDTOList;
        if (response == null || response.getQueryVoucherServiceResponse() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getKey(), ErrorNullValueCodeEnum.ERR_N00002.getValue());
        }
        if (ObjectUtil.isNotEmpty((Object)response.getQueryVoucherServiceResponse().getResponseBody()) && ObjectUtil.isNotEmpty((Object)(voucherInformationDTOList = response.getQueryVoucherServiceResponse().getResponseBody().getVoucherInformation()))) {
            for (VoucherInformationDTO voucherInformationDTO : voucherInformationDTOList) {
                voucherInformationDTO.setVoucherUrl(this.ePolicyDownService.aesEncryptVoucherUrl(voucherInformationDTO.getVoucherNo(), voucherInformationDTO.getVoucherUrl()));
            }
        }
        return response;
    }
}

