/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.RechargePoaResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRechargePoaLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRechargePoaLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class RechargePoaHandler
implements BusinessHandler {
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisChannelUserService apisChannelUserService;
    @Autowired
    private ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    private ApisBusiRechargePoaLogService apisChannelRechargePoaService;
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    RedisTemplate redisTemplate;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        this.defaultValue(request);
        this.isRepeat(request);
        return request;
    }

    private void isRepeat(StanderRequest request) throws ApisDataCompletionException {
        if (this.isNull(request.getRechargePoaRequest().getRechargePoaServerBody().getBusinessNo())) {
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10467.getValue(), ChannelErrorCodeEnum.ERR_C10467.getKey());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"businessNo", (Object)request.getRechargePoaRequest().getRechargePoaServerBody().getBusinessNo())).eq((Object)"deleted", (Object)ApisBusiRechargePoaLog.DELETE_FLAG_FALSE);
        ApisBusiRechargePoaLog apisBusiRechargePoaLog = (ApisBusiRechargePoaLog)this.apisChannelRechargePoaService.getOne((Wrapper)queryWrapper);
        if (!BeanUtil.isEmpty((Object)apisBusiRechargePoaLog, (String[])new String[0])) {
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10469.getValue(), ChannelErrorCodeEnum.ERR_C10469.getKey());
        }
        boolean isSet = this.setRedisKey(request.getRechargePoaRequest().getRechargePoaServerBody().getBusinessNo());
        if (!isSet) {
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10469.getValue(), ChannelErrorCodeEnum.ERR_C10469.getKey());
        }
    }

    private boolean setRedisKey(String key) {
        boolean isSet = this.redisTemplate.opsForValue().setIfAbsent((Object)("recharge:" + key), (Object)1);
        if (isSet) {
            this.redisTemplate.expire((Object)("recharge:" + key), 1L, TimeUnit.MINUTES);
        }
        return isSet;
    }

    private void defaultValue(StanderRequest request) throws ApisDataCompletionException {
        if (!ObjectUtil.isNotEmpty((Object)request.getRechargePoaRequest().getRechargePoaServerBody())) {
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10467.getValue(), ChannelErrorCodeEnum.ERR_C10467.getKey());
        }
        QueryWrapper qwp = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)qwp.eq((Object)"user_code", (Object)request.getHeader().getUserCode())).eq((Object)"config_code", (Object)"channel_recharge")).eq((Object)"deleted", (Object)CommonConstant.DeletedFlag.DELETED_NO);
        ApisChannelConfigs apisChannelConfigs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)qwp);
        if (BeanUtil.isEmpty((Object)apisChannelConfigs, (String[])new String[0])) {
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10468.getValue(), ChannelErrorCodeEnum.ERR_C10468.getKey());
        }
        if (this.isNull(request.getRechargePoaRequest().getRechargePoaServerBody().getAccountCode())) {
            request.getRechargePoaRequest().getRechargePoaServerBody().setAccountCode("111646772");
        }
        request.getRechargePoaRequest().getRechargePoaServerBody().setCurrency("RMB");
        if (this.isNull(request.getRechargePoaRequest().getRechargePoaServerBody().getCustomerName())) {
            throw new ApisDataCompletionException("\u6295\u4fdd\u4eba\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10467.getKey());
        }
        request.getRechargePoaRequest().getRechargePoaServerBody().setOwnerType("0");
        request.getRechargePoaRequest().getRechargePoaServerBody().setOwnerName(request.getRechargePoaRequest().getRechargePoaServerBody().getCustomerName());
        if (this.isNull(request.getRechargePoaRequest().getRechargePoaServerBody().getOwnerType())) {
            request.getRechargePoaRequest().getRechargePoaServerBody().setOwnerType("9");
        }
        if ("9".equals(request.getRechargePoaRequest().getRechargePoaServerBody().getOwnerType())) {
            if (this.isNull(request.getRechargePoaRequest().getRechargePoaServerBody().getAgentShare())) {
                request.getRechargePoaRequest().getRechargePoaServerBody().setAgentShare("1");
            }
            if (this.isNull(request.getRechargePoaRequest().getRechargePoaServerBody().getAccount())) {
                throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10466.getValue(), ChannelErrorCodeEnum.ERR_C10466.getKey());
            }
        } else {
            request.getRechargePoaRequest().getRechargePoaServerBody().setAgentShare("0");
        }
        request.getRechargePoaRequest().getRechargePoaServerBody().setProduct(request.getRechargePoaRequest().getRechargePoaServerBody().getRiskCode());
        QueryWrapper qw = new QueryWrapper();
        ((QueryWrapper)qw.eq((Object)"ration_code", (Object)request.getRechargePoaRequest().getRechargePoaServerBody().getRiskCode())).eq((Object)"deleted", (Object)CommonConstant.DeletedFlag.DELETED_NO);
        ApisPfpRationMain apisPfpRationMain = (ApisPfpRationMain)this.apisPfpRationMainService.list((Wrapper)qw).get(0);
        if (!BeanUtil.isEmpty((Object)apisPfpRationMain, (String[])new String[0])) {
            request.getRechargePoaRequest().getRechargePoaServerBody().setRiskCode(apisPfpRationMain.getProductCode());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"user_code", (Object)request.getRechargePoaRequest().getRechargePoaServerBody().getAccount())).eq((Object)"deleted", (Object)CommonConstant.DeletedFlag.DELETED_NO);
        List apisChannelUserList = this.apisChannelUserService.list((Wrapper)queryWrapper);
        if (apisChannelUserList.size() <= 0) {
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10473.getValue(), ChannelErrorCodeEnum.ERR_C10473.getKey());
        }
        ApisChannelUser apisChannelUser = (ApisChannelUser)apisChannelUserList.get(0);
        if (!BeanUtil.isEmpty((Object)apisChannelUser, (String[])new String[0])) {
            request.getRechargePoaRequest().getRechargePoaServerBody().setAgentName(apisChannelUser.getChannelName());
            request.getRechargePoaRequest().getRechargePoaServerBody().setAgentCode(apisChannelUser.getChannelCode());
            request.getRechargePoaRequest().getRechargePoaServerBody().setCompanyCode(apisChannelUser.getMakeCom());
        }
    }

    private boolean isNull(String value) {
        return value == null || value.length() <= 0;
    }

    public StanderResponse execute(StanderRequest request) {
        StanderResponse response = this.coreInsureApi.rechargePoaQuery(request);
        return response;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (response == null || response.getRechargePoaResponse() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getKey(), ErrorNullValueCodeEnum.ERR_N00002.getValue());
        }
        if (response.getRechargePoaResponse().getResponseVo().getStatus() != CommonConstant.FccbResponseCode.FAIL) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N50001.getKey(), ErrorNullValueCodeEnum.ERR_N50001.getValue());
        }
        response.getRechargePoaResponse().setResponseBody(RechargePoaResponseDTO.builder().agencyCode(request.getRechargePoaRequest().getRechargePoaServerBody().getAgentCode()).transFlowId(request.getRechargePoaRequest().getRequestHead().getConsumerSeqNo()).transAmt(request.getRechargePoaRequest().getRechargePoaServerBody().getAmount()).transType("ID").transDate(request.getRechargePoaRequest().getRequestHead().getTransactionDate()).customerAccount(request.getRechargePoaRequest().getRechargePoaServerBody().getAccount()).userCode(request.getRechargePoaRequest().getRequestHead().getConsumerID()).product(request.getRechargePoaRequest().getRechargePoaServerBody().getProduct()).build());
        ApisBusiRechargePoaLog apisBusiRechargePoaLog = new ApisBusiRechargePoaLog();
        apisBusiRechargePoaLog.setBusinessNo(request.getRechargePoaRequest().getRechargePoaServerBody().getBusinessNo());
        apisBusiRechargePoaLog.setTransFlowId(request.getRechargePoaRequest().getRequestHead().getConsumerSeqNo());
        apisBusiRechargePoaLog.setUser(request.getHeader().getUserCode());
        apisBusiRechargePoaLog.setUserCode(request.getRechargePoaRequest().getRechargePoaServerBody().getAccount());
        this.apisChannelRechargePoaService.save((Object)apisBusiRechargePoaLog);
        return response;
    }
}

