/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.SaveInstallmentPayRecordAndPushUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.InstallmentPayRecordSaveRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelInstallmentOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelInstallmentOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SaveInstallmentPayRecordAndPushHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(SaveInstallmentPayRecordAndPushHandler.class);
    @Autowired
    SaveInstallmentPayRecordAndPushUtil saveInstallmentPayRecordAndPushUtil;
    @Autowired
    ApisBusiChannelInstallmentOrderService apisBusiChannelInstallmentOrderService;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.saveInstallmentPayRecordAndPushUtil.verifyRepeatRequest(request);
        this.saveInstallmentPayRecordAndPushUtil.validateRquest(request);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        InstallmentPayRecordSaveRequestDTO requestBody = request.getInstallmentPayRecordSaveServiceRequest().getRequestBody();
        ApisBusiChannelOrder apisBusiChannelOrder = new ApisBusiChannelOrder();
        apisBusiChannelOrder.setPolicyNo(requestBody.getPolicyNo());
        QueryWrapper queryWrapper = new QueryWrapper((Object)apisBusiChannelOrder);
        ApisBusiChannelOrder busiChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        this.log.warn("\u8ba2\u5355\u8868\u67e5\u8be2\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        if (ObjectUtil.isEmpty((Object)busiChannelOrder) || ObjectUtil.isEmpty((Object)busiChannelOrder.getChannelCode()) || ObjectUtil.isEmpty((Object)busiChannelOrder.getCreator())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10113.getValue(), ChannelErrorCodeEnum.ERR_C10113.getKey());
        }
        ApisBusiChannelInstallmentOrder apisBusiChannelInstallmentOrder = new ApisBusiChannelInstallmentOrder();
        apisBusiChannelInstallmentOrder.setOrderNo(requestBody.getOrderNo());
        QueryWrapper qw = new QueryWrapper((Object)apisBusiChannelInstallmentOrder);
        ApisBusiChannelInstallmentOrder busiChannelInstallmentOrder = (ApisBusiChannelInstallmentOrder)this.apisBusiChannelInstallmentOrderService.getOne((Wrapper)qw);
        this.log.warn("\u6263\u6b3e\u8bb0\u5f55\u67e5\u8be2\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        if (ObjectUtil.isNotEmpty((Object)busiChannelInstallmentOrder)) {
            this.log.warn("policyNO: {}, orderNo: {} \u5df2\u63a5\u6536", (Object)requestBody.getPolicyNo(), (Object)requestBody.getOrderNo());
            this.saveInstallmentPayRecordAndPushUtil.unLock(request);
            return null;
        }
        ApisBusiChannelInstallmentOrder validatorInstallmentOrder = new ApisBusiChannelInstallmentOrder();
        validatorInstallmentOrder.setCurrentPayNo(requestBody.getPayNo());
        validatorInstallmentOrder.setPolicyNo(requestBody.getPolicyNo());
        qw = new QueryWrapper((Object)validatorInstallmentOrder);
        ApisBusiChannelInstallmentOrder busiValidtorChannelInstallmentOrder = (ApisBusiChannelInstallmentOrder)this.apisBusiChannelInstallmentOrderService.getOne((Wrapper)qw);
        this.log.warn("\u6263\u6b3e\u8bb0\u5f55\u7b2c\u4e8c\u6b21\u67e5\u8be2\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        if (ObjectUtil.isNotEmpty((Object)busiValidtorChannelInstallmentOrder)) {
            if (requestBody.getPayAmount().compareTo(busiValidtorChannelInstallmentOrder.getCurrentPremium()) != 0) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10648.getValue(), ChannelErrorCodeEnum.ERR_C10648.getKey());
            }
            if ("SUCCESS".equals(busiValidtorChannelInstallmentOrder.getPayStatus())) {
                this.log.warn("policyNO: {} , payNo: {} \u5df2\u63a5\u6536\uff0c\u4e14\u72b6\u6001\u662f\u652f\u4ed8\u6210\u529f", (Object)requestBody.getPolicyNo(), (Object)requestBody.getPayNo());
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10649.getValue(), ChannelErrorCodeEnum.ERR_C10649.getKey());
            }
            busiValidtorChannelInstallmentOrder.setOrderNo(requestBody.getOrderNo());
            busiValidtorChannelInstallmentOrder.setPayTime(LocalDateTime.ofInstant(requestBody.getPayTime().toInstant(), ZoneId.systemDefault()));
            busiValidtorChannelInstallmentOrder.setPayStatus(requestBody.getPayStatus());
            busiValidtorChannelInstallmentOrder.setPayFailReason(requestBody.getPayFailReason() == null ? "" : requestBody.getPayFailReason());
            this.apisBusiChannelInstallmentOrderService.updateById((Object)busiValidtorChannelInstallmentOrder);
            this.log.warn("\u6263\u6b3e\u8bb0\u5f55\u66f4\u65b01\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            requestBody.setDueDate(Date.from(busiValidtorChannelInstallmentOrder.getDueDate().atZone(ZoneId.systemDefault()).toInstant()));
        } else {
            apisBusiChannelInstallmentOrder.setPolicyNo(requestBody.getPolicyNo());
            apisBusiChannelInstallmentOrder.setCreator(busiChannelOrder.getCreator());
            apisBusiChannelInstallmentOrder.setChannelCode(busiChannelOrder.getChannelCode());
            apisBusiChannelInstallmentOrder.setCurrentPayNo(requestBody.getPayNo());
            apisBusiChannelInstallmentOrder.setCurrentPremium(requestBody.getPayAmount());
            apisBusiChannelInstallmentOrder.setPayTime(LocalDateTime.ofInstant(requestBody.getPayTime().toInstant(), ZoneId.systemDefault()));
            apisBusiChannelInstallmentOrder.setPayStatus(requestBody.getPayStatus());
            apisBusiChannelInstallmentOrder.setPayFailReason(requestBody.getPayFailReason());
            apisBusiChannelInstallmentOrder.setDueDate(LocalDateTime.ofInstant(requestBody.getPayTime().toInstant(), ZoneId.systemDefault()));
            requestBody.setDueDate(requestBody.getPayTime());
            this.apisBusiChannelInstallmentOrderService.save((Object)apisBusiChannelInstallmentOrder);
            this.log.warn("\u6263\u6b3e\u8bb0\u5f55\u66f4\u65b01\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        }
        this.apisBusiTaskLogService.insertTaskInfo(ApisAutoTaskConstantsEnum.INSTALLMENT_PAY_RECORED_TO_AGENT.getValue(), requestBody.getOrderNo());
        this.log.warn("\u5b9a\u65f6\u4efb\u52a1\u8868\u66f4\u65b0\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.saveInstallmentPayRecordAndPushUtil.unLock(request);
        requestBody.setUserCode(busiChannelOrder.getCreator());
        requestBody.setChannelCode(busiChannelOrder.getChannelCode());
        this.saveInstallmentPayRecordAndPushUtil.asyncNotice(requestBody, null);
        return null;
    }
}

