/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PaymentAccountQueryRequestBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PaymentNotifyMessageRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.payment.PaymentAccountQueryResponseVo;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import com.sinosoft.epay.sdk.EpaySign;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class StanderAccountQueryHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderAccountQueryHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    private static String MSG_TYPE = "ddaAccountQuery";
    private static String SYSTEM_CODE = "03";
    private static String VERSION_NO = "1.0";
    @Autowired
    private ApisChannelUserService apisChannelUserService;
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Value(value="${payment.privateKey}")
    private String privateKey;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getHeader().setBusinessKey(UUID.fastUUID().toString().replaceAll("-", ""));
        this.verifyNull(request);
        this.verifyAuthority(request);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        PaymentAccountQueryRequestBodyDTO body = request.getPaymentAccountQueryRequest().getBody();
        PaymentNotifyMessageRequestHeadDTO head = new PaymentNotifyMessageRequestHeadDTO();
        head.setSystemCode(SYSTEM_CODE);
        head.setMsgtype(MSG_TYPE);
        head.setVersion(VERSION_NO);
        head.setTimestamp(String.valueOf(DateUtil.current()));
        request.getPaymentAccountQueryRequest().setHead(head);
        JSONObject headMap = JSON.parseObject((String)JSON.toJSONString((Object)head));
        JSONObject bodyMap = JSON.parseObject((String)JSON.toJSONString((Object)body));
        EpaySign epaySignClient = EpaySign.newInstance(null, (String)this.privateKey, (Boolean)false);
        String content = epaySignClient.requestSign((Map)headMap, (Map)bodyMap);
        head.setSign(content);
        PaymentAccountQueryResponseVo responseVo = this.coreInsureApi.accountQuery(request.getPaymentAccountQueryRequest());
        if (ObjectUtils.isEmpty((Object)responseVo) || ObjectUtils.isEmpty((Object)responseVo.getHead())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorNullValueCodeEnum.ERR_N00002.getKey()).message(ErrorNullValueCodeEnum.ERR_N00002.getValue()).build();
        }
        if (!"0".equals(responseVo.getHead().getCode())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorNullValueCodeEnum.ERR_N80003.getKey()).message(responseVo.getHead().getMessage()).build();
        }
        return StanderResponse.builder().header(request.getHeader()).paymentAccountQueryResponseVo(responseVo).build();
    }

    public void verifyNull(StanderRequest request) throws ApisBusinessException {
        PaymentAccountQueryRequestBodyDTO paymentAccountQueryRequestBodyDTO = request.getPaymentAccountQueryRequest().getBody();
        if (StringUtils.isBlank((CharSequence)paymentAccountQueryRequestBodyDTO.getAccountName())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u6295\u4fdd\u4eba\u59d3\u540d\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)paymentAccountQueryRequestBodyDTO.getIdNumber())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u8bc1\u4ef6\u53f7\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)paymentAccountQueryRequestBodyDTO.getIdType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u8bc1\u4ef6\u7c7b\u578b\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    public void verifyAuthority(StanderRequest request) throws ApisBusinessException {
        String userCode = request.getHeader().getUserCode();
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10145.getKey()).message(ChannelErrorCodeEnum.ERR_C10145.getValue()).build();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)"policy_query_range");
        queryWrapper.eq((Object)"deleted", (Object)CommonConstant.DeletedFlag.DELETED_NO);
        List userAccountList = this.apisChannelConfigsService.list((Wrapper)queryWrapper);
        HashSet<String> userCodeList = new HashSet<String>();
        for (ApisChannelConfigs userAccount : userAccountList) {
            if (userAccount.getUserCode() == null) continue;
            userCodeList.add(userAccount.getUserCode());
        }
        if (userCodeList.contains(userCode)) {
            return;
        }
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setUserCode(userCode);
        apisChannelConfigs.setConfigCode("QueryRightQ009");
        ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        if (channelConfigs != null) {
            ApisChannelUser apisChannelUser = new ApisChannelUser();
            apisChannelUser.setUserCode(userCode);
            QueryWrapper apisChannelUserWrapper = new QueryWrapper((Object)apisChannelUser);
            List channelUserList = this.apisChannelUserService.list((Wrapper)apisChannelUserWrapper);
            if (ObjectUtils.isNotEmpty((Object)channelUserList) && channelConfigs.getConfigValue().equals(((ApisChannelUser)channelUserList.get(0)).getChannelCode())) {
                return;
            }
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10004.getKey()).message(ChannelErrorCodeEnum.ERR_C10004.getValue()).build();
        }
        throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10004.getKey()).message(ChannelErrorCodeEnum.ERR_C10004.getValue()).build();
    }
}

