/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientCheckServiceRequestDto;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CompanyInfoAuditRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.CompanyInfoAuditDto;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.AppliClientCheckServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiReqmsgLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiReqmsgLogService;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.factory.CoreDtoConverterFactory;
import com.jdaz.sinosoftgz.coreapi.common.handler.CoreDtoConverter;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderAppliCheckHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderAppliCheckHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    MediaUploadUtil mediaUploadUtil;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    private ApisBusiReqmsgLogService apisBusiReqmsgLogService;
    @Autowired
    private CoreDtoConverterFactory coreDtoConverterFactory;
    private static final String IMAGE_TYPE_NAME = "|\u6295\u4fdd\u4eba\u8d44\u6599|\u5ba2\u6237\u8eab\u4efd\u8d44\u6599|";
    private static final String IMAGE_TYPE = "|UWA_B|UWA_B01|";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getAppliClientCheckServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        if (request.getAppliClientCheckServiceRequest().getRequestBody() == null) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "body"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        AppliClientCheckServiceRequestDto body = request.getAppliClientCheckServiceRequest().getRequestBody();
        if (StringUtils.isBlank((CharSequence)body.getRegNumber()) && StringUtils.isBlank((CharSequence)body.getVatNumber()) && StringUtils.isBlank((CharSequence)body.getSocialSecurityNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7/\u793e\u4fdd\u4fdd\u9669\u767b\u8bb0\u8bc1\u53f7\u81f3\u5c11\u4e00\u9879"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (body.getImageList() == null || body.getImageList().size() == 0) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "imageList"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)body.getCompanyName())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "companyName"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        AppliClientCheckServiceResponse response = AppliClientCheckServiceResponse.builder().build();
        ApisBusiChannelOrder apisBusinessChannelOrder = new ApisBusiChannelOrder();
        apisBusinessChannelOrder.setRequestTime(LocalDateTime.now());
        apisBusinessChannelOrder.setCreateTime(new Date());
        try {
            apisBusinessChannelOrder.setStatus("01");
            CompanyInfoAuditRequest companyInfoAuditRequest = CompanyInfoAuditRequest.builder().build();
            CompanyInfoAuditDto companyInfoAuditDto = CompanyInfoAuditDto.builder().build();
            BeanUtils.copyProperties((Object)request.getAppliClientCheckServiceRequest().getRequestBody(), (Object)companyInfoAuditDto);
            companyInfoAuditRequest.setRequestHead(request.getAppliClientCheckServiceRequest().getRequestHead());
            companyInfoAuditRequest.setRequestBody(companyInfoAuditDto);
            companyInfoAuditRequest.getRequestHead().setConsumerSeqNo(request.getHeader().getBusinessKey());
            QuotePriceServiceResponse quotePriceServiceResponse = this.coreInsureApi.companyInfoAudit(companyInfoAuditRequest);
            if (quotePriceServiceResponse == null || quotePriceServiceResponse.getResponseHead() == null || quotePriceServiceResponse.getResponseHead().getStatus() == CommonConstant.FccbResponseCode.FAIL.intValue()) {
                if (quotePriceServiceResponse == null || quotePriceServiceResponse.getResponseHead() == null) {
                    throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getValue(), ErrorNullValueCodeEnum.ERR_N00002.getKey());
                }
                throw new ApisBusinessException(quotePriceServiceResponse.getResponseHead().getAppMessage(), quotePriceServiceResponse.getResponseHead().getAppCode());
            }
            String linkNo = "";
            AppliClientCheckServiceRequestDto requestBody = request.getAppliClientCheckServiceRequest().getRequestBody();
            if (StringUtils.isNotBlank((CharSequence)requestBody.getRegNumber())) {
                linkNo = requestBody.getRegNumber();
            } else if (StringUtils.isNotBlank((CharSequence)requestBody.getVatNumber())) {
                linkNo = requestBody.getVatNumber();
            } else if (StringUtils.isNotBlank((CharSequence)requestBody.getSocialSecurityNo())) {
                linkNo = requestBody.getSocialSecurityNo();
            }
            ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = new ImgBatchUploadRequestDTO();
            ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = new ImgBatchUploadServiceRequest();
            imgBatchUploadRequestDTO.setLinkNo(linkNo);
            for (ImgMetaDTO imgMetaDTO : requestBody.getImageList()) {
                imgMetaDTO.setImgTypeName(IMAGE_TYPE_NAME);
                imgMetaDTO.setImgType(IMAGE_TYPE);
            }
            imgBatchUploadRequestDTO.setImgList(requestBody.getImageList());
            imgBatchUploadServiceRequest.setRequestBody(imgBatchUploadRequestDTO);
            imgBatchUploadServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
            request.setImgBatchUploadServiceRequest(imgBatchUploadServiceRequest);
            this.mediaUploadUtil.imgBatchUpload(request);
            apisBusinessChannelOrder.setFinishedTime(LocalDateTime.now());
            this.insertReqMsg(request);
        }
        catch (ApisBusinessException e) {
            apisBusinessChannelOrder.setStatus("00");
            throw e;
        }
        finally {
            apisBusinessChannelOrder.setFinishedTime(LocalDateTime.now());
            Date startDate = new Date();
            this.insertApisBusinessChannelOrderByAppliCheck(request, apisBusinessChannelOrder);
            this.log.warn("\u65b0\u589e\u5ba2\u6237\u5ba1\u6838\u8bb0\u5f55\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
        }
        return StanderResponse.builder().header(request.getHeader()).appliClientCheckServiceResponse(response).build();
    }

    public void insertApisBusinessChannelOrderByAppliCheck(StanderRequest request, ApisBusiChannelOrder apisBusinessChannelOrder) throws ApisBusinessException {
        try {
            apisBusinessChannelOrder.setChannelCode(request.getHeader().getChannelCode());
            apisBusinessChannelOrder.setBusinessKey(request.getAppliClientCheckServiceRequest().getRequestHead().getConsumerSeqNo());
            apisBusinessChannelOrder.setCreator(request.getHeader().getUserCode());
            apisBusinessChannelOrder.setRequestUser(request.getHeader().getOriginUserCode());
            apisBusinessChannelOrder.setOrderNo(request.getHeader().getBusinessKey());
            apisBusinessChannelOrder.setNotifyUrl(request.getAppliClientCheckServiceRequest().getRequestBody().getNotifyUrl());
            this.apisBusiChannelOrderService.save((Object)apisBusinessChannelOrder);
        }
        catch (Exception e) {
            this.log.error("\u65b0\u589e\u5ba2\u6237\u5ba1\u6838\u8bb0\u5f55", (Throwable)e);
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getKey(), ChannelErrorCodeEnum.ERR_C10006.getValue());
        }
    }

    public void insertReqMsg(StanderRequest request) throws ApisBusinessException {
        String orderNo = "";
        try {
            CoreDtoConverter converter = this.coreDtoConverterFactory.get("JSON");
            String api = request.getHeader().getBussinessType();
            String bodyStr = converter.toPacketStr((Object)request.getAppliClientCheckServiceRequest());
            orderNo = request.getHeader().getBusinessKey();
            ApisBusiReqmsgLog apisBusiReqmsgLog = new ApisBusiReqmsgLog();
            apisBusiReqmsgLog.setApiCode(api);
            apisBusiReqmsgLog.setPolicyNo(request.getAppliClientCheckServiceRequest().getRequestHead().getConsumerSeqNo());
            apisBusiReqmsgLog.setLogContent(bodyStr);
            apisBusiReqmsgLog.setOrderNo(orderNo);
            apisBusiReqmsgLog.setLogType("1");
            apisBusiReqmsgLog.setCreator(request.getHeader().getUserCode());
            this.apisBusiReqmsgLogService.save((Object)apisBusiReqmsgLog);
        }
        catch (Exception e) {
            this.log.error("\u8bb0\u5f55\u4f01\u4e1a\u4fe1\u606f\u5ba1\u6838\u65f6\u51fa\u9519\uff0c\u8bf7\u6c42id\uff1a{}", (Object)orderNo, (Object)e);
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
    }
}

