/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.HttpClientJsonUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientCheckNotifyServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientCheckNotifyServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientCheckNotifyServiceRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.AppliClientCheckServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.AppliClientCheckServiceResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiReqmsgLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiReqmsgLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderAppliCheckNotifyHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderAppliCheckNotifyHandler.class);
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    HttpClientJsonUtil httpClientJsonUtil;
    @Autowired
    private ApisBusiReqmsgLogService apisBusiReqmsgLogService;
    @Autowired
    private ApisBusiTaskLogService apisBusiTaskLogService;
    private final String NOTIFY_URL = "notify_url";
    private final String GROUP_NOTIFY = "group_notify";
    private final String ORDER_NO = "order_no";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        AppliClientCheckNotifyServiceRequestHeadDTO headDto = request.getAppliClientCheckNotifyServiceRequest().getHead();
        AppliClientCheckServiceResponseHeadDTO responseHeadDTO = AppliClientCheckServiceResponseHeadDTO.builder().build();
        AppliClientCheckNotifyServiceRequest appliClientCheckNotifyServiceRequest = request.getAppliClientCheckNotifyServiceRequest();
        AppliClientCheckServiceResponse appliClientCheckServiceResponse = AppliClientCheckServiceResponse.builder().head(responseHeadDTO).build();
        String requestType = headDto.getRequestType();
        Map map = this.appliCheckNotifyUrl(request, requestType);
        String notifyUrl = (String)map.get("notify_url");
        String orderNo = (String)map.get("order_no");
        String json = JSON.toJSONString((Object)appliClientCheckNotifyServiceRequest);
        responseHeadDTO.setRequestType(requestType);
        responseHeadDTO.setRequestId(headDto.getRequestId());
        responseHeadDTO.setErrorCode(ChannelErrorCodeEnum.ERR_C10002.getKey());
        responseHeadDTO.setResponseCode("1");
        responseHeadDTO.setErrorMessage(ChannelErrorCodeEnum.ERR_C10002.getValue());
        if ("G000".equals(requestType)) {
            this.log.warn("\u6e20\u9053\u56de\u8c03\u5730\u5740\uff1a{}", (Object)notifyUrl);
            if (StringUtils.isNotBlank((CharSequence)notifyUrl)) {
                try {
                    this.log.warn("\u6e20\u9053\u56de\u8c03\u62a5\u6587\uff1a{}", (Object)json);
                    String resJson = this.httpClientJsonUtil.requestJson(json, notifyUrl);
                    AppliClientCheckNotifyServiceRequest response = (AppliClientCheckNotifyServiceRequest)JSON.parseObject((String)resJson, AppliClientCheckNotifyServiceRequest.class);
                    if (response != null && response.getHead() != null && "1".equals(response.getHead().getResponseCode())) {
                        this.log.warn("\u6e20\u9053\u56de\u8c03\u6210\u529f");
                    }
                }
                catch (Exception e) {
                    this.log.warn("\u56de\u8c03\u6e20\u9053\u5ba1\u6838\u63a5\u53e3\u5931\u8d25\uff1a", (Throwable)e);
                    responseHeadDTO.setErrorCode("F001");
                    responseHeadDTO.setErrorMessage(e.getMessage());
                    responseHeadDTO.setResponseCode("0");
                    this.taskLogSave(appliClientCheckNotifyServiceRequest.getHead().getRequestId(), notifyUrl, json, "\u901a\u77e5\u5931\u8d25");
                }
            }
        } else if ("G004".equals(requestType) && StringUtils.isNotBlank((CharSequence)notifyUrl)) {
            String reqJson = "";
            String status = "60";
            try {
                this.log.warn("\u6e20\u9053\u56de\u8c03\u62a5\u6587\uff1a" + json);
                String fileAddress = appliClientCheckNotifyServiceRequest.getBody().getFileAddress();
                String resJson = this.httpClientJsonUtil.request(fileAddress);
                AppliClientCheckNotifyServiceRequestDTO requestDto = (AppliClientCheckNotifyServiceRequestDTO)JSON.parseObject((String)resJson, AppliClientCheckNotifyServiceRequestDTO.class);
                if (requestDto != null) {
                    requestDto.setBusinessNo(appliClientCheckNotifyServiceRequest.getBody().getAgencyPolicyRef());
                    appliClientCheckNotifyServiceRequest.getBody().setBusinessNo(appliClientCheckNotifyServiceRequest.getBody().getAgencyPolicyRef());
                    appliClientCheckNotifyServiceRequest.getBody().setAgencyPolicyRef(orderNo);
                    appliClientCheckNotifyServiceRequest.getBody().setInsuredPremiumList(requestDto.getInsuredPremiumList());
                }
                reqJson = JSON.toJSONString((Object)appliClientCheckNotifyServiceRequest);
                String jfeeFlag = appliClientCheckNotifyServiceRequest.getBody().getJfeeFlag();
                String prePayFlag = appliClientCheckNotifyServiceRequest.getBody().getPrePayFlag();
                status = "1".equals(prePayFlag) || "0".equals(jfeeFlag) ? "70" : "60";
                this.log.warn("\u6e20\u9053\u56de\u8c03\u63a5\u53e3\u5730\u5740\uff1a{}", (Object)notifyUrl);
                this.log.warn("\u6e20\u9053\u56de\u8c03\u63a5\u53e3\u62a5\u6587\uff1a{}", (Object)reqJson);
                resJson = this.httpClientJsonUtil.requestJson(reqJson, notifyUrl);
                AppliClientCheckNotifyServiceRequest response = (AppliClientCheckNotifyServiceRequest)JSON.parseObject((String)resJson, AppliClientCheckNotifyServiceRequest.class);
                if (response == null || response.getHead() == null || !"1".equals(response.getHead().getResponseCode())) {
                    this.log.warn("\u6e20\u9053\u56de\u8c03\u5931\u8d25");
                    this.taskLogSave(appliClientCheckNotifyServiceRequest.getBody().getAgencyPolicyRef(), notifyUrl, json, "\u901a\u77e5\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.log.error("\u56de\u8c03\u6e20\u9053\u51fa\u5355\u63a5\u53e3\u5931\u8d25\uff1a", (Throwable)e);
                responseHeadDTO.setErrorCode("F001");
                responseHeadDTO.setErrorMessage(e.getMessage());
                responseHeadDTO.setResponseCode("0");
                this.taskLogSave(appliClientCheckNotifyServiceRequest.getBody().getAgencyPolicyRef(), notifyUrl, json, "\u901a\u77e5\u5931\u8d25");
            }
            finally {
                this.motifyLog(appliClientCheckNotifyServiceRequest, reqJson, status);
            }
        }
        return StanderResponse.builder().appliClientCheckServiceResponse(appliClientCheckServiceResponse).build();
    }

    private Map<String, String> appliCheckNotifyUrl(StanderRequest request, String requestType) {
        HashMap<String, String> map = new HashMap<String, String>();
        String orderNo = "";
        QueryWrapper queryWrapper = new QueryWrapper();
        if ("G000".equals(requestType)) {
            orderNo = request.getAppliClientCheckNotifyServiceRequest().getHead().getRequestId();
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
        } else if ("G004".equals(requestType)) {
            orderNo = request.getAppliClientCheckNotifyServiceRequest().getBody().getAgencyPolicyRef();
            queryWrapper.eq((Object)"policy_no", (Object)orderNo);
        }
        List list = this.apisBusiChannelOrderService.list((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)list) && list.size() > 0) {
            map.put("notify_url", ((ApisBusiChannelOrder)list.get(0)).getNotifyUrl());
            map.put("order_no", ((ApisBusiChannelOrder)list.get(0)).getOrderNo());
            return map;
        }
        return null;
    }

    public void motifyLog(AppliClientCheckNotifyServiceRequest request, String resJson, String status) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String policyNo = request.getBody().getBusinessNo();
        queryWrapper.eq((Object)"policy_no", (Object)policyNo);
        List list = this.apisBusiChannelOrderService.list((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)list) && list.size() > 0) {
            ApisBusiReqmsgLog apisBusiReqmsgLog = new ApisBusiReqmsgLog();
            apisBusiReqmsgLog.setApiCode("notifyAgent");
            apisBusiReqmsgLog.setPolicyNo(policyNo);
            apisBusiReqmsgLog.setLogContent(resJson);
            apisBusiReqmsgLog.setOrderNo(((ApisBusiChannelOrder)list.get(0)).getOrderNo());
            apisBusiReqmsgLog.setLogType("1");
            apisBusiReqmsgLog.setCreator(((ApisBusiChannelOrder)list.get(0)).getCreator());
            this.apisBusiReqmsgLogService.save((Object)apisBusiReqmsgLog);
            ApisBusiChannelOrder apisBusiChannelOrder = (ApisBusiChannelOrder)list.get(0);
            apisBusiChannelOrder.setStatus(status);
            this.apisBusiChannelOrderService.updateById((Object)apisBusiChannelOrder);
        }
    }

    public void taskLogSave(String businessKey, String requestString, String url, String errMsg) {
        if (StringUtils.isEmpty((CharSequence)businessKey)) {
            businessKey = "\u9ed8\u8ba4";
        }
        ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
        apisBusiTaskLog.setPushType("group_notify");
        apisBusiTaskLog.setBusinessKey(businessKey);
        apisBusiTaskLog.setRemark("\u8ba2\u5355\u53f7\uff1a" + businessKey);
        apisBusiTaskLog.setPushStep(Integer.valueOf(1));
        apisBusiTaskLog.setPushContent(requestString);
        apisBusiTaskLog.setPushTargetUrl(url);
        apisBusiTaskLog.setLastPushTime(LocalDateTime.now());
        apisBusiTaskLog.setErrMsg(errMsg);
        this.log.warn("notify\u56de\u8c03\u6267\u884c\u5931\u8d25");
        apisBusiTaskLog.setPushStatus("4");
        this.apisBusiTaskLogService.saveOrUpdate((Object)apisBusiTaskLog);
    }
}

