/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CommonsValidateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.AsyncQuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BusinessUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiAsyncOrderMqLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiAsyncOrderMqLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import com.sinosoftgz.starter.rocketmq.utils.RocketMqUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderAsyncQuotePriceHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderAsyncQuotePriceHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    AsyncQuotePriceValidate asyncQuotePriceValidate;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    RocketMqUtils rocketMqUtils;
    private final String REQUEST_ENTITY_QUOTEPRICE = "quotePriceServiceRequest";
    private static String MESSAGE_DESTINATION = "apis-async-quotePrice:quotePrice";
    @Autowired
    ApisBusiAsyncOrderMqLogService apisBusiAsyncOrderMqLogService;
    @Autowired
    BusinessUtils businessUtils;
    @Autowired
    private CommonsValidateUtil commonsValidateUtil;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        TimeInterval totalTimer = DateUtil.timer();
        request.getQuotePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        String originMessage = JSON.toJSONString((Object)request);
        request.getQuotePriceServiceRequest().getRequestBody().setAsyncOriginRequest(originMessage);
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"quotePriceServiceRequest");
        this.dataCompletionUtil.verifyRepeatRequest(request);
        this.dataCompletionUtil.dataCompletion(request);
        this.log.warn("\u6570\u636e\u8865\u5168\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.asyncQuotePriceValidate.validateRequest(request);
        this.log.warn("\u5f02\u6b65\u51fa\u5355\u89c4\u5219\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.dataCompletionUtil.settleInsuredFlag(request);
        this.dataCompletionUtil.calculateTotalPremium(request);
        this.log.warn("\u4fdd\u8d39\u8ba1\u7b97\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().setPlanList(null);
        this.dataCompletionUtil.riskDataCompletion(request);
        this.dataCompletionUtil.fxqDataCompletion(request);
        this.commonsValidateUtil.executorValidate(request, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        this.log.warn("\u5f02\u6b65\uff0cdataCompletion\u7528\u65f6 :{}", (Object)totalTimer.intervalRestart());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        TimeInterval totalTimer = DateUtil.timer();
        String businessNo = this.businessUtils.getBusinessNo(request);
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setPolicyRef(businessNo);
        this.dataCompletionUtil.unLock(request);
        Boolean executeFlag = this.sendMessage(request);
        StanderResponse response = null;
        if (!executeFlag.booleanValue()) {
            throw new ApisBusinessException("\u5f02\u6b65\u8ba2\u5355\u6d88\u606f\u53d1\u9001\u5931\u8d25", ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
        response = this.packageResponse(businessNo, request);
        this.saveSuccessMQLog(request, response);
        this.log.warn("\u5f02\u6b65\uff0cexecute\u7528\u65f6 :{}", (Object)totalTimer.intervalRestart());
        return response;
    }

    private StanderResponse packageResponse(String businessNo, StanderRequest request) {
        TimeInterval totalTimer = DateUtil.timer();
        QuotePriceServiceResponse quotePriceServiceResponse = QuotePriceServiceResponse.builder().build();
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
        responseHeadDTO.setConsumerSeqNo(request.getQuotePriceServiceRequest().getRequestHead().getConsumerSeqNo());
        QuotePriceServiceResponseDTO responseBody = QuotePriceServiceResponseDTO.builder().build();
        responseBody.setBusinessNo(businessNo);
        responseBody.setPolicyStatus("70");
        responseBody.setTotalPremium(quotePriceDTO.getMain().getSumPremium());
        responseBody.setAgencyPolicyRef(quotePriceDTO.getMain().getOrderNo());
        responseBody.setEffectiveDate(quotePriceDTO.getMain().getStartDate());
        responseBody.setExpireDate(quotePriceDTO.getMain().getEndDate());
        responseBody.setInsuredPremiumList(this.dataCompletionUtil.packagedInsuredPremiumList(request));
        quotePriceServiceResponse.setResponseHead(responseHeadDTO);
        quotePriceServiceResponse.setResponseBody(responseBody);
        this.log.warn("\u5f02\u6b65\uff0cpackageResponse :{}", (Object)totalTimer.intervalRestart());
        return StanderResponse.builder().header(request.getHeader()).quotePriceServiceResponse(quotePriceServiceResponse).build();
    }

    private Boolean sendMessage(StanderRequest standerRequest) {
        Boolean sendFlag = false;
        try {
            StanderRequest sr = (StanderRequest)JSON.parseObject((String)standerRequest.getQuotePriceServiceRequest().getRequestBody().getAsyncOriginRequest(), StanderRequest.class);
            sr.getQuotePriceServiceRequest().getRequestBody().setAsyncFlag(Boolean.valueOf(true));
            String policyRef = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyRef();
            sr.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setPolicyRef(policyRef);
            String message = JSON.toJSONString((Object)sr);
            String destination = MESSAGE_DESTINATION;
            SendResult sendResult = this.rocketMqUtils.syncSendQueue(destination, (Object)message);
            if (SendStatus.SEND_OK == sendResult.getSendStatus()) {
                this.log.warn("MQ\u6d88\u606f\u53d1\u9001\u6210\u529f\uff0c\u751f\u6210\u4fdd\u5355\u53f7\uff1a{}\uff01", (Object)policyRef);
                sendFlag = true;
            }
        }
        catch (Exception e) {
            sendFlag = false;
            this.log.error("error:", (Throwable)e);
        }
        return sendFlag;
    }

    private void saveSuccessMQLog(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        try {
            String policyNo = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyRef();
            String orderNo = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo();
            String status = ApisBusiAsyncOrderMqLog.MESSAGE_STATUS_SEND_OK;
            String requestContent = request.getQuotePriceServiceRequest().getRequestBody().getAsyncOriginRequest();
            String responseContent = JSON.toJSONString((Object)response.getQuotePriceServiceResponse());
            ApisBusiAsyncOrderMqLog apisBusiAsyncOrderMqLog = new ApisBusiAsyncOrderMqLog();
            apisBusiAsyncOrderMqLog.setCreator(request.getHeader().getUserCode());
            apisBusiAsyncOrderMqLog.setPolicyNo(policyNo);
            apisBusiAsyncOrderMqLog.setOrderNo(orderNo);
            apisBusiAsyncOrderMqLog.setStatus(status);
            apisBusiAsyncOrderMqLog.setRequestContent(requestContent);
            apisBusiAsyncOrderMqLog.setResponseContent(responseContent);
            this.apisBusiAsyncOrderMqLogService.save((Object)apisBusiAsyncOrderMqLog);
        }
        catch (Exception e) {
            throw new ApisBusinessException("\u8bb0\u5f55\u5f02\u6b65\u751f\u6210\u4fdd\u5355\u6d88\u606f\u5f02\u5e38", ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
    }
}

