/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.AuthorizePlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.AuthorizePlanQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.AuthorizePlanQueryResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelProduct;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelProductService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationMainMapper;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.sql.Date;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StanderAuthorizePlanQueryHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderAuthorizePlanQueryHandler.class);
    @Autowired
    ApisChannelProductService apisChannelProductService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisPfpRationMainMapper apisPfpRationMainMapper;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisChannelUserService apisChannelUserService;
    private static final String TYPE_OF_PLAN = "All";
    private static final String[] PRODUCT_CODE = new String[]{"P070002", "P070006", "P070001", "P070007", "P070003", "P070004", "P090001", "P010090"};
    private static final String AUTHORIZE_PLAN_QUERY_REQUEST = "authorizePlanQueryRequest";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getAuthorizePlanQueryRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        request.getHeader().setBusinessKey(UUID.fastUUID().toString().replaceAll("-", ""));
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)AUTHORIZE_PLAN_QUERY_REQUEST);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        List planCodeList = this.findAuthorizePlanCodeList(request);
        AuthorizePlanQueryResponse authorizePlanQueryResponse = null;
        if (ObjectUtils.isNotEmpty((Object)planCodeList) && planCodeList.size() > 0) {
            List rationMainList = this.apisPfpRationMainMapper.findRationInfoByRationCodes(planCodeList);
            authorizePlanQueryResponse = this.covertInfo(request, rationMainList);
        } else {
            authorizePlanQueryResponse = this.covertInfo(request, null);
        }
        return StanderResponse.builder().header(request.getHeader()).authorizePlanQueryResponse(authorizePlanQueryResponse).build();
    }

    public List<String> findAuthorizePlanCodeList(StanderRequest request) throws ApisDataCompletionException {
        ArrayList<String> planCodeList = new ArrayList<String>();
        String userCode = request.getHeader().getUserCode();
        ApisChannelUser apisChannelUser = new ApisChannelUser();
        apisChannelUser.setUserCode(userCode);
        apisChannelUser.setDeleted(Integer.valueOf(0));
        QueryWrapper userWrapper = new QueryWrapper((Object)apisChannelUser);
        apisChannelUser = (ApisChannelUser)this.apisChannelUserService.getOne((Wrapper)userWrapper, false);
        if (ObjectUtils.isNotEmpty((Object)apisChannelUser)) {
            String productCode = request.getAuthorizePlanQueryRequest().getRequestBody().getTypeOfPlan();
            String covertProductCode = "";
            ApisChannelProduct apisChannelProduct = new ApisChannelProduct();
            apisChannelProduct.setChannelCode(apisChannelUser.getChannelCode());
            QueryWrapper queryWrapper = null;
            if (!TYPE_OF_PLAN.equals(productCode)) {
                covertProductCode = this.dataCompletionUtil.convertCode("riskType", productCode);
                if (ObjectUtils.isEmpty((Object)covertProductCode) || !Arrays.asList(PRODUCT_CODE).contains(covertProductCode)) {
                    throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10484.getValue(), ChannelErrorCodeEnum.ERR_C10484.getKey());
                }
                apisChannelProduct.setProductCode(covertProductCode);
                queryWrapper = new QueryWrapper((Object)apisChannelProduct);
            } else {
                queryWrapper = new QueryWrapper((Object)apisChannelProduct);
                queryWrapper.in((Object)"product_code", Arrays.asList(PRODUCT_CODE));
            }
            List list = this.apisChannelProductService.list((Wrapper)queryWrapper);
            for (ApisChannelProduct acpt : list) {
                planCodeList.add(acpt.getPlanCode());
            }
            return planCodeList;
        }
        return null;
    }

    public AuthorizePlanQueryResponse covertInfo(StanderRequest request, List<ApisPfpRationMain> rationMainList) {
        AuthorizePlanQueryResponse authorizePlanQueryResponse = AuthorizePlanQueryResponse.builder().build();
        ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
        responseHeadDTO.setConsumerSeqNo(request.getAuthorizePlanQueryRequest().getRequestHead().getConsumerSeqNo());
        responseHeadDTO.setProviderSeqNo(UUID.fastUUID().toString().replaceAll("-", ""));
        if (ObjectUtils.isNotEmpty(rationMainList) && rationMainList.size() > 0) {
            responseHeadDTO.setAppCode(ChannelErrorCodeEnum.ERR_C10002.getKey());
            responseHeadDTO.setStatus(CommonConstant.FccbResponseCode.SUCCESS.intValue());
            responseHeadDTO.setAppMessage(ChannelErrorCodeEnum.ERR_C10002.getValue());
        } else {
            responseHeadDTO.setStatus(CommonConstant.FccbResponseCode.FAIL.intValue());
            responseHeadDTO.setAppCode(ChannelErrorCodeEnum.ERR_C10014.getKey());
            responseHeadDTO.setAppMessage(ChannelErrorCodeEnum.ERR_C10014.getValue());
        }
        authorizePlanQueryResponse.setResponseHead(responseHeadDTO);
        if (1 == responseHeadDTO.getStatus()) {
            ArrayList<AuthorizePlanDTO> authorizedPlanList = new ArrayList<AuthorizePlanDTO>();
            for (ApisPfpRationMain apisPfpRationMain : rationMainList) {
                AuthorizePlanDTO authorizePlanDTO = AuthorizePlanDTO.builder().build();
                authorizePlanDTO.setPlanCode(apisPfpRationMain.getRationCode());
                authorizePlanDTO.setPlanNameZhs(apisPfpRationMain.getRationName());
                authorizePlanDTO.setPlanNameEn(apisPfpRationMain.getRationEname() == null ? "" : apisPfpRationMain.getRationEname());
                authorizePlanDTO.setPlanStatus(apisPfpRationMain.getValidStatus());
                authorizePlanDTO.setEffectiveDate(Date.from(apisPfpRationMain.getValidDate().atZone(ZoneId.systemDefault()).toInstant()));
                authorizePlanDTO.setExpireDate(Date.from(apisPfpRationMain.getInvalidDate().atZone(ZoneId.systemDefault()).toInstant()));
                authorizedPlanList.add(authorizePlanDTO);
            }
            AuthorizePlanQueryResponseDTO authorizePlanQueryResponseDTO = AuthorizePlanQueryResponseDTO.builder().authorizedPlanList(authorizedPlanList).build();
            authorizePlanQueryResponse.setResponseBody(authorizePlanQueryResponseDTO);
        }
        return authorizePlanQueryResponse;
    }
}

