/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.PushToAgentUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.BasicsPolicyModifyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.BasicsPolicyModifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwResultMsgDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.BasicsPolicyModifyResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderBasicsPolicyModifyHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderBasicsPolicyModifyHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    PushToAgentUtil pushToAgentUtil;
    private static String BUSS_TYPE_E = "E";
    private static final String SUCCESS_FLAG = "00";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getBasicsPolicyModifyRequest())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorNullValueCodeEnum.ERR_N00001.getKey()).message(ErrorNullValueCodeEnum.ERR_N00001.getValue()).build();
        }
        request.getBasicsPolicyModifyRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        this.requestCheck(request);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse response = this.coreInsureApi.basicsPolicyModify(request);
        return response;
    }

    private void requestCheck(StanderRequest request) throws ApisBusinessException {
        HashMap<String, String> map1 = new HashMap<String, String>(16);
        map1.put("requestHead", "\u8bf7\u6c42\u5934");
        map1.put("requestBody", "\u8bf7\u6c42\u4f53");
        BasicsPolicyModifyRequest basicsPolicyModifyRequest = request.getBasicsPolicyModifyRequest();
        BaseApisParamUtil.checkFieldThrowExp((Object)basicsPolicyModifyRequest, map1, (ErrorCode)ErrorNullValueCodeEnum.ERR_N50001);
        HashMap<String, String> map2 = new HashMap<String, String>(16);
        map2.put("policyNo", "\u4fdd\u5355\u53f7");
        map2.put("basicsPolicyModify", "\u57fa\u7840\u4fdd\u5355\u4fe1\u606f");
        BaseApisParamUtil.checkFieldThrowExp((Object)basicsPolicyModifyRequest.getRequestBody(), map2, (ErrorCode)ErrorNullValueCodeEnum.ERR_N50001);
        List policyModifyDTOList = request.getBasicsPolicyModifyRequest().getRequestBody().getBasicsPolicy();
        HashMap<String, String> map3 = new HashMap<String, String>(16);
        map3.put("serialNo", "\u88ab\u4fdd\u9669\u4eba\u5e8f\u53f7");
        map3.put("insuredName", "\u88ab\u4fdd\u4eba\u540d\u79f0");
        map3.put("identifyType", "\u88ab\u4fdd\u4eba\u8bc1\u4ef6\u7c7b\u578b");
        map3.put("identifyNumber", "\u88ab\u4fdd\u4eba\u8bc1\u4ef6\u53f7\u7801");
        for (BasicsPolicyModifyDTO basicsPolicyModifyDTO : policyModifyDTOList) {
            BaseApisParamUtil.checkFieldThrowExp((Object)basicsPolicyModifyDTO, map3, (ErrorCode)ErrorNullValueCodeEnum.ERR_N50001);
        }
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (response == null || response.getBasicsPolicyModifyResponse() == null || response.getBasicsPolicyModifyResponse().getResponseBody() == null || response.getBasicsPolicyModifyResponse().getResponseHead() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getValue(), ErrorNullValueCodeEnum.ERR_N00002.getKey());
        }
        ResponseHeadDTO responseHeadDTO = response.getBasicsPolicyModifyResponse().getResponseHead();
        if (!SUCCESS_FLAG.equals(responseHeadDTO.getAppCode())) {
            throw new ApisBusinessException(responseHeadDTO.getAppMessage(), ChannelErrorCodeEnum.ERR_C10750.getKey());
        }
        BasicsPolicyModifyResponseDTO policyModifyResponseDTO = response.getBasicsPolicyModifyResponse().getResponseBody();
        String reqPolicyNo = request.getBasicsPolicyModifyRequest().getRequestBody().getPolicyNo();
        String respPolicyNo = policyModifyResponseDTO.getPolicyNo();
        String policyNo = ObjectUtil.isEmpty((Object)respPolicyNo) ? reqPolicyNo : respPolicyNo;
        log.warn("\u7559\u5b66\u751f\u533b\u7597\u9669\u88ab\u4fdd\u4eba\u57fa\u7840\u4fdd\u5355\u4fe1\u606f\u4fee\u6539\u6210\u529f\uff0c\u63a8\u9001\u6700\u65b0\u4fdd\u5355\u4fe1\u606f\u7ed9\u6e20\u9053\uff0c\u4fdd\u5355\u53f7\uff1a{}", (Object)policyNo);
        LitigationUwResultMsgDTO msgDTO = LitigationUwResultMsgDTO.builder().policyNo(policyNo).msgType(BUSS_TYPE_E).endorseType("12").build();
        this.pushToAgentUtil.pushPolicyDetailToAgent(msgDTO);
        return response;
    }
}

