/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.BasicsPolicyQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StanderBasicsPolicyQueryHandler
implements BusinessHandler {
    @Autowired
    CoreInsureApi coreInsureApi;
    private static final String SUCCESS_FLAG = "00";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getBasicsPolicyQueryRequest())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorNullValueCodeEnum.ERR_N00001.getKey()).message(ErrorNullValueCodeEnum.ERR_N00001.getValue()).build();
        }
        request.getBasicsPolicyQueryRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        this.requestCheck(request);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse response = this.coreInsureApi.basicsPolicyQuery(request);
        return response;
    }

    private void requestCheck(StanderRequest request) throws ApisBusinessException {
        HashMap<String, String> map1 = new HashMap<String, String>(8);
        map1.put("requestHead", "\u8bf7\u6c42\u5934");
        map1.put("requestBody", "\u8bf7\u6c42\u4f53");
        BasicsPolicyQueryRequest basicsPolicyQueryRequest = request.getBasicsPolicyQueryRequest();
        BaseApisParamUtil.checkFieldThrowExp((Object)basicsPolicyQueryRequest, map1, (ErrorCode)ErrorNullValueCodeEnum.ERR_N50001);
        HashMap<String, String> map2 = new HashMap<String, String>(8);
        map2.put("policyNo", "\u4fdd\u5355\u53f7");
        BaseApisParamUtil.checkFieldThrowExp((Object)basicsPolicyQueryRequest.getRequestBody(), map2, (ErrorCode)ErrorNullValueCodeEnum.ERR_N50001);
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (response == null || response.getBasicsPolicyQueryResponse() == null || response.getBasicsPolicyQueryResponse().getResponseHead() == null || response.getBasicsPolicyQueryResponse().getResponseBody() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getValue(), ErrorNullValueCodeEnum.ERR_N00002.getKey());
        }
        ResponseHeadDTO responseHeadDTO = response.getBasicsPolicyQueryResponse().getResponseHead();
        if (!SUCCESS_FLAG.equals(responseHeadDTO.getAppCode())) {
            throw new ApisBusinessException(responseHeadDTO.getAppMessage(), ChannelErrorCodeEnum.ERR_C10751.getKey());
        }
        if (ObjectUtil.isEmpty((Object)response.getBasicsPolicyQueryResponse().getResponseBody().getBasicsPolicy())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10014.getValue(), ChannelErrorCodeEnum.ERR_C10014.getKey());
        }
        return response;
    }
}

