/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceRulerUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ShortRateCalculateUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CalculateObjectDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CoverageDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.GroupPlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemCargoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemFamilyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PayPlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CalculateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredPremiumDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationPaymentPlan;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationPaymentPlanService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StanderCalculateHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(StanderCalculateHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    QuotePriceRulerUtil quotePriceRulerUtil;
    @Autowired
    ShortRateCalculateUtil shortRateCalculateUtil;
    @Autowired
    private ApisPfpRationPaymentPlanService apisPfpRationPaymentPlanService;
    public static final String RATION_RATE_TYPE_KIND_FACTORY = "02";
    public static final String RATION_RATE_TYPE_RULE = "03";
    public static final String SHORT_RATE_TYPE_RULE = "04";
    private static final String POLICY_CALCULATE_SERVICE_REQUEST = "policyCalculateServiceRequest";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        String uuid = UUID.fastUUID().toString().replaceAll("-", "");
        String businessKey = request.getHeader().getBusinessKey();
        request.getHeader().setBusinessKey(ObjectUtil.isNotEmpty((Object)businessKey) ? businessKey : uuid);
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)POLICY_CALCULATE_SERVICE_REQUEST);
        request.getPolicyCalculateServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        QuotePriceDTO quotePriceDTO = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
        List planList = quotePriceDTO.getPlanList();
        if (ObjectUtil.isNotEmpty((Object)planList)) {
            this.dataCompletionUtil.verifyRequestByList(request);
        } else {
            this.calculateCompletion(request);
            this.dataCompletionUtil.verifyRequestBySingle(request);
        }
        return request;
    }

    private void calculateCompletion(StanderRequest request) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
        QuotePriceServiceRequest quotePriceServiceRequest = QuotePriceServiceRequest.builder().build();
        quotePriceServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        if (!ObjectUtil.isNotEmpty((Object)quotePriceDTO.getCoverage()) || !ObjectUtil.isNotEmpty((Object)quotePriceDTO.getCoverage().getItemList()) || quotePriceDTO.getCoverage().getItemList().size() <= 0) {
            ArrayList<ItemMainDTO> itemList = new ArrayList<ItemMainDTO>();
            ItemMainDTO itemMainDTO = ItemMainDTO.builder().goodsCode(quotePriceDTO.getPlanCode()).build();
            itemList.add(itemMainDTO);
            quotePriceDTO.setCoverage(CoverageDTO.builder().itemList(itemList).build());
        }
        quotePriceServiceRequest.setRequestBody(QuotePriceServiceRequestDTO.builder().quotePrice(quotePriceDTO).build());
        quotePriceServiceRequest.getRequestBody().setIsOptional(request.getPolicyCalculateServiceRequest().getRequestBody().getIsOptional());
        request.setQuotePriceServiceRequest(quotePriceServiceRequest);
        this.dataCompletionUtil.dataCompletion(request);
        BeanUtils.copyProperties((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice(), (Object)quotePriceDTO);
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        List calList = new ArrayList();
        QuotePriceDTO quotePrice = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
        List planList = quotePrice.getPlanList();
        long start = System.currentTimeMillis();
        String riskCode = quotePrice.getMain().getRiskCode();
        if (null != planList && planList.size() > 0) {
            calList = this.assembleObjectByList(request);
        } else {
            ApisPfpRationMain rationMainInfo = this.dataCompletionUtil.getApisPfpRationMainInfo(quotePrice.getPlanCode(), "2");
            if (RATION_RATE_TYPE_KIND_FACTORY.equals(rationMainInfo.getRationRateType())) {
                String methodType = this.dataCompletionUtil.queryCalcType(quotePrice.getPlanCode());
                if (this.dataCompletionUtil.verifyPet(request)) {
                    calList = this.assembleObjectByPet(request, methodType);
                } else if ("96".equals(methodType)) {
                    calList = this.assembleObjectByFreight(request, methodType);
                } else {
                    if ("97".equals(methodType)) {
                        calList = this.assembleObjectByLawsuit(request, methodType);
                        return this.coreInsureApi.policyCalculateByLawsuit(request, calList);
                    }
                    if ("HY-GN- LAND-7D-WBHW-2C".equals(quotePrice.getPlanCode())) {
                        calList = this.assembleObjectByHy(request);
                        return this.coreInsureApi.policyCalculateByHy(request, calList);
                    }
                    calList = RiskCodeEnum.RISK_0015.getCode().equals(riskCode) ? this.assembleObjectByLiab(request) : this.assembleObjectBySingle(request);
                }
            } else {
                if (RATION_RATE_TYPE_RULE.equals(rationMainInfo.getRationRateType())) {
                    return this.quotePriceRulerUtil.execute(request, "T");
                }
                if (SHORT_RATE_TYPE_RULE.equals(rationMainInfo.getRationRateType())) {
                    return this.shortRateCalculateUtil.calculate(request);
                }
            }
        }
        log.warn("\u4fdd\u8d39\u8ba1\u7b97-\u53c2\u6570\u7ec4\u88c5\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        StanderResponse standerResponse = this.coreInsureApi.policyCalculate(calList);
        HashMap planDisCountMap = this.dataCompletionUtil.findPlanDiscountMap(request.getHeader().getUserCode(), quotePrice.getMain().getInputDate());
        List insuredPremiumList = standerResponse.getCalculateResponse().getResponseBody().getInsuredPremiumList();
        if (ObjectUtil.isNotEmpty((Object)insuredPremiumList) && ObjectUtil.isNotEmpty((Object)planDisCountMap) && this.setItemKindDisCount(planDisCountMap, quotePrice.getCoverage().getItemList()).booleanValue()) {
            Double totalPremium = BigDecimal.ZERO.doubleValue();
            for (InsuredPremiumDTO insuredPremiumDTO : insuredPremiumList) {
                if (planDisCountMap.containsKey(insuredPremiumDTO.getGoodCode())) {
                    insuredPremiumDTO.setPremium(Double.valueOf(new BigDecimal(insuredPremiumDTO.getPremium()).multiply((BigDecimal)planDisCountMap.get(insuredPremiumDTO.getGoodCode())).setScale(0, 4).doubleValue()));
                }
                log.warn("\u4fdd\u8d39\u8ba1\u7b97\uff0c\u8be5\u88ab\u4fdd\u4eba\u4fdd\u8d39\u4e3a\uff1a{}", (Object)insuredPremiumDTO.getPremium());
                totalPremium = totalPremium + insuredPremiumDTO.getPremium();
            }
            log.warn("\u4fdd\u8d39\u8ba1\u7b97\u5408\u8ba1\u4fdd\u8d39\u4e3a\uff1a{}", (Object)totalPremium);
            standerResponse.getCalculateResponse().getResponseBody().setTotalPremium(Double.valueOf(new BigDecimal(totalPremium).setScale(0, 4).doubleValue()));
            log.warn("\u4fdd\u8d39\u8ba1\u7b97\uff0c\u8f6c\u6362\u540e\u4fdd\u8d39\u4e3a\uff1a{}", (Object)standerResponse.getCalculateResponse().getResponseBody().getTotalPremium());
        }
        log.warn("\u4fdd\u8d39\u8ba1\u7b97-\u603b\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return standerResponse;
    }

    private Boolean setItemKindDisCount(HashMap<String, BigDecimal> planDisCountMap, List<ItemMainDTO> itemList) {
        Boolean disCountPolicy = false;
        if (ObjectUtil.isEmpty(itemList)) {
            return disCountPolicy;
        }
        for (ItemMainDTO itemMainDTO : itemList) {
            if (!planDisCountMap.containsKey(itemMainDTO.getGoodsCode())) continue;
            for (ItemKindDTO itemKind : itemMainDTO.getItemKind()) {
                disCountPolicy = true;
                itemKind.setDisCount(Double.valueOf(planDisCountMap.get(itemMainDTO.getGoodsCode()).doubleValue()));
            }
        }
        return disCountPolicy;
    }

    private List<CalculateObjectDTO> assembleObjectBySingle(StanderRequest request) throws ApisBusinessException {
        QuotePriceDTO quotePrice = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
        RequestHeadDTO requestHead = request.getPolicyCalculateServiceRequest().getRequestHead();
        List insuredListReq = quotePrice.getInsuredList();
        this.dataCompletionUtil.checkInsuredInfo(request);
        InsuredDTO insuredDTO = null;
        ArrayList<CalculateObjectDTO> calList = new ArrayList<CalculateObjectDTO>();
        Date startDate = quotePrice.getMain().getStartDate();
        Date endDate = quotePrice.getMain().getEndDate();
        int days = DataCompletionUtil.betweenDays((Date)startDate, (Date)endDate, (boolean)true);
        int index = 0;
        for (int i = 0; i < insuredListReq.size(); ++i) {
            int akIndex = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().size() > 1 ? index : 0;
            String goodsCode = ((ItemMainDTO)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(akIndex)).getGoodsCode();
            String methodType = this.dataCompletionUtil.queryCalcType(goodsCode);
            insuredDTO = (InsuredDTO)insuredListReq.get(i);
            CalculateObjectDTO calculateObjectDTO = CalculateObjectDTO.builder().build();
            calculateObjectDTO.setConsumerSeqNo(requestHead.getConsumerSeqNo());
            calculateObjectDTO.setAgencyPolicyRef(quotePrice.getMain().getOrderNo());
            calculateObjectDTO.setInsuredIDCache(insuredDTO.getInsuredIDCache());
            calculateObjectDTO.setInsuredName(insuredDTO.getInsuredName());
            calculateObjectDTO.setCalMethod(methodType);
            calculateObjectDTO.setPlanCode(goodsCode);
            if (!(methodType.equals("97") || methodType.equals("96") || methodType.equals("99") || methodType.equals("9") || RiskCodeEnum.getType((String)quotePrice.getMain().getRiskCode()) == 2)) {
                calculateObjectDTO.setInsuredType(insuredDTO.getInsuredType());
            }
            if (methodType.equals("1") || methodType.equals("12")) {
                calculateObjectDTO.setDay(Integer.valueOf(days));
            }
            if (methodType.equals("10")) {
                calculateObjectDTO.setGdIsInsuranceFlag(ObjectUtil.isEmpty((Object)insuredDTO) ? "" : insuredDTO.getSocialSecurityFlag());
            }
            if (methodType.equals("11") || methodType.equals("12")) {
                calculateObjectDTO.setPhdTotal(Integer.valueOf(insuredListReq.size()));
            }
            if (methodType.equals("5") || methodType.equals("2")) {
                boolean flag = DataCompletionUtil.judgeDate((Date)quotePrice.getMain().getStartDate(), (Date)quotePrice.getMain().getEndDate());
                calculateObjectDTO.setYearDays((flag ? new Integer("366") : new Integer("365")).intValue());
                calculateObjectDTO.setUwDays(Integer.valueOf(days));
            }
            if (methodType.equals("6") || methodType.equals("7")) {
                calculateObjectDTO.setNumber(Integer.valueOf(days));
            }
            if (methodType.equals("3")) {
                int months = this.dataCompletionUtil.betweenMonth(startDate, endDate);
                calculateObjectDTO.setMonth(Integer.valueOf(months));
            }
            calList.add(calculateObjectDTO);
            ++index;
        }
        return calList;
    }

    private List<CalculateObjectDTO> assembleObjectByLiab(StanderRequest request) throws ApisBusinessException {
        QuotePriceDTO quotePrice = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
        RequestHeadDTO requestHead = request.getPolicyCalculateServiceRequest().getRequestHead();
        List insuredListReq = quotePrice.getInsuredList();
        this.dataCompletionUtil.checkInsuredInfo(request);
        ArrayList<CalculateObjectDTO> calList = new ArrayList<CalculateObjectDTO>();
        Date startDate = quotePrice.getMain().getStartDate();
        Date endDate = quotePrice.getMain().getEndDate();
        int days = DataCompletionUtil.betweenDays((Date)startDate, (Date)endDate, (boolean)true);
        int index = 0;
        int akIndex = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().size() > 1 ? index : 0;
        String goodsCode = ((ItemMainDTO)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(akIndex)).getGoodsCode();
        String methodType = this.dataCompletionUtil.queryCalcType(goodsCode);
        CalculateObjectDTO calculateObjectDTO = CalculateObjectDTO.builder().build();
        calculateObjectDTO.setConsumerSeqNo(requestHead.getConsumerSeqNo());
        calculateObjectDTO.setAgencyPolicyRef(quotePrice.getMain().getOrderNo());
        calculateObjectDTO.setCalMethod(methodType);
        calculateObjectDTO.setPlanCode(goodsCode);
        if (methodType.equals("1") || methodType.equals("12")) {
            calculateObjectDTO.setDay(Integer.valueOf(days));
        }
        if (methodType.equals("11") || methodType.equals("12")) {
            calculateObjectDTO.setPhdTotal(Integer.valueOf(insuredListReq.size()));
        }
        if (methodType.equals("5") || methodType.equals("2")) {
            boolean flag = DataCompletionUtil.judgeDate((Date)quotePrice.getMain().getStartDate(), (Date)quotePrice.getMain().getEndDate());
            calculateObjectDTO.setYearDays((flag ? new Integer("366") : new Integer("365")).intValue());
            calculateObjectDTO.setUwDays(Integer.valueOf(days));
        }
        if (methodType.equals("6") || methodType.equals("7")) {
            calculateObjectDTO.setNumber(Integer.valueOf(days));
        }
        if (methodType.equals("3")) {
            int months = this.dataCompletionUtil.betweenMonth(startDate, endDate);
            calculateObjectDTO.setMonth(Integer.valueOf(months));
        }
        calList.add(calculateObjectDTO);
        return calList;
    }

    private List<CalculateObjectDTO> assembleObjectByHy(StanderRequest request) throws ApisBusinessException {
        QuotePriceDTO quotePrice = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
        RequestHeadDTO requestHead = request.getPolicyCalculateServiceRequest().getRequestHead();
        ArrayList<CalculateObjectDTO> calList = new ArrayList<CalculateObjectDTO>();
        int index = 0;
        int akIndex = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().size() > 1 ? index : 0;
        String goodsCode = ((ItemMainDTO)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(akIndex)).getGoodsCode();
        String methodType = this.dataCompletionUtil.queryCalcType(goodsCode);
        CalculateObjectDTO calculateObjectDTO = CalculateObjectDTO.builder().build();
        calculateObjectDTO.setConsumerSeqNo(requestHead.getConsumerSeqNo());
        calculateObjectDTO.setAgencyPolicyRef(quotePrice.getMain().getOrderNo());
        calculateObjectDTO.setCalMethod(methodType);
        calculateObjectDTO.setPlanCode(goodsCode);
        calculateObjectDTO.setAmount(BigDecimal.valueOf(((ItemMainDTO)quotePrice.getCoverage().getItemList().get(0)).getSumInsured()));
        calList.add(calculateObjectDTO);
        return calList;
    }

    private List<CalculateObjectDTO> assembleObjectByList(StanderRequest request) throws ApisDataCompletionException {
        QuotePriceDTO quotePrice = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
        RequestHeadDTO requestHead = request.getPolicyCalculateServiceRequest().getRequestHead();
        List groupPlanList = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getPlanList();
        this.dataCompletionUtil.verifyInsuredTypeByOtis(groupPlanList);
        String methodType = "";
        List insuredIdvList = null;
        InsuredIdvDTO insuredIdv = null;
        ArrayList<CalculateObjectDTO> calList = new ArrayList<CalculateObjectDTO>();
        String effectiveDate = null;
        String expireDate = null;
        int days = 0;
        for (int i = 0; i < groupPlanList.size(); ++i) {
            GroupPlanDTO groupPlan = (GroupPlanDTO)groupPlanList.get(i);
            insuredIdvList = groupPlan.getInsuredIdvList();
            methodType = this.dataCompletionUtil.queryCalcType(groupPlan.getPlanCode());
            for (int j = 0; j < insuredIdvList.size(); ++j) {
                insuredIdv = (InsuredIdvDTO)insuredIdvList.get(j);
                CalculateObjectDTO calculateObjectDTO = CalculateObjectDTO.builder().build();
                calculateObjectDTO.setConsumerSeqNo(requestHead.getConsumerSeqNo());
                calculateObjectDTO.setAgencyPolicyRef(quotePrice.getMain().getOrderNo());
                calculateObjectDTO.setCompanyInfo(quotePrice.getCompanyInfo());
                calculateObjectDTO.setInsuredIDCache(insuredIdv.getInsuredIDCache());
                calculateObjectDTO.setInsuredName(insuredIdv.getInsuredName());
                calculateObjectDTO.setCalMethod(methodType);
                calculateObjectDTO.setPlanCode(groupPlan.getPlanCode());
                effectiveDate = DateUtil.format((Date)insuredIdv.getStartDate(), (String)"yyyy-MM-dd");
                expireDate = DateUtil.format((Date)insuredIdv.getEndDate(), (String)"yyyy-MM-dd");
                days = Integer.parseInt(String.valueOf(DateUtil.between((Date)DateUtil.parse((CharSequence)effectiveDate), (Date)DateUtil.parse((CharSequence)expireDate), (DateUnit)DateUnit.DAY)));
                boolean dateFlag = DataCompletionUtil.judgeUwDate((Date)insuredIdv.getStartDate(), (Date)insuredIdv.getEndDate());
                if (!dateFlag) {
                    ++days;
                }
                if (!(methodType.equals("97") || methodType.equals("96") || methodType.equals("99") || methodType.equals("9"))) {
                    calculateObjectDTO.setInsuredType(insuredIdv.getInsuredType());
                }
                if (methodType.equals("1") || methodType.equals("11") || methodType.equals("12")) {
                    calculateObjectDTO.setDay(Integer.valueOf(days));
                }
                if (methodType.equals("10")) {
                    calculateObjectDTO.setGdIsInsuranceFlag(ObjectUtil.isEmpty((Object)insuredIdv) ? "" : insuredIdv.getSocialSecurityFlag());
                }
                if (methodType.equals("11") || methodType.equals("12")) {
                    calculateObjectDTO.setPhdTotal(Integer.valueOf(insuredIdvList.size()));
                }
                if (methodType.equals("5") || methodType.equals("2")) {
                    boolean flag = DataCompletionUtil.judgeDate((Date)quotePrice.getMain().getStartDate(), (Date)quotePrice.getMain().getEndDate());
                    calculateObjectDTO.setYearDays((flag ? new Integer("366") : new Integer("365")).intValue());
                    calculateObjectDTO.setUwDays(Integer.valueOf(days));
                }
                if (methodType.equals("6") || methodType.equals("7")) {
                    calculateObjectDTO.setNumber(Integer.valueOf(days));
                }
                if (methodType.equals("3")) {
                    int months = this.dataCompletionUtil.betweenMonth(quotePrice.getMain().getStartDate(), quotePrice.getMain().getEndDate());
                    calculateObjectDTO.setMonth(Integer.valueOf(months));
                }
                calList.add(calculateObjectDTO);
            }
        }
        return calList;
    }

    private List<CalculateObjectDTO> assembleObjectByPet(StanderRequest request, String methodType) throws ApisDataCompletionException {
        ArrayList<CalculateObjectDTO> calList;
        block3: {
            List itemFamily;
            QuotePriceDTO quotePrice;
            block4: {
                block2: {
                    quotePrice = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
                    itemFamily = ((ItemMainDTO)quotePrice.getCoverage().getItemList().get(0)).getItemFamily();
                    calList = new ArrayList<CalculateObjectDTO>();
                    if (!methodType.equals("9")) break block2;
                    CalculateObjectDTO calculateObjectDTO = CalculateObjectDTO.builder().build();
                    calculateObjectDTO.setCalMethod(methodType);
                    calculateObjectDTO.setPlanCode(quotePrice.getPlanCode());
                    calList.add(calculateObjectDTO);
                    break block3;
                }
                if (!methodType.equals("8")) break block4;
                this.dataCompletionUtil.getPetType(request);
                for (int i = 0; i < itemFamily.size(); ++i) {
                    CalculateObjectDTO calculateObjectDTO = CalculateObjectDTO.builder().build();
                    calculateObjectDTO.setCalMethod(methodType);
                    calculateObjectDTO.setPlanCode(quotePrice.getPlanCode());
                    calculateObjectDTO.setInsuredType(((ItemFamilyDTO)itemFamily.get(i)).getInsuredType());
                    calculateObjectDTO.setSex(((ItemFamilyDTO)itemFamily.get(i)).getPetSex());
                    calculateObjectDTO.setGdItemType(((ItemFamilyDTO)itemFamily.get(i)).getPetType());
                    calList.add(calculateObjectDTO);
                }
                break block3;
            }
            if (!methodType.equals("1")) break block3;
            this.dataCompletionUtil.getPetType(request);
            Date startDate = quotePrice.getMain().getStartDate();
            Date endDate = quotePrice.getMain().getEndDate();
            int days = DataCompletionUtil.betweenDays((Date)startDate, (Date)endDate, (boolean)true);
            for (int i = 0; i < itemFamily.size(); ++i) {
                CalculateObjectDTO calculateObjectDTO = CalculateObjectDTO.builder().build();
                calculateObjectDTO.setCalMethod(methodType);
                calculateObjectDTO.setPlanCode(quotePrice.getPlanCode());
                calculateObjectDTO.setInsuredType(((ItemFamilyDTO)itemFamily.get(i)).getInsuredType());
                calculateObjectDTO.setDay(Integer.valueOf(days));
                calList.add(calculateObjectDTO);
            }
        }
        return calList;
    }

    private List<CalculateObjectDTO> assembleObjectByFreight(StanderRequest request, String methodType) {
        QuotePriceDTO quotePrice = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
        ItemMainDTO itemMain = (ItemMainDTO)quotePrice.getCoverage().getItemList().get(0);
        ItemCargoDTO itemCargo = (ItemCargoDTO)((ItemMainDTO)quotePrice.getCoverage().getItemList().get(0)).getItemCargo().get(0);
        String isXiz = "XZ,XJ,";
        ArrayList<CalculateObjectDTO> calList = new ArrayList<CalculateObjectDTO>();
        CalculateObjectDTO calculateObjectDTO = CalculateObjectDTO.builder().build();
        calculateObjectDTO.setCalMethod(methodType);
        calculateObjectDTO.setPlanCode(itemMain.getGoodsCode());
        calculateObjectDTO.setGdSingleLimit(itemCargo.getIndemnifyLimit());
        calculateObjectDTO.setGdLjLimit(itemCargo.getSumInsured());
        calculateObjectDTO.setGdTranSoprtType(itemCargo.getConveyanceName());
        if (isXiz.contains(itemCargo.getFromProvince() + ",") || isXiz.contains(itemCargo.getToProvince() + ",")) {
            calculateObjectDTO.setIsXiz("Y");
        } else {
            calculateObjectDTO.setIsXiz("N");
        }
        calList.add(calculateObjectDTO);
        return calList;
    }

    private List<CalculateObjectDTO> assembleObjectByLawsuit(StanderRequest request, String methodType) throws ApisBusinessException {
        QuotePriceDTO quotePrice = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
        ArrayList<CalculateObjectDTO> calList = new ArrayList<CalculateObjectDTO>();
        CalculateObjectDTO calculateObjectDTO = CalculateObjectDTO.builder().build();
        calculateObjectDTO.setPlanCode(quotePrice.getPlanCode());
        calculateObjectDTO.setCalMethod(methodType);
        if ("06".equals(quotePrice.getMain().getClassCode())) {
            calculateObjectDTO.setAnnualPremium(new BigDecimal(quotePrice.getMain().getSumPremium()));
            calculateObjectDTO.setAmount(new BigDecimal(((ItemMainDTO)quotePrice.getCoverage().getItemList().get(0)).getSumInsured()));
        } else {
            String userCode = request.getHeader().getUserCode();
            String planCode = quotePrice.getPlanCode();
            BigDecimal actionAmount = new BigDecimal(quotePrice.getRiskInfo().getActionAmount());
            ApisChannelConfigs config = this.dataCompletionUtil.getConfig(userCode, "lawsuit_premium", planCode);
            if (ObjectUtil.isNotEmpty((Object)config) && ObjectUtil.isNotEmpty((Object)config.getConfigValue())) {
                BigDecimal multiply = actionAmount.multiply(quotePrice.getRiskInfo().getAnnualPremiumRate());
                BigDecimal value = new BigDecimal(config.getConfigValue());
                if (multiply.doubleValue() < value.doubleValue() && value.doubleValue() == quotePrice.getRiskInfo().getAnnualPremium().doubleValue()) {
                    calculateObjectDTO.setLawsuitPremiumConfigFlag(true);
                    calculateObjectDTO.setGdAmountRate(quotePrice.getRiskInfo().getAnnualPremiumRate());
                }
            }
            calculateObjectDTO.setAnnualPremium(quotePrice.getRiskInfo().getAnnualPremium());
            calculateObjectDTO.setAmount(actionAmount);
        }
        calList.add(calculateObjectDTO);
        return calList;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        BeanUtils.copyProperties((Object)request.getHeader(), (Object)response.getHeader());
        int stauts = response.getCalculateResponse().getResponseHead().getStatus();
        this.calculateInstallment(request, response);
        if (0 == stauts) {
            throw new ApisBusinessException(response.getCalculateResponse().getResponseHead().getAppMessage(), response.getCalculateResponse().getResponseHead().getAppCode());
        }
        return response;
    }

    private void calculateInstallment(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        block20: {
            BigDecimal perPeriodPremium;
            BigDecimal sumPremiumTemp;
            ArrayList<PayPlanDTO> payPlanList;
            int maxPayNo;
            String installmentType;
            List rationPaymentPlan;
            BigDecimal totalPremium;
            List insuredIdvList;
            block21: {
                block19: {
                    TimeInterval timer = DateUtil.timer();
                    QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
                    Integer installmentNumber = quotePriceDTO.getMain().getInstallmentNumber();
                    if (ObjectUtil.isEmpty((Object)installmentNumber) || installmentNumber <= 1) {
                        return;
                    }
                    List itemList = quotePriceDTO.getCoverage().getItemList();
                    insuredIdvList = quotePriceDTO.getCoverage().getInsuredIdvList();
                    CalculateResponseDTO calculateResponseDTO = response.getCalculateResponse().getResponseBody();
                    totalPremium = new BigDecimal(calculateResponseDTO.getTotalPremium()).setScale(2, 4);
                    log.warn("\u4fdd\u8d39\u8ba1\u7b97\u8fd4\u56de\u603b\u4fdd\u8d39\uff1a{}", (Object)totalPremium);
                    if (ObjectUtil.isEmpty((Object)itemList)) {
                        return;
                    }
                    ArrayList goodCodeList = new ArrayList();
                    itemList.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getGoodsCode()) && !goodCodeList.contains(t.getGoodsCode())).forEach(p -> goodCodeList.add(p.getGoodsCode()));
                    if (ObjectUtil.isEmpty(goodCodeList)) {
                        return;
                    }
                    ArrayList<List> rationPaymentPlanListAll = new ArrayList<List>();
                    List rationPaymentPlanList = this.apisPfpRationPaymentPlanService.getApisPfpRationPaymentPlanList(goodCodeList);
                    if (ObjectUtil.isEmpty((Object)rationPaymentPlanList)) {
                        return;
                    }
                    for (String goodCode : goodCodeList) {
                        rationPaymentPlanListAll.add(rationPaymentPlanList.stream().filter(t -> goodCode.equals(t.getRationCode())).collect(Collectors.toList()));
                    }
                    rationPaymentPlanListAll.removeIf(ObjectUtil::isEmpty);
                    if (ObjectUtil.isEmpty(rationPaymentPlanListAll) || rationPaymentPlanListAll.size() != goodCodeList.size()) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10679.getValue(), ChannelErrorCodeEnum.ERR_C10679.getKey());
                    }
                    rationPaymentPlan = (List)rationPaymentPlanListAll.get(0);
                    if (installmentNumber.intValue() != rationPaymentPlan.size()) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10288.getValue(), ChannelErrorCodeEnum.ERR_C10288.getKey());
                    }
                    for (int i = 1; i < rationPaymentPlanListAll.size(); ++i) {
                        List list = (List)rationPaymentPlanListAll.get(i);
                        if (list.size() != rationPaymentPlan.size()) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10679.getValue(), ChannelErrorCodeEnum.ERR_C10679.getKey());
                        }
                        for (Object pp : rationPaymentPlan) {
                            List tmpList = list.stream().filter(arg_0 -> StanderCalculateHandler.lambda$calculateInstallment$3((ApisPfpRationPaymentPlan)pp, arg_0)).collect(Collectors.toList());
                            if (!ObjectUtil.isEmpty(tmpList) && ((ApisPfpRationPaymentPlan)tmpList.get(0)).getPaymentMethod().equals(pp.getPaymentMethod()) && ((ApisPfpRationPaymentPlan)tmpList.get(0)).getPayValue().equals(pp.getPayValue())) continue;
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10679.getValue(), ChannelErrorCodeEnum.ERR_C10679.getKey());
                        }
                    }
                    log.warn("\u5206\u671f\u914d\u7f6e\u6821\u9a8c\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
                    installmentType = ((ApisPfpRationPaymentPlan)rationPaymentPlan.get(0)).getPaymentMethod();
                    maxPayNo = rationPaymentPlan.stream().mapToInt(ApisPfpRationPaymentPlan::getPayNo).max().getAsInt();
                    if ("1".equals(installmentType) && insuredIdvList.size() > 1) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10680.getValue(), ChannelErrorCodeEnum.ERR_C10680.getKey());
                    }
                    payPlanList = new ArrayList<PayPlanDTO>();
                    response.getCalculateResponse().getResponseBody().setPayPlanList(payPlanList);
                    if (!"1".equals(installmentType)) break block19;
                    for (ApisPfpRationPaymentPlan pp : rationPaymentPlan) {
                        payPlanList.add(PayPlanDTO.builder().payTimes(pp.getPayNo()).planFee(Double.valueOf(pp.getPayValue().doubleValue())).build());
                    }
                    break block20;
                }
                if (!"2".equals(installmentType)) break block21;
                sumPremiumTemp = BigDecimal.ZERO;
                perPeriodPremium = null;
                for (int i = 0; i < rationPaymentPlan.size(); ++i) {
                    ApisPfpRationPaymentPlan pp = (ApisPfpRationPaymentPlan)rationPaymentPlan.get(i);
                    perPeriodPremium = totalPremium.subtract(sumPremiumTemp);
                    if (pp.getPayNo() != maxPayNo) {
                        perPeriodPremium = totalPremium.multiply(pp.getPayValue().divide(CommonConstant.ONE_HUNDRED, 4, 4));
                        perPeriodPremium = perPeriodPremium.compareTo(BigDecimal.ONE) == -1 ? BigDecimal.ONE : perPeriodPremium.setScale(0, 4);
                        sumPremiumTemp = sumPremiumTemp.add(perPeriodPremium);
                    }
                    payPlanList.add(PayPlanDTO.builder().payTimes(pp.getPayNo()).planFee(Double.valueOf(perPeriodPremium.doubleValue())).build());
                }
                break block20;
            }
            if (!"3".equals(installmentType)) break block20;
            sumPremiumTemp = BigDecimal.ZERO;
            perPeriodPremium = null;
            for (int i = 0; i < rationPaymentPlan.size(); ++i) {
                ApisPfpRationPaymentPlan pp = (ApisPfpRationPaymentPlan)rationPaymentPlan.get(i);
                if (pp.getPayNo() == 1) {
                    perPeriodPremium = pp.getPayValue().multiply(new BigDecimal(insuredIdvList.size()));
                    sumPremiumTemp = sumPremiumTemp.add(perPeriodPremium);
                } else if (pp.getPayNo() == maxPayNo) {
                    perPeriodPremium = totalPremium.subtract(sumPremiumTemp);
                } else {
                    perPeriodPremium = totalPremium.multiply(pp.getPayValue().divide(CommonConstant.ONE_HUNDRED, 4, 4));
                    perPeriodPremium = perPeriodPremium.compareTo(BigDecimal.ONE) == -1 ? BigDecimal.ONE : perPeriodPremium.setScale(0, 4);
                    sumPremiumTemp = sumPremiumTemp.add(perPeriodPremium);
                }
                payPlanList.add(PayPlanDTO.builder().payTimes(pp.getPayNo()).planFee(Double.valueOf(perPeriodPremium.doubleValue())).build());
            }
        }
    }

    private static /* synthetic */ boolean lambda$calculateInstallment$3(ApisPfpRationPaymentPlan pp, ApisPfpRationPaymentPlan t) {
        return t.getPayNo().equals(pp.getPayNo());
    }
}

