/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CommonsValidateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderQuotePriceHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.CfDrugsUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ExpandDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiReqmsgLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderCfDrugsQuotePriceHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderCfDrugsQuotePriceHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    QuotePriceValidate quotePriceValidate;
    @Autowired
    MediaUploadUtil mediaUploadUtil;
    @Autowired
    ApisBusiReqmsgLogMapper apisBusiReqmsgLogMapper;
    @Autowired
    private CommonsValidateUtil commonsValidateUtil;
    @Autowired
    StanderQuotePriceHandler standerQuotePriceHandler;
    @Autowired
    CfDrugsUtil cfDrugsUtil;
    private final String RESPONSE_ENTITY_QUOTEPRICE = "policyListQueryResponse";
    private final String REQUEST_ENTITY_QUOTEPRICE = "quotePriceServiceRequest";
    private final String RESPONSE_ENTITY_PLOICYSUBMIT = "policySubmitResponse";
    private static final String CLAUSE_LIABILITY_KEY_WORD = "\u6761\u6b3e\u8d23\u4efb\u4fe1\u606f\u4e2d";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"quotePriceServiceRequest");
        request.getQuotePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        this.cfDrugsUtil.verifyMd5Value(request);
        this.dataCompletionUtil.verifyRepeatRequest(request);
        this.dataCompletionUtil.dataCompletion(request);
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        request.getQuotePriceServiceRequest().getRequestHead().setConsumerSeqNo(request.getHeader().getUserCode() + mainDTO.getOrderNo());
        log.warn("\u6570\u636e\u8865\u5168\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.quotePriceValidate.validateRquest(request);
        log.warn("\u51fa\u5355\u89c4\u5219\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.dataCompletionUtil.settleInsuredFlag(request);
        this.dataCompletionUtil.riskDataCompletion(request);
        this.dataCompletionUtil.fxqDataCompletion(request);
        this.commonsValidateUtil.executorValidate(request, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        this.completionImageInfo(request);
        return request;
    }

    private void completionImageInfo(StanderRequest request) {
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        ArrayList<ImgMetaDTO> imgMetaList = new ArrayList<ImgMetaDTO>();
        AppliClientDTO appliClientDto = (AppliClientDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getAppliClient().get(0);
        Optional<ExpandDTO> expendOptional = appliClientDto.getExpands().stream().filter(item -> "url".equals(item.getKey())).findFirst();
        if (expendOptional.isPresent()) {
            ExpandDTO expandDto = expendOptional.get();
            ImgMetaDTO imgMetaDto = ImgMetaDTO.builder().fileUrl(ObjectUtil.isNotEmpty((Object)expandDto.getValue()) ? expandDto.getValue() : "").build();
            imgMetaList.add(imgMetaDto);
            ImgBatchUploadRequestDTO imgBatchUploadRequestDto = ImgBatchUploadRequestDTO.builder().orderNo(mainDTO.getOrderNo()).imgList(imgMetaList).build();
            ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = ImgBatchUploadServiceRequest.builder().requestHead(request.getQuotePriceServiceRequest().getRequestHead()).requestBody(imgBatchUploadRequestDto).build();
            request.setImgBatchUploadServiceRequest(imgBatchUploadServiceRequest);
        }
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        QuotePriceServiceResponse quotePriceServiceResponse;
        block17: {
            ApisBusiChannelOrder apisBusinessChannelOrder = new ApisBusiChannelOrder();
            apisBusinessChannelOrder.setRequestTime(LocalDateTime.now());
            apisBusinessChannelOrder.setCreateTime(new Date());
            quotePriceServiceResponse = QuotePriceServiceResponse.builder().build();
            Double sumPremium = null;
            MainDTO mainDTO = MainDTO.builder().build();
            QuotePriceServiceResponseDTO responseBody = QuotePriceServiceResponseDTO.builder().build();
            try {
                apisBusinessChannelOrder.setStatus("01");
                String businessNo = "";
                String policyStatus = "70";
                Date startTime = new Date();
                StanderResponse quotePriceResponse = this.coreInsureApi.quotePrice(request);
                BaseApisParamUtil.verificationResponse((StanderResponse)quotePriceResponse, (String)"policyListQueryResponse");
                mainDTO = quotePriceResponse.getPolicyListQueryResponse().getResponseBody().getMain();
                MainDTO requestMainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
                if (StringUtils.isEmpty((CharSequence)requestMainDTO.getJFeeFlag())) {
                    requestMainDTO.setJFeeFlag(mainDTO.getJFeeFlag());
                }
                if (StringUtils.isEmpty((CharSequence)requestMainDTO.getStepFlag())) {
                    requestMainDTO.setStepFlag(this.dataCompletionUtil.getStepFlag(request.getHeader().getUserCode()));
                }
                apisBusinessChannelOrder.setPayType(mainDTO.getJFeeFlag());
                sumPremium = mainDTO.getSumPremium();
                StanderResponse policySubmitResponse = null;
                apisBusinessChannelOrder.setProposalTime(LocalDateTime.now());
                apisBusinessChannelOrder.setProposalNo(mainDTO.getProposalNo());
                mainDTO.setOutPaymentType(requestMainDTO.getOutPaymentType() == null ? "" : requestMainDTO.getOutPaymentType());
                if (ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest())) {
                    request.getImgBatchUploadServiceRequest().getRequestBody().setLinkNo(mainDTO.getProposalNo());
                    this.cfDrugsUtil.syncUploadCfDrugs(request);
                }
                apisBusinessChannelOrder.setStatus("02");
                apisBusinessChannelOrder.setGiftType(mainDTO.getGiftType());
                Map map = this.standerQuotePriceHandler.policyNoGetService(apisBusinessChannelOrder, request, mainDTO);
                String obj = (String)DataCompletionUtil.castToClass(String.class, map.get("policyStatus"));
                policyStatus = StringUtils.isEmpty((CharSequence)obj) ? "70" : obj;
                businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
                if ("1".equals(requestMainDTO.getStepFlag())) {
                    String prePayFlag;
                    policySubmitResponse = this.coreInsureApi.policySubmit(this.dataCompletionUtil.packagePolicyConfirmRequestData(mainDTO, request, businessNo, "P"));
                    BaseApisParamUtil.verificationResponse((StanderResponse)policySubmitResponse, (String)"policySubmitResponse");
                    businessNo = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getBusinessNo();
                    if (StringUtils.isEmpty((CharSequence)businessNo) || businessNo.startsWith("T")) {
                        businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
                    }
                    policyStatus = StringUtils.isNotEmpty((CharSequence)requestMainDTO.getOutPaymentType()) && "1".equals(mainDTO.getJFeeFlag()) ? "70" : ("1".equals(prePayFlag = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getPrePayFlag()) || "0".equals(mainDTO.getJFeeFlag()) ? "70" : "60");
                }
                if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                    apisBusinessChannelOrder.setPolicyNo(businessNo);
                    apisBusinessChannelOrder.setPolicyTime(LocalDateTime.now());
                    if ("70".equals(policyStatus)) {
                        apisBusinessChannelOrder.setStatus("04");
                    }
                }
                ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
                responseHeadDTO.setConsumerSeqNo(request.getQuotePriceServiceRequest().getRequestHead().getConsumerSeqNo());
                if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                    responseBody.setTotalPremium(sumPremium);
                    responseBody.setBusinessNo(businessNo);
                    responseBody.setAgencyPolicyRef(mainDTO.getOrderNo());
                    responseBody.setSumAmount(mainDTO.getSumAmount());
                    responseBody.setPolicyUrl(this.cfDrugsUtil.getPolicyQueryUrl());
                    responseHeadDTO.setStatus(1);
                    quotePriceServiceResponse.setResponseHead(responseHeadDTO);
                    if (policyStatus.equals("70")) {
                        this.apisBusiReqmsgLogMapper.deleteApisBusiReqmsgLog(businessNo, "1");
                    }
                    break block17;
                }
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10054.getValue(), ChannelErrorCodeEnum.ERR_C10054.getKey());
            }
            catch (ApisBusinessException e) {
                String errMsg = e.getMessage();
                if (errMsg.indexOf(CLAUSE_LIABILITY_KEY_WORD) != -1) {
                    String rationCode = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsCode();
                    String rationName = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsName();
                    errMsg = "" + rationName + "\u3010" + rationCode + "\u3011\u4ea7\u54c1\u6b63\u5feb\u9a6c\u52a0\u97ad\u4e0a\u67b6\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8d2d\u4e70\u3002";
                }
                throw new ApisBusinessException(errMsg, e.getErrorCode());
            }
            finally {
                apisBusinessChannelOrder.setFinishedTime(LocalDateTime.now());
                if (ObjectUtil.isNotEmpty(sumPremium)) {
                    apisBusinessChannelOrder.setPremium(new BigDecimal(sumPremium));
                }
                if (ObjectUtil.isNotEmpty((Object)mainDTO.getSumAmount())) {
                    apisBusinessChannelOrder.setAmount(new BigDecimal(mainDTO.getSumAmount()));
                }
                Date startDate = new Date();
                this.dataCompletionUtil.insertApisBusinessChannelOrder(request, apisBusinessChannelOrder);
                log.warn("\u65b0\u589e\u6e20\u9053\u8ba2\u5355\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
                responseBody.setDownloadUrl(this.cfDrugsUtil.getPolicyDownUrl(request, apisBusinessChannelOrder.getPolicyNo()));
                quotePriceServiceResponse.setResponseBody(responseBody);
                this.dataCompletionUtil.insertReqMsg(request, quotePriceServiceResponse, apisBusinessChannelOrder.getPolicyNo(), "2");
            }
        }
        return StanderResponse.builder().header(request.getHeader()).quotePriceServiceResponse(quotePriceServiceResponse).build();
    }
}

