/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CommonsValidateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderRefundCalculateHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.FxqCustomerCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CancellationInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorsePriceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorsePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorseServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainEndorDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainEndorPriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PayPlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RefundCalculateServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RefundCalculateServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PremiumPayStatusQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PremiumPayStatusQueryRequestBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PremiumPayStatusQueryRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CorrectQuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CorrectQuotePriceServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseApplyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.MainEndorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.RefundCalculateServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.payment.ResponseVo;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskManagementScenesEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderCorrectHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderCorrectHandler.class);
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    RedisTemplateUtil redisTemplateUtil;
    @Autowired
    private StanderRefundCalculateHandler standerRefundCalculateHandler;
    @Autowired
    private ApisBusinessService apisBusinessService;
    @Autowired
    private RiskManagementCheckUtil riskManagementCheckUtil;
    @Autowired
    private FxqCustomerCheckUtil fxqCustomerCheckUtil;
    @Autowired
    private CommonsValidateUtil commonsValidateUtil;
    @Autowired
    private MediaUploadUtil mediaUploadUtil;
    private static String ENDOR_TYPE_01 = "01";
    private static String ENDOR_TYPE_04 = "04";
    private static String OPERATE_CODE = "all";
    private static String CALCULATE_FLAG = "1";
    private static String POLICY_STATUS = "1";
    private static String PAY_COMPLETE_1 = "1";
    private static String PAY_COMPLETE_0 = "0";
    private static String CANCEL_FLAG_A = "A";
    private static String CANCEL_FLAG_B = "P";
    private static String CALCULATE_TYPE_0 = "0";
    private static String CALCULATE_TYPE_1 = "1";
    private static String CALCULATE_TYPE_2 = "2";
    private static String REASON_1 = "\u7b7e\u8bc1\u62d2\u7b7e";
    private static String REASON_2 = "\u4e0d\u7b26\u5408\u5065\u5eb7\u544a\u77e5";
    private static String POLICY_STAUTS_4 = "4";
    private static final String SYSTEM_BUSY_ERR = "\u7cfb\u7edf\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
    private static final String KUAYUE_CORRECT = "kuayueCancle";
    public static final ExecutorService POLICY_CANCLE_ASYNC_RETURN_EXECUTORS = new ThreadPoolExecutor(10, 20, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    @Autowired
    private ApisBusiTaskLogService apisBusiTaskLogService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        Long curTime;
        List existApisChannelConfigList;
        this.log.warn("==============\u6279\u6539\u63a5\u53e3\u5f00\u59cb==================");
        RequestHeadDTO requestHeadDTO = RequestHeadDTO.initRequestHead();
        request.getEndorseServiceRequest().setRequestHead(requestHeadDTO);
        MainEndorDTO mainEndorDTO = request.getEndorseServiceRequest().getRequestBody().getMain();
        Date a1 = new Date();
        PolicyDTO policyDTO = this.dataCompletionUtil.executePolicyDetails(request);
        request.getEndorseServiceRequest().getRequestBody().setPolicyDTO(policyDTO);
        request.getEndorseServiceRequest().getRequestBody().getMain().setEndDate(policyDTO.getMain().getEndDate());
        this.log.warn("\n\u4fdd\u5355\u6ce8\u9500>>>>>>\u8c03\u7528\u4fdd\u5355\u8be6\u60c5\u63a5\u53e3\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - a1.getTime()));
        boolean isSelfHelpPlatform = ObjectUtil.isNotEmpty((Object)this.dataCompletionUtil.getConfig(request.getHeader().getUserCode(), "self_help_platform"));
        request.getEndorseServiceRequest().getRequestBody().setIsSelfHelpPlatform(Boolean.valueOf(isSelfHelpPlatform));
        Date a2 = new Date();
        this.dataCompletionUtil.correctPreviaVerify(request, policyDTO);
        this.log.warn("\n\u4fdd\u5355\u6ce8\u9500>>>>>>\u524d\u7f6e\u6821\u9a8c\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - a2.getTime()));
        this.dataCompletionUtil.validNotApisPolicy(request.getEndorseServiceRequest().getRequestBody().getMain().getPolicyNo(), isSelfHelpPlatform);
        Date a4 = new Date();
        this.premiumPayStatusQuery(request, policyDTO);
        this.log.warn("\n\u4fdd\u5355\u6ce8\u9500>>>>>>\u8c03\u7528\u4fdd\u5355\u7ed3\u6e05\u63a5\u53e3\u67e5\u8be2\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - a4.getTime()));
        Date a3 = new Date();
        this.dataCompletionUtil.transformPayee(request, policyDTO);
        this.log.warn("\n\u4fdd\u5355\u9000\u4fdd>>>>>>\u9000\u8d39\u9886\u6b3e\u4eba\u4fe1\u606f\u8865\u5168\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - a3.getTime()));
        String endorseType = request.getEndorseServiceRequest().getRequestBody().getMain().getEndorseType();
        if ((!StringUtils.isNotBlank((CharSequence)endorseType) || !"01".equals(endorseType)) && StringUtils.isNotBlank((CharSequence)endorseType) && "04".equals(endorseType)) {
            request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate((Date)DateUtil.parse((CharSequence)policyDTO.getMain().getStartDateStr(), (String)"yyyy-MM-dd"));
            request.getEndorseServiceRequest().getRequestBody().getMain().setCalculateFlag(null);
            if (StringUtils.isNotEmpty((CharSequence)mainEndorDTO.getCalculateType())) {
                request.getEndorseServiceRequest().getRequestBody().getMain().setSubEndorType("0" + mainEndorDTO.getCalculateType());
            }
        }
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode("policy_cancel_async_return");
        apisChannelConfigs.setChannelCode(request.getHeader().getChannelCode());
        apisChannelConfigs.setDeleted(ApisChannelConfigs.DELETE_FLAG_FALSE);
        List apisChannelConfigsList = this.redisTemplateUtil.getApisChannelConfigList(apisChannelConfigs, this.redisTemplateUtil.generatePrefix(RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code, new Object[]{apisChannelConfigs.getChannelCode()}));
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigsList) && ObjectUtil.isNotEmpty(existApisChannelConfigList = apisChannelConfigsList.stream().filter(p -> ObjectUtil.isEmpty((Object)p.getProductCode()) || p.getProductCode().contains(policyDTO.getMain().getRiskCode())).collect(Collectors.toList()))) {
            this.dataCompletionUtil.validClaimMoney(request.getEndorseServiceRequest().getRequestBody().getMain().getPolicyNo(), "1");
            request.getEndorseServiceRequest().getRequestBody().setApisChannelConfigsList(existApisChannelConfigList);
            request.setAsyncReturn(Boolean.valueOf(true));
        }
        if ("04".equals(endorseType) && "0".equals(policyDTO.getMain().getJFeeFlag()) && policyDTO.getMain().getPayTimes() == 1) {
            if (ObjectUtil.isNotEmpty((Object)request.getAsyncReturn()) && request.getAsyncReturn().booleanValue()) {
                curTime = System.currentTimeMillis();
                this.calculateRefundPremiumDataCompletion(request, mainEndorDTO, policyDTO);
                StanderRequest standerRequest = this.standerRefundCalculateHandler.executeRefundCalculateBeforeProcess(request, policyDTO);
                this.log.warn("\u9000\u4fdd\u63a5\u53e3\u8bd5\u7b97\u6570\u636e\u8865\u5168\u540e :{}", (Object)JSON.toJSONString((Object)standerRequest));
                StanderResponse standerResponse = this.refundCalculateExecute(standerRequest);
                RefundCalculateServiceResponseDTO responseBody = standerResponse.getRefundCalculateResponse().getResponseBody();
                BigDecimal refundPremium = responseBody.getRefundPremium().multiply(new BigDecimal("-1"));
                request.getEndorseServiceRequest().getRequestBody().setSumPremiumChg(refundPremium);
                this.log.warn("\n\u4fdd\u5355\u6ce8\u9500>>>>>>\u9000\u4fdd\u4fdd\u8d39\u8ba1\u7b97\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - curTime));
            }
        } else {
            curTime = System.currentTimeMillis();
            this.calculateRefundPremiumDataCompletion(request, mainEndorDTO, policyDTO);
            StanderRequest standerRequest = this.standerRefundCalculateHandler.executeRefundCalculateBeforeProcess(request, policyDTO);
            this.log.warn("\u9000\u4fdd\u63a5\u53e3\u8bd5\u7b97\u6570\u636e\u8865\u5168\u540e :{}", (Object)JSON.toJSONString((Object)standerRequest));
            StanderResponse standerResponse = this.refundCalculateExecute(standerRequest);
            RefundCalculateServiceResponseDTO responseBody = standerResponse.getRefundCalculateResponse().getResponseBody();
            BigDecimal refundPremium = responseBody.getRefundPremium().multiply(new BigDecimal("-1"));
            BigDecimal installRefundPremium = responseBody.getInstallRefundPremium();
            if (ObjectUtil.isNotEmpty((Object)installRefundPremium)) {
                installRefundPremium = installRefundPremium.multiply(new BigDecimal("-1"));
            }
            String cancelType = standerRequest.getRefundCalculateServiceRequest().getRequestBody().getCancellationInfo().getCancelType();
            request.getEndorseServiceRequest().getRequestBody().getMain().setSubEndorType("0" + cancelType);
            request.getEndorseServiceRequest().getRequestBody().getMain().setSumPremiumChg(refundPremium);
            request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate(responseBody.getCancelDate());
            request.getEndorseServiceRequest().getRequestBody().getMain().setInstallRefundPremium(installRefundPremium);
            this.log.warn("\n\u4fdd\u5355\u6ce8\u9500>>>>>>\u9000\u4fdd\u4fdd\u8d39\u8ba1\u7b97\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - curTime));
        }
        this.dataQuotePriceCompletion(request, policyDTO);
        this.riskDataCompletion(request, policyDTO, policyDTO.getMain().getPolicyType());
        this.fxqDataCompletion(request, policyDTO);
        this.commonsValidateUtil.executorValidate(request, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true));
        return request;
    }

    private void calculateRefundPremiumDataCompletion(StanderRequest request, MainEndorDTO mainEndorDTO, PolicyDTO policyDTO) {
        if (StringUtils.isEmpty((CharSequence)request.getEndorseServiceRequest().getRequestBody().getMain().getCancelFlag())) {
            request.getEndorseServiceRequest().getRequestBody().getMain().setCancelFlag(CANCEL_FLAG_A);
        }
        if (StringUtils.isEmpty((CharSequence)request.getEndorseServiceRequest().getRequestBody().getMain().getCalculateType())) {
            request.getEndorseServiceRequest().getRequestBody().getMain().setCalculateType(CALCULATE_TYPE_0);
        }
        RefundCalculateServiceRequest refundCalculateServiceRequest = RefundCalculateServiceRequest.builder().build();
        RefundCalculateServiceRequestDTO refundCalculateDTO = RefundCalculateServiceRequestDTO.builder().build();
        com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDTO policy = com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDTO.builder().build();
        policy.setPolicyRef(mainEndorDTO.getPolicyNo());
        if (KUAYUE_CORRECT.equals(request.getHeader().getBussinessType())) {
            if (ObjectUtil.isNotEmpty((Object)policyDTO.getMain().getStartDate())) {
                policy.setCancelDate(policyDTO.getMain().getStartDate());
            } else {
                policy.setCancelDate(mainEndorDTO.getValidDate());
            }
        } else {
            policy.setCancelDate(mainEndorDTO.getValidDate());
        }
        refundCalculateDTO.setPolicy(policy);
        CancellationInfoDTO cancellationInfoDTO = CancellationInfoDTO.builder().build();
        cancellationInfoDTO.setCancelFlag(mainEndorDTO.getCancelFlag());
        cancellationInfoDTO.setCancelType(mainEndorDTO.getCalculateType());
        cancellationInfoDTO.setReasonRemark(mainEndorDTO.getReason());
        refundCalculateDTO.setCancellationInfo(cancellationInfoDTO);
        refundCalculateServiceRequest.setRequestHead(request.getEndorseServiceRequest().getRequestHead());
        refundCalculateServiceRequest.setRequestBody(refundCalculateDTO);
        request.setRefundCalculateServiceRequest(refundCalculateServiceRequest);
        this.log.warn("\u9000\u4fdd\u63a5\u53e3\u8bd5\u7b97\u524d :{}", (Object)JSON.toJSONString((Object)request));
    }

    private StanderResponse refundCalculateExecute(StanderRequest standerRequest) throws ApisBusinessException {
        StanderResponse standerResponse = this.standerRefundCalculateHandler.execute(standerRequest);
        this.log.warn("\u9000\u8d39\u8ba1\u7b97\u7ed3\u679c\uff1a{}", (Object)standerResponse);
        if (ObjectUtil.isEmpty((Object)standerResponse) || ObjectUtil.isEmpty((Object)standerResponse.getRefundCalculateResponse()) || ObjectUtil.isEmpty((Object)standerResponse.getRefundCalculateResponse().getResponseBody()) || ObjectUtil.isEmpty((Object)standerResponse.getRefundCalculateResponse().getResponseBody().getRefundPremium()) || ObjectUtil.isEmpty((Object)standerResponse.getRefundCalculateResponse().getResponseBody().getCancelDate())) {
            this.log.warn("\n\u9000\u4fdd\u4fdd\u8d39\u8ba1\u7b97\u8fd4\u53c2\u6709\u8bef");
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N11003.getValue(), ErrorNullValueCodeEnum.ERR_N11003.getKey());
        }
        return standerResponse;
    }

    private void riskDataCompletion(StanderRequest request, PolicyDTO policyDTO, String policyType) throws ApisBusinessException {
        String riskManagementScenes = request.getEndorseServiceRequest().getRequestBody().getMain().getEndorseType().equals("01") ? RiskManagementScenesEnum.REFUND.getCode() : RiskManagementScenesEnum.CORRECT.getCode();
        this.riskManagementCheckUtil.riskManagementData(request, policyDTO, riskManagementScenes, policyType);
    }

    private void fxqDataCompletion(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        this.fxqCustomerCheckUtil.fxqCustomerData(request, policyDTO);
    }

    public void dataQuotePriceCompletion(StanderRequest request, PolicyDTO policyDTO) {
        EndorseServiceRequest endorseServiceRequest = request.getEndorseServiceRequest();
        String operateCode = request.getHeader().getUserCode();
        String[] userArr = operateCode.split("_");
        if (userArr.length > 1 && "00".equals(userArr[1])) {
            operateCode = policyDTO.getMain().getOperateCode();
        }
        if (endorseServiceRequest.getRequestBody().getIsSelfHelpPlatform().booleanValue()) {
            request.getHeader().setChannelCode(policyDTO.getSalesList().getAgentCode());
            operateCode = policyDTO.getMain().getOperateCode();
        }
        EndorsePriceServiceRequest endorsePriceServiceRequest = new EndorsePriceServiceRequest();
        EndorsePriceRequestDTO endorsePriceRequestDTO = new EndorsePriceRequestDTO();
        MainEndorPriceDTO mainEndorPriceDTO = new MainEndorPriceDTO();
        BeanUtils.copyProperties((Object)endorseServiceRequest.getRequestBody().getMain(), (Object)mainEndorPriceDTO);
        mainEndorPriceDTO.setOperateCode(operateCode);
        BigDecimal installRefundPremium = endorseServiceRequest.getRequestBody().getMain().getInstallRefundPremium();
        if (ObjectUtil.isNotEmpty((Object)installRefundPremium)) {
            mainEndorPriceDTO.setActualRefPremium(Double.valueOf(Math.abs(installRefundPremium.doubleValue())));
        }
        int validHour = DateUtil.hour((Date)mainEndorPriceDTO.getValidDate(), (boolean)true);
        mainEndorPriceDTO.setValidHour(Integer.valueOf(validHour));
        endorsePriceRequestDTO.setMain(mainEndorPriceDTO);
        endorsePriceServiceRequest.setRequestHead(endorseServiceRequest.getRequestHead());
        endorsePriceServiceRequest.setRequestBody(endorsePriceRequestDTO);
        request.setEndorsePriceServiceRequest(endorsePriceServiceRequest);
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        List existApisChannelConfigList;
        if (ObjectUtil.isNotEmpty((Object)request.getAsyncReturn()) && request.getAsyncReturn().booleanValue() && ObjectUtil.isNotEmpty((Object)(existApisChannelConfigList = request.getEndorseServiceRequest().getRequestBody().getApisChannelConfigsList()))) {
            Long awaitTime = 10000L;
            String configValue = ((ApisChannelConfigs)existApisChannelConfigList.get(0)).getConfigValue();
            if (ObjectUtil.isNotEmpty((Object)configValue)) {
                try {
                    Long time;
                    awaitTime = time = Long.valueOf(configValue);
                }
                catch (Exception e) {
                    this.log.warn("\u6e20\u9053{}\uff0c\u914d\u7f6e\u7684\u9000\u4fdd\u5f02\u6b65\u8fd4\u56de\u65f6\u95f4\u65e0\u6548,\u53d6\u9ed8\u8ba4\u503c\uff01");
                    awaitTime = 10000L;
                }
            }
            CyclicBarrier barrier = new CyclicBarrier(2);
            StanderRequest req = request;
            CopyOnWriteArrayList retList = new CopyOnWriteArrayList();
            ArrayList errorList = new ArrayList();
            request.setAsyncReturn(Boolean.valueOf(true));
            POLICY_CANCLE_ASYNC_RETURN_EXECUTORS.execute(() -> {
                try {
                    boolean isError = false;
                    try {
                        this.dataCompletionUtil.doCorrectQuotePriceExecutor(req, retList);
                    }
                    catch (ApisBusinessException e) {
                        isError = true;
                        errorList.add(e.getMessage());
                        errorList.add(e.getErrorCode());
                        if (null != e.getMessage() && e.getMessage().contains(SYSTEM_BUSY_ERR)) {
                            errorList.clear();
                            retList.clear();
                            String tempRequestJson = this.getEndorsePriceRequest(req);
                            ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog().setPushType(ApisAutoTaskConstantsEnum.POLICY_CANCEL_ASYNC_ENDORSE_PRICE.getValue()).setBusinessKey("AEP-" + UUID.fastUUID().toString().replaceAll("-", "")).setPushContent(tempRequestJson).setPushStatus("4").setPushStep(Integer.valueOf(1)).setRemark(request.getEndorseServiceRequest().getRequestBody().getMain().getPolicyNo()).setErrMsg(e.getMessage()).setLastPushTime(LocalDateTime.now());
                            this.apisBusiTaskLogService.saveTaskInfo(apisBusiTaskLog);
                        }
                    }
                    catch (Exception e) {
                        this.log.error("\u4fdd\u5355{}\uff0c\u6279\u6539\u8bd5\u7b97\u8bf7\u6c42\u51fa\u9519\uff1a", (Object)request.getEndorseServiceRequest().getRequestBody().getMain().getPolicyNo(), (Object)e);
                        errorList.add(ChannelErrorCodeEnum.ERR_C10006.getValue());
                        errorList.add(ChannelErrorCodeEnum.ERR_C10006.getKey());
                        isError = true;
                    }
                    if (!isError) {
                        ApisBusiTaskLog apisBusiTaskLog;
                        try {
                            this.dataCompletionUtil.doPolicyConfirmExecute(req, (StanderResponse)retList.get(0));
                        }
                        catch (ApisBusinessException e) {
                            errorList.add(e.getMessage());
                            errorList.add(e.getErrorCode());
                            apisBusiTaskLog = new ApisBusiTaskLog().setPushType(ApisAutoTaskConstantsEnum.POLICY_CANCEL_ASYNC_CONFIRM.getValue()).setBusinessKey("APC-" + UUID.fastUUID().toString().replaceAll("-", "")).setPushContent(JSON.toJSONString((Object)request.getPolicySubmitRequest())).setPushStatus("4").setPushStep(Integer.valueOf(1)).setRemark(request.getEndorseServiceRequest().getRequestBody().getMain().getPolicyNo()).setErrMsg(e.getMessage()).setLastPushTime(LocalDateTime.now());
                            this.apisBusiTaskLogService.saveTaskInfo(apisBusiTaskLog);
                        }
                        catch (Exception e) {
                            this.log.error("\u4fdd\u5355{}\uff0c\u5f02\u6b65\u53d1\u9001\u9000\u4fdd\u786e\u8ba4\u8bf7\u6c42\u51fa\u9519\uff1a", (Object)request.getEndorseServiceRequest().getRequestBody().getMain().getPolicyNo(), (Object)e);
                            errorList.add(ChannelErrorCodeEnum.ERR_C10006.getValue());
                            errorList.add(ChannelErrorCodeEnum.ERR_C10006.getKey());
                            apisBusiTaskLog = new ApisBusiTaskLog().setPushType(ApisAutoTaskConstantsEnum.POLICY_CANCEL_ASYNC_CONFIRM.getValue()).setBusinessKey("APC-" + UUID.fastUUID().toString().replaceAll("-", "")).setPushContent(JSON.toJSONString((Object)request.getPolicySubmitRequest())).setPushStatus("4").setPushStep(Integer.valueOf(1)).setRemark(request.getEndorseServiceRequest().getRequestBody().getMain().getPolicyNo()).setErrMsg(e.getMessage()).setLastPushTime(LocalDateTime.now());
                            this.apisBusiTaskLogService.saveTaskInfo(apisBusiTaskLog);
                        }
                    }
                }
                finally {
                    try {
                        barrier.await();
                    }
                    catch (Exception e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
            try {
                barrier.await(awaitTime, TimeUnit.MILLISECONDS);
            }
            catch (Exception te) {
                this.log.error("\u9000\u4fdd\u4fdd\u5355{}\uff0c\u8d85\u65f6{}ms", (Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo(), (Object)awaitTime);
            }
            if (errorList.size() == 2) {
                throw new ApisBusinessException((String)errorList.get(0), (String)errorList.get(1));
            }
            if (retList.size() == 1) {
                return (StanderResponse)retList.get(0);
            }
            return StanderResponse.builder().correctQuotePriceServiceResponse(CorrectQuotePriceServiceResponse.builder().responseBody(CorrectQuotePriceServiceResponseDTO.builder().endorseApply(EndorseApplyDTO.builder().main(MainEndorResponseDTO.builder().build()).build()).build()).build()).build();
        }
        return this.dataCompletionUtil.doPolicyConfirmExecute(request, this.dataCompletionUtil.doCorrectQuotePriceExecutor(request, null));
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        BigDecimal installRefundPremium = request.getEndorseServiceRequest().getRequestBody().getMain().getInstallRefundPremium();
        EndorseServiceResponse endorseServiceResponse = new EndorseServiceResponse();
        EndorseServiceResponseDTO endorseServiceResponseDTO = new EndorseServiceResponseDTO();
        ResponseHeadDTO responseHeadDTO = null;
        boolean isPolicySubmitResNotEmpty = ObjectUtil.isNotEmpty((Object)response.getPolicySubmitResponse());
        if (isPolicySubmitResNotEmpty) {
            responseHeadDTO = response.getPolicySubmitResponse().getResponseHead();
        }
        EndorseApplyDTO endorseApplyDTO = response.getCorrectQuotePriceServiceResponse().getResponseBody().getEndorseApply();
        if (isPolicySubmitResNotEmpty) {
            endorseApplyDTO.getMain().setEndorseNo(response.getPolicySubmitResponse().getResponseBody().getBusinessNo());
            endorseApplyDTO.getMain().setUnderwriteFlag(response.getPolicySubmitResponse().getResponseBody().getUnderwriteFlag());
        } else {
            endorseApplyDTO.getMain().setEndorseNo(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo());
        }
        endorseApplyDTO.getMain().setInstallRefundPremium(null != installRefundPremium ? Double.valueOf(Math.abs(installRefundPremium.doubleValue())) : null);
        if (ObjectUtil.isNotEmpty((Object)endorseApplyDTO.getMain().getChgSumPremium())) {
            endorseApplyDTO.getMain().setChgSumPremium(Double.valueOf(Math.abs(endorseApplyDTO.getMain().getChgSumPremium())));
        } else if (ObjectUtil.isNotEmpty((Object)request.getEndorseServiceRequest().getRequestBody().getMain().getSumPremiumChg())) {
            endorseApplyDTO.getMain().setChgSumPremium(Double.valueOf(Math.abs(request.getEndorseServiceRequest().getRequestBody().getMain().getSumPremiumChg().doubleValue())));
        } else if (ObjectUtil.isNotEmpty((Object)request.getEndorseServiceRequest().getRequestBody().getSumPremiumChg())) {
            endorseApplyDTO.getMain().setChgSumPremium(Double.valueOf(Math.abs(request.getEndorseServiceRequest().getRequestBody().getSumPremiumChg().doubleValue())));
        }
        endorseServiceResponseDTO.setEndorseApply(endorseApplyDTO);
        endorseServiceResponse.setResponseHead(responseHeadDTO);
        endorseServiceResponse.setResponseBody(endorseServiceResponseDTO);
        response.setEndorseServiceResponse(endorseServiceResponse);
        response.setCorrectQuotePriceServiceResponse(null);
        response.setPolicySubmitResponse(null);
        return response;
    }

    private StanderResponse executeQuotePrice(StanderRequest request) {
        return this.coreCorrectApi.correctQuotePrice(request);
    }

    private StanderResponse executeConfirm(StanderRequest request) {
        return this.coreCorrectApi.correctConfirm(request);
    }

    public void premiumPayStatusQuery(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        MainEndorDTO mainEndor = request.getEndorseServiceRequest().getRequestBody().getMain();
        Date startDate = policyDTO.getMain().getStartDate();
        String policyStatus = policyDTO.getMain().getPolicyStatus();
        String jFeeFlag = policyDTO.getMain().getJFeeFlag();
        Integer payTimes = policyDTO.getMain().getPayTimes();
        Date endorseDate = mainEndor.getEndorseDate();
        if ("Y".equals(mainEndor.getReqRefund()) && request.getEndorseServiceRequest().getRequestBody().getIsSelfHelpPlatform().booleanValue()) {
            mainEndor.setEndorseType(ENDOR_TYPE_01);
            return;
        }
        ResponseVo responseVo = null;
        if (StringUtils.isNotBlank((CharSequence)jFeeFlag) && !"1".equals(jFeeFlag)) {
            PremiumPayStatusQueryRequest premiumPayStatusQueryRequest = PremiumPayStatusQueryRequest.builder().build();
            premiumPayStatusQueryRequest.setRequestHead(PremiumPayStatusQueryRequestHeadDTO.initHeadDTO());
            PremiumPayStatusQueryRequestBodyDTO bodyDTO = PremiumPayStatusQueryRequestBodyDTO.builder().build();
            bodyDTO.setPolicyNo(mainEndor.getPolicyNo());
            premiumPayStatusQueryRequest.setPremiumPayStatusQueryBody(bodyDTO);
            responseVo = this.coreInsureApi.premiumPayStatusQuery(premiumPayStatusQueryRequest);
        }
        boolean endorFlag = false;
        if (StringUtils.isNotBlank((CharSequence)policyStatus) && POLICY_STATUS.equals(policyStatus)) {
            int startDateNum = Integer.parseInt(DateUtil.format((Date)startDate, (String)"yyyyMMddHH"));
            int endorseDateNum = Integer.parseInt(DateUtil.format((Date)endorseDate, (String)"yyyyMMddHH"));
            if (ObjectUtil.isNotEmpty((Object)startDate) && ObjectUtil.isNotEmpty((Object)endorseDate) && startDateNum >= endorseDateNum) {
                if (ObjectUtil.isNotEmpty((Object)responseVo) && responseVo.getStatus() == -2) {
                    endorFlag = true;
                    request.getEndorseServiceRequest().getRequestBody().getMain().setEndorseType(ENDOR_TYPE_04);
                } else if (ObjectUtil.isNotEmpty((Object)responseVo) && responseVo.getStatus() == 0) {
                    BigDecimal payFee = responseVo.getPayFee();
                    if (ObjectUtil.isNotEmpty((Object)payFee)) {
                        if (payFee.compareTo(BigDecimal.ZERO) == 0) {
                            endorFlag = true;
                            request.getEndorseServiceRequest().getRequestBody().getMain().setEndorseType(ENDOR_TYPE_04);
                        }
                    } else {
                        this.log.error("\u4fdd\u5355\u5b9e\u6536\u5b9e\u4ed8\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u5f02\u5e38");
                        throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N11007.getValue(), ErrorNullValueCodeEnum.ERR_N11007.getKey());
                    }
                }
            }
            if (!endorFlag) {
                endorFlag = true;
                request.getEndorseServiceRequest().getRequestBody().getMain().setEndorseType(ENDOR_TYPE_01);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)policyStatus) && POLICY_STAUTS_4.equals(policyStatus)) {
            request.getEndorseServiceRequest().getRequestBody().getMain().setEndorseType(ENDOR_TYPE_01);
            return;
        }
        if (!endorFlag) {
            this.log.error("\u4fdd\u5355\u72b6\u6001\u975e\u751f\u6548,\u4e0d\u5141\u8bb8\u505a\u6279\u6539,\u8bf7\u7a0d\u540e\u518d\u8bd5!");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10421.getValue(), ChannelErrorCodeEnum.ERR_C10421.getKey());
        }
    }

    public void assignEndorDate(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        String calculateFlag = request.getEndorseServiceRequest().getRequestBody().getMain().getCalculateFlag();
        Date endorseDate = request.getEndorseServiceRequest().getRequestBody().getMain().getEndorseDate();
        PayPlanDTO payPlan = null;
        Date planStartDate = null;
        DateTime validDate = null;
        String cancelFlag = request.getEndorseServiceRequest().getRequestBody().getMain().getCancelFlag();
        String calculateType = request.getEndorseServiceRequest().getRequestBody().getMain().getCalculateType();
        if (StringUtils.isEmpty((CharSequence)cancelFlag)) {
            request.getEndorseServiceRequest().getRequestBody().getMain().setCancelFlag(CANCEL_FLAG_A);
            cancelFlag = CANCEL_FLAG_A;
        }
        if (StringUtils.isEmpty((CharSequence)calculateType)) {
            request.getEndorseServiceRequest().getRequestBody().getMain().setCalculateType(CALCULATE_TYPE_0);
            calculateType = CALCULATE_TYPE_0;
        }
        if (StringUtils.isNotBlank((CharSequence)calculateFlag) && CALCULATE_FLAG.equals(calculateFlag)) {
            List payPlanList = policyDTO.getPayPlanList();
            if (ObjectUtil.isNotEmpty((Object)payPlanList) && payPlanList.size() == 1) {
                String reason = request.getEndorseServiceRequest().getRequestBody().getMain().getReason();
                String riskCode = policyDTO.getMain().getRiskCode();
                if (endorseDate.getTime() <= policyDTO.getMain().getStartDate().getTime()) {
                    request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate(policyDTO.getMain().getStartDate());
                } else if (StringUtils.isNotBlank((CharSequence)reason) && REASON_1.equals(reason)) {
                    request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate(policyDTO.getMain().getStartDate());
                } else if (StringUtils.isNotBlank((CharSequence)reason) && REASON_2.equals(reason) && StringUtils.isNotBlank((CharSequence)riskCode) && "P070002".equals(riskCode)) {
                    request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate(policyDTO.getMain().getStartDate());
                } else {
                    request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate(endorseDate);
                }
            } else if (ObjectUtil.isNotEmpty((Object)payPlanList) && payPlanList.size() > 1) {
                if (endorseDate.getTime() <= policyDTO.getMain().getStartDate().getTime()) {
                    request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate(policyDTO.getMain().getStartDate());
                } else if (CANCEL_FLAG_A.equals(cancelFlag)) {
                    if (CALCULATE_TYPE_0.equals(calculateType)) {
                        request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate(endorseDate);
                    } else if (CALCULATE_TYPE_1.equals(calculateType)) {
                        request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate(policyDTO.getMain().getStartDate());
                    } else if (CALCULATE_TYPE_2.equals(calculateType)) {
                        for (int i = 0; i < payPlanList.size(); ++i) {
                            payPlan = (PayPlanDTO)payPlanList.get(i);
                            planStartDate = payPlan.getPlanStartDate();
                            if (!PAY_COMPLETE_1.equals(payPlan.getPayComplete())) continue;
                            validDate = DateUtil.offsetDay((Date)planStartDate, (int)1);
                            request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate((Date)validDate);
                            break;
                        }
                    }
                } else if (CANCEL_FLAG_B.equals(cancelFlag)) {
                    int i;
                    Integer payTimes = null;
                    for (i = 0; i < payPlanList.size(); ++i) {
                        payPlan = (PayPlanDTO)payPlanList.get(i);
                        if (!PAY_COMPLETE_1.equals(payPlan.getPayComplete())) continue;
                        payTimes = payPlan.getPayTimes();
                        break;
                    }
                    if (ObjectUtil.isEmpty(payTimes)) {
                        for (i = 0; i < payPlanList.size(); ++i) {
                            payPlan = (PayPlanDTO)payPlanList.get(i);
                            planStartDate = payPlan.getPlanStartDate();
                            if (1 != payPlan.getPayTimes()) continue;
                            validDate = DateUtil.offsetDay((Date)planStartDate, (int)1);
                            request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate((Date)validDate);
                            break;
                        }
                    } else {
                        payTimes = payTimes + 1;
                        for (i = 0; i < payPlanList.size(); ++i) {
                            payPlan = (PayPlanDTO)payPlanList.get(i);
                            planStartDate = payPlan.getPlanStartDate();
                            if (!payTimes.equals(payPlan.getPayTimes())) continue;
                            validDate = DateUtil.offsetDay((Date)planStartDate, (int)1);
                            request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate((Date)validDate);
                            break;
                        }
                    }
                    if (ObjectUtil.isEmpty(validDate)) {
                        this.log.error("\n\u6279\u6539\u63a5\u53e3>>>>\u6279\u6539\u751f\u6548\u65e5\u671f\u53d6\u503c\u6709\u8bef", (Object)"ERR_N11004");
                        throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N11004.getValue(), ErrorNullValueCodeEnum.ERR_N11004.getKey());
                    }
                }
            }
        } else {
            request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate(endorseDate);
        }
    }

    private String getEndorsePriceRequest(StanderRequest request) {
        PolicyDTO policyDTO = request.getEndorseServiceRequest().getRequestBody().getPolicyDTO();
        request.getEndorseServiceRequest().getRequestBody().setPolicyDTO(null);
        StanderRequest req = StanderRequest.builder().header(request.getHeader()).policyDetailServiceRequest(request.getPolicyDetailServiceRequest()).endorsePriceServiceRequest(request.getEndorsePriceServiceRequest()).endorseServiceRequest(request.getEndorseServiceRequest()).build();
        String json = JSON.toJSONString((Object)req);
        request.getEndorseServiceRequest().getRequestBody().setPolicyDTO(policyDTO);
        return json;
    }
}

